/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.structuredAnalysis;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.Local;
import soot.Value;
import soot.dava.internal.AST.ASTDoWhileNode;
import soot.dava.internal.AST.ASTForLoopNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTUnaryBinaryCondition;
import soot.dava.internal.AST.ASTUnconditionalLoopNode;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.toolkits.base.AST.structuredAnalysis.DavaFlowSet;
import soot.dava.toolkits.base.AST.structuredAnalysis.StructuredAnalysis;
import soot.dava.toolkits.base.AST.traversals.AllDefinitionsFinder;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;

public class ReachingDefs
extends StructuredAnalysis<Stmt> {
    Object toAnalyze;

    public ReachingDefs(Object analyze) {
        this.toAnalyze = analyze;
        this.process(analyze, new DavaFlowSet());
    }

    @Override
    public DavaFlowSet<Stmt> emptyFlowSet() {
        return new DavaFlowSet<Stmt>();
    }

    @Override
    public DavaFlowSet<Stmt> newInitialFlow() {
        DavaFlowSet<Stmt> initial = new DavaFlowSet<Stmt>();
        AllDefinitionsFinder defFinder = new AllDefinitionsFinder();
        ((ASTNode)this.toAnalyze).apply(defFinder);
        List<DefinitionStmt> allDefs = defFinder.getAllDefs();
        for (DefinitionStmt def : allDefs) {
            initial.add(def);
        }
        return initial;
    }

    @Override
    public void setMergeType() {
        this.MERGETYPE = 1;
    }

    @Override
    public DavaFlowSet<Stmt> cloneFlowSet(DavaFlowSet<Stmt> flowSet) {
        return flowSet.clone();
    }

    @Override
    public DavaFlowSet<Stmt> processUnaryBinaryCondition(ASTUnaryBinaryCondition cond, DavaFlowSet<Stmt> inSet) {
        return inSet;
    }

    @Override
    public DavaFlowSet<Stmt> processSynchronizedLocal(Local local, DavaFlowSet<Stmt> inSet) {
        return inSet;
    }

    @Override
    public DavaFlowSet<Stmt> processSwitchKey(Value key, DavaFlowSet<Stmt> inSet) {
        return inSet;
    }

    @Override
    public DavaFlowSet<Stmt> processStatement(Stmt s2, DavaFlowSet<Stmt> inSet) {
        if (inSet == this.NOPATH) {
            return inSet;
        }
        if (s2 instanceof DefinitionStmt) {
            DavaFlowSet<Stmt> toReturn = this.cloneFlowSet(inSet);
            Value leftOp = ((DefinitionStmt)s2).getLeftOp();
            if (leftOp instanceof Local) {
                this.kill(toReturn, (Local)leftOp);
                this.gen(toReturn, (DefinitionStmt)s2);
                return toReturn;
            }
        }
        return inSet;
    }

    public void gen(DavaFlowSet<Stmt> in, DefinitionStmt s2) {
        in.add(s2);
    }

    public void kill(DavaFlowSet<Stmt> in, Local redefined) {
        String redefinedLocalName = redefined.getName();
        Iterator<Stmt> listIt = in.iterator();
        while (listIt.hasNext()) {
            String storedLocalName;
            DefinitionStmt tempStmt = (DefinitionStmt)listIt.next();
            Value leftOp = tempStmt.getLeftOp();
            if (!(leftOp instanceof Local) || redefinedLocalName.compareTo(storedLocalName = ((Local)leftOp).getName()) != 0) continue;
            listIt.remove();
        }
    }

    public List<DefinitionStmt> getReachingDefs(Local local, Object node) {
        ArrayList<DefinitionStmt> toReturn = new ArrayList<DefinitionStmt>();
        DavaFlowSet beforeSet = null;
        beforeSet = node instanceof ASTWhileNode || node instanceof ASTDoWhileNode || node instanceof ASTUnconditionalLoopNode || node instanceof ASTForLoopNode ? this.getAfterSet(node) : this.getBeforeSet(node);
        if (beforeSet == null) {
            throw new RuntimeException("Could not get reaching defs of node");
        }
        for (Object temp : beforeSet) {
            if (!(temp instanceof DefinitionStmt)) {
                throw new RuntimeException("Not an instanceof DefinitionStmt" + temp);
            }
            DefinitionStmt stmt = (DefinitionStmt)temp;
            Value leftOp = stmt.getLeftOp();
            if (leftOp.toString().compareTo(local.toString()) != 0) continue;
            toReturn.add(stmt);
        }
        return toReturn;
    }

    public void reachingDefsToString(Object node) {
        DavaFlowSet beforeSet = null;
        beforeSet = node instanceof ASTWhileNode || node instanceof ASTDoWhileNode || node instanceof ASTUnconditionalLoopNode || node instanceof ASTForLoopNode ? this.getAfterSet(node) : this.getBeforeSet(node);
        if (beforeSet == null) {
            throw new RuntimeException("Could not get reaching defs of node");
        }
        for (Object o : beforeSet) {
            System.out.println("Reaching def:" + o);
        }
    }
}

