/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.interProcedural;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.PrimType;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.dava.DavaBody;
import soot.dava.DecompilationException;
import soot.dava.internal.AST.ASTNode;
import soot.dava.toolkits.base.AST.traversals.AllDefinitionsFinder;
import soot.jimple.DefinitionStmt;
import soot.jimple.DoubleConstant;
import soot.jimple.FieldRef;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.NumericConstant;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.util.Chain;

public class ConstantFieldValueFinder {
    public final boolean DEBUG = false;
    public static String combiner = "_$p$g_";
    HashMap<String, SootField> classNameFieldNameToSootFieldMapping = new HashMap();
    HashMap<String, ArrayList> fieldToValues = new HashMap();
    HashMap<String, Object> primTypeFieldValueToUse = new HashMap();
    Chain appClasses;

    public ConstantFieldValueFinder(Chain classes) {
        this.appClasses = classes;
        this.debug("ConstantFieldValueFinder -- applyAnalyses", "computing Method Summaries");
        this.computeFieldToValuesAssignedList();
        this.valuesForPrimTypeFields();
    }

    public HashMap<String, Object> getFieldsWithConstantValues() {
        return this.primTypeFieldValueToUse;
    }

    public HashMap<String, SootField> getClassNameFieldNameToSootFieldMapping() {
        return this.classNameFieldNameToSootFieldMapping;
    }

    private void valuesForPrimTypeFields() {
        for (SootClass s2 : this.appClasses) {
            this.debug("\nvaluesforPrimTypeFields", "Processing class " + s2.getName());
            String declaringClass = s2.getName();
            for (SootField f : s2.getFields()) {
                Number tempVal;
                String fieldName = f.getName();
                Type fieldType = f.getType();
                if (!(fieldType instanceof PrimType)) continue;
                String combined = declaringClass + combiner + fieldName;
                this.classNameFieldNameToSootFieldMapping.put(combined, f);
                Constable value = null;
                if (fieldType instanceof DoubleType && f.hasTag("DoubleConstantValueTag")) {
                    double val = ((DoubleConstantValueTag)f.getTag("DoubleConstantValueTag")).getDoubleValue();
                    value = new Double(val);
                } else if (fieldType instanceof FloatType && f.hasTag("FloatConstantValueTag")) {
                    float val = ((FloatConstantValueTag)f.getTag("FloatConstantValueTag")).getFloatValue();
                    value = new Float(val);
                } else if (fieldType instanceof LongType && f.hasTag("LongConstantValueTag")) {
                    long val = ((LongConstantValueTag)f.getTag("LongConstantValueTag")).getLongValue();
                    value = new Long(val);
                } else if (fieldType instanceof CharType && f.hasTag("IntegerConstantValueTag")) {
                    int val = ((IntegerConstantValueTag)f.getTag("IntegerConstantValueTag")).getIntValue();
                    value = new Integer(val);
                } else if (fieldType instanceof BooleanType && f.hasTag("IntegerConstantValueTag")) {
                    int val = ((IntegerConstantValueTag)f.getTag("IntegerConstantValueTag")).getIntValue();
                    value = val == 0 ? new Boolean(false) : new Boolean(true);
                } else if ((fieldType instanceof IntType || fieldType instanceof ByteType || fieldType instanceof ShortType) && f.hasTag("IntegerConstantValueTag")) {
                    int val = ((IntegerConstantValueTag)f.getTag("IntegerConstantValueTag")).getIntValue();
                    value = new Integer(val);
                }
                if (value != null) {
                    this.debug("TAGGED value found for field: " + combined);
                    this.primTypeFieldValueToUse.put(combined, value);
                    continue;
                }
                ArrayList temp = this.fieldToValues.get(combined);
                if (temp == null) {
                    if (fieldType instanceof DoubleType) {
                        value = new Double(0.0);
                    } else if (fieldType instanceof FloatType) {
                        value = new Float(0.0f);
                    } else if (fieldType instanceof LongType) {
                        value = new Long(0L);
                    } else if (fieldType instanceof BooleanType) {
                        value = new Boolean(false);
                    } else if (fieldType instanceof IntType || fieldType instanceof ByteType || fieldType instanceof ShortType || fieldType instanceof CharType) {
                        value = new Integer(0);
                    } else {
                        throw new DecompilationException("Unknown primitive type...please report to developer");
                    }
                    this.primTypeFieldValueToUse.put(combined, value);
                    this.debug("DEFAULT value for field: " + combined);
                    continue;
                }
                this.debug("CHECKING USER ASSIGNED VALUES FOR: " + combined);
                ArrayList values = temp;
                Iterator it = values.iterator();
                NumericConstant tempConstant = null;
                while (it.hasNext()) {
                    Value val = (Value)it.next();
                    if (!(val instanceof NumericConstant)) {
                        tempConstant = null;
                        this.debug("Not numeric constant hence giving up");
                        break;
                    }
                    if (tempConstant == null) {
                        tempConstant = (NumericConstant)val;
                        continue;
                    }
                    if (tempConstant.equals(val)) continue;
                    tempConstant = null;
                    break;
                }
                if (tempConstant == null) continue;
                if (tempConstant instanceof LongConstant) {
                    tempVal = new Long(((LongConstant)tempConstant).value);
                    if (((Long)tempVal).compareTo(new Long(0L)) == 0) {
                        this.primTypeFieldValueToUse.put(combined, tempVal);
                        continue;
                    }
                    this.debug("Not assigning the agreed value since that is not the default value for " + combined);
                    continue;
                }
                if (tempConstant instanceof DoubleConstant) {
                    tempVal = new Double(((DoubleConstant)tempConstant).value);
                    if (((Double)tempVal).compareTo(new Double(0.0)) == 0) {
                        this.primTypeFieldValueToUse.put(combined, tempVal);
                        continue;
                    }
                    this.debug("Not assigning the agreed value since that is not the default value for " + combined);
                    continue;
                }
                if (tempConstant instanceof FloatConstant) {
                    tempVal = new Float(((FloatConstant)tempConstant).value);
                    if (((Float)tempVal).compareTo(new Float(0.0f)) == 0) {
                        this.primTypeFieldValueToUse.put(combined, tempVal);
                        continue;
                    }
                    this.debug("Not assigning the agreed value since that is not the default value for " + combined);
                    continue;
                }
                if (tempConstant instanceof IntConstant) {
                    tempVal = new Integer(((IntConstant)tempConstant).value);
                    if (((Integer)tempVal).compareTo(new Integer(0)) == 0) {
                        SootField tempField = this.classNameFieldNameToSootFieldMapping.get(combined);
                        if (tempField.getType() instanceof BooleanType) {
                            this.primTypeFieldValueToUse.put(combined, new Boolean(false));
                            continue;
                        }
                        this.primTypeFieldValueToUse.put(combined, tempVal);
                        continue;
                    }
                    this.debug("Not assigning the agreed value since that is not the default value for " + combined);
                    continue;
                }
                throw new DecompilationException("Un handled Numberic Constant....report to programmer");
            }
        }
    }

    private void computeFieldToValuesAssignedList() {
        for (SootClass s2 : this.appClasses) {
            this.debug("\ncomputeMethodSummaries", "Processing class " + s2.getName());
            Iterator<SootMethod> methodIt = s2.methodIterator();
            while (methodIt.hasNext()) {
                SootMethod m4 = methodIt.next();
                DavaBody body = null;
                if (!m4.hasActiveBody()) continue;
                body = (DavaBody)m4.getActiveBody();
                ASTNode AST = (ASTNode)body.getUnits().getFirst();
                AllDefinitionsFinder defFinder = new AllDefinitionsFinder();
                AST.apply(defFinder);
                for (DefinitionStmt stmt : defFinder.getAllDefs()) {
                    ArrayList<Value> valueList;
                    Value left = stmt.getLeftOp();
                    if (!(left instanceof FieldRef)) continue;
                    this.debug("computeMethodSummaries method: " + m4.getName(), "Field ref is: " + left);
                    FieldRef ref = (FieldRef)left;
                    SootField field = ref.getField();
                    if (!(field.getType() instanceof PrimType)) continue;
                    String fieldName = field.getName();
                    String declaringClass = field.getDeclaringClass().getName();
                    this.debug("\tField Name: " + fieldName);
                    this.debug("\tField DeclaringClass: " + declaringClass);
                    String combined = declaringClass + combiner + fieldName;
                    ArrayList<Value> temp = this.fieldToValues.get(combined);
                    if (temp == null) {
                        valueList = new ArrayList<Value>();
                        this.fieldToValues.put(combined, valueList);
                    } else {
                        valueList = temp;
                    }
                    valueList.add(stmt.getRightOp());
                }
            }
        }
    }

    public void printConstantValueFields() {
        System.out.println("\n\n Printing Constant Value Fields (method: printConstantValueFields)");
        for (String combined : this.primTypeFieldValueToUse.keySet()) {
            int temp = combined.indexOf(combiner, 0);
            if (temp <= 0) continue;
            System.out.println("Class: " + combined.substring(0, temp) + " Field: " + combined.substring(temp + combiner.length()) + " Value: " + this.primTypeFieldValueToUse.get(combined));
        }
    }

    public void debug(String methodName, String debug) {
    }

    public void debug(String debug) {
    }
}

