/*
 * Decompiled with CFR 0.152.
 */
package soot.dava;

import soot.AbstractUnitPrinter;
import soot.ArrayType;
import soot.RefType;
import soot.SootFieldRef;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.dava.DavaBody;
import soot.dava.toolkits.base.renamer.RemoveFullyQualifiedName;
import soot.jimple.ClassConstant;
import soot.jimple.Constant;
import soot.jimple.IdentityRef;
import soot.jimple.ThisRef;

public class DavaUnitPrinter
extends AbstractUnitPrinter {
    DavaBody body;
    private boolean eatSpace = false;

    public DavaUnitPrinter(DavaBody body) {
        this.body = body;
    }

    @Override
    public void methodRef(SootMethodRef m4) {
        this.handleIndent();
        this.output.append(m4.name());
    }

    @Override
    public void fieldRef(SootFieldRef f) {
        this.handleIndent();
        this.output.append(f.name());
    }

    @Override
    public void identityRef(IdentityRef r) {
        this.handleIndent();
        if (!(r instanceof ThisRef)) {
            throw new RuntimeException();
        }
        this.literal("this");
    }

    @Override
    public void literal(String s2) {
        this.handleIndent();
        if (this.eatSpace && s2.equals(" ")) {
            this.eatSpace = false;
            return;
        }
        this.eatSpace = false;
        if (s2.equals("staticinvoke") || s2.equals("virtualinvoke") || s2.equals("interfaceinvoke")) {
            this.eatSpace = true;
            return;
        }
        this.output.append(s2);
    }

    @Override
    public void type(Type t2) {
        this.handleIndent();
        if (t2 instanceof RefType) {
            String name = ((RefType)t2).getSootClass().getJavaStyleName();
            if (!name.equals(((RefType)t2).getSootClass().toString())) {
                name = RemoveFullyQualifiedName.getReducedName(this.body.getImportList(), ((RefType)t2).getSootClass().toString(), t2);
            }
            this.output.append(name);
        } else if (t2 instanceof ArrayType) {
            ((ArrayType)t2).toString(this);
        } else {
            this.output.append(t2.toString());
        }
    }

    @Override
    public void unitRef(Unit u, boolean branchTarget) {
        throw new RuntimeException("Dava doesn't have unit references!");
    }

    @Override
    public void constant(Constant c) {
        if (c instanceof ClassConstant) {
            this.handleIndent();
            String fullClassName = ((ClassConstant)c).value.replaceAll("/", ".");
            this.output.append(fullClassName + ".class");
        } else {
            super.constant(c);
        }
    }

    public void addNot() {
        this.output.append(" !");
    }

    public void addAggregatedOr() {
        this.output.append(" || ");
    }

    public void addAggregatedAnd() {
        this.output.append(" && ");
    }

    public void addLeftParen() {
        this.output.append(" (");
    }

    public void addRightParen() {
        this.output.append(") ");
    }

    public void printString(String s2) {
        this.output.append(s2);
    }
}

