/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Value;
import soot.coffi.CONSTANT_Fieldref_info;
import soot.coffi.CONSTANT_InterfaceMethodref_info;
import soot.coffi.CONSTANT_Methodref_info;
import soot.coffi.CONSTANT_NameAndType_info;
import soot.coffi.CONSTANT_Utf8_info;
import soot.coffi.ClassFile;

abstract class cp_info {
    private static final Logger logger = LoggerFactory.getLogger(cp_info.class);
    public static final byte CONSTANT_Utf8 = 1;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Float = 4;
    public static final byte CONSTANT_Long = 5;
    public static final byte CONSTANT_Double = 6;
    public static final byte CONSTANT_Class = 7;
    public static final byte CONSTANT_String = 8;
    public static final byte CONSTANT_Fieldref = 9;
    public static final byte CONSTANT_Methodref = 10;
    public static final byte CONSTANT_InterfaceMethodref = 11;
    public static final byte CONSTANT_NameAndType = 12;
    public static final byte CONSTANT_MethodHandle = 15;
    public static final byte CONSTANT_MethodType = 16;
    public static final byte CONSTANT_InvokeDynamic = 18;
    public static final byte REF_getField = 1;
    public static final byte REF_getStatic = 2;
    public static final byte REF_putField = 3;
    public static final byte REF_putStatic = 4;
    public static final byte REF_invokeVirtual = 5;
    public static final byte REF_invokeStatic = 6;
    public static final byte REF_invokeSpecial = 7;
    public static final byte REF_newInvokeSpecial = 8;
    public static final byte REF_invokeInterface = 9;
    public static final byte[] REF_TO_CONSTANT = new byte[]{-1, 9, 9, 9, 9, 10, 10, 10, 10, 11};
    public byte tag;

    cp_info() {
    }

    public abstract int size();

    public abstract String toString(cp_info[] var1);

    public abstract String typeName();

    public abstract int compareTo(cp_info[] var1, cp_info var2, cp_info[] var3);

    public static long ints2long(long high, long low) {
        long h2 = high;
        long l = low;
        return (h2 << 32) + l;
    }

    public static String printBits(int i) {
        String s2 = "";
        int k = 1;
        for (int j = 0; j < 32; ++j) {
            s2 = (i & k) != 0 ? "1" + s2 : "0" + s2;
            k <<= 1;
        }
        return s2;
    }

    public static String printBits(long i) {
        String s2 = "";
        long k = 1L;
        for (long j = 0L; j < 64L; ++j) {
            s2 = (i & k) != 0L ? "1" + s2 : "0" + s2;
            k <<= 1;
        }
        return s2;
    }

    public static String getClassname(cp_info[] constant_pool, int i) {
        cp_info c = constant_pool[i];
        switch (c.tag) {
            case 7: {
                return c.toString(constant_pool);
            }
            case 9: {
                return cp_info.getClassname(constant_pool, ((CONSTANT_Fieldref_info)c).class_index);
            }
            case 10: {
                return cp_info.getClassname(constant_pool, ((CONSTANT_Methodref_info)c).class_index);
            }
            case 11: {
                return cp_info.getClassname(constant_pool, ((CONSTANT_InterfaceMethodref_info)c).class_index);
            }
        }
        logger.debug("Request for classname for non-class object!");
        return "Can't find classname. Sorry.";
    }

    public static String getName(cp_info[] constant_pool, int i) {
        cp_info c = constant_pool[i];
        switch (c.tag) {
            case 1: {
                return c.toString(constant_pool);
            }
            case 12: {
                return cp_info.getName(constant_pool, ((CONSTANT_NameAndType_info)c).name_index);
            }
            case 9: {
                return cp_info.getName(constant_pool, ((CONSTANT_Fieldref_info)c).name_and_type_index);
            }
            case 10: {
                return cp_info.getName(constant_pool, ((CONSTANT_Methodref_info)c).name_and_type_index);
            }
            case 11: {
                return cp_info.getName(constant_pool, ((CONSTANT_InterfaceMethodref_info)c).name_and_type_index);
            }
        }
        logger.debug("Request for name for non-named object!");
        return "Can't find name of that object. Sorry.";
    }

    public static int countParams(cp_info[] constant_pool, int m4) {
        String s2 = cp_info.getTypeDescr(constant_pool, m4);
        s2 = ClassFile.parseMethodDesc_params(s2);
        StringTokenizer st = new StringTokenizer(s2, ",", false);
        return st.countTokens();
    }

    public static String getTypeDescr(cp_info[] constant_pool, int i) {
        cp_info c = constant_pool[i];
        if (c instanceof CONSTANT_Utf8_info) {
            return c.toString(constant_pool);
        }
        if (c instanceof CONSTANT_NameAndType_info) {
            return cp_info.getTypeDescr(constant_pool, ((CONSTANT_NameAndType_info)c).descriptor_index);
        }
        if (c instanceof CONSTANT_Methodref_info) {
            return cp_info.getTypeDescr(constant_pool, ((CONSTANT_Methodref_info)c).name_and_type_index);
        }
        if (c instanceof CONSTANT_InterfaceMethodref_info) {
            return cp_info.getTypeDescr(constant_pool, ((CONSTANT_InterfaceMethodref_info)c).name_and_type_index);
        }
        if (c instanceof CONSTANT_Fieldref_info) {
            return cp_info.getTypeDescr(constant_pool, ((CONSTANT_Fieldref_info)c).name_and_type_index);
        }
        logger.debug("Invalid request for type descr!");
        return "Invalid type descriptor request.";
    }

    public static String fieldType(cp_info[] constant_pool, int i) {
        return ClassFile.parseDesc(cp_info.getTypeDescr(constant_pool, i), "");
    }

    public abstract Value createJimpleConstantValue(cp_info[] var1);
}

