/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import java.util.ArrayList;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import soot.tagkit.AnnotationAnnotationElem;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;

abstract class AnnotationElemBuilder
extends AnnotationVisitor {
    protected final ArrayList<AnnotationElem> elems;

    AnnotationElemBuilder(int expected) {
        super(327680);
        this.elems = new ArrayList(expected);
    }

    AnnotationElemBuilder() {
        this(4);
    }

    public AnnotationElem getAnnotationElement(String name, Object value) {
        AnnotationElem elem;
        if (value instanceof Byte) {
            elem = new AnnotationIntElem(((Byte)value).byteValue(), 'B', name);
        } else if (value instanceof Boolean) {
            elem = new AnnotationIntElem((Boolean)value != false ? 1 : 0, 'Z', name);
        } else if (value instanceof Character) {
            elem = new AnnotationIntElem(((Character)value).charValue(), 'C', name);
        } else if (value instanceof Short) {
            elem = new AnnotationIntElem(((Short)value).shortValue(), 'S', name);
        } else if (value instanceof Integer) {
            elem = new AnnotationIntElem((Integer)value, 'I', name);
        } else if (value instanceof Long) {
            elem = new AnnotationLongElem((Long)value, 'J', name);
        } else if (value instanceof Float) {
            elem = new AnnotationFloatElem(((Float)value).floatValue(), 'F', name);
        } else if (value instanceof Double) {
            elem = new AnnotationDoubleElem((Double)value, 'D', name);
        } else if (value instanceof String) {
            elem = new AnnotationStringElem(value.toString(), 's', name);
        } else if (value instanceof Type) {
            Type t2 = (Type)value;
            elem = new AnnotationClassElem(t2.getDescriptor(), 'c', name);
        } else if (value.getClass().isArray()) {
            ArrayList<AnnotationElem> annotationArray = new ArrayList<AnnotationElem>();
            if (value instanceof byte[]) {
                byte[] byArray = (byte[])value;
                int n = byArray.length;
                for (int i = 0; i < n; ++i) {
                    Byte element = byArray[i];
                    annotationArray.add(this.getAnnotationElement(name, element));
                }
            } else if (value instanceof boolean[]) {
                boolean[] blArray = (boolean[])value;
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    Boolean element = blArray[i];
                    annotationArray.add(this.getAnnotationElement(name, element));
                }
            } else if (value instanceof char[]) {
                char[] cArray = (char[])value;
                int n = cArray.length;
                for (int i = 0; i < n; ++i) {
                    Character element = Character.valueOf(cArray[i]);
                    annotationArray.add(this.getAnnotationElement(name, element));
                }
            } else if (value instanceof short[]) {
                short[] sArray = (short[])value;
                int n = sArray.length;
                for (int i = 0; i < n; ++i) {
                    Short element = sArray[i];
                    annotationArray.add(this.getAnnotationElement(name, element));
                }
            } else if (value instanceof int[]) {
                int[] nArray = (int[])value;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer element = nArray[i];
                    annotationArray.add(this.getAnnotationElement(name, element));
                }
            } else if (value instanceof long[]) {
                long[] lArray = (long[])value;
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long element = lArray[i];
                    annotationArray.add(this.getAnnotationElement(name, element));
                }
            } else if (value instanceof float[]) {
                float[] fArray = (float[])value;
                int n = fArray.length;
                for (int i = 0; i < n; ++i) {
                    Float element = Float.valueOf(fArray[i]);
                    annotationArray.add(this.getAnnotationElement(name, element));
                }
            } else if (value instanceof double[]) {
                double[] dArray = (double[])value;
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    Double element = dArray[i];
                    annotationArray.add(this.getAnnotationElement(name, element));
                }
            } else if (value instanceof String[]) {
                for (String element : (String[])value) {
                    annotationArray.add(this.getAnnotationElement(name, element));
                }
            } else if (value instanceof Type[]) {
                for (Type element : (Type[])value) {
                    annotationArray.add(this.getAnnotationElement(name, element));
                }
            } else {
                throw new UnsupportedOperationException("Unsupported array value type: " + value.getClass());
            }
            elem = new AnnotationArrayElem(annotationArray, '[', name);
        } else {
            throw new UnsupportedOperationException("Unsupported value type: " + value.getClass());
        }
        return elem;
    }

    @Override
    public void visit(String name, Object value) {
        AnnotationElem elem = this.getAnnotationElement(name, value);
        this.elems.add(elem);
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        this.elems.add(new AnnotationEnumElem(desc, value, 'e', name));
    }

    @Override
    public AnnotationVisitor visitArray(final String name) {
        return new AnnotationElemBuilder(){

            @Override
            public void visitEnd() {
                String ename = name;
                if (ename == null) {
                    ename = "default";
                }
                AnnotationElemBuilder.this.elems.add(new AnnotationArrayElem(this.elems, '[', ename));
            }
        };
    }

    @Override
    public AnnotationVisitor visitAnnotation(final String name, final String desc) {
        return new AnnotationElemBuilder(){

            @Override
            public void visitEnd() {
                AnnotationTag tag = new AnnotationTag(desc, this.elems);
                AnnotationElemBuilder.this.elems.add(new AnnotationAnnotationElem(tag, '@', name));
            }
        };
    }

    @Override
    public abstract void visitEnd();
}

