/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import soot.Body;
import soot.Hierarchy;
import soot.ModuleRefType;
import soot.ModuleUtil;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.util.Chain;

public class TrapManager {
    public static boolean isExceptionCaughtAt(SootClass e, Unit u, Body b) {
        Hierarchy h2 = Scene.v().getActiveHierarchy();
        UnitPatchingChain units = b.getUnits();
        for (Trap t2 : b.getTraps()) {
            if (!h2.isClassSubclassOfIncluding(e, t2.getException())) continue;
            Iterator<Unit> it = units.iterator(t2.getBeginUnit(), units.getPredOf(t2.getEndUnit()));
            while (it.hasNext()) {
                if (!u.equals(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Trap> getTrapsAt(Unit unit, Body b) {
        ArrayList<Trap> trapsList = new ArrayList<Trap>();
        UnitPatchingChain units = b.getUnits();
        for (Trap t2 : b.getTraps()) {
            Iterator<Unit> it = units.iterator(t2.getBeginUnit(), units.getPredOf(t2.getEndUnit()));
            while (it.hasNext()) {
                if (!unit.equals(it.next())) continue;
                trapsList.add(t2);
            }
        }
        return trapsList;
    }

    public static Set<Unit> getTrappedUnitsOf(Body b) {
        HashSet<Unit> trapsSet = new HashSet<Unit>();
        UnitPatchingChain units = b.getUnits();
        for (Trap t2 : b.getTraps()) {
            Iterator<Unit> it = units.iterator(t2.getBeginUnit(), units.getPredOf(t2.getEndUnit()));
            while (it.hasNext()) {
                trapsSet.add(it.next());
            }
        }
        return trapsSet;
    }

    public static void splitTrapsAgainst(Body b, Unit rangeStart, Unit rangeEnd) {
        Chain<Trap> traps = b.getTraps();
        UnitPatchingChain units = b.getUnits();
        Iterator<Trap> trapsIt = traps.snapshotIterator();
        block0: while (trapsIt.hasNext()) {
            Trap t2 = trapsIt.next();
            Iterator<Unit> unitIt = units.iterator(t2.getBeginUnit(), t2.getEndUnit());
            boolean insideRange = false;
            while (unitIt.hasNext()) {
                Unit u = unitIt.next();
                if (u.equals(rangeStart)) {
                    insideRange = true;
                }
                if (!unitIt.hasNext()) {
                    if (!insideRange) continue block0;
                    Trap newTrap = (Trap)t2.clone();
                    t2.setBeginUnit(rangeStart);
                    newTrap.setEndUnit(rangeStart);
                    traps.insertAfter(newTrap, t2);
                }
                if (!u.equals(rangeEnd)) continue;
                if (!insideRange) {
                    throw new RuntimeException("inversed range?");
                }
                Trap firstTrap = (Trap)t2.clone();
                Trap secondTrap = (Trap)t2.clone();
                firstTrap.setEndUnit(rangeStart);
                secondTrap.setBeginUnit(rangeStart);
                secondTrap.setEndUnit(rangeEnd);
                t2.setBeginUnit(rangeEnd);
                traps.insertAfter(firstTrap, t2);
                traps.insertAfter(secondTrap, t2);
            }
        }
    }

    public static List<RefType> getExceptionTypesOf(Unit u, Body body) {
        ArrayList<RefType> possibleTypes = new ArrayList<RefType>();
        for (Trap trap : body.getTraps()) {
            if (trap.getHandlerUnit() != u) continue;
            RefType type = ModuleUtil.module_mode() ? ModuleRefType.v(trap.getException().getName(), Optional.fromNullable(trap.getException().moduleName)) : RefType.v(trap.getException().getName());
            possibleTypes.add(type);
        }
        return possibleTypes;
    }
}

