/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.AmbiguousFieldException;
import soot.AmbiguousMethodException;
import soot.Modifier;
import soot.ModuleRefType;
import soot.ModuleScene;
import soot.ModuleUtil;
import soot.RefType;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.SootModuleInfo;
import soot.Type;
import soot.baf.BafBody;
import soot.dava.toolkits.base.misc.PackageNamer;
import soot.options.Options;
import soot.tagkit.AbstractHost;
import soot.util.Chain;
import soot.util.EmptyChain;
import soot.util.HashChain;
import soot.util.Numberable;
import soot.util.NumberedString;
import soot.util.SmallNumberedMap;
import soot.validation.ClassFlagsValidator;
import soot.validation.ClassValidator;
import soot.validation.MethodDeclarationValidator;
import soot.validation.OuterClassValidator;
import soot.validation.ValidationException;

public class SootClass
extends AbstractHost
implements Numberable {
    private static final Logger logger = LoggerFactory.getLogger(SootClass.class);
    protected String name;
    protected String shortName;
    protected String fixedShortName;
    protected String packageName;
    protected String fixedPackageName;
    protected int modifiers;
    protected Chain<SootField> fields;
    protected SmallNumberedMap<SootMethod> subSigToMethods;
    protected List<SootMethod> methodList;
    protected Chain<SootClass> interfaces;
    protected boolean isInScene;
    protected SootClass superClass;
    protected SootClass outerClass;
    protected boolean isPhantom;
    public final String moduleName;
    protected SootModuleInfo moduleInformation;
    public static final String INVOKEDYNAMIC_DUMMY_CLASS_NAME = "soot.dummy.InvokeDynamic";
    public static final int DANGLING = 0;
    public static final int HIERARCHY = 1;
    public static final int SIGNATURES = 2;
    public static final int BODIES = 3;
    private volatile int resolvingLevel = 0;
    private RefType refType;
    protected volatile int number = 0;
    private static ClassValidator[] validators;

    public SootClass(String name, int modifiers) {
        this(name, modifiers, null);
    }

    public SootClass(String name, int modifiers, String moduleName) {
        if (name.charAt(0) == '[') {
            throw new RuntimeException("Attempt to make a class whose name starts with [");
        }
        this.moduleName = moduleName;
        this.setName(name);
        this.modifiers = modifiers;
        this.initializeRefType(name, moduleName);
        if (Options.v().debug_resolver()) {
            logger.debug("created " + name + " with modifiers " + modifiers);
        }
        this.setResolvingLevel(3);
    }

    protected void initializeRefType(String name, String moduleName) {
        this.refType = ModuleUtil.module_mode() ? ModuleRefType.v(name, Optional.fromNullable(this.moduleName)) : RefType.v(name);
        this.refType.setSootClass(this);
    }

    public SootClass(String name, String moduleName) {
        this(name, 0, moduleName);
    }

    public SootClass(String name) {
        this(name, 0, null);
    }

    protected String levelToString(int level) {
        switch (level) {
            case 0: {
                return "DANGLING";
            }
            case 1: {
                return "HIERARCHY";
            }
            case 2: {
                return "SIGNATURES";
            }
            case 3: {
                return "BODIES";
            }
        }
        throw new RuntimeException("unknown resolving level");
    }

    public void checkLevel(int level) {
        int currentLevel = this.resolvingLevel();
        if (currentLevel >= level) {
            return;
        }
        if (!Scene.v().doneResolving() || Options.v().ignore_resolving_levels()) {
            return;
        }
        this.checkLevelIgnoreResolving(level);
    }

    public void checkLevelIgnoreResolving(int level) {
        int currentLevel = this.resolvingLevel();
        if (currentLevel < level) {
            String hint = "\nIf you are extending Soot, try to add the following call before calling soot.Main.main(..):\nScene.v().addBasicClass(" + this.getName() + "," + this.levelToString(level) + ");\nOtherwise, try whole-program mode (-w).";
            throw new RuntimeException("This operation requires resolving level " + this.levelToString(level) + " but " + this.name + " is at resolving level " + this.levelToString(currentLevel) + hint);
        }
    }

    public int resolvingLevel() {
        return this.resolvingLevel;
    }

    public void setResolvingLevel(int newLevel) {
        this.resolvingLevel = newLevel;
    }

    public boolean isInScene() {
        return this.isInScene;
    }

    public void setInScene(boolean isInScene) {
        this.isInScene = isInScene;
        Scene.v().getClassNumberer().add(this);
    }

    public int getFieldCount() {
        this.checkLevel(2);
        return this.fields == null ? 0 : this.fields.size();
    }

    public Chain<SootField> getFields() {
        this.checkLevel(2);
        return this.fields == null ? EmptyChain.v() : this.fields;
    }

    public void addField(SootField f) {
        this.checkLevel(2);
        if (f.isDeclared()) {
            throw new RuntimeException("already declared: " + f.getName());
        }
        if (this.declaresField(f.getName(), f.getType())) {
            throw new RuntimeException("Field already exists : " + f.getName() + " of type " + f.getType());
        }
        if (this.fields == null) {
            this.fields = new HashChain<SootField>();
        }
        this.fields.add(f);
        f.setDeclared(true);
        f.setDeclaringClass(this);
    }

    public void removeField(SootField f) {
        this.checkLevel(2);
        if (!f.isDeclared() || f.getDeclaringClass() != this) {
            throw new RuntimeException("did not declare: " + f.getName());
        }
        if (this.fields != null) {
            this.fields.remove(f);
        }
        f.setDeclared(false);
        f.setDeclaringClass(null);
    }

    public SootField getField(String name, Type type) {
        SootField sf = this.getFieldUnsafe(name, type);
        if (sf == null) {
            throw new RuntimeException("No field " + name + " in class " + this.getName());
        }
        return sf;
    }

    public SootField getFieldUnsafe(String name, Type type) {
        this.checkLevel(2);
        if (this.fields == null) {
            return null;
        }
        for (SootField field : this.fields.getElementsUnsorted()) {
            if (!field.getName().equals(name) || !field.getType().equals(type)) continue;
            return field;
        }
        return null;
    }

    public SootField getFieldByName(String name) {
        SootField foundField = this.getFieldByNameUnsafe(name);
        if (foundField == null) {
            throw new RuntimeException("No field " + name + " in class " + this.getName());
        }
        return foundField;
    }

    public SootField getFieldByNameUnsafe(String name) {
        this.checkLevel(2);
        if (this.fields == null) {
            return null;
        }
        SootField foundField = null;
        for (SootField field : this.fields.getElementsUnsorted()) {
            if (!field.getName().equals(name)) continue;
            if (foundField == null) {
                foundField = field;
                continue;
            }
            throw new AmbiguousFieldException(name, this.name);
        }
        return foundField;
    }

    public SootField getField(String subsignature) {
        SootField sf = this.getFieldUnsafe(subsignature);
        if (sf == null) {
            throw new RuntimeException("No field " + subsignature + " in class " + this.getName());
        }
        return sf;
    }

    public SootField getFieldUnsafe(String subsignature) {
        this.checkLevel(2);
        if (this.fields == null) {
            return null;
        }
        for (SootField field : this.fields.getElementsUnsorted()) {
            if (!field.getSubSignature().equals(subsignature)) continue;
            return field;
        }
        return null;
    }

    public boolean declaresField(String subsignature) {
        this.checkLevel(2);
        return this.getFieldUnsafe(subsignature) != null;
    }

    public SootMethod getMethod(NumberedString subsignature) {
        SootMethod ret = this.getMethodUnsafe(subsignature);
        if (ret == null) {
            throw new RuntimeException("No method " + subsignature + " in class " + this.getName());
        }
        return ret;
    }

    public SootMethod getMethodUnsafe(NumberedString subsignature) {
        this.checkLevel(2);
        if (this.subSigToMethods == null) {
            return null;
        }
        SootMethod ret = this.subSigToMethods.get(subsignature);
        return ret;
    }

    public boolean declaresMethod(NumberedString subsignature) {
        this.checkLevel(2);
        if (this.subSigToMethods == null) {
            return false;
        }
        SootMethod ret = this.subSigToMethods.get(subsignature);
        return ret != null;
    }

    public SootMethod getMethod(String subsignature) {
        this.checkLevel(2);
        NumberedString numberedString = Scene.v().getSubSigNumberer().find(subsignature);
        if (numberedString == null) {
            throw new RuntimeException("No method " + subsignature + " in class " + this.getName());
        }
        return this.getMethod(numberedString);
    }

    public SootMethod getMethodUnsafe(String subsignature) {
        this.checkLevel(2);
        NumberedString numberedString = Scene.v().getSubSigNumberer().find(subsignature);
        return numberedString == null ? null : this.getMethodUnsafe(numberedString);
    }

    public boolean declaresMethod(String subsignature) {
        this.checkLevel(2);
        NumberedString numberedString = Scene.v().getSubSigNumberer().find(subsignature);
        return numberedString == null ? false : this.declaresMethod(numberedString);
    }

    public boolean declaresFieldByName(String name) {
        this.checkLevel(2);
        if (this.fields == null) {
            return false;
        }
        for (SootField field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean declaresField(String name, Type type) {
        this.checkLevel(2);
        if (this.fields == null) {
            return false;
        }
        for (SootField field : this.fields) {
            if (!field.getName().equals(name) || !field.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public int getMethodCount() {
        this.checkLevel(2);
        if (this.subSigToMethods == null) {
            return 0;
        }
        return this.subSigToMethods.nonNullSize();
    }

    public Iterator<SootMethod> methodIterator() {
        this.checkLevel(2);
        if (this.methodList == null) {
            return Collections.emptyIterator();
        }
        return new Iterator<SootMethod>(){
            final Iterator<SootMethod> internalIterator;
            private SootMethod currentMethod;
            {
                this.internalIterator = SootClass.this.methodList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.internalIterator.hasNext();
            }

            @Override
            public SootMethod next() {
                this.currentMethod = this.internalIterator.next();
                return this.currentMethod;
            }

            @Override
            public void remove() {
                this.internalIterator.remove();
                SootClass.this.subSigToMethods.put(this.currentMethod.getNumberedSubSignature(), null);
                this.currentMethod.setDeclared(false);
            }
        };
    }

    public List<SootMethod> getMethods() {
        this.checkLevel(2);
        if (this.methodList == null) {
            return Collections.emptyList();
        }
        return this.methodList;
    }

    public SootMethod getMethod(String name, List<Type> parameterTypes, Type returnType) {
        SootMethod sm = this.getMethodUnsafe(name, parameterTypes, returnType);
        if (sm != null) {
            return sm;
        }
        throw new RuntimeException("Class " + this.getName() + " doesn't have method " + name + "(" + parameterTypes + ") : " + returnType);
    }

    public SootMethod getMethodUnsafe(String name, List<Type> parameterTypes, Type returnType) {
        this.checkLevel(2);
        if (this.methodList == null) {
            return null;
        }
        for (SootMethod method : new ArrayList<SootMethod>(this.methodList)) {
            if (!method.getName().equals(name) || !parameterTypes.equals(method.getParameterTypes()) || !returnType.equals(method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    public SootMethod getMethod(String name, List<Type> parameterTypes) {
        this.checkLevel(2);
        SootMethod foundMethod = null;
        if (this.methodList == null) {
            return null;
        }
        for (SootMethod method : this.methodList) {
            if (!method.getName().equals(name) || !parameterTypes.equals(method.getParameterTypes())) continue;
            if (foundMethod == null) {
                foundMethod = method;
                continue;
            }
            throw new AmbiguousMethodException(name, this.name);
        }
        if (foundMethod == null) {
            throw new RuntimeException("couldn't find method " + name + "(" + parameterTypes + ") in " + this);
        }
        return foundMethod;
    }

    public SootMethod getMethodByNameUnsafe(String name) {
        this.checkLevel(2);
        SootMethod foundMethod = null;
        if (this.methodList == null) {
            return null;
        }
        for (SootMethod method : this.methodList) {
            if (!method.getName().equals(name)) continue;
            if (foundMethod == null) {
                foundMethod = method;
                continue;
            }
            throw new AmbiguousMethodException(name, this.name);
        }
        return foundMethod;
    }

    public SootMethod getMethodByName(String name) {
        SootMethod foundMethod = this.getMethodByNameUnsafe(name);
        if (foundMethod == null) {
            throw new RuntimeException("couldn't find method " + name + "(*) in " + this);
        }
        return foundMethod;
    }

    public boolean declaresMethod(String name, List<Type> parameterTypes) {
        this.checkLevel(2);
        if (this.methodList == null) {
            return false;
        }
        for (SootMethod method : this.methodList) {
            if (!method.getName().equals(name) || !method.getParameterTypes().equals(parameterTypes)) continue;
            return true;
        }
        return false;
    }

    public boolean declaresMethod(String name, List<Type> parameterTypes, Type returnType) {
        this.checkLevel(2);
        if (this.methodList == null) {
            return false;
        }
        for (SootMethod method : this.methodList) {
            if (!method.getName().equals(name) || !method.getParameterTypes().equals(parameterTypes) || !method.getReturnType().equals(returnType)) continue;
            return true;
        }
        return false;
    }

    public boolean declaresMethodByName(String name) {
        this.checkLevel(2);
        if (this.methodList == null) {
            return false;
        }
        for (SootMethod method : this.methodList) {
            if (!method.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addMethod(SootMethod m4) {
        this.checkLevel(2);
        if (m4.isDeclared()) {
            throw new RuntimeException("already declared: " + m4.getName());
        }
        if (this.methodList == null) {
            this.methodList = Collections.synchronizedList(new ArrayList());
            this.subSigToMethods = new SmallNumberedMap();
        }
        if (this.subSigToMethods.get(m4.getNumberedSubSignature()) != null) {
            throw new RuntimeException("Attempting to add method " + m4.getSubSignature() + " to class " + this + ", but the class already has a method with that signature.");
        }
        this.subSigToMethods.put(m4.getNumberedSubSignature(), m4);
        this.methodList.add(m4);
        m4.setDeclared(true);
        m4.setDeclaringClass(this);
    }

    public synchronized SootMethod getOrAddMethod(SootMethod m4) {
        SootMethod old;
        this.checkLevel(2);
        if (m4.isDeclared()) {
            throw new RuntimeException("already declared: " + m4.getName());
        }
        if (this.methodList == null) {
            this.methodList = Collections.synchronizedList(new ArrayList());
            this.subSigToMethods = new SmallNumberedMap();
        }
        if ((old = this.subSigToMethods.get(m4.getNumberedSubSignature())) != null) {
            return old;
        }
        this.subSigToMethods.put(m4.getNumberedSubSignature(), m4);
        this.methodList.add(m4);
        m4.setDeclared(true);
        m4.setDeclaringClass(this);
        return m4;
    }

    public synchronized SootField getOrAddField(SootField f) {
        this.checkLevel(2);
        if (f.isDeclared()) {
            throw new RuntimeException("already declared: " + f.getName());
        }
        SootField old = this.getFieldUnsafe(f.getName(), f.getType());
        if (old != null) {
            return old;
        }
        if (this.fields == null) {
            this.fields = new HashChain<SootField>();
        }
        this.fields.add(f);
        f.setDeclared(true);
        f.setDeclaringClass(this);
        return f;
    }

    public void removeMethod(SootMethod m4) {
        this.checkLevel(2);
        if (!m4.isDeclared() || m4.getDeclaringClass() != this) {
            throw new RuntimeException("incorrect declarer for remove: " + m4.getName());
        }
        if (this.subSigToMethods.get(m4.getNumberedSubSignature()) == null) {
            throw new RuntimeException("Attempt to remove method " + m4.getSubSignature() + " which is not in class " + this);
        }
        this.subSigToMethods.put(m4.getNumberedSubSignature(), null);
        this.methodList.remove(m4);
        m4.setDeclared(false);
        m4.setDeclaringClass(null);
        Scene.v().getMethodNumberer().remove(m4);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int getInterfaceCount() {
        this.checkLevel(1);
        return this.interfaces == null ? 0 : this.interfaces.size();
    }

    public Chain<SootClass> getInterfaces() {
        this.checkLevel(1);
        return this.interfaces == null ? EmptyChain.v() : this.interfaces;
    }

    public boolean implementsInterface(String name) {
        this.checkLevel(1);
        if (this.interfaces == null) {
            return false;
        }
        for (SootClass sc : this.interfaces) {
            if (!sc.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addInterface(SootClass interfaceClass) {
        this.checkLevel(1);
        if (this.implementsInterface(interfaceClass.getName())) {
            throw new RuntimeException("duplicate interface: " + interfaceClass.getName());
        }
        if (this.interfaces == null) {
            this.interfaces = new HashChain<SootClass>();
        }
        this.interfaces.add(interfaceClass);
    }

    public void removeInterface(SootClass interfaceClass) {
        this.checkLevel(1);
        if (!this.implementsInterface(interfaceClass.getName())) {
            throw new RuntimeException("no such interface: " + interfaceClass.getName());
        }
        this.interfaces.remove(interfaceClass);
    }

    public boolean hasSuperclass() {
        this.checkLevel(1);
        return this.superClass != null;
    }

    public SootClass getSuperclass() {
        this.checkLevel(1);
        if (this.superClass == null && !this.isPhantom()) {
            throw new RuntimeException("no superclass for " + this.getName());
        }
        return this.superClass;
    }

    public SootClass getSuperclassUnsafe() {
        this.checkLevel(1);
        return this.superClass;
    }

    public void setSuperclass(SootClass c) {
        this.checkLevel(1);
        this.superClass = c;
    }

    public boolean hasOuterClass() {
        this.checkLevel(1);
        return this.outerClass != null;
    }

    public SootClass getOuterClass() {
        this.checkLevel(1);
        if (this.outerClass == null) {
            throw new RuntimeException("no outer class");
        }
        return this.outerClass;
    }

    public SootClass getOuterClassUnsafe() {
        this.checkLevel(1);
        return this.outerClass;
    }

    public void setOuterClass(SootClass c) {
        this.checkLevel(1);
        this.outerClass = c;
    }

    public boolean isInnerClass() {
        return this.hasOuterClass();
    }

    public String getName() {
        return this.name;
    }

    public String getJavaStyleName() {
        if (PackageNamer.v().has_FixedNames()) {
            if (this.fixedShortName == null) {
                this.fixedShortName = PackageNamer.v().get_FixedClassName(this.name);
            }
            if (!PackageNamer.v().use_ShortName(this.getJavaPackageName(), this.fixedShortName)) {
                return this.getJavaPackageName() + "." + this.fixedShortName;
            }
            return this.fixedShortName;
        }
        return this.shortName;
    }

    public String getShortJavaStyleName() {
        if (PackageNamer.v().has_FixedNames()) {
            if (this.fixedShortName == null) {
                this.fixedShortName = PackageNamer.v().get_FixedClassName(this.name);
            }
            return this.fixedShortName;
        }
        return this.shortName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getJavaPackageName() {
        if (PackageNamer.v().has_FixedNames()) {
            if (this.fixedPackageName == null) {
                this.fixedPackageName = PackageNamer.v().get_FixedPackageName(this.packageName);
            }
            return this.fixedPackageName;
        }
        return this.packageName;
    }

    public void setName(String name) {
        this.name = name.intern();
        this.shortName = name;
        this.packageName = "";
        int index = name.lastIndexOf(46);
        if (index > 0) {
            this.shortName = name.substring(index + 1);
            this.packageName = name.substring(0, index);
        }
        this.fixedShortName = null;
        this.fixedPackageName = null;
    }

    public boolean isInterface() {
        this.checkLevel(1);
        return Modifier.isInterface(this.getModifiers());
    }

    public boolean isEnum() {
        this.checkLevel(1);
        return Modifier.isEnum(this.getModifiers());
    }

    public boolean isSynchronized() {
        this.checkLevel(1);
        return Modifier.isSynchronized(this.getModifiers());
    }

    public boolean isConcrete() {
        return !this.isInterface() && !this.isAbstract();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean containsBafBody() {
        Iterator<SootMethod> methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod m4 = methodIt.next();
            if (!m4.hasActiveBody() || !(m4.getActiveBody() instanceof BafBody)) continue;
            return true;
        }
        return false;
    }

    public void setRefType(RefType refType) {
        this.refType = refType;
    }

    public boolean hasRefType() {
        return this.refType != null;
    }

    public RefType getType() {
        return this.refType;
    }

    public String toString() {
        return this.getName();
    }

    public void renameFieldsAndMethods(boolean privateOnly) {
        this.checkLevel(2);
        Iterator<SootField> fieldIt = this.getFields().iterator();
        int fieldCount = 0;
        if (fieldIt.hasNext()) {
            while (fieldIt.hasNext()) {
                SootField f = fieldIt.next();
                if (privateOnly && !Modifier.isPrivate(f.getModifiers())) continue;
                String newFieldName = "__field" + fieldCount++;
                f.setName(newFieldName);
            }
        }
        Iterator<SootMethod> methodIt = this.methodIterator();
        int methodCount = 0;
        if (methodIt.hasNext()) {
            while (methodIt.hasNext()) {
                SootMethod m4 = methodIt.next();
                if (privateOnly && !Modifier.isPrivate(m4.getModifiers())) continue;
                String newMethodName = "__method" + methodCount++;
                m4.setName(newMethodName);
            }
        }
    }

    public boolean isApplicationClass() {
        return Scene.v().getApplicationClasses().contains(this);
    }

    public void setApplicationClass() {
        if (this.isApplicationClass()) {
            return;
        }
        Chain<SootClass> c = Scene.v().getContainingChain(this);
        if (c != null) {
            c.remove(this);
        }
        Scene.v().getApplicationClasses().add(this);
        this.isPhantom = false;
    }

    public boolean isLibraryClass() {
        return Scene.v().getLibraryClasses().contains(this);
    }

    public void setLibraryClass() {
        if (this.isLibraryClass()) {
            return;
        }
        Chain<SootClass> c = Scene.v().getContainingChain(this);
        if (c != null) {
            c.remove(this);
        }
        Scene.v().getLibraryClasses().add(this);
        this.isPhantom = false;
    }

    public boolean isJavaLibraryClass() {
        return this.name.startsWith("java.") || this.name.startsWith("sun.") || this.name.startsWith("javax.") || this.name.startsWith("com.sun.") || this.name.startsWith("org.omg.") || this.name.startsWith("org.xml.") || this.name.startsWith("org.w3c.dom");
    }

    public boolean isPhantomClass() {
        return Scene.v().getPhantomClasses().contains(this);
    }

    public void setPhantomClass() {
        Chain<SootClass> c = Scene.v().getContainingChain(this);
        if (c != null) {
            c.remove(this);
        }
        Scene.v().getPhantomClasses().add(this);
        this.isPhantom = true;
    }

    public boolean isPhantom() {
        return this.isPhantom;
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public void setNumber(int number) {
        this.number = number;
    }

    public void rename(String newName) {
        this.name = newName;
        if (this.refType != null) {
            this.refType.setClassName(this.name);
        } else {
            this.refType = ModuleUtil.module_mode() ? ModuleScene.v().getOrAddRefType(this.name, Optional.fromNullable(this.moduleName)) : Scene.v().getOrAddRefType(this.name);
        }
    }

    private static synchronized ClassValidator[] getValidators() {
        if (validators == null) {
            validators = new ClassValidator[]{OuterClassValidator.v(), MethodDeclarationValidator.v(), ClassFlagsValidator.v()};
        }
        return validators;
    }

    public void validate() {
        ArrayList<ValidationException> exceptionList = new ArrayList<ValidationException>();
        this.validate(exceptionList);
        if (!exceptionList.isEmpty()) {
            throw (ValidationException)exceptionList.get(0);
        }
    }

    public void validate(List<ValidationException> exceptionList) {
        boolean runAllValidators = Options.v().debug() || Options.v().validate();
        for (ClassValidator validator : SootClass.getValidators()) {
            if (!validator.isBasicValidator() && !runAllValidators) continue;
            validator.validate(this, exceptionList);
        }
    }

    public String getFilePath() {
        if (ModuleUtil.module_mode()) {
            return this.moduleName + ":" + this.getName();
        }
        return this.getName();
    }

    public SootModuleInfo getModuleInformation() {
        return this.moduleInformation;
    }

    public void setModuleInformation(SootModuleInfo moduleInformation) {
        this.moduleInformation = moduleInformation;
    }

    public boolean isExportedByModule() {
        if (this.getModuleInformation() == null && ModuleUtil.module_mode()) {
            Scene.v().forceResolve(this.getName(), 3);
        }
        if (this.getModuleInformation() == null) {
            return true;
        }
        return this.getModuleInformation().exportsPackagePublic(this.getJavaPackageName());
    }

    public boolean isExportedByModule(String toModule) {
        if (this.getModuleInformation() == null && ModuleUtil.module_mode()) {
            ModuleScene.v().forceResolve(this.getName(), 3, Optional.of(this.moduleName));
        }
        return this.getModuleInformation().exportsPackage(this.getJavaPackageName(), toModule);
    }

    public boolean isOpenedByModule() {
        if (this.getModuleInformation() == null && ModuleUtil.module_mode()) {
            Scene.v().forceResolve(this.getName(), 3);
        }
        if (this.getModuleInformation() == null) {
            return true;
        }
        return this.getModuleInformation().openPackagePublic(this.getJavaPackageName());
    }
}

