/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.MagicNumberFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pxb.android.axml.AxmlReader;
import pxb.android.axml.AxmlVisitor;
import pxb.android.axml.NodeVisitor;
import soot.AbstractSootFieldRef;
import soot.AndroidPlatformException;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.ClassSource;
import soot.Context;
import soot.DoubleType;
import soot.EntryPoints;
import soot.FastHierarchy;
import soot.FloatType;
import soot.G;
import soot.Hierarchy;
import soot.IntType;
import soot.Kind;
import soot.Local;
import soot.LongType;
import soot.ModuleUtil;
import soot.PhaseOptions;
import soot.PointsToAnalysis;
import soot.PolymorphicMethodRef;
import soot.RefType;
import soot.ShortType;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.SootMethodRefImpl;
import soot.SootResolver;
import soot.SourceLocator;
import soot.Type;
import soot.Unit;
import soot.VoidType;
import soot.dexpler.DalvikThrowAnalysis;
import soot.jimple.spark.internal.ClientAccessibilityOracle;
import soot.jimple.spark.internal.PublicAndProtectedAccessibility;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.ContextSensitiveCallGraph;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.pointer.DumbPointerAnalysis;
import soot.jimple.toolkits.pointer.SideEffectAnalysis;
import soot.options.CGOptions;
import soot.options.Options;
import soot.toolkits.exceptions.PedanticThrowAnalysis;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.exceptions.UnitThrowAnalysis;
import soot.util.ArrayNumberer;
import soot.util.Chain;
import soot.util.HashChain;
import soot.util.IterableNumberer;
import soot.util.MapNumberer;
import soot.util.Numberable;
import soot.util.Numberer;
import soot.util.StringNumberer;
import soot.util.WeakMapNumberer;

public class Scene {
    private static final Logger logger = LoggerFactory.getLogger(Scene.class);
    private final int defaultSdkVersion = 15;
    private final Map<String, Integer> maxAPIs = new HashMap<String, Integer>();
    private AndroidVersionInfo androidSDKVersionInfo;
    Chain<SootClass> classes = new HashChain<SootClass>();
    Chain<SootClass> applicationClasses = new HashChain<SootClass>();
    Chain<SootClass> libraryClasses = new HashChain<SootClass>();
    Chain<SootClass> phantomClasses = new HashChain<SootClass>();
    protected final Map<String, RefType> nameToClass = new ConcurrentHashMap<String, RefType>();
    protected final ArrayNumberer<Kind> kindNumberer;
    protected IterableNumberer<Type> typeNumberer = new ArrayNumberer<Type>();
    protected IterableNumberer<SootMethod> methodNumberer = new ArrayNumberer<SootMethod>();
    protected Numberer<Unit> unitNumberer = new MapNumberer<Unit>();
    protected Numberer<Context> contextNumberer = null;
    protected Numberer<SparkField> fieldNumberer = new ArrayNumberer<SparkField>();
    protected IterableNumberer<SootClass> classNumberer = new ArrayNumberer<SootClass>();
    protected StringNumberer subSigNumberer = new StringNumberer();
    protected IterableNumberer<Local> localNumberer = new ArrayNumberer<Local>();
    protected Hierarchy activeHierarchy;
    protected FastHierarchy activeFastHierarchy;
    protected CallGraph activeCallGraph;
    protected ReachableMethods reachableMethods;
    protected PointsToAnalysis activePointsToAnalysis;
    protected SideEffectAnalysis activeSideEffectAnalysis;
    protected List<SootMethod> entryPoints;
    protected ClientAccessibilityOracle accessibilityOracle;
    protected boolean allowsPhantomRefs = false;
    protected SootClass mainClass;
    protected String sootClassPath = null;
    private ThrowAnalysis defaultThrowAnalysis = null;
    private int androidAPIVersion = -1;
    Set<String> reservedNames = new HashSet<String>();
    private int stateCount;
    private ContextSensitiveCallGraph cscg = null;
    protected final Set<String>[] basicclasses = new Set[4];
    private List<SootClass> dynamicClasses = null;
    List<String> pkgList;
    private boolean doneResolving = false;
    private boolean incrementalBuild;
    protected LinkedList<String> excludedPackages;

    public Scene(Singletons.Global g2) {
        this.setReservedNames();
        String scp = System.getProperty("soot.class.path");
        if (scp != null) {
            this.setSootClassPath(scp);
        }
        this.kindNumberer = new ArrayNumberer((Numberable[])new Kind[]{Kind.INVALID, Kind.STATIC, Kind.VIRTUAL, Kind.INTERFACE, Kind.SPECIAL, Kind.CLINIT, Kind.THREAD, Kind.EXECUTOR, Kind.ASYNCTASK, Kind.FINALIZE, Kind.INVOKE_FINALIZE, Kind.PRIVILEGED, Kind.NEWINSTANCE});
        if (Options.v().weak_map_structures()) {
            this.methodNumberer = new WeakMapNumberer<SootMethod>();
            this.fieldNumberer = new WeakMapNumberer<SparkField>();
            this.classNumberer = new WeakMapNumberer<SootClass>();
            this.localNumberer = new WeakMapNumberer<Local>();
        }
        this.addSootBasicClasses();
        this.determineExcludedPackages();
    }

    private void determineExcludedPackages() {
        this.excludedPackages = new LinkedList();
        if (Options.v().exclude() != null) {
            this.excludedPackages.addAll(Options.v().exclude());
        }
        if (!Options.v().include_all() && Options.v().output_format() != 10 && Options.v().output_format() != 11) {
            this.excludedPackages.add("java.*");
            this.excludedPackages.add("sun.*");
            this.excludedPackages.add("javax.*");
            this.excludedPackages.add("com.sun.*");
            this.excludedPackages.add("com.ibm.*");
            this.excludedPackages.add("org.xml.*");
            this.excludedPackages.add("org.w3c.*");
            this.excludedPackages.add("apple.awt.*");
            this.excludedPackages.add("com.apple.*");
        }
    }

    public static Scene v() {
        if (ModuleUtil.module_mode()) {
            return G.v().soot_ModuleScene();
        }
        return G.v().soot_Scene();
    }

    public void setMainClass(SootClass m4) {
        this.mainClass = m4;
        if (!m4.declaresMethod(this.getSubSigNumberer().findOrAdd("void main(java.lang.String[])"))) {
            throw new RuntimeException("Main-class has no main method!");
        }
    }

    public Set<String> getReservedNames() {
        return this.reservedNames;
    }

    public String quotedNameOf(String s2) {
        boolean found = s2.contains("-");
        for (String token : this.reservedNames) {
            if (!s2.contains(token)) continue;
            found = true;
            break;
        }
        if (!found) {
            return s2;
        }
        StringBuilder res = new StringBuilder(s2.length());
        for (String part : s2.split("\\.")) {
            if (res.length() > 0) {
                res.append('.');
            }
            if (part.startsWith("-") || this.reservedNames.contains(part)) {
                res.append('\'');
                res.append(part);
                res.append('\'');
                continue;
            }
            res.append(part);
        }
        return res.toString();
    }

    public String unescapeName(String s2) {
        if (!s2.contains("'")) {
            return s2;
        }
        StringBuilder res = new StringBuilder(s2.length());
        for (String part : s2.split("\\.")) {
            if (res.length() > 0) {
                res.append('.');
            }
            if (part.startsWith("'") && part.endsWith("'")) {
                res.append(part.substring(1, part.length() - 1));
                continue;
            }
            res.append(part);
        }
        return res.toString();
    }

    public boolean hasMainClass() {
        if (this.mainClass == null) {
            this.setMainClassFromOptions();
        }
        return this.mainClass != null;
    }

    public SootClass getMainClass() {
        if (!this.hasMainClass()) {
            throw new RuntimeException("There is no main class set!");
        }
        return this.mainClass;
    }

    public SootMethod getMainMethod() {
        if (!this.hasMainClass()) {
            throw new RuntimeException("There is no main class set!");
        }
        SootMethod mainMethod = this.mainClass.getMethodUnsafe("main", Collections.singletonList(ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v());
        if (mainMethod == null) {
            throw new RuntimeException("Main class declares no main method!");
        }
        return mainMethod;
    }

    public void setSootClassPath(String p) {
        this.sootClassPath = p;
        SourceLocator.v().invalidateClassPath();
    }

    public void extendSootClassPath(String newPathElement) {
        this.sootClassPath = this.sootClassPath + File.pathSeparator + newPathElement;
        SourceLocator.v().extendClassPath(newPathElement);
    }

    public String getSootClassPath() {
        if (this.sootClassPath == null) {
            String optionscp = Options.v().soot_classpath();
            if (optionscp != null && optionscp.length() > 0) {
                this.sootClassPath = optionscp;
            }
            if (this.sootClassPath == null || this.sootClassPath.isEmpty()) {
                this.sootClassPath = this.defaultClassPath();
            } else if (Options.v().prepend_classpath()) {
                this.sootClassPath = this.sootClassPath + File.pathSeparator + this.defaultClassPath();
            }
            List<String> process_dir = Options.v().process_dir();
            StringBuffer pds = new StringBuffer();
            for (String path : process_dir) {
                if (this.sootClassPath.contains(path)) continue;
                pds.append(path);
                pds.append(File.pathSeparator);
            }
            this.sootClassPath = pds + this.sootClassPath;
        }
        return this.sootClassPath;
    }

    private int getMaxAPIAvailable(String dir) {
        Integer mapi = this.maxAPIs.get(dir);
        if (mapi != null) {
            return mapi;
        }
        File d = new File(dir);
        if (!d.exists()) {
            throw new AndroidPlatformException(String.format("The Android platform directory you have specified (%s) does not exist. Please check.", dir));
        }
        File[] files = d.listFiles();
        if (files == null) {
            return -1;
        }
        int maxApi = -1;
        for (File f : files) {
            String name = f.getName();
            if (!f.isDirectory() || !name.startsWith("android-")) continue;
            try {
                int v = Integer.decode(name.split("android-")[1]);
                if (v <= maxApi) continue;
                maxApi = v;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.maxAPIs.put(dir, maxApi);
        return maxApi;
    }

    public String getAndroidJarPath(String jars, String apk) {
        int APIVersion = this.getAndroidAPIVersion(jars, apk);
        String jarPath = jars + File.separator + "android-" + APIVersion + File.separator + "android.jar";
        File f = new File(jarPath);
        if (!f.isFile()) {
            throw new AndroidPlatformException(String.format("error: target android.jar %s does not exist.", jarPath));
        }
        return jarPath;
    }

    public int getAndroidAPIVersion() {
        return this.androidAPIVersion > 0 ? this.androidAPIVersion : (Options.v().android_api_version() > 0 ? Options.v().android_api_version() : 15);
    }

    private int getAndroidAPIVersion(String jars, String apk) {
        String jarPath;
        File apkF;
        if (this.androidAPIVersion > 0) {
            return this.androidAPIVersion;
        }
        File jarsF = new File(jars);
        File file = apkF = apk == null ? null : new File(apk);
        if (!jarsF.exists()) {
            throw new AndroidPlatformException(String.format("Android platform directory '%s' does not exist!", jarsF.getAbsolutePath()));
        }
        if (apkF != null && !apkF.exists()) {
            throw new RuntimeException("file '" + apk + "' does not exist!");
        }
        this.androidAPIVersion = 15;
        if (Options.v().android_api_version() > 0) {
            this.androidAPIVersion = Options.v().android_api_version();
        } else if (apk != null && apk.toLowerCase().endsWith(".apk")) {
            this.androidAPIVersion = this.getTargetSDKVersion(apk, jars);
        }
        int maxAPI = this.getMaxAPIAvailable(jars);
        if (maxAPI > 0 && this.androidAPIVersion > maxAPI) {
            this.androidAPIVersion = maxAPI;
        }
        while (this.androidAPIVersion < maxAPI && !new File(jarPath = jars + File.separator + "android-" + this.androidAPIVersion + File.separator + "android.jar").exists()) {
            ++this.androidAPIVersion;
        }
        return this.androidAPIVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTargetSDKVersion(String apkFile, String platformJARs) {
        InputStream manifestIS = null;
        ZipFile archive = null;
        try {
            try {
                archive = new ZipFile(apkFile);
                Enumeration<? extends ZipEntry> entries = archive.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.equals("AndroidManifest.xml")) continue;
                    manifestIS = archive.getInputStream(entry);
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error when looking for manifest in apk: " + e);
            }
            if (manifestIS == null) {
                logger.debug("Could not find sdk version in Android manifest! Using default: 15");
                int e = 15;
                return e;
            }
            int maxAPI = this.getMaxAPIAvailable(platformJARs);
            this.androidSDKVersionInfo = this.getAndroidVersionInfo(manifestIS);
            int APIVersion = -1;
            if (this.androidSDKVersionInfo.sdkTargetVersion != -1) {
                if (this.androidSDKVersionInfo.sdkTargetVersion > maxAPI && this.androidSDKVersionInfo.minSdkVersion != -1 && this.androidSDKVersionInfo.minSdkVersion <= maxAPI) {
                    logger.warn("Android API version '" + this.androidSDKVersionInfo.sdkTargetVersion + "' not available, using minApkVersion '" + this.androidSDKVersionInfo.minSdkVersion + "' instead");
                    APIVersion = this.androidSDKVersionInfo.minSdkVersion;
                } else {
                    APIVersion = this.androidSDKVersionInfo.sdkTargetVersion;
                }
            } else if (this.androidSDKVersionInfo.platformBuildVersionCode != -1) {
                if (this.androidSDKVersionInfo.platformBuildVersionCode > maxAPI && this.androidSDKVersionInfo.minSdkVersion != -1 && this.androidSDKVersionInfo.minSdkVersion <= maxAPI) {
                    logger.warn("Android API version '" + this.androidSDKVersionInfo.platformBuildVersionCode + "' not available, using minApkVersion '" + this.androidSDKVersionInfo.minSdkVersion + "' instead");
                    APIVersion = this.androidSDKVersionInfo.minSdkVersion;
                } else {
                    APIVersion = this.androidSDKVersionInfo.platformBuildVersionCode;
                }
            } else if (this.androidSDKVersionInfo.minSdkVersion != -1) {
                APIVersion = this.androidSDKVersionInfo.minSdkVersion;
            } else {
                logger.debug("Could not find sdk version in Android manifest! Using default: 15");
                APIVersion = 15;
            }
            if (APIVersion <= 2) {
                APIVersion = 3;
            }
            int n = APIVersion;
            return n;
        }
        finally {
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error when looking for manifest in apk: " + e);
                }
            }
        }
    }

    public AndroidVersionInfo getAndroidSDKVersionInfo() {
        return this.androidSDKVersionInfo;
    }

    private AndroidVersionInfo getAndroidVersionInfo(InputStream manifestIS) {
        final AndroidVersionInfo versionInfo = new AndroidVersionInfo();
        try {
            AxmlReader xmlReader = new AxmlReader(IOUtils.toByteArray(manifestIS));
            xmlReader.accept(new AxmlVisitor(){
                private String nodeName = null;

                @Override
                public void attr(String ns, String name, int resourceId, int type, Object obj) {
                    super.attr(ns, name, resourceId, type, obj);
                    if (this.nodeName != null && name != null) {
                        if (this.nodeName.equals("manifest")) {
                            if (name.equals("platformBuildVersionCode")) {
                                versionInfo.platformBuildVersionCode = Integer.valueOf("" + obj);
                            }
                        } else if (this.nodeName.equals("uses-sdk")) {
                            if (name.equals("targetSdkVersion") || name.equals("") && resourceId == 16843376) {
                                versionInfo.sdkTargetVersion = Integer.valueOf("" + obj);
                            } else if (name.equals("minSdkVersion") || name.equals("") && resourceId == 16843276) {
                                versionInfo.minSdkVersion = Integer.valueOf("" + obj);
                            }
                        }
                    }
                }

                @Override
                public NodeVisitor child(String ns, String name) {
                    this.nodeName = name;
                    return this;
                }
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return versionInfo;
    }

    public String defaultClassPath() {
        if (Options.v().src_prec() != 5) {
            for (String entry : Options.v().process_dir()) {
                if (!entry.toLowerCase().endsWith(".apk")) continue;
                System.err.println("APK file on process dir, but chosen src-prec does not support loading APKs");
                break;
            }
        }
        if (Options.v().src_prec() == 5) {
            return this.defaultAndroidClassPath();
        }
        String path = Scene.defaultJavaClassPath();
        if (path == null) {
            throw new RuntimeException("Error: cannot find rt.jar.");
        }
        return path;
    }

    private String defaultAndroidClassPath() {
        String androidJars = Options.v().android_jars();
        String forceAndroidJar = Options.v().force_android_jar();
        if ((androidJars == null || androidJars.equals("")) && (forceAndroidJar == null || forceAndroidJar.equals(""))) {
            throw new RuntimeException("You are analyzing an Android application but did not define android.jar. Options -android-jars or -force-android-jar should be used.");
        }
        String jarPath = "";
        if (forceAndroidJar != null && !forceAndroidJar.isEmpty()) {
            jarPath = forceAndroidJar;
            if (Options.v().android_api_version() > 0) {
                this.androidAPIVersion = Options.v().android_api_version();
            } else if (forceAndroidJar.contains("android-")) {
                Pattern pt = Pattern.compile("\\" + File.separatorChar + "android-(\\d+)\\" + File.separatorChar);
                Matcher m4 = pt.matcher(forceAndroidJar);
                if (m4.find()) {
                    this.androidAPIVersion = Integer.valueOf(m4.group(1));
                }
            } else {
                this.androidAPIVersion = 15;
            }
        } else if (androidJars != null && !androidJars.isEmpty()) {
            LinkedList<String> classPathEntries = new LinkedList<String>(Arrays.asList(Options.v().soot_classpath().split(File.pathSeparator)));
            classPathEntries.addAll(Options.v().process_dir());
            String targetApk = "";
            HashSet<String> targetDexs = new HashSet<String>();
            for (String entry : classPathEntries) {
                if (Scene.isApk(entry)) {
                    if (targetApk != null && !targetApk.isEmpty()) {
                        throw new RuntimeException("only one Android application can be analyzed when using option -android-jars.");
                    }
                    targetApk = entry;
                }
                if (!entry.toLowerCase().endsWith(".dex")) continue;
                targetDexs.add(entry);
            }
            if (targetApk == null || targetApk.isEmpty()) {
                if (targetDexs.isEmpty()) {
                    throw new RuntimeException("no apk file given");
                }
                jarPath = this.getAndroidJarPath(androidJars, null);
            } else {
                jarPath = this.getAndroidJarPath(androidJars, targetApk);
            }
        }
        if (jarPath.equals("")) {
            throw new RuntimeException("android.jar not found.");
        }
        File f = new File(jarPath);
        if (!f.exists()) {
            throw new RuntimeException("file '" + jarPath + "' does not exist!");
        }
        logger.debug("Using '" + jarPath + "' as android.jar");
        return jarPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isApk(String file) {
        boolean r = false;
        File apk = new File(file);
        MagicNumberFileFilter apkFilter = new MagicNumberFileFilter(new byte[]{80, 75, 3, 4});
        if (!apkFilter.accept(apk)) {
            return r;
        }
        ZipFile zf = null;
        try {
            zf = new ZipFile(file);
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry z = en.nextElement();
                String name = z.getName();
                if (!name.equals("classes.dex")) continue;
                r = true;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return r;
    }

    public static boolean isJavaGEQ9(String version2) {
        String[] elements = version2.split("\\.");
        Integer firstVersionDigest = Integer.valueOf(elements[0]);
        if (firstVersionDigest >= 9) {
            return true;
        }
        if (firstVersionDigest == 1 && elements.length > 1) {
            return Integer.valueOf(elements[1]) >= 9;
        }
        throw new IllegalArgumentException("Unknown Version number schema!");
    }

    public static String defaultJavaClassPath() {
        boolean javaGEQ9;
        StringBuilder sb = new StringBuilder();
        if (System.getProperty("os.name").equals("Mac OS X")) {
            File uiJar;
            String prefix = System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes" + File.separator;
            File classesJar = new File(prefix + "classes.jar");
            if (classesJar.exists()) {
                sb.append(classesJar.getAbsolutePath() + File.pathSeparator);
            }
            if ((uiJar = new File(prefix + "ui.jar")).exists()) {
                sb.append(uiJar.getAbsolutePath() + File.pathSeparator);
            }
        }
        if (javaGEQ9 = Scene.isJavaGEQ9(System.getProperty("java.version"))) {
            sb.append("VIRTUAL_FS_FOR_JDK");
            Scene.v().addBasicClass("java.lang.invoke.StringConcatFactory");
        } else {
            File rtJar = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar");
            if (rtJar.exists() && rtJar.isFile()) {
                sb.append(rtJar.getAbsolutePath());
            } else {
                rtJar = new File(System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar");
                if (rtJar.exists() && rtJar.isFile()) {
                    sb.append(rtJar.getAbsolutePath());
                } else {
                    return null;
                }
            }
        }
        if ((Options.v().whole_program() || Options.v().output_format() == 15) && !javaGEQ9) {
            sb.append(File.pathSeparator + System.getProperty("java.home") + File.separator + "lib" + File.separator + "jce.jar");
        }
        return sb.toString();
    }

    public int getState() {
        return this.stateCount;
    }

    protected synchronized void modifyHierarchy() {
        ++this.stateCount;
        this.activeHierarchy = null;
        this.activeFastHierarchy = null;
        this.activeSideEffectAnalysis = null;
        this.activePointsToAnalysis = null;
    }

    public void addClass(SootClass c) {
        this.addClassSilent(c);
        c.setLibraryClass();
        this.modifyHierarchy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addClassSilent(SootClass c) {
        SootClass sootClass = c;
        synchronized (sootClass) {
            if (c.isInScene()) {
                throw new RuntimeException("already managed: " + c.getName());
            }
            if (this.containsClass(c.getName())) {
                throw new RuntimeException("duplicate class: " + c.getName());
            }
            this.classes.add(c);
            c.getType().setSootClass(c);
            c.setInScene(true);
            if (!c.isPhantom) {
                this.modifyHierarchy();
            }
            this.nameToClass.computeIfAbsent(c.getName(), k -> c.getType());
        }
    }

    public void removeClass(SootClass c) {
        if (!c.isInScene()) {
            throw new RuntimeException();
        }
        this.classes.remove(c);
        if (c.isLibraryClass()) {
            this.libraryClasses.remove(c);
        } else if (c.isPhantomClass()) {
            this.phantomClasses.remove(c);
        } else if (c.isApplicationClass()) {
            this.applicationClasses.remove(c);
        }
        c.getType().setSootClass(null);
        c.setInScene(false);
        this.modifyHierarchy();
    }

    public boolean containsClass(String className) {
        RefType type = this.nameToClass.get(className);
        if (type == null) {
            return false;
        }
        if (!type.hasSootClass()) {
            return false;
        }
        SootClass c = type.getSootClass();
        return c.isInScene();
    }

    public boolean containsType(String className) {
        return this.nameToClass.containsKey(className);
    }

    public String signatureToClass(String sig) {
        if (sig.charAt(0) != '<') {
            throw new RuntimeException("oops " + sig);
        }
        if (sig.charAt(sig.length() - 1) != '>') {
            throw new RuntimeException("oops " + sig);
        }
        int index = sig.indexOf(":");
        if (index < 0) {
            throw new RuntimeException("oops " + sig);
        }
        return this.unescapeName(sig.substring(1, index));
    }

    public String signatureToSubsignature(String sig) {
        if (sig.charAt(0) != '<') {
            throw new RuntimeException("oops " + sig);
        }
        if (sig.charAt(sig.length() - 1) != '>') {
            throw new RuntimeException("oops " + sig);
        }
        int index = sig.indexOf(":");
        if (index < 0) {
            throw new RuntimeException("oops " + sig);
        }
        return sig.substring(index + 2, sig.length() - 1);
    }

    public SootField grabField(String fieldSignature) {
        String cname = this.signatureToClass(fieldSignature);
        String fname = this.signatureToSubsignature(fieldSignature);
        if (!this.containsClass(cname)) {
            return null;
        }
        SootClass c = this.getSootClass(cname);
        return c.getFieldUnsafe(fname);
    }

    public boolean containsField(String fieldSignature) {
        return this.grabField(fieldSignature) != null;
    }

    public SootMethod grabMethod(String methodSignature) {
        String cname = this.signatureToClass(methodSignature);
        String mname = this.signatureToSubsignature(methodSignature);
        if (!this.containsClass(cname)) {
            return null;
        }
        SootClass c = this.getSootClass(cname);
        return c.getMethodUnsafe(mname);
    }

    public boolean containsMethod(String methodSignature) {
        return this.grabMethod(methodSignature) != null;
    }

    public SootField getField(String fieldSignature) {
        SootField f = this.grabField(fieldSignature);
        if (f != null) {
            return f;
        }
        throw new RuntimeException("tried to get nonexistent field " + fieldSignature);
    }

    public SootMethod getMethod(String methodSignature) {
        SootMethod m4 = this.grabMethod(methodSignature);
        if (m4 != null) {
            return m4;
        }
        throw new RuntimeException("tried to get nonexistent method " + methodSignature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SootClass tryLoadClass(String className, int desiredLevel) {
        this.setPhantomRefs(true);
        try (ClassSource source = SourceLocator.v().getClassSource(className);){
            if (!this.getPhantomRefs() && source == null) {
                this.setPhantomRefs(false);
                SootClass sootClass = null;
                return sootClass;
            }
        }
        SootResolver resolver = SootResolver.v();
        SootClass toReturn = resolver.resolveClass(className, desiredLevel);
        this.setPhantomRefs(false);
        return toReturn;
    }

    public SootClass loadClassAndSupport(String className) {
        SootClass ret = this.loadClass(className, 2);
        if (!ret.isPhantom()) {
            ret = this.loadClass(className, 3);
        }
        return ret;
    }

    public SootClass loadClass(String className, int desiredLevel) {
        this.setPhantomRefs(true);
        SootResolver resolver = SootResolver.v();
        SootClass toReturn = resolver.resolveClass(className, desiredLevel);
        this.setPhantomRefs(false);
        return toReturn;
    }

    public Type getType(String arg) {
        Type t2 = this.getTypeUnsafe(arg, false);
        if (t2 == null) {
            throw new RuntimeException("Unknown Type: '" + t2 + "'");
        }
        return t2;
    }

    public Type getTypeUnsafe(String arg) {
        return this.getTypeUnsafe(arg, true);
    }

    public Type getTypeUnsafe(String arg, boolean phantomNonExist) {
        String type = arg.replaceAll("([^\\[\\]]*)(.*)", "$1");
        int arrayCount = arg.contains("[") ? arg.replaceAll("([^\\[\\]]*)(.*)", "$2").length() / 2 : 0;
        Type result = this.getRefTypeUnsafe(type);
        if (result == null) {
            if (type.equals("long")) {
                result = LongType.v();
            } else if (type.equals("short")) {
                result = ShortType.v();
            } else if (type.equals("double")) {
                result = DoubleType.v();
            } else if (type.equals("int")) {
                result = IntType.v();
            } else if (type.equals("float")) {
                result = FloatType.v();
            } else if (type.equals("byte")) {
                result = ByteType.v();
            } else if (type.equals("char")) {
                result = CharType.v();
            } else if (type.equals("void")) {
                result = VoidType.v();
            } else if (type.equals("boolean")) {
                result = BooleanType.v();
            } else if (this.allowsPhantomRefs() && phantomNonExist) {
                this.getSootClassUnsafe(type, phantomNonExist);
                result = this.getRefTypeUnsafe(type);
            }
        }
        if (result != null && arrayCount != 0) {
            result = ArrayType.v(result, arrayCount);
        }
        return result;
    }

    public RefType getRefType(String className) {
        RefType refType = this.getRefTypeUnsafe(className);
        if (refType == null) {
            throw new IllegalStateException("RefType " + className + " not loaded. If you tried to get the RefType of a library class, did you call loadNecessaryClasses()? Otherwise please check Soot's classpath.");
        }
        return refType;
    }

    public RefType getRefTypeUnsafe(String className) {
        RefType refType = this.nameToClass.get(className);
        return refType;
    }

    public RefType getObjectType() {
        return this.getRefType("java.lang.Object");
    }

    public SootClass getSootClassUnsafe(String className) {
        return this.getSootClassUnsafe(className, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SootClass getSootClassUnsafe(String className, boolean phantomNonExist) {
        SootClass tsc;
        RefType type = this.nameToClass.get(className);
        if (type != null && (tsc = type.getSootClass()) != null) {
            return tsc;
        }
        if (this.allowsPhantomRefs() && phantomNonExist || className.equals("soot.dummy.InvokeDynamic")) {
            RefType refType = type = this.getOrAddRefType(className);
            synchronized (refType) {
                SootClass c = new SootClass(className);
                c.isPhantom = true;
                this.addClassSilent(c);
                c.setPhantomClass();
                return c;
            }
        }
        return null;
    }

    public SootClass getSootClass(String className) {
        SootClass sc = this.getSootClassUnsafe(className);
        if (sc != null) {
            return sc;
        }
        throw new RuntimeException(System.getProperty("line.separator") + "Aborting: can't find classfile " + className);
    }

    public Chain<SootClass> getClasses() {
        return this.classes;
    }

    public Chain<SootClass> getApplicationClasses() {
        return this.applicationClasses;
    }

    public Chain<SootClass> getLibraryClasses() {
        return this.libraryClasses;
    }

    public Chain<SootClass> getPhantomClasses() {
        return this.phantomClasses;
    }

    Chain<SootClass> getContainingChain(SootClass c) {
        if (c.isApplicationClass()) {
            return this.getApplicationClasses();
        }
        if (c.isLibraryClass()) {
            return this.getLibraryClasses();
        }
        if (c.isPhantomClass()) {
            return this.getPhantomClasses();
        }
        return null;
    }

    public SideEffectAnalysis getSideEffectAnalysis() {
        if (!this.hasSideEffectAnalysis()) {
            this.setSideEffectAnalysis(new SideEffectAnalysis(this.getPointsToAnalysis(), this.getCallGraph()));
        }
        return this.activeSideEffectAnalysis;
    }

    public void setSideEffectAnalysis(SideEffectAnalysis sea) {
        this.activeSideEffectAnalysis = sea;
    }

    public boolean hasSideEffectAnalysis() {
        return this.activeSideEffectAnalysis != null;
    }

    public void releaseSideEffectAnalysis() {
        this.activeSideEffectAnalysis = null;
    }

    public PointsToAnalysis getPointsToAnalysis() {
        if (!this.hasPointsToAnalysis()) {
            return DumbPointerAnalysis.v();
        }
        return this.activePointsToAnalysis;
    }

    public void setPointsToAnalysis(PointsToAnalysis pa) {
        this.activePointsToAnalysis = pa;
    }

    public boolean hasPointsToAnalysis() {
        return this.activePointsToAnalysis != null;
    }

    public void releasePointsToAnalysis() {
        this.activePointsToAnalysis = null;
    }

    public ClientAccessibilityOracle getClientAccessibilityOracle() {
        if (!this.hasClientAccessibilityOracle()) {
            return PublicAndProtectedAccessibility.v();
        }
        return this.accessibilityOracle;
    }

    public boolean hasClientAccessibilityOracle() {
        return this.accessibilityOracle != null;
    }

    public void setClientAccessibilityOracle(ClientAccessibilityOracle oracle) {
        this.accessibilityOracle = oracle;
    }

    public void releaseClientAccessibilityOracle() {
        this.accessibilityOracle = null;
    }

    public synchronized FastHierarchy getOrMakeFastHierarchy() {
        if (!this.hasFastHierarchy()) {
            this.setFastHierarchy(new FastHierarchy());
        }
        return this.getFastHierarchy();
    }

    public synchronized FastHierarchy getFastHierarchy() {
        if (!this.hasFastHierarchy()) {
            throw new RuntimeException("no active FastHierarchy present for scene");
        }
        return this.activeFastHierarchy;
    }

    public synchronized void setFastHierarchy(FastHierarchy hierarchy) {
        this.activeFastHierarchy = hierarchy;
    }

    public synchronized boolean hasFastHierarchy() {
        return this.activeFastHierarchy != null;
    }

    public synchronized void releaseFastHierarchy() {
        this.activeFastHierarchy = null;
    }

    public synchronized Hierarchy getActiveHierarchy() {
        if (!this.hasActiveHierarchy()) {
            this.setActiveHierarchy(new Hierarchy());
        }
        return this.activeHierarchy;
    }

    public synchronized void setActiveHierarchy(Hierarchy hierarchy) {
        this.activeHierarchy = hierarchy;
    }

    public synchronized boolean hasActiveHierarchy() {
        return this.activeHierarchy != null;
    }

    public synchronized void releaseActiveHierarchy() {
        this.activeHierarchy = null;
    }

    public boolean hasCustomEntryPoints() {
        return this.entryPoints != null;
    }

    public List<SootMethod> getEntryPoints() {
        if (this.entryPoints == null) {
            this.entryPoints = EntryPoints.v().all();
        }
        return this.entryPoints;
    }

    public void setEntryPoints(List<SootMethod> entryPoints) {
        this.entryPoints = entryPoints;
    }

    public ContextSensitiveCallGraph getContextSensitiveCallGraph() {
        if (this.cscg == null) {
            throw new RuntimeException("No context-sensitive call graph present in Scene. You can bulid one with Paddle.");
        }
        return this.cscg;
    }

    public void setContextSensitiveCallGraph(ContextSensitiveCallGraph cscg) {
        this.cscg = cscg;
    }

    public CallGraph getCallGraph() {
        if (!this.hasCallGraph()) {
            throw new RuntimeException("No call graph present in Scene. Maybe you want Whole Program mode (-w).");
        }
        return this.activeCallGraph;
    }

    public void setCallGraph(CallGraph cg) {
        this.reachableMethods = null;
        this.activeCallGraph = cg;
    }

    public boolean hasCallGraph() {
        return this.activeCallGraph != null;
    }

    public void releaseCallGraph() {
        this.activeCallGraph = null;
        this.reachableMethods = null;
    }

    public ReachableMethods getReachableMethods() {
        if (this.reachableMethods == null) {
            this.reachableMethods = new ReachableMethods(this.getCallGraph(), new ArrayList<SootMethod>(this.getEntryPoints()));
        }
        this.reachableMethods.update();
        return this.reachableMethods;
    }

    public void setReachableMethods(ReachableMethods rm) {
        this.reachableMethods = rm;
    }

    public boolean hasReachableMethods() {
        return this.reachableMethods != null;
    }

    public void releaseReachableMethods() {
        this.reachableMethods = null;
    }

    public boolean getPhantomRefs() {
        return Options.v().allow_phantom_refs();
    }

    public void setPhantomRefs(boolean value) {
        this.allowsPhantomRefs = value;
    }

    public boolean allowsPhantomRefs() {
        return this.getPhantomRefs();
    }

    public Numberer<Kind> kindNumberer() {
        return this.kindNumberer;
    }

    public IterableNumberer<Type> getTypeNumberer() {
        return this.typeNumberer;
    }

    public IterableNumberer<SootMethod> getMethodNumberer() {
        return this.methodNumberer;
    }

    public Numberer<Context> getContextNumberer() {
        return this.contextNumberer;
    }

    public Numberer<Unit> getUnitNumberer() {
        return this.unitNumberer;
    }

    public Numberer<SparkField> getFieldNumberer() {
        return this.fieldNumberer;
    }

    public IterableNumberer<SootClass> getClassNumberer() {
        return this.classNumberer;
    }

    public StringNumberer getSubSigNumberer() {
        return this.subSigNumberer;
    }

    public IterableNumberer<Local> getLocalNumberer() {
        return this.localNumberer;
    }

    public void setContextNumberer(Numberer<Context> n) {
        if (this.contextNumberer != null) {
            throw new RuntimeException("Attempt to set context numberer when it is already set.");
        }
        this.contextNumberer = n;
    }

    public ThrowAnalysis getDefaultThrowAnalysis() {
        if (this.defaultThrowAnalysis == null) {
            int optionsThrowAnalysis = Options.v().throw_analysis();
            switch (optionsThrowAnalysis) {
                case 1: {
                    this.defaultThrowAnalysis = PedanticThrowAnalysis.v();
                    break;
                }
                case 2: {
                    this.defaultThrowAnalysis = UnitThrowAnalysis.v();
                    break;
                }
                case 3: {
                    this.defaultThrowAnalysis = DalvikThrowAnalysis.v();
                    break;
                }
                default: {
                    throw new IllegalStateException("Options.v().throw_analysi() == " + Options.v().throw_analysis());
                }
            }
        }
        return this.defaultThrowAnalysis;
    }

    public void setDefaultThrowAnalysis(ThrowAnalysis ta) {
        this.defaultThrowAnalysis = ta;
    }

    private void setReservedNames() {
        Set<String> rn = this.getReservedNames();
        rn.add("newarray");
        rn.add("newmultiarray");
        rn.add("nop");
        rn.add("ret");
        rn.add("specialinvoke");
        rn.add("staticinvoke");
        rn.add("tableswitch");
        rn.add("virtualinvoke");
        rn.add("null_type");
        rn.add("unknown");
        rn.add("cmp");
        rn.add("cmpg");
        rn.add("cmpl");
        rn.add("entermonitor");
        rn.add("exitmonitor");
        rn.add("interfaceinvoke");
        rn.add("lengthof");
        rn.add("lookupswitch");
        rn.add("neg");
        rn.add("if");
        rn.add("abstract");
        rn.add("annotation");
        rn.add("boolean");
        rn.add("break");
        rn.add("byte");
        rn.add("case");
        rn.add("catch");
        rn.add("char");
        rn.add("class");
        rn.add("enum");
        rn.add("final");
        rn.add("native");
        rn.add("public");
        rn.add("protected");
        rn.add("private");
        rn.add("static");
        rn.add("synchronized");
        rn.add("transient");
        rn.add("volatile");
        rn.add("interface");
        rn.add("void");
        rn.add("short");
        rn.add("int");
        rn.add("long");
        rn.add("float");
        rn.add("double");
        rn.add("extends");
        rn.add("implements");
        rn.add("breakpoint");
        rn.add("default");
        rn.add("goto");
        rn.add("instanceof");
        rn.add("new");
        rn.add("return");
        rn.add("throw");
        rn.add("throws");
        rn.add("null");
        rn.add("from");
        rn.add("to");
        rn.add("with");
        rn.add("cls");
        rn.add("dynamicinvoke");
        rn.add("strictfp");
    }

    private void addSootBasicClasses() {
        this.basicclasses[1] = new HashSet<String>();
        this.basicclasses[2] = new HashSet<String>();
        this.basicclasses[3] = new HashSet<String>();
        this.addBasicClass("java.lang.Object");
        this.addBasicClass("java.lang.Class", 2);
        this.addBasicClass("java.lang.Void", 2);
        this.addBasicClass("java.lang.Boolean", 2);
        this.addBasicClass("java.lang.Byte", 2);
        this.addBasicClass("java.lang.Character", 2);
        this.addBasicClass("java.lang.Short", 2);
        this.addBasicClass("java.lang.Integer", 2);
        this.addBasicClass("java.lang.Long", 2);
        this.addBasicClass("java.lang.Float", 2);
        this.addBasicClass("java.lang.Double", 2);
        this.addBasicClass("java.lang.String");
        this.addBasicClass("java.lang.StringBuffer", 2);
        this.addBasicClass("java.lang.Enum", 2);
        this.addBasicClass("java.lang.Error");
        this.addBasicClass("java.lang.AssertionError", 2);
        this.addBasicClass("java.lang.Throwable", 2);
        this.addBasicClass("java.lang.Exception", 2);
        this.addBasicClass("java.lang.NoClassDefFoundError", 2);
        this.addBasicClass("java.lang.ReflectiveOperationException", 2);
        this.addBasicClass("java.lang.ExceptionInInitializerError");
        this.addBasicClass("java.lang.RuntimeException");
        this.addBasicClass("java.lang.ClassNotFoundException");
        this.addBasicClass("java.lang.ArithmeticException");
        this.addBasicClass("java.lang.ArrayStoreException");
        this.addBasicClass("java.lang.ClassCastException");
        this.addBasicClass("java.lang.IllegalMonitorStateException");
        this.addBasicClass("java.lang.IndexOutOfBoundsException");
        this.addBasicClass("java.lang.ArrayIndexOutOfBoundsException");
        this.addBasicClass("java.lang.NegativeArraySizeException");
        this.addBasicClass("java.lang.NullPointerException", 2);
        this.addBasicClass("java.lang.InstantiationError");
        this.addBasicClass("java.lang.InternalError");
        this.addBasicClass("java.lang.OutOfMemoryError");
        this.addBasicClass("java.lang.StackOverflowError");
        this.addBasicClass("java.lang.UnknownError");
        this.addBasicClass("java.lang.ThreadDeath");
        this.addBasicClass("java.lang.ClassCircularityError");
        this.addBasicClass("java.lang.ClassFormatError");
        this.addBasicClass("java.lang.IllegalAccessError");
        this.addBasicClass("java.lang.IncompatibleClassChangeError");
        this.addBasicClass("java.lang.LinkageError");
        this.addBasicClass("java.lang.VerifyError");
        this.addBasicClass("java.lang.NoSuchFieldError");
        this.addBasicClass("java.lang.AbstractMethodError");
        this.addBasicClass("java.lang.NoSuchMethodError");
        this.addBasicClass("java.lang.UnsatisfiedLinkError");
        this.addBasicClass("java.lang.Thread");
        this.addBasicClass("java.lang.Runnable");
        this.addBasicClass("java.lang.Cloneable");
        this.addBasicClass("java.io.Serializable");
        this.addBasicClass("java.lang.ref.Finalizer");
        this.addBasicClass("java.lang.invoke.LambdaMetafactory");
    }

    public void addBasicClass(String name) {
        this.addBasicClass(name, 1);
    }

    public void addBasicClass(String name, int level) {
        this.basicclasses[level].add(name);
    }

    public void loadBasicClasses() {
        this.addReflectionTraceClasses();
        int loadedClasses = 0;
        for (int i = 3; i >= 1; --i) {
            for (String name : this.basicclasses[i]) {
                SootClass basicClass = this.tryLoadClass(name, i);
                if (basicClass == null || basicClass.isPhantom()) continue;
                ++loadedClasses;
            }
        }
        if (loadedClasses == 0) {
            throw new RuntimeException("None of the basic classes could be loaded! Check your Soot class path!");
        }
    }

    public Set<String> getBasicClasses() {
        HashSet<String> all = new HashSet<String>();
        for (int i = 0; i < this.basicclasses.length; ++i) {
            Set<String> classes = this.basicclasses[i];
            if (classes == null) continue;
            all.addAll(classes);
        }
        return all;
    }

    protected Set<String>[] getBasicClassesIncludingResolveLevel() {
        return this.basicclasses;
    }

    protected void addReflectionTraceClasses() {
        CGOptions options = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
        String log = options.reflection_log();
        HashSet<String> classNames = new HashSet<String>();
        if (log != null && log.length() > 0) {
            BufferedReader reader = null;
            String line = "";
            try {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(log)));
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0) continue;
                    String[] portions = line.split(";", -1);
                    String kind = portions[0];
                    String target = portions[1];
                    String source = portions[2];
                    String sourceClassName = source.substring(0, source.lastIndexOf("."));
                    classNames.add(sourceClassName);
                    if (kind.equals("Class.forName")) {
                        classNames.add(target);
                        continue;
                    }
                    if (kind.equals("Class.newInstance")) {
                        classNames.add(target);
                        continue;
                    }
                    if (kind.equals("Method.invoke") || kind.equals("Constructor.newInstance")) {
                        classNames.add(this.signatureToClass(target));
                        continue;
                    }
                    if (kind.equals("Field.set*") || kind.equals("Field.get*")) {
                        classNames.add(this.signatureToClass(target));
                        continue;
                    }
                    throw new RuntimeException("Unknown entry kind: " + kind);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Line: '" + line + "'", e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        for (String c : classNames) {
            this.addBasicClass(c, 3);
        }
    }

    public Collection<SootClass> dynamicClasses() {
        if (this.dynamicClasses == null) {
            throw new IllegalStateException("Have to call loadDynamicClasses() first!");
        }
        return this.dynamicClasses;
    }

    private void loadNecessaryClass(String name) {
        SootClass c = this.loadClassAndSupport(name);
        c.setApplicationClass();
    }

    public void loadNecessaryClasses() {
        this.loadBasicClasses();
        for (String name : Options.v().classes()) {
            this.loadNecessaryClass(name);
        }
        this.loadDynamicClasses();
        if (Options.v().oaat()) {
            if (Options.v().process_dir().isEmpty()) {
                throw new IllegalArgumentException("If switch -oaat is used, then also -process-dir must be given.");
            }
        } else {
            for (String path : Options.v().process_dir()) {
                for (String cl : SourceLocator.v().getClassesUnder(path)) {
                    SootClass theClass = this.loadClassAndSupport(cl);
                    if (theClass.isPhantom) continue;
                    theClass.setApplicationClass();
                }
            }
        }
        this.prepareClasses();
        this.setDoneResolving();
    }

    public void loadDynamicClasses() {
        this.dynamicClasses = new ArrayList<SootClass>();
        HashSet<String> dynClasses = new HashSet<String>();
        dynClasses.addAll(Options.v().dynamic_class());
        for (String path : Options.v().dynamic_dir()) {
            dynClasses.addAll(SourceLocator.v().getClassesUnder(path));
        }
        for (String pkg : Options.v().dynamic_package()) {
            dynClasses.addAll(SourceLocator.v().classesInDynamicPackage(pkg));
        }
        for (String className : dynClasses) {
            this.dynamicClasses.add(this.loadClassAndSupport(className));
        }
        Iterator<SootClass> iterator = this.dynamicClasses.iterator();
        while (iterator.hasNext()) {
            SootClass c = iterator.next();
            if (c.isConcrete()) continue;
            if (Options.v().verbose()) {
                logger.warn("dynamic class " + c.getName() + " is abstract or an interface, and it will not be considered.");
            }
            iterator.remove();
        }
    }

    private void prepareClasses() {
        HashChain<SootClass> processedClasses = new HashChain<SootClass>();
        block0: while (true) {
            HashChain<SootClass> unprocessedClasses = new HashChain<SootClass>(this.getClasses());
            unprocessedClasses.removeAll(processedClasses);
            if (unprocessedClasses.isEmpty()) break;
            processedClasses.addAll(unprocessedClasses);
            Iterator iterator = unprocessedClasses.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                SootClass s2 = (SootClass)iterator.next();
                if (s2.isPhantom()) continue;
                if (Options.v().app()) {
                    s2.setApplicationClass();
                }
                if (Options.v().classes().contains(s2.getName())) {
                    s2.setApplicationClass();
                    continue;
                }
                if (s2.isApplicationClass() && this.isExcluded(s2)) {
                    s2.setLibraryClass();
                }
                if (this.isIncluded(s2)) {
                    s2.setApplicationClass();
                }
                if (!s2.isApplicationClass()) continue;
                this.loadClassAndSupport(s2.getName());
            }
            break;
        }
    }

    public boolean isExcluded(SootClass sc) {
        String name = sc.getName();
        for (String pkg : this.excludedPackages) {
            if (!name.equals(pkg) && (!pkg.endsWith(".*") && !pkg.endsWith("$*") || !name.startsWith(pkg.substring(0, pkg.length() - 1)))) continue;
            return !this.isIncluded(sc);
        }
        return false;
    }

    public boolean isIncluded(SootClass sc) {
        String name = sc.getName();
        for (String inc : Options.v().include()) {
            if (!name.equals(inc) && (!inc.endsWith(".*") && !inc.endsWith("$*") || !name.startsWith(inc.substring(0, inc.length() - 1)))) continue;
            return true;
        }
        return false;
    }

    public void setPkgList(List<String> list) {
        this.pkgList = list;
    }

    public List<String> getPkgList() {
        return this.pkgList;
    }

    public SootMethodRef makeMethodRef(SootClass declaringClass, String name, List<Type> parameterTypes, Type returnType, boolean isStatic) {
        if (PolymorphicMethodRef.handlesClass(declaringClass)) {
            return new PolymorphicMethodRef(declaringClass, name, parameterTypes, returnType, isStatic);
        }
        return new SootMethodRefImpl(declaringClass, name, parameterTypes, returnType, isStatic);
    }

    public SootMethodRef makeConstructorRef(SootClass declaringClass, List<Type> parameterTypes) {
        return this.makeMethodRef(declaringClass, "<init>", parameterTypes, VoidType.v(), false);
    }

    public SootFieldRef makeFieldRef(SootClass declaringClass, String name, Type type, boolean isStatic) {
        return new AbstractSootFieldRef(declaringClass, name, type, isStatic);
    }

    public List<SootClass> getClasses(int desiredLevel) {
        ArrayList<SootClass> ret = new ArrayList<SootClass>();
        for (SootClass cl : this.getClasses()) {
            if (cl.resolvingLevel() < desiredLevel) continue;
            ret.add(cl);
        }
        return ret;
    }

    public boolean doneResolving() {
        return this.doneResolving;
    }

    public void setDoneResolving() {
        this.doneResolving = true;
    }

    void setResolving(boolean value) {
        this.doneResolving = value;
    }

    public void setMainClassFromOptions() {
        if (this.mainClass != null) {
            return;
        }
        if (Options.v().main_class() != null && Options.v().main_class().length() > 0) {
            this.setMainClass(this.getSootClass(Options.v().main_class()));
        } else {
            Iterator<Object> classIter = Options.v().classes().iterator();
            while (classIter.hasNext()) {
                SootClass c = this.getSootClass((String)classIter.next());
                if (!c.declaresMethod("main", Collections.singletonList(ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v())) continue;
                logger.debug("No main class given. Inferred '" + c.getName() + "' as main class.");
                this.setMainClass(c);
                return;
            }
            for (SootClass c : this.getApplicationClasses()) {
                if (!c.declaresMethod("main", Collections.singletonList(ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v())) continue;
                logger.debug("No main class given. Inferred '" + c.getName() + "' as main class.");
                this.setMainClass(c);
                return;
            }
        }
    }

    public boolean isIncrementalBuild() {
        return this.incrementalBuild;
    }

    public void initiateIncrementalBuild() {
        this.incrementalBuild = true;
    }

    public void incrementalBuildFinished() {
        this.incrementalBuild = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SootClass forceResolve(String className, int level) {
        SootClass c;
        boolean tmp = this.doneResolving;
        this.doneResolving = false;
        try {
            c = SootResolver.v().resolveClass(className, level);
        }
        finally {
            this.doneResolving = tmp;
        }
        return c;
    }

    public SootClass makeSootClass(String name) {
        return new SootClass(name);
    }

    public SootClass makeSootClass(String name, int modifiers) {
        return new SootClass(name, modifiers);
    }

    public SootMethod makeSootMethod(String name, List<Type> parameterTypes, Type returnType) {
        return new SootMethod(name, parameterTypes, returnType);
    }

    public SootMethod makeSootMethod(String name, List<Type> parameterTypes, Type returnType, int modifiers) {
        return new SootMethod(name, parameterTypes, returnType, modifiers);
    }

    public SootMethod makeSootMethod(String name, List<Type> parameterTypes, Type returnType, int modifiers, List<SootClass> thrownExceptions) {
        return new SootMethod(name, parameterTypes, returnType, modifiers, thrownExceptions);
    }

    public SootField makeSootField(String name, Type type, int modifiers) {
        return new SootField(name, type, modifiers);
    }

    public SootField makeSootField(String name, Type type) {
        return new SootField(name, type);
    }

    public RefType getOrAddRefType(String refTypeName) {
        return this.nameToClass.computeIfAbsent(refTypeName, k -> new RefType((String)k));
    }

    public CallGraph internalMakeCallGraph() {
        return new CallGraph();
    }

    public static class AndroidVersionInfo {
        public int sdkTargetVersion = -1;
        public int minSdkVersion = -1;
        public int platformBuildVersionCode = -1;
    }
}

