/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.CompilationDeathException;
import soot.PhaseOptions;
import soot.ScenePack;
import soot.Transform;

public class RadioScenePack
extends ScenePack {
    private static final Logger logger = LoggerFactory.getLogger(RadioScenePack.class);

    public RadioScenePack(String name) {
        super(name);
    }

    @Override
    protected void internalApply() {
        LinkedList<Transform> enableds = new LinkedList<Transform>();
        for (Transform t2 : this) {
            Map<String, String> opts = PhaseOptions.v().getPhaseOptions(t2);
            if (!PhaseOptions.getBoolean(opts, "enabled")) continue;
            enableds.add(t2);
        }
        if (enableds.size() == 0) {
            logger.debug("Exactly one phase in the pack " + this.getPhaseName() + " must be enabled. Currently, none of them are.");
            throw new CompilationDeathException(0);
        }
        if (enableds.size() > 1) {
            logger.debug("Only one phase in the pack " + this.getPhaseName() + " may be enabled. The following are enabled currently: ");
            for (Transform t2 : enableds) {
                logger.debug("  " + t2.getPhaseName());
            }
            throw new CompilationDeathException(0);
        }
        for (Transform t2 : enableds) {
            t2.apply();
        }
    }

    @Override
    public void add(Transform t2) {
        super.add(t2);
        this.checkEnabled(t2);
    }

    @Override
    public void insertAfter(Transform t2, String phaseName) {
        super.insertAfter(t2, phaseName);
        this.checkEnabled(t2);
    }

    @Override
    public void insertBefore(Transform t2, String phaseName) {
        super.insertBefore(t2, phaseName);
        this.checkEnabled(t2);
    }

    private void checkEnabled(Transform t2) {
        Map<String, String> options = PhaseOptions.v().getPhaseOptions(t2);
        if (PhaseOptions.getBoolean(options, "enabled")) {
            PhaseOptions.v().setPhaseOption(t2, "enabled:true");
        }
    }
}

