/*
 * Decompiled with CFR 0.152.
 */
package soot;

import soot.Body;
import soot.LabeledUnitPrinter;
import soot.SootFieldRef;
import soot.SootMethodRef;
import soot.Type;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityRef;
import soot.jimple.ParameterRef;
import soot.jimple.ThisRef;

public class NormalUnitPrinter
extends LabeledUnitPrinter {
    public NormalUnitPrinter(Body body) {
        super(body);
    }

    @Override
    public void type(Type t2) {
        this.handleIndent();
        String s2 = t2 == null ? "<null>" : t2.toQuotedString();
        this.output.append(s2);
    }

    @Override
    public void methodRef(SootMethodRef m4) {
        this.handleIndent();
        this.output.append(m4.getSignature());
    }

    @Override
    public void fieldRef(SootFieldRef f) {
        this.handleIndent();
        this.output.append(f.getSignature());
    }

    @Override
    public void identityRef(IdentityRef r) {
        this.handleIndent();
        if (r instanceof ThisRef) {
            this.literal("@this: ");
            this.type(r.getType());
        } else if (r instanceof ParameterRef) {
            ParameterRef pr = (ParameterRef)r;
            this.literal("@parameter" + pr.getIndex() + ": ");
            this.type(r.getType());
        } else if (r instanceof CaughtExceptionRef) {
            this.literal("@caughtexception");
        } else {
            throw new RuntimeException();
        }
    }

    @Override
    public void literal(String s2) {
        this.handleIndent();
        this.output.append(s2);
    }
}

