/*
 * Decompiled with CFR 0.152.
 */
package soot;

public class Modifier {
    public static final int ABSTRACT = 1024;
    public static final int FINAL = 16;
    public static final int INTERFACE = 512;
    public static final int NATIVE = 256;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int PUBLIC = 1;
    public static final int STATIC = 8;
    public static final int SYNCHRONIZED = 32;
    public static final int TRANSIENT = 128;
    public static final int VOLATILE = 64;
    public static final int STRICTFP = 2048;
    public static final int ANNOTATION = 8192;
    public static final int ENUM = 16384;
    public static final int SYNTHETIC = 4096;
    public static final int CONSTRUCTOR = 65536;
    public static final int DECLARED_SYNCHRONIZED = 131072;
    public static final int REQUIRES_TRANSITIVE = 32;
    public static final int REQUIRES_STATIC = 64;
    public static final int REQUIRES_SYNTHETIC = 4096;
    public static final int REQUIRES_MANDATED = 32768;

    private Modifier() {
    }

    public static boolean isAbstract(int m4) {
        return (m4 & 0x400) != 0;
    }

    public static boolean isFinal(int m4) {
        return (m4 & 0x10) != 0;
    }

    public static boolean isInterface(int m4) {
        return (m4 & 0x200) != 0;
    }

    public static boolean isNative(int m4) {
        return (m4 & 0x100) != 0;
    }

    public static boolean isPrivate(int m4) {
        return (m4 & 2) != 0;
    }

    public static boolean isProtected(int m4) {
        return (m4 & 4) != 0;
    }

    public static boolean isPublic(int m4) {
        return (m4 & 1) != 0;
    }

    public static boolean isStatic(int m4) {
        return (m4 & 8) != 0;
    }

    public static boolean isSynchronized(int m4) {
        return (m4 & 0x20) != 0;
    }

    public static boolean isTransient(int m4) {
        return (m4 & 0x80) != 0;
    }

    public static boolean isVolatile(int m4) {
        return (m4 & 0x40) != 0;
    }

    public static boolean isStrictFP(int m4) {
        return (m4 & 0x800) != 0;
    }

    public static boolean isAnnotation(int m4) {
        return (m4 & 0x2000) != 0;
    }

    public static boolean isEnum(int m4) {
        return (m4 & 0x4000) != 0;
    }

    public static boolean isSynthetic(int m4) {
        return (m4 & 0x1000) != 0;
    }

    public static boolean isConstructor(int m4) {
        return (m4 & 0x10000) != 0;
    }

    public static boolean isDeclaredSynchronized(int m4) {
        return (m4 & 0x20000) != 0;
    }

    public static String toString(int m4) {
        StringBuffer buffer = new StringBuffer();
        if (Modifier.isPublic(m4)) {
            buffer.append("public ");
        } else if (Modifier.isPrivate(m4)) {
            buffer.append("private ");
        } else if (Modifier.isProtected(m4)) {
            buffer.append("protected ");
        }
        if (Modifier.isAbstract(m4)) {
            buffer.append("abstract ");
        }
        if (Modifier.isStatic(m4)) {
            buffer.append("static ");
        }
        if (Modifier.isFinal(m4)) {
            buffer.append("final ");
        }
        if (Modifier.isSynchronized(m4)) {
            buffer.append("synchronized ");
        }
        if (Modifier.isNative(m4)) {
            buffer.append("native ");
        }
        if (Modifier.isTransient(m4)) {
            buffer.append("transient ");
        }
        if (Modifier.isVolatile(m4)) {
            buffer.append("volatile ");
        }
        if (Modifier.isStrictFP(m4)) {
            buffer.append("strictfp ");
        }
        if (Modifier.isAnnotation(m4)) {
            buffer.append("annotation ");
        }
        if (Modifier.isEnum(m4)) {
            buffer.append("enum ");
        }
        if (Modifier.isInterface(m4)) {
            buffer.append("interface ");
        }
        return buffer.toString().trim();
    }
}

