/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import soot.Immediate;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Body;
import soot.JastAddJ.ClassDecl;
import soot.JastAddJ.ConstructorAccess;
import soot.JastAddJ.ConstructorDecl;
import soot.JastAddJ.Expr;
import soot.JastAddJ.List;
import soot.JastAddJ.NameType;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.Local;
import soot.Type;
import soot.Value;
import soot.jimple.NullConstant;

public class SuperConstructorAccess
extends ConstructorAccess
implements Cloneable {
    protected boolean decls_computed = false;
    protected SimpleSet decls_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.decls_computed = false;
        this.decls_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public SuperConstructorAccess clone() throws CloneNotSupportedException {
        SuperConstructorAccess node = (SuperConstructorAccess)super.clone();
        node.decls_computed = false;
        node.decls_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public SuperConstructorAccess copy() {
        try {
            SuperConstructorAccess node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Override
    public SuperConstructorAccess fullCopy() {
        SuperConstructorAccess tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public void nameCheck() {
        TypeDecl s2;
        super.nameCheck();
        TypeDecl c = this.hostType();
        TypeDecl typeDecl = s2 = c.isClassDecl() && ((ClassDecl)c).hasSuperclass() ? ((ClassDecl)c).superclass() : this.unknownType();
        if (this.isQualified()) {
            if (!s2.isInnerType() || s2.inStaticContext()) {
                this.error("the super type " + s2.typeName() + " of " + c.typeName() + " is not an inner class");
            } else if (!this.qualifier().type().instanceOf(s2.enclosingType())) {
                this.error("The type of this primary expression, " + this.qualifier().type().typeName() + " is not enclosing the super type, " + s2.typeName() + ", of " + c.typeName());
            }
        }
        if (!this.isQualified() && s2.isInnerType() && !c.isInnerType()) {
            this.error("no enclosing instance for " + s2.typeName() + " when accessed in " + this);
        }
        if (s2.isInnerType() && this.hostType().instanceOf(s2.enclosingType())) {
            this.error("cannot reference this before supertype constructor has been called");
        }
    }

    @Override
    public void transformation() {
        this.addEnclosingVariables();
        if (this.decl().isPrivate() && this.decl().hostType() != this.hostType()) {
            this.decl().createAccessor();
        }
        super.transformation();
    }

    @Override
    public void collectTypesToSignatures(Collection<Type> set) {
        super.collectTypesToSignatures(set);
        this.addDependencyIfNeeded(set, this.decl().erasedConstructor().hostType());
    }

    public SuperConstructorAccess() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[1];
        this.setChild(new List(), 0);
    }

    public SuperConstructorAccess(String p0, List<Expr> p1) {
        this.setID(p0);
        this.setChild(p1, 0);
    }

    public SuperConstructorAccess(Symbol p0, List<Expr> p1) {
        this.setID(p0);
        this.setChild(p1, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setID(String value) {
        this.tokenString_ID = value;
    }

    @Override
    public void setID(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol2.value;
        this.IDstart = symbol2.getStart();
        this.IDend = symbol2.getEnd();
    }

    @Override
    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    @Override
    public void setArgList(List<Expr> list) {
        this.setChild(list, 0);
    }

    @Override
    public int getNumArg() {
        return this.getArgList().getNumChild();
    }

    @Override
    public int getNumArgNoTransform() {
        return this.getArgListNoTransform().getNumChildNoTransform();
    }

    @Override
    public Expr getArg(int i) {
        return (Expr)this.getArgList().getChild(i);
    }

    @Override
    public void addArg(Expr node) {
        List<Expr> list = this.parent == null || state == null ? this.getArgListNoTransform() : this.getArgList();
        list.addChild(node);
    }

    @Override
    public void addArgNoTransform(Expr node) {
        List<Expr> list = this.getArgListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setArg(Expr node, int i) {
        List<Expr> list = this.getArgList();
        list.setChild(node, i);
    }

    @Override
    public List<Expr> getArgs() {
        return this.getArgList();
    }

    @Override
    public List<Expr> getArgsNoTransform() {
        return this.getArgListNoTransform();
    }

    @Override
    public List<Expr> getArgList() {
        List list = (List)this.getChild(0);
        list.getNumChild();
        return list;
    }

    @Override
    public List<Expr> getArgListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    @Override
    public Value eval(Body b) {
        ConstructorDecl c = this.decl().erasedConstructor();
        Local base = b.emitThis(this.hostType());
        boolean index = false;
        ArrayList<Immediate> list = new ArrayList<Immediate>();
        if (c.needsEnclosing()) {
            if (this.hasPrevExpr() && !this.prevExpr().isTypeAccess()) {
                list.add(this.asImmediate(b, this.prevExpr().eval(b)));
            } else if (this.hostType().needsSuperEnclosing()) {
                Type type = ((ClassDecl)this.hostType()).superclass().enclosingType().getSootType();
                if (this.hostType().needsEnclosing()) {
                    list.add(this.asImmediate(b, b.newParameterRef(type, 1, this)));
                } else {
                    list.add(this.asImmediate(b, b.newParameterRef(type, 0, this)));
                }
            } else {
                list.add(this.emitThis(b, this.superConstructorQualifier(c.hostType().enclosingType())));
            }
        }
        for (int i = 0; i < this.getNumArg(); ++i) {
            list.add(this.asImmediate(b, this.getArg(i).type().emitCastTo(b, this.getArg(i), c.getParameter(i).type())));
        }
        if (this.decl().isPrivate() && this.decl().hostType() != this.hostType()) {
            list.add(this.asImmediate(b, NullConstant.v()));
            b.add(b.newInvokeStmt(b.newSpecialInvokeExpr(base, this.decl().erasedConstructor().createAccessor().sootRef(), list, (ASTNode)this), this));
            return base;
        }
        return b.newSpecialInvokeExpr(base, c.sootRef(), list, (ASTNode)this);
    }

    @Override
    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        return this.isDAbefore(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        return this.isDUbefore(v);
    }

    @Override
    public SimpleSet decls() {
        if (this.decls_computed) {
            return this.decls_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.decls_value = this.decls_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.decls_computed = true;
        }
        return this.decls_value;
    }

    private SimpleSet decls_compute() {
        Collection c = this.hasPrevExpr() && !this.prevExpr().isTypeAccess() ? this.hostType().lookupSuperConstructor() : this.lookupSuperConstructor();
        return this.chooseConstructor(c, this.getArgList());
    }

    @Override
    public String name() {
        ASTNode$State state = this.state();
        return "super";
    }

    @Override
    public boolean isSuperConstructorAccess() {
        ASTNode$State state = this.state();
        return true;
    }

    @Override
    public NameType predNameType() {
        ASTNode$State state = this.state();
        return NameType.EXPRESSION_NAME;
    }

    public Collection lookupSuperConstructor() {
        ASTNode$State state = this.state();
        Collection lookupSuperConstructor_value = this.getParent().Define_Collection_lookupSuperConstructor(this, null);
        return lookupSuperConstructor_value;
    }

    public TypeDecl enclosingInstance() {
        ASTNode$State state = this.state();
        TypeDecl enclosingInstance_value = this.getParent().Define_TypeDecl_enclosingInstance(this, null);
        return enclosingInstance_value;
    }

    @Override
    public boolean Define_boolean_hasPackage(ASTNode caller, ASTNode child, String packageName) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.unqualifiedScope().hasPackage(packageName);
        }
        return super.Define_boolean_hasPackage(caller, child, packageName);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.unqualifiedScope().lookupVariable(name);
        }
        return super.Define_SimpleSet_lookupVariable(caller, child, name);
    }

    @Override
    public boolean Define_boolean_inExplicitConstructorInvocation(ASTNode caller, ASTNode child) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return true;
        }
        return super.Define_boolean_inExplicitConstructorInvocation(caller, child);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

