/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

public class Problem
implements Comparable {
    protected int line = -1;
    protected int column = -1;
    protected int endLine = -1;
    protected int endColumn = -1;
    protected String fileName;
    protected String message;
    protected Severity severity = Severity.ERROR;
    protected Kind kind = Kind.OTHER;

    public int compareTo(Object o) {
        if (o instanceof Problem) {
            Problem other = (Problem)o;
            if (!this.fileName.equals(other.fileName)) {
                return this.fileName.compareTo(other.fileName);
            }
            if (this.line != other.line) {
                return this.line - other.line;
            }
            return this.message.compareTo(other.message);
        }
        return 0;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public int endLine() {
        return this.endLine;
    }

    public int endColumn() {
        return this.endColumn;
    }

    public String fileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String message() {
        return this.message;
    }

    public Severity severity() {
        return this.severity;
    }

    public Kind kind() {
        return this.kind;
    }

    public Problem(String fileName, String message) {
        this.fileName = fileName;
        this.message = message;
    }

    public Problem(String fileName, String message, int line) {
        this(fileName, message);
        this.line = line;
    }

    public Problem(String fileName, String message, int line, Severity severity) {
        this(fileName, message);
        this.line = line;
        this.severity = severity;
    }

    public Problem(String fileName, String message, int line, int column, Severity severity) {
        this(fileName, message);
        this.line = line;
        this.column = column;
        this.severity = severity;
    }

    public Problem(String fileName, String message, int line, Severity severity, Kind kind) {
        this(fileName, message);
        this.line = line;
        this.kind = kind;
        this.severity = severity;
    }

    public Problem(String fileName, String message, int line, int column, Severity severity, Kind kind) {
        this(fileName, message);
        this.line = line;
        this.column = column;
        this.kind = kind;
        this.severity = severity;
    }

    public Problem(String fileName, String message, int line, int column, int endLine, int endColumn, Severity severity, Kind kind) {
        this(fileName, message);
        this.line = line;
        this.column = column;
        this.endLine = endLine;
        this.endColumn = endColumn;
        this.kind = kind;
        this.severity = severity;
    }

    public String toString() {
        String location = "";
        if (this.line != -1 && this.column != -1) {
            location = this.line + "," + this.column + ":";
        } else if (this.line != -1) {
            location = this.line + ":";
        }
        String s2 = "";
        if (this.kind == Kind.LEXICAL) {
            s2 = "Lexical Error: ";
        } else if (this.kind == Kind.SYNTACTIC) {
            s2 = "Syntactic Error: ";
        } else if (this.kind == Kind.SEMANTIC) {
            s2 = "Semantic Error: ";
        }
        return this.fileName + ":" + location + "\n  " + s2 + this.message;
    }

    public static class Kind {
        public static final Kind OTHER = new Kind();
        public static final Kind LEXICAL = new Kind();
        public static final Kind SYNTACTIC = new Kind();
        public static final Kind SEMANTIC = new Kind();

        private Kind() {
        }
    }

    public static class Severity {
        public static final Severity ERROR = new Severity();
        public static final Severity WARNING = new Severity();

        private Severity() {
        }
    }
}

