/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import soot.Immediate;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Access;
import soot.JastAddJ.ArrayCreationExpr;
import soot.JastAddJ.ArrayInit;
import soot.JastAddJ.ArrayTypeAccess;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constraints;
import soot.JastAddJ.Expr;
import soot.JastAddJ.GenericClassDecl;
import soot.JastAddJ.GenericMethodDecl;
import soot.JastAddJ.List;
import soot.JastAddJ.MethodDecl;
import soot.JastAddJ.NameType;
import soot.JastAddJ.Opt;
import soot.JastAddJ.ParameterDeclaration;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.TypeVariable;
import soot.JastAddJ.Variable;
import soot.JastAddJ.VariableArityParameterDeclaration;
import soot.Local;
import soot.Scene;
import soot.SootMethodRef;
import soot.Type;
import soot.Value;

public class MethodAccess
extends Access
implements Cloneable {
    protected String tokenString_ID;
    public int IDstart;
    public int IDend;
    protected Map computeDAbefore_int_Variable_values;
    protected boolean exceptionCollection_computed = false;
    protected Collection exceptionCollection_value;
    protected boolean decls_computed = false;
    protected SimpleSet decls_value;
    protected boolean decl_computed = false;
    protected MethodDecl decl_value;
    protected boolean type_computed = false;
    protected TypeDecl type_value;
    protected Map typeArguments_MethodDecl_values;

    @Override
    public void flushCache() {
        super.flushCache();
        this.computeDAbefore_int_Variable_values = null;
        this.exceptionCollection_computed = false;
        this.exceptionCollection_value = null;
        this.decls_computed = false;
        this.decls_value = null;
        this.decl_computed = false;
        this.decl_value = null;
        this.type_computed = false;
        this.type_value = null;
        this.typeArguments_MethodDecl_values = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public MethodAccess clone() throws CloneNotSupportedException {
        MethodAccess node = (MethodAccess)super.clone();
        node.computeDAbefore_int_Variable_values = null;
        node.exceptionCollection_computed = false;
        node.exceptionCollection_value = null;
        node.decls_computed = false;
        node.decls_value = null;
        node.decl_computed = false;
        node.decl_value = null;
        node.type_computed = false;
        node.type_value = null;
        node.typeArguments_MethodDecl_values = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public MethodAccess copy() {
        try {
            MethodAccess node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public MethodAccess fullCopy() {
        MethodAccess tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    protected void collectExceptions(Collection c, ASTNode target) {
        super.collectExceptions(c, target);
        for (int i = 0; i < this.decl().getNumException(); ++i) {
            c.add(this.decl().getException(i).type());
        }
    }

    @Override
    public void exceptionHandling() {
        for (TypeDecl exceptionType : this.exceptionCollection()) {
            if (this.handlesException(exceptionType)) continue;
            this.error("" + this.decl().hostType().fullName() + "." + this + " invoked in " + this.hostType().fullName() + " may throw uncaught exception " + exceptionType.fullName());
        }
    }

    @Override
    protected boolean reachedException(TypeDecl catchType) {
        for (TypeDecl exceptionType : this.exceptionCollection()) {
            if (!catchType.mayCatch(exceptionType)) continue;
            return true;
        }
        return super.reachedException(catchType);
    }

    private static SimpleSet removeInstanceMethods(SimpleSet c) {
        SimpleSet set = SimpleSet.emptySet;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            MethodDecl m4 = (MethodDecl)iter.next();
            if (!m4.isStatic()) continue;
            set = set.add(m4);
        }
        return set;
    }

    public boolean applicable(MethodDecl decl) {
        if (this.getNumArg() != decl.getNumParameter()) {
            return false;
        }
        if (!this.name().equals(decl.name())) {
            return false;
        }
        for (int i = 0; i < this.getNumArg(); ++i) {
            if (this.getArg(i).type().instanceOf(decl.getParameter(i).type())) continue;
            return false;
        }
        return true;
    }

    public MethodAccess(String name, List args, int start, int end) {
        this(name, (List<Expr>)args);
        this.setStart(start);
        this.setEnd(end);
    }

    @Override
    public void toString(StringBuffer s2) {
        s2.append(this.name());
        s2.append("(");
        if (this.getNumArg() > 0) {
            this.getArg(0).toString(s2);
            for (int i = 1; i < this.getNumArg(); ++i) {
                s2.append(", ");
                this.getArg(i).toString(s2);
            }
        }
        s2.append(")");
    }

    @Override
    public void nameCheck() {
        if (this.isQualified() && this.qualifier().isPackageAccess() && !this.qualifier().isUnknown()) {
            this.error("The method " + this.decl().signature() + " can not be qualified by a package name.");
        }
        if (this.isQualified() && this.decl().isAbstract() && this.qualifier().isSuperAccess()) {
            this.error("may not access abstract methods in superclass");
        }
        if (!(!this.decls().isEmpty() || this.isQualified() && this.qualifier().isUnknown())) {
            StringBuffer s2 = new StringBuffer();
            s2.append("no method named " + this.name());
            s2.append("(");
            for (int i = 0; i < this.getNumArg(); ++i) {
                if (i != 0) {
                    s2.append(", ");
                }
                s2.append(this.getArg(i).type().typeName());
            }
            s2.append(") in " + this.methodHost() + " matches.");
            if (this.singleCandidateDecl() != null) {
                s2.append(" However, there is a method " + this.singleCandidateDecl().signature());
            }
            this.error(s2.toString());
        }
        if (this.decls().size() > 1) {
            boolean allAbstract = true;
            Iterator iter = this.decls().iterator();
            while (iter.hasNext() && allAbstract) {
                MethodDecl m4 = (MethodDecl)iter.next();
                if (m4.isAbstract() || m4.hostType().isObject()) continue;
                allAbstract = false;
            }
            if (!allAbstract && this.validArgs()) {
                StringBuffer s3 = new StringBuffer();
                s3.append("several most specific methods for " + this + "\n");
                Iterator iter2 = this.decls().iterator();
                while (iter2.hasNext()) {
                    MethodDecl m5 = (MethodDecl)iter2.next();
                    s3.append("    " + m5.signature() + " in " + m5.hostType().typeName() + "\n");
                }
                this.error(s3.toString());
            }
        }
    }

    @Override
    public void checkModifiers() {
        if (this.decl().isDeprecated() && !this.withinDeprecatedAnnotation() && this.hostType().topLevelType() != this.decl().hostType().topLevelType() && !this.withinSuppressWarnings("deprecation")) {
            this.warning(this.decl().signature() + " in " + this.decl().hostType().typeName() + " has been deprecated");
        }
    }

    public Collection computeConstraints(GenericMethodDecl decl) {
        int i;
        Constraints c = new Constraints();
        for (i = 0; i < decl.original().getNumTypeParameter(); ++i) {
            c.addTypeVariable(decl.original().getTypeParameter(i));
        }
        for (i = 0; i < this.getNumArg(); ++i) {
            TypeDecl A2 = this.getArg(i).type();
            int index = i >= decl.getNumParameter() ? decl.getNumParameter() - 1 : i;
            TypeDecl F9 = decl.getParameter(index).type();
            if (decl.getParameter(index) instanceof VariableArityParameterDeclaration && (this.getNumArg() != decl.getNumParameter() || !A2.isArrayDecl())) {
                F9 = F9.componentType();
            }
            c.convertibleTo(A2, F9);
        }
        if (c.rawAccess) {
            return new ArrayList();
        }
        c.resolveEqualityConstraints();
        c.resolveSupertypeConstraints();
        if (c.unresolvedTypeArguments()) {
            TypeDecl R2;
            TypeDecl S = this.assignConvertedType();
            if (S.isUnboxedPrimitive()) {
                S = S.boxed();
            }
            TypeDecl Rprime = R2 = decl.type();
            if (R2.isVoid()) {
                R2 = this.typeObject();
            }
            c.convertibleFrom(S, R2);
            c.resolveEqualityConstraints();
            c.resolveSupertypeConstraints();
            c.resolveSubtypeConstraints();
        }
        return c.typeArguments();
    }

    protected SimpleSet potentiallyApplicable(Collection candidates) {
        SimpleSet potentiallyApplicable = SimpleSet.emptySet;
        for (MethodDecl decl : candidates) {
            if (!this.potentiallyApplicable(decl) || !this.accessible(decl)) continue;
            if (decl instanceof GenericMethodDecl) {
                decl = ((GenericMethodDecl)decl).lookupParMethodDecl(this.typeArguments(decl));
            }
            potentiallyApplicable = potentiallyApplicable.add(decl);
        }
        return potentiallyApplicable;
    }

    protected SimpleSet applicableBySubtyping(SimpleSet potentiallyApplicable) {
        SimpleSet maxSpecific = SimpleSet.emptySet;
        Iterator iter = potentiallyApplicable.iterator();
        while (iter.hasNext()) {
            MethodDecl decl = (MethodDecl)iter.next();
            if (!this.applicableBySubtyping(decl)) continue;
            maxSpecific = MethodAccess.mostSpecific(maxSpecific, decl);
        }
        return maxSpecific;
    }

    protected SimpleSet applicableByMethodInvocationConversion(SimpleSet potentiallyApplicable, SimpleSet maxSpecific) {
        if (maxSpecific.isEmpty()) {
            Iterator iter = potentiallyApplicable.iterator();
            while (iter.hasNext()) {
                MethodDecl decl = (MethodDecl)iter.next();
                if (!this.applicableByMethodInvocationConversion(decl)) continue;
                maxSpecific = MethodAccess.mostSpecific(maxSpecific, decl);
            }
        }
        return maxSpecific;
    }

    protected SimpleSet applicableVariableArity(SimpleSet potentiallyApplicable, SimpleSet maxSpecific) {
        if (maxSpecific.isEmpty()) {
            Iterator iter = potentiallyApplicable.iterator();
            while (iter.hasNext()) {
                MethodDecl decl = (MethodDecl)iter.next();
                if (!decl.isVariableArity() || !this.applicableVariableArity(decl)) continue;
                maxSpecific = MethodAccess.mostSpecific(maxSpecific, decl);
            }
        }
        return maxSpecific;
    }

    private static SimpleSet mostSpecific(SimpleSet maxSpecific, MethodDecl decl) {
        if (maxSpecific.isEmpty()) {
            maxSpecific = maxSpecific.add(decl);
        } else if (decl.moreSpecificThan((MethodDecl)maxSpecific.iterator().next())) {
            maxSpecific = SimpleSet.emptySet.add(decl);
        } else if (!((MethodDecl)maxSpecific.iterator().next()).moreSpecificThan(decl)) {
            maxSpecific = maxSpecific.add(decl);
        }
        return maxSpecific;
    }

    private TypeDecl refined_InnerClasses_MethodAccess_methodQualifierType() {
        TypeDecl typeDecl;
        if (this.hasPrevExpr()) {
            return this.prevExpr().type();
        }
        for (typeDecl = this.hostType(); typeDecl != null && !typeDecl.hasMethod(this.name()); typeDecl = typeDecl.enclosingType()) {
        }
        if (typeDecl != null) {
            return typeDecl;
        }
        return this.decl().hostType();
    }

    public TypeDecl superAccessorTarget() {
        TypeDecl targetDecl = this.prevExpr().type();
        TypeDecl enclosing = this.hostType();
        while (!(enclosing = enclosing.enclosingType()).instanceOf(targetDecl)) {
        }
        return enclosing;
    }

    public void refined_Transformations_MethodAccess_transformation() {
        MethodDecl m4 = this.decl();
        if (this.requiresAccessor()) {
            super.transformation();
            this.replace(this).with(this.decl().createAccessor(this.methodQualifierType()).createBoundAccess(this.getArgList()));
            return;
        }
        if (!m4.isStatic() && this.isQualified() && this.prevExpr().isSuperAccess() && !this.hostType().instanceOf(this.prevExpr().type())) {
            this.decl().createSuperAccessor(this.superAccessorTarget());
        }
        super.transformation();
    }

    @Override
    public void checkWarnings() {
        MethodDecl decl = this.decl();
        if (decl.getNumParameter() == 0) {
            return;
        }
        if (decl.getNumParameter() > this.getNumArg()) {
            return;
        }
        ParameterDeclaration param = decl.getParameter(decl.getNumParameter() - 1);
        if (!this.withinSuppressWarnings("unchecked") && !decl.hasAnnotationSafeVarargs() && param.isVariableArity() && !param.type().isReifiable()) {
            this.warning("unchecked array creation for variable arity parameter of " + this.decl().name());
        }
    }

    @Override
    public void collectTypesToSignatures(Collection<Type> set) {
        super.collectTypesToSignatures(set);
        this.addDependencyIfNeeded(set, this.methodQualifierType());
    }

    public MethodAccess() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[1];
        this.setChild(new List(), 0);
    }

    public MethodAccess(String p0, List<Expr> p1) {
        this.setID(p0);
        this.setChild(p1, 0);
    }

    public MethodAccess(Symbol p0, List<Expr> p1) {
        this.setID(p0);
        this.setChild(p1, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setID(String value) {
        this.tokenString_ID = value;
    }

    public void setID(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol2.value;
        this.IDstart = symbol2.getStart();
        this.IDend = symbol2.getEnd();
    }

    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    public void setArgList(List<Expr> list) {
        this.setChild(list, 0);
    }

    public int getNumArg() {
        return this.getArgList().getNumChild();
    }

    public int getNumArgNoTransform() {
        return this.getArgListNoTransform().getNumChildNoTransform();
    }

    public Expr getArg(int i) {
        return (Expr)this.getArgList().getChild(i);
    }

    public void addArg(Expr node) {
        List<Expr> list = this.parent == null || state == null ? this.getArgListNoTransform() : this.getArgList();
        list.addChild(node);
    }

    public void addArgNoTransform(Expr node) {
        List<Expr> list = this.getArgListNoTransform();
        list.addChild(node);
    }

    public void setArg(Expr node, int i) {
        List<Expr> list = this.getArgList();
        list.setChild(node, i);
    }

    public List<Expr> getArgs() {
        return this.getArgList();
    }

    public List<Expr> getArgsNoTransform() {
        return this.getArgListNoTransform();
    }

    public List<Expr> getArgList() {
        List list = (List)this.getChild(0);
        list.getNumChild();
        return list;
    }

    public List<Expr> getArgListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    protected SimpleSet maxSpecific(Collection candidates) {
        SimpleSet potentiallyApplicable = this.potentiallyApplicable(candidates);
        SimpleSet maxSpecific = this.applicableBySubtyping(potentiallyApplicable);
        maxSpecific = this.applicableByMethodInvocationConversion(potentiallyApplicable, maxSpecific);
        maxSpecific = this.applicableVariableArity(potentiallyApplicable, maxSpecific);
        return maxSpecific;
    }

    @Override
    public void typeCheck() {
        if (this.isQualified() && this.decl().isAbstract() && this.qualifier().isSuperAccess()) {
            this.error("may not access abstract methods in superclass");
        }
        if (!this.decl().isVariableArity() || this.invokesVariableArityAsArray()) {
            for (int i = 0; i < this.decl().getNumParameter(); ++i) {
                TypeDecl parmType;
                TypeDecl exprType = this.getArg(i).type();
                if (exprType.methodInvocationConversionTo(parmType = this.decl().getParameter(i).type()) || exprType.isUnknown() || parmType.isUnknown()) continue;
                this.error("#The type " + exprType.typeName() + " of expr " + this.getArg(i) + " is not compatible with the method parameter " + this.decl().getParameter(i));
            }
        }
    }

    protected TypeDecl refined_GenericsCodegen_MethodAccess_methodQualifierType() {
        MethodDecl m4;
        TypeDecl typeDecl = this.refined_InnerClasses_MethodAccess_methodQualifierType();
        if (typeDecl == null) {
            return null;
        }
        Collection methods = (typeDecl = typeDecl.erasure()).memberMethods((m4 = this.decl().sourceMethodDecl()).name());
        if (!methods.contains(this.decl()) && !methods.contains(m4)) {
            return m4.hostType();
        }
        return typeDecl.erasure();
    }

    @Override
    public void transformation() {
        if (this.decl().isVariableArity() && !this.invokesVariableArityAsArray()) {
            List<Expr> list = new List<Expr>();
            for (int i = 0; i < this.decl().getNumParameter() - 1; ++i) {
                list.add((Expr)this.getArg(i).fullCopy());
            }
            List<Expr> last = new List<Expr>();
            for (int i = this.decl().getNumParameter() - 1; i < this.getNumArg(); ++i) {
                last.add((Expr)this.getArg(i).fullCopy());
            }
            Access typeAccess = this.decl().lastParameter().type().elementType().createQualifiedAccess();
            for (int i = 0; i < this.decl().lastParameter().type().dimension(); ++i) {
                typeAccess = new ArrayTypeAccess(typeAccess);
            }
            list.add(new ArrayCreationExpr(typeAccess, new Opt<ArrayInit>(new ArrayInit(last))));
            this.setArgList(list);
        }
        this.refined_Transformations_MethodAccess_transformation();
    }

    private ArrayList buildArgList(Body b) {
        ArrayList<Immediate> list = new ArrayList<Immediate>();
        for (int i = 0; i < this.getNumArg(); ++i) {
            list.add(this.asImmediate(b, this.getArg(i).type().emitCastTo(b, this.getArg(i), this.decl().getParameter(i).type())));
        }
        return list;
    }

    @Override
    public Value eval(Body b) {
        Value result;
        MethodDecl decl = this.decl().erasedMethod();
        if (!this.decl().isStatic() && this.isQualified() && this.prevExpr().isSuperAccess()) {
            Value result2;
            Local left = this.asLocal(b, this.createLoadQualifier(b));
            ArrayList list = this.buildArgList(b);
            if (!this.hostType().instanceOf(this.prevExpr().type())) {
                MethodDecl m4 = decl.createSuperAccessor(this.superAccessorTarget());
                result2 = this.methodQualifierType().isInterfaceDecl() ? b.newInterfaceInvokeExpr(left, m4.sootRef(), list, (ASTNode)this) : b.newVirtualInvokeExpr(left, m4.sootRef(), list, (ASTNode)this);
            } else {
                result2 = b.newSpecialInvokeExpr(left, this.sootRef(), list, (ASTNode)this);
            }
            if (decl.type() != this.decl().type()) {
                result2 = decl.type().emitCastTo(b, result2, this.decl().type(), this);
            }
            return this.type().isVoid() ? result2 : this.asLocal(b, result2);
        }
        if (!this.decl().isStatic()) {
            Local left = this.asLocal(b, this.createLoadQualifier(b));
            ArrayList list = this.buildArgList(b);
            result = this.methodQualifierType().isInterfaceDecl() ? b.newInterfaceInvokeExpr(left, this.sootRef(), list, (ASTNode)this) : b.newVirtualInvokeExpr(left, this.sootRef(), list, (ASTNode)this);
        } else {
            if (this.isQualified() && !this.qualifier().isTypeAccess()) {
                b.newTemp(this.qualifier().eval(b));
            }
            ArrayList list = this.buildArgList(b);
            result = b.newStaticInvokeExpr(this.sootRef(), list, (ASTNode)this);
        }
        if (decl.type() != this.decl().type()) {
            result = decl.type().emitCastTo(b, result, this.decl().type(), this);
        }
        return this.type().isVoid() ? result : this.asLocal(b, result);
    }

    private SootMethodRef sootRef() {
        MethodDecl decl = this.decl().erasedMethod();
        ArrayList<Type> parameters = new ArrayList<Type>();
        for (int i = 0; i < decl.getNumParameter(); ++i) {
            parameters.add(decl.getParameter(i).type().getSootType());
        }
        SootMethodRef ref = Scene.v().makeMethodRef(this.methodQualifierType().getSootClassDecl(), decl.name(), parameters, decl.type().getSootType(), decl.isStatic());
        return ref;
    }

    private Value createLoadQualifier(Body b) {
        MethodDecl m4 = this.decl().erasedMethod();
        if (this.hasPrevExpr()) {
            Value v = this.prevExpr().eval(b);
            if (v == null) {
                throw new Error("Problems evaluating " + this.prevExpr().getClass().getName());
            }
            Local qualifier = this.asLocal(b, v);
            return qualifier;
        }
        if (!m4.isStatic()) {
            return this.emitThis(b, this.methodQualifierType());
        }
        throw new Error("createLoadQualifier not supported for " + m4.getClass().getName());
    }

    protected TypeDecl methodQualifierType() {
        TypeDecl typeDecl = this.refined_GenericsCodegen_MethodAccess_methodQualifierType();
        if (typeDecl != null) {
            return typeDecl;
        }
        return this.decl().hostType();
    }

    private TypeDecl refined_TypeAnalysis_MethodAccess_type() {
        return this.decl().type();
    }

    public boolean computeDAbefore(int i, Variable v) {
        ArrayList<Object> _parameters = new ArrayList<Object>(2);
        _parameters.add(i);
        _parameters.add(v);
        if (this.computeDAbefore_int_Variable_values == null) {
            this.computeDAbefore_int_Variable_values = new HashMap(4);
        }
        if (this.computeDAbefore_int_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.computeDAbefore_int_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean computeDAbefore_int_Variable_value = this.computeDAbefore_compute(i, v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.computeDAbefore_int_Variable_values.put(_parameters, computeDAbefore_int_Variable_value);
        }
        return computeDAbefore_int_Variable_value;
    }

    private boolean computeDAbefore_compute(int i, Variable v) {
        return i == 0 ? this.isDAbefore(v) : this.getArg(i - 1).isDAafter(v);
    }

    @Override
    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        return this.getNumArg() == 0 ? this.isDAbefore(v) : this.getArg(this.getNumArg() - 1).isDAafter(v);
    }

    @Override
    public boolean isDAafterTrue(Variable v) {
        ASTNode$State state = this.state();
        return (this.getNumArg() != 0 ? this.getArg(this.getNumArg() - 1).isDAafter(v) : this.isDAbefore(v)) || this.isFalse();
    }

    @Override
    public boolean isDAafterFalse(Variable v) {
        ASTNode$State state = this.state();
        return (this.getNumArg() != 0 ? this.getArg(this.getNumArg() - 1).isDAafter(v) : this.isDAbefore(v)) || this.isTrue();
    }

    public Collection exceptionCollection() {
        if (this.exceptionCollection_computed) {
            return this.exceptionCollection_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.exceptionCollection_value = this.exceptionCollection_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.exceptionCollection_computed = true;
        }
        return this.exceptionCollection_value;
    }

    private Collection exceptionCollection_compute() {
        HashSet<TypeDecl> set = new HashSet<TypeDecl>();
        Iterator iter = this.decls().iterator();
        if (!iter.hasNext()) {
            return set;
        }
        MethodDecl m4 = (MethodDecl)iter.next();
        for (int i = 0; i < m4.getNumException(); ++i) {
            TypeDecl exceptionType = m4.getException(i).type();
            set.add(exceptionType);
        }
        while (iter.hasNext()) {
            HashSet<TypeDecl> first = new HashSet<TypeDecl>();
            first.addAll(set);
            HashSet<TypeDecl> second = new HashSet<TypeDecl>();
            m4 = (MethodDecl)iter.next();
            for (int i = 0; i < m4.getNumException(); ++i) {
                TypeDecl exceptionType = m4.getException(i).type();
                second.add(exceptionType);
            }
            set = new HashSet();
            for (TypeDecl firstType : first) {
                for (TypeDecl secondType : second) {
                    if (firstType.instanceOf(secondType)) {
                        set.add(firstType);
                        continue;
                    }
                    if (!secondType.instanceOf(firstType)) continue;
                    set.add(secondType);
                }
            }
        }
        return set;
    }

    public MethodDecl singleCandidateDecl() {
        ASTNode$State state = this.state();
        MethodDecl result = null;
        for (MethodDecl m4 : this.lookupMethod(this.name())) {
            if (result == null) {
                result = m4;
                continue;
            }
            if (m4.getNumParameter() != this.getNumArg() || result.getNumParameter() == this.getNumArg()) continue;
            result = m4;
        }
        return result;
    }

    public SimpleSet decls() {
        if (this.decls_computed) {
            return this.decls_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.decls_value = this.decls_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.decls_computed = true;
        }
        return this.decls_value;
    }

    private SimpleSet decls_compute() {
        SimpleSet maxSpecific = this.maxSpecific(this.lookupMethod(this.name()));
        if (this.isQualified() ? this.qualifier().staticContextQualifier() : this.inStaticContext()) {
            maxSpecific = MethodAccess.removeInstanceMethods(maxSpecific);
        }
        return maxSpecific;
    }

    public MethodDecl decl() {
        if (this.decl_computed) {
            return this.decl_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.decl_value = this.decl_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.decl_computed = true;
        }
        return this.decl_value;
    }

    private MethodDecl decl_compute() {
        SimpleSet decls = this.decls();
        if (decls.size() == 1) {
            return (MethodDecl)decls.iterator().next();
        }
        boolean allAbstract = true;
        Iterator iter = decls.iterator();
        while (iter.hasNext() && allAbstract) {
            MethodDecl m4 = (MethodDecl)iter.next();
            if (m4.isAbstract() || m4.hostType().isObject()) continue;
            allAbstract = false;
        }
        if (decls.size() > 1 && allAbstract) {
            return (MethodDecl)decls.iterator().next();
        }
        return this.unknownMethod();
    }

    public boolean accessible(MethodDecl m4) {
        ASTNode$State state = this.state();
        if (!this.isQualified()) {
            return true;
        }
        if (!m4.accessibleFrom(this.hostType())) {
            return false;
        }
        if (!this.qualifier().type().accessibleFrom(this.hostType())) {
            return false;
        }
        if (m4.isProtected() && !m4.hostPackage().equals(this.hostPackage()) && !m4.isStatic() && !this.qualifier().isSuperAccess()) {
            return this.hostType().mayAccess(this, m4);
        }
        return true;
    }

    public boolean validArgs() {
        ASTNode$State state = this.state();
        for (int i = 0; i < this.getNumArg(); ++i) {
            if (!this.getArg(i).type().isUnknown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String dumpString() {
        ASTNode$State state = this.state();
        return this.getClass().getName() + " [" + this.getID() + "]";
    }

    public String name() {
        ASTNode$State state = this.state();
        return this.getID();
    }

    @Override
    public boolean isMethodAccess() {
        ASTNode$State state = this.state();
        return true;
    }

    @Override
    public NameType predNameType() {
        ASTNode$State state = this.state();
        return NameType.AMBIGUOUS_NAME;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        if (this.getNumArg() == 0 && this.name().equals("getClass") && this.decl().hostType().isObject()) {
            TypeDecl bound = this.isQualified() ? this.qualifier().type() : this.hostType();
            ArrayList<TypeDecl> args = new ArrayList<TypeDecl>();
            args.add(bound.erasure().asWildcardExtends());
            return ((GenericClassDecl)this.lookupType("java.lang", "Class")).lookupParTypeDecl(args);
        }
        return this.refined_TypeAnalysis_MethodAccess_type();
    }

    public boolean applicableBySubtyping(MethodDecl m4) {
        ASTNode$State state = this.state();
        if (m4.getNumParameter() != this.getNumArg()) {
            return false;
        }
        for (int i = 0; i < m4.getNumParameter(); ++i) {
            if (this.getArg(i).type().instanceOf(m4.getParameter(i).type())) continue;
            return false;
        }
        return true;
    }

    public boolean applicableByMethodInvocationConversion(MethodDecl m4) {
        ASTNode$State state = this.state();
        if (m4.getNumParameter() != this.getNumArg()) {
            return false;
        }
        for (int i = 0; i < m4.getNumParameter(); ++i) {
            if (this.getArg(i).type().methodInvocationConversionTo(m4.getParameter(i).type())) continue;
            return false;
        }
        return true;
    }

    public boolean applicableVariableArity(MethodDecl m4) {
        int i;
        ASTNode$State state = this.state();
        for (i = 0; i < m4.getNumParameter() - 1; ++i) {
            if (this.getArg(i).type().methodInvocationConversionTo(m4.getParameter(i).type())) continue;
            return false;
        }
        for (i = m4.getNumParameter() - 1; i < this.getNumArg(); ++i) {
            if (this.getArg(i).type().methodInvocationConversionTo(m4.lastParameter().type().componentType())) continue;
            return false;
        }
        return true;
    }

    public boolean potentiallyApplicable(MethodDecl m4) {
        ASTNode$State state = this.state();
        if (!m4.name().equals(this.name())) {
            return false;
        }
        if (!m4.accessibleFrom(this.hostType())) {
            return false;
        }
        if (m4.isVariableArity() && this.arity() < m4.arity() - 1) {
            return false;
        }
        if (!m4.isVariableArity() && m4.arity() != this.arity()) {
            return false;
        }
        if (m4 instanceof GenericMethodDecl) {
            GenericMethodDecl gm = (GenericMethodDecl)m4;
            ArrayList list = this.typeArguments(m4);
            if (list.size() != 0) {
                if (gm.getNumTypeParameter() != list.size()) {
                    return false;
                }
                for (int i = 0; i < gm.getNumTypeParameter(); ++i) {
                    if (((TypeDecl)list.get(i)).subtype(gm.original().getTypeParameter(i))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public int arity() {
        ASTNode$State state = this.state();
        return this.getNumArg();
    }

    public ArrayList typeArguments(MethodDecl m4) {
        MethodDecl _parameters = m4;
        if (this.typeArguments_MethodDecl_values == null) {
            this.typeArguments_MethodDecl_values = new HashMap(4);
        }
        if (this.typeArguments_MethodDecl_values.containsKey(_parameters)) {
            return (ArrayList)this.typeArguments_MethodDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        ArrayList typeArguments_MethodDecl_value = this.typeArguments_compute(m4);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeArguments_MethodDecl_values.put(_parameters, typeArguments_MethodDecl_value);
        }
        return typeArguments_MethodDecl_value;
    }

    private ArrayList typeArguments_compute(MethodDecl m4) {
        ArrayList<TypeDecl> typeArguments = new ArrayList<TypeDecl>();
        if (m4 instanceof GenericMethodDecl) {
            GenericMethodDecl g2 = (GenericMethodDecl)m4;
            Collection arguments = this.computeConstraints(g2);
            if (arguments.isEmpty()) {
                return typeArguments;
            }
            int i = 0;
            for (TypeDecl typeDecl : arguments) {
                if (typeDecl == null) {
                    TypeVariable v = g2.original().getTypeParameter(i);
                    typeDecl = v.getNumTypeBound() == 0 ? this.typeObject() : (v.getNumTypeBound() == 1 ? v.getTypeBound(0).type() : v.lubType());
                }
                typeArguments.add(typeDecl);
                ++i;
            }
        }
        return typeArguments;
    }

    public boolean invokesVariableArityAsArray() {
        ASTNode$State state = this.state();
        if (!this.decl().isVariableArity()) {
            return false;
        }
        if (this.arity() != this.decl().arity()) {
            return false;
        }
        return this.getArg(this.getNumArg() - 1).type().methodInvocationConversionTo(this.decl().lastParameter().type());
    }

    public boolean requiresAccessor() {
        ASTNode$State state = this.state();
        MethodDecl m4 = this.decl();
        if (m4.isPrivate() && m4.hostType() != this.hostType()) {
            return true;
        }
        return m4.isProtected() && !m4.hostPackage().equals(this.hostPackage()) && !this.hostType().hasMethod(m4.name());
    }

    public boolean handlesException(TypeDecl exceptionType) {
        ASTNode$State state = this.state();
        boolean handlesException_TypeDecl_value = this.getParent().Define_boolean_handlesException(this, null, exceptionType);
        return handlesException_TypeDecl_value;
    }

    public MethodDecl unknownMethod() {
        ASTNode$State state = this.state();
        MethodDecl unknownMethod_value = this.getParent().Define_MethodDecl_unknownMethod(this, null);
        return unknownMethod_value;
    }

    @Override
    public boolean inExplicitConstructorInvocation() {
        ASTNode$State state = this.state();
        boolean inExplicitConstructorInvocation_value = this.getParent().Define_boolean_inExplicitConstructorInvocation(this, null);
        return inExplicitConstructorInvocation_value;
    }

    public TypeDecl typeObject() {
        ASTNode$State state = this.state();
        TypeDecl typeObject_value = this.getParent().Define_TypeDecl_typeObject(this, null);
        return typeObject_value;
    }

    @Override
    public boolean withinSuppressWarnings(String s2) {
        ASTNode$State state = this.state();
        boolean withinSuppressWarnings_String_value = this.getParent().Define_boolean_withinSuppressWarnings(this, null, s2);
        return withinSuppressWarnings_String_value;
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getArgListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            return this.computeDAbefore(i, v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public Collection Define_Collection_lookupMethod(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.unqualifiedScope().lookupMethod(name);
        }
        return this.getParent().Define_Collection_lookupMethod(this, caller, name);
    }

    @Override
    public boolean Define_boolean_hasPackage(ASTNode caller, ASTNode child, String packageName) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.unqualifiedScope().hasPackage(packageName);
        }
        return this.getParent().Define_boolean_hasPackage(this, caller, packageName);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupType(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.unqualifiedScope().lookupType(name);
        }
        return this.getParent().Define_SimpleSet_lookupType(this, caller, name);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.unqualifiedScope().lookupVariable(name);
        }
        return this.getParent().Define_SimpleSet_lookupVariable(this, caller, name);
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return NameType.EXPRESSION_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public String Define_String_methodHost(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.unqualifiedScope().methodHost();
    }

    @Override
    public TypeDecl Define_TypeDecl_assignConvertedType(ASTNode caller, ASTNode child) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.typeObject();
        }
        return this.getParent().Define_TypeDecl_assignConvertedType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

