/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import soot.JastAddJ.ArrayDecl;
import soot.JastAddJ.ClassDecl;
import soot.JastAddJ.GLBTypeFactory;
import soot.JastAddJ.GenericTypeDecl;
import soot.JastAddJ.InterfaceDecl;
import soot.JastAddJ.ParTypeDecl;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.TypeVariable;
import soot.JastAddJ.WildcardExtendsType;
import soot.JastAddJ.WildcardSuperType;

public class Constraints {
    private Collection typeVariables = new ArrayList(4);
    private Map constraintsMap = new HashMap();
    public boolean rawAccess = false;

    public void addTypeVariable(TypeVariable T) {
        if (!this.typeVariables.contains(T)) {
            this.typeVariables.add(T);
            this.constraintsMap.put(T, new ConstraintSet());
        }
    }

    public boolean unresolvedTypeArguments() {
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            if (set.typeArgument != null) continue;
            return true;
        }
        return false;
    }

    public void printConstraints() {
        System.err.println("Current constraints:");
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            for (TypeDecl U : set.supertypeConstraints) {
                System.err.println("  " + T.fullName() + " :> " + U.fullName());
            }
            for (TypeDecl U : set.subtypeConstraints) {
                System.err.println("  " + T.fullName() + " <: " + U.fullName());
            }
            for (TypeDecl U : set.equaltypeConstraints) {
                System.err.println("  " + T.fullName() + " = " + U.fullName());
            }
        }
    }

    public void resolveBounds() {
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            if (set.typeArgument != null) continue;
            set.typeArgument = T.getTypeBound(0).type();
        }
    }

    public void resolveEqualityConstraints() {
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            boolean done = false;
            Iterator i2 = set.equaltypeConstraints.iterator();
            while (!done && i2.hasNext()) {
                TypeDecl U = (TypeDecl)i2.next();
                if (!this.typeVariables.contains(U)) {
                    this.replaceEqualityConstraints(T, U);
                    set.equaltypeConstraints.clear();
                    set.equaltypeConstraints.add(U);
                    set.typeArgument = U;
                    done = true;
                    continue;
                }
                if (T == U) continue;
                this.replaceAllConstraints(T, U);
                done = true;
            }
            if (set.typeArgument != null || set.equaltypeConstraints.size() != 1 || !set.equaltypeConstraints.contains(T)) continue;
            set.typeArgument = T;
        }
    }

    public void replaceEqualityConstraints(TypeDecl before, TypeDecl after) {
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            this.replaceConstraints(set.equaltypeConstraints, before, after);
        }
    }

    public void replaceAllConstraints(TypeDecl before, TypeDecl after) {
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            this.replaceConstraints(set.supertypeConstraints, before, after);
            this.replaceConstraints(set.subtypeConstraints, before, after);
            this.replaceConstraints(set.equaltypeConstraints, before, after);
        }
    }

    private void replaceConstraints(Collection constraints, TypeDecl before, TypeDecl after) {
        ArrayList<TypeDecl> newConstraints = new ArrayList<TypeDecl>();
        Iterator i2 = constraints.iterator();
        while (i2.hasNext()) {
            TypeDecl U = (TypeDecl)i2.next();
            if (U != before) continue;
            i2.remove();
            newConstraints.add(after);
        }
        constraints.addAll(newConstraints);
    }

    public void resolveSubtypeConstraints() {
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            if (set.subtypeConstraints.isEmpty() && T.getNumTypeBound() <= 0 || set.typeArgument != null) continue;
            ArrayList bounds = new ArrayList();
            Iterator i2 = set.subtypeConstraints.iterator();
            while (i2.hasNext()) {
                bounds.add(i2.next());
            }
            for (int i = 0; i < T.getNumTypeBound(); ++i) {
                bounds.add(T.getTypeBound(i).type());
            }
            set.typeArgument = GLBTypeFactory.glb(bounds);
        }
    }

    public void resolveSupertypeConstraints() {
        for (TypeVariable T : this.typeVariables) {
            TypeDecl typeDecl;
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            if (set.supertypeConstraints.isEmpty() || set.typeArgument != null) continue;
            set.typeArgument = typeDecl = T.lookupLUBType(set.supertypeConstraints).lub();
        }
    }

    public static HashSet directSupertypes(TypeDecl t2) {
        if (t2 instanceof ClassDecl) {
            ClassDecl type = (ClassDecl)t2;
            HashSet<TypeDecl> set = new HashSet<TypeDecl>();
            if (type.hasSuperclass()) {
                set.add(type.superclass());
            }
            for (int i = 0; i < type.getNumImplements(); ++i) {
                set.add(type.getImplements(i).type());
            }
            return set;
        }
        if (t2 instanceof InterfaceDecl) {
            InterfaceDecl type = (InterfaceDecl)t2;
            HashSet<TypeDecl> set = new HashSet<TypeDecl>();
            for (int i = 0; i < type.getNumSuperInterfaceId(); ++i) {
                set.add(type.getSuperInterfaceId(i).type());
            }
            return set;
        }
        if (t2 instanceof TypeVariable) {
            TypeVariable type = (TypeVariable)t2;
            HashSet<TypeDecl> set = new HashSet<TypeDecl>();
            for (int i = 0; i < type.getNumTypeBound(); ++i) {
                set.add(type.getTypeBound(i).type());
            }
            return set;
        }
        throw new Error("Operation not supported for " + t2.fullName() + ", " + t2.getClass().getName());
    }

    public static HashSet parameterizedSupertypes(TypeDecl t2) {
        HashSet result = new HashSet();
        Constraints.addParameterizedSupertypes(t2, new HashSet(), result);
        return result;
    }

    public static void addParameterizedSupertypes(TypeDecl t2, HashSet processed, HashSet result) {
        if (!processed.contains(t2)) {
            processed.add(t2);
            if (t2.isParameterizedType()) {
                result.add(t2);
            }
            for (TypeDecl typeDecl : Constraints.directSupertypes(t2)) {
                Constraints.addParameterizedSupertypes(typeDecl, processed, result);
            }
        }
    }

    public Collection typeArguments() {
        ArrayList<TypeDecl> list = new ArrayList<TypeDecl>(this.typeVariables.size());
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            list.add(set.typeArgument);
        }
        return list;
    }

    public void addSupertypeConstraint(TypeDecl T, TypeDecl A2) {
        ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
        set.supertypeConstraints.add(A2);
    }

    public void addSubtypeConstraint(TypeDecl T, TypeDecl A2) {
        ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
        set.subtypeConstraints.add(A2);
    }

    public void addEqualConstraint(TypeDecl T, TypeDecl A2) {
        ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
        set.equaltypeConstraints.add(A2);
    }

    public void convertibleTo(TypeDecl A2, TypeDecl F9) {
        block13: {
            block15: {
                TypeDecl U;
                block16: {
                    block14: {
                        block12: {
                            if (!F9.involvesTypeParameters()) {
                                return;
                            }
                            if (A2.isNull()) {
                                return;
                            }
                            if (!A2.isUnboxedPrimitive()) break block12;
                            TypeDecl U2 = A2.boxed();
                            this.convertibleTo(U2, F9);
                            break block13;
                        }
                        if (!(F9 instanceof TypeVariable)) break block14;
                        if (!this.typeVariables.contains(F9)) break block13;
                        this.addSupertypeConstraint(F9, A2);
                        break block13;
                    }
                    if (!F9.isArrayDecl()) break block15;
                    U = ((ArrayDecl)F9).componentType();
                    if (!U.involvesTypeParameters()) {
                        return;
                    }
                    if (!A2.isArrayDecl()) break block16;
                    TypeDecl V9 = ((ArrayDecl)A2).componentType();
                    if (!V9.isReferenceType()) break block13;
                    this.convertibleTo(V9, U);
                    break block13;
                }
                if (!A2.isTypeVariable()) break block13;
                TypeVariable t2 = (TypeVariable)A2;
                for (int i = 0; i < t2.getNumTypeBound(); ++i) {
                    TypeDecl typeBound = t2.getTypeBound(i).type();
                    if (!typeBound.isArrayDecl() || !((ArrayDecl)typeBound).componentType().isReferenceType()) continue;
                    TypeDecl V10 = ((ArrayDecl)typeBound).componentType();
                    this.convertibleTo(V10, U);
                }
                break block13;
            }
            if (F9 instanceof ParTypeDecl && !F9.isRawType()) {
                Iterator iter = Constraints.parameterizedSupertypes(A2).iterator();
                while (iter.hasNext()) {
                    ParTypeDecl PF = (ParTypeDecl)((Object)F9);
                    ParTypeDecl PA = (ParTypeDecl)iter.next();
                    if (PF.genericDecl() != PA.genericDecl()) continue;
                    if (A2.isRawType()) {
                        this.rawAccess = true;
                        continue;
                    }
                    for (int i = 0; i < PF.getNumArgument(); ++i) {
                        TypeDecl V11;
                        TypeDecl S;
                        TypeDecl U;
                        TypeDecl T = PF.getArgument(i).type();
                        if (!T.involvesTypeParameters()) continue;
                        if (!T.isWildcard()) {
                            U = T;
                            TypeDecl V12 = PA.getArgument(i).type();
                            this.constraintEqual(V12, U);
                            continue;
                        }
                        if (T instanceof WildcardExtendsType) {
                            U = ((WildcardExtendsType)T).getAccess().type();
                            S = PA.getArgument(i).type();
                            if (!S.isWildcard()) {
                                V11 = S;
                                this.convertibleTo(V11, U);
                                continue;
                            }
                            if (!(S instanceof WildcardExtendsType)) continue;
                            V11 = ((WildcardExtendsType)S).getAccess().type();
                            this.convertibleTo(V11, U);
                            continue;
                        }
                        if (!(T instanceof WildcardSuperType)) continue;
                        U = ((WildcardSuperType)T).getAccess().type();
                        S = PA.getArgument(i).type();
                        if (!S.isWildcard()) {
                            V11 = S;
                            this.convertibleFrom(V11, U);
                            continue;
                        }
                        if (!(S instanceof WildcardSuperType)) continue;
                        V11 = ((WildcardSuperType)S).getAccess().type();
                        this.convertibleFrom(V11, U);
                    }
                }
            }
        }
    }

    public void convertibleFrom(TypeDecl A2, TypeDecl F9) {
        if (!F9.involvesTypeParameters()) {
            return;
        }
        if (A2.isNull()) {
            return;
        }
        if (F9 instanceof TypeVariable) {
            if (this.typeVariables.contains(F9)) {
                this.addSubtypeConstraint(F9, A2);
            }
        } else if (F9.isArrayDecl()) {
            TypeDecl U = ((ArrayDecl)F9).componentType();
            if (A2.isArrayDecl()) {
                TypeDecl V9 = ((ArrayDecl)A2).componentType();
                this.convertibleFrom(V9, U);
            } else if (A2.isTypeVariable()) {
                TypeVariable t2 = (TypeVariable)A2;
                for (int i = 0; i < t2.getNumTypeBound(); ++i) {
                    TypeDecl typeBound = t2.getTypeBound(i).type();
                    if (!typeBound.isArrayDecl() || !((ArrayDecl)typeBound).componentType().isReferenceType()) continue;
                    TypeDecl V10 = ((ArrayDecl)typeBound).componentType();
                    this.convertibleFrom(V10, U);
                }
            }
        } else if (F9 instanceof ParTypeDecl && !F9.isRawType() && A2 instanceof ParTypeDecl && !A2.isRawType()) {
            ParTypeDecl PF = (ParTypeDecl)((Object)F9);
            ParTypeDecl PA = (ParTypeDecl)((Object)A2);
            TypeDecl G2 = PF.genericDecl();
            TypeDecl H = PA.genericDecl();
            for (int i = 0; i < PF.getNumArgument(); ++i) {
                int j;
                ArrayList<TypeDecl> list;
                TypeDecl W;
                TypeDecl X;
                TypeDecl U;
                TypeDecl T = PF.getArgument(i).type();
                if (!T.involvesTypeParameters()) continue;
                if (!T.isWildcard()) {
                    U = T;
                    if (!G2.instanceOf(H)) continue;
                    if (H != G2) {
                        for (TypeDecl V11 : Constraints.parameterizedSupertypes(F9)) {
                            if (V11.isRawType() || ((ParTypeDecl)((Object)V11)).genericDecl() != H || !F9.instanceOf(V11)) continue;
                            this.convertibleFrom(A2, V11);
                        }
                        continue;
                    }
                    if (PF.getNumArgument() != PA.getNumArgument()) continue;
                    X = PA.getArgument(i).type();
                    if (!X.isWildcard()) {
                        W = X;
                        this.constraintEqual(W, U);
                        continue;
                    }
                    if (X instanceof WildcardExtendsType) {
                        W = ((WildcardExtendsType)X).getAccess().type();
                        this.convertibleFrom(W, U);
                        continue;
                    }
                    if (!(X instanceof WildcardSuperType)) continue;
                    W = ((WildcardSuperType)X).getAccess().type();
                    this.convertibleTo(W, U);
                    continue;
                }
                if (T instanceof WildcardExtendsType) {
                    U = ((WildcardExtendsType)T).getAccess().type();
                    if (!G2.instanceOf(H)) continue;
                    if (H != G2) {
                        for (TypeDecl V11 : Constraints.parameterizedSupertypes(F9)) {
                            if (V11.isRawType() || ((ParTypeDecl)((Object)V11)).genericDecl() != H) continue;
                            list = new ArrayList<TypeDecl>();
                            for (j = 0; j < ((ParTypeDecl)((Object)V11)).getNumArgument(); ++j) {
                                list.add(((ParTypeDecl)((Object)V11)).getArgument(j).type().asWildcardExtends());
                            }
                            V11 = ((GenericTypeDecl)((Object)H)).lookupParTypeDecl(list);
                            this.convertibleFrom(A2, V11);
                        }
                        continue;
                    }
                    if (PF.getNumArgument() != PA.getNumArgument() || !((X = PA.getArgument(i).type()) instanceof WildcardExtendsType)) continue;
                    W = ((WildcardExtendsType)X).getAccess().type();
                    this.convertibleFrom(W, U);
                    continue;
                }
                if (!(T instanceof WildcardSuperType)) continue;
                U = ((WildcardSuperType)T).getAccess().type();
                if (!G2.instanceOf(H)) continue;
                if (H != G2) {
                    for (TypeDecl V11 : Constraints.parameterizedSupertypes(F9)) {
                        if (V11.isRawType() || ((ParTypeDecl)((Object)V11)).genericDecl() != H) continue;
                        list = new ArrayList();
                        for (j = 0; j < ((ParTypeDecl)((Object)V11)).getNumArgument(); ++j) {
                            list.add(((ParTypeDecl)((Object)V11)).getArgument(j).type().asWildcardExtends());
                        }
                        V11 = ((GenericTypeDecl)((Object)H)).lookupParTypeDecl(list);
                        this.convertibleFrom(A2, V11);
                    }
                    continue;
                }
                if (PF.getNumArgument() != PA.getNumArgument() || !((X = PA.getArgument(i).type()) instanceof WildcardSuperType)) continue;
                W = ((WildcardSuperType)X).getAccess().type();
                this.convertibleTo(W, U);
            }
        } else if (F9.isRawType()) {
            this.rawAccess = true;
        }
    }

    public void constraintEqual(TypeDecl A2, TypeDecl F9) {
        block11: {
            block12: {
                TypeDecl U;
                block13: {
                    block10: {
                        if (!F9.involvesTypeParameters()) {
                            return;
                        }
                        if (A2.isNull()) {
                            return;
                        }
                        if (!(F9 instanceof TypeVariable)) break block10;
                        if (!this.typeVariables.contains(F9)) break block11;
                        this.addEqualConstraint(F9, A2);
                        break block11;
                    }
                    if (!F9.isArrayDecl()) break block12;
                    U = ((ArrayDecl)F9).componentType();
                    if (!A2.isArrayDecl()) break block13;
                    TypeDecl V9 = ((ArrayDecl)A2).componentType();
                    this.constraintEqual(V9, U);
                    break block11;
                }
                if (!A2.isTypeVariable()) break block11;
                TypeVariable t2 = (TypeVariable)A2;
                for (int i = 0; i < t2.getNumTypeBound(); ++i) {
                    TypeDecl typeBound = t2.getTypeBound(i).type();
                    if (!typeBound.isArrayDecl() || !((ArrayDecl)typeBound).componentType().isReferenceType()) continue;
                    TypeDecl V10 = ((ArrayDecl)typeBound).componentType();
                    this.constraintEqual(V10, U);
                }
                break block11;
            }
            if (F9 instanceof ParTypeDecl && !F9.isRawType() && A2 instanceof ParTypeDecl) {
                ParTypeDecl PF = (ParTypeDecl)((Object)F9);
                ParTypeDecl PA = (ParTypeDecl)((Object)A2);
                if (PF.genericDecl() == PA.genericDecl()) {
                    if (A2.isRawType()) {
                        this.rawAccess = true;
                    } else {
                        for (int i = 0; i < PF.getNumArgument(); ++i) {
                            TypeDecl V11;
                            TypeDecl S;
                            TypeDecl U;
                            TypeDecl T = PF.getArgument(i).type();
                            if (!T.involvesTypeParameters()) continue;
                            if (!T.isWildcard()) {
                                U = T;
                                TypeDecl V12 = PA.getArgument(i).type();
                                this.constraintEqual(V12, U);
                                continue;
                            }
                            if (T instanceof WildcardExtendsType) {
                                U = ((WildcardExtendsType)T).getAccess().type();
                                S = PA.getArgument(i).type();
                                if (!(S instanceof WildcardExtendsType)) continue;
                                V11 = ((WildcardExtendsType)S).getAccess().type();
                                this.constraintEqual(V11, U);
                                continue;
                            }
                            if (!(T instanceof WildcardSuperType)) continue;
                            U = ((WildcardSuperType)T).getAccess().type();
                            S = PA.getArgument(i).type();
                            if (!(S instanceof WildcardSuperType)) continue;
                            V11 = ((WildcardSuperType)S).getAccess().type();
                            this.constraintEqual(V11, U);
                        }
                    }
                }
            }
        }
    }

    static class ConstraintSet {
        public Collection supertypeConstraints = new HashSet(4);
        public Collection subtypeConstraints = new HashSet(4);
        public Collection equaltypeConstraints = new HashSet(4);
        public TypeDecl typeArgument;

        ConstraintSet() {
        }
    }
}

