/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

public class Constant {
    public boolean error = false;

    int intValue() {
        throw new UnsupportedOperationException();
    }

    long longValue() {
        throw new UnsupportedOperationException();
    }

    float floatValue() {
        throw new UnsupportedOperationException();
    }

    double doubleValue() {
        throw new UnsupportedOperationException();
    }

    boolean booleanValue() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    String stringValue() {
        throw new UnsupportedOperationException();
    }

    protected Constant() {
    }

    static Constant create(int i) {
        return new ConstantInt(i);
    }

    static Constant create(long l) {
        return new ConstantLong(l);
    }

    static Constant create(float f) {
        return new ConstantFloat(f);
    }

    static Constant create(double d) {
        return new ConstantDouble(d);
    }

    static Constant create(boolean b) {
        return new ConstantBoolean(b);
    }

    static Constant create(char c) {
        return new ConstantChar(c);
    }

    static Constant create(String s2) {
        return new ConstantString(s2);
    }

    static class ConstantString
    extends Constant {
        private String value;

        public ConstantString(String s2) {
            this.value = s2;
        }

        @Override
        String stringValue() {
            return this.value;
        }
    }

    static class ConstantBoolean
    extends Constant {
        private boolean value;

        public ConstantBoolean(boolean b) {
            this.value = b;
        }

        @Override
        boolean booleanValue() {
            return this.value;
        }

        @Override
        String stringValue() {
            return new Boolean(this.value).toString();
        }
    }

    static class ConstantChar
    extends Constant {
        private char value;

        public ConstantChar(char c) {
            this.value = c;
        }

        @Override
        int intValue() {
            return this.value;
        }

        @Override
        long longValue() {
            return this.value;
        }

        @Override
        float floatValue() {
            return this.value;
        }

        @Override
        double doubleValue() {
            return this.value;
        }

        @Override
        String stringValue() {
            return new Character(this.value).toString();
        }
    }

    static class ConstantDouble
    extends Constant {
        private double value;

        public ConstantDouble(double d) {
            this.value = d;
        }

        @Override
        int intValue() {
            return (int)this.value;
        }

        @Override
        long longValue() {
            return (long)this.value;
        }

        @Override
        float floatValue() {
            return (float)this.value;
        }

        @Override
        double doubleValue() {
            return this.value;
        }

        @Override
        String stringValue() {
            return new Double(this.value).toString();
        }
    }

    static class ConstantFloat
    extends Constant {
        private float value;

        public ConstantFloat(float f) {
            this.value = f;
        }

        @Override
        int intValue() {
            return (int)this.value;
        }

        @Override
        long longValue() {
            return (long)this.value;
        }

        @Override
        float floatValue() {
            return this.value;
        }

        @Override
        double doubleValue() {
            return this.value;
        }

        @Override
        String stringValue() {
            return new Float(this.value).toString();
        }
    }

    static class ConstantLong
    extends Constant {
        private long value;

        public ConstantLong(long l) {
            this.value = l;
        }

        @Override
        int intValue() {
            return (int)this.value;
        }

        @Override
        long longValue() {
            return this.value;
        }

        @Override
        float floatValue() {
            return this.value;
        }

        @Override
        double doubleValue() {
            return this.value;
        }

        @Override
        String stringValue() {
            return new Long(this.value).toString();
        }
    }

    static class ConstantInt
    extends Constant {
        private int value;

        public ConstantInt(int i) {
            this.value = i;
        }

        @Override
        int intValue() {
            return this.value;
        }

        @Override
        long longValue() {
            return this.value;
        }

        @Override
        float floatValue() {
            return this.value;
        }

        @Override
        double doubleValue() {
            return this.value;
        }

        @Override
        String stringValue() {
            return new Integer(this.value).toString();
        }
    }
}

