/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Access;
import soot.JastAddJ.Annotation;
import soot.JastAddJ.ArrayDecl;
import soot.JastAddJ.BodyDecl;
import soot.JastAddJ.ClassDeclSubstituted;
import soot.JastAddJ.Constant;
import soot.JastAddJ.ConstructorDecl;
import soot.JastAddJ.Expr;
import soot.JastAddJ.FieldDeclaration;
import soot.JastAddJ.GenericClassDecl;
import soot.JastAddJ.InterfaceDecl;
import soot.JastAddJ.List;
import soot.JastAddJ.MethodDecl;
import soot.JastAddJ.MethodDeclSubstituted;
import soot.JastAddJ.Modifiers;
import soot.JastAddJ.NameType;
import soot.JastAddJ.Opt;
import soot.JastAddJ.Parameterization;
import soot.JastAddJ.ReferenceType;
import soot.JastAddJ.Signatures;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.TypeVariable;
import soot.MethodSource;
import soot.Scene;
import soot.SootClass;
import soot.coffi.CoffiMethodSource;
import soot.tagkit.SourceFileTag;

public class ClassDecl
extends ReferenceType
implements Cloneable {
    protected boolean interfacesMethodsSignatureMap_computed = false;
    protected HashMap interfacesMethodsSignatureMap_value;
    protected boolean methodsSignatureMap_computed = false;
    protected HashMap methodsSignatureMap_value;
    protected Map ancestorMethods_String_values;
    protected Map memberTypes_String_values;
    protected boolean memberFieldsMap_computed = false;
    protected HashMap memberFieldsMap_value;
    protected Map memberFields_String_values;
    protected boolean unimplementedMethods_computed = false;
    protected Collection unimplementedMethods_value;
    protected boolean hasAbstract_computed = false;
    protected boolean hasAbstract_value;
    protected Map castingConversionTo_TypeDecl_values;
    protected boolean isString_computed = false;
    protected boolean isString_value;
    protected boolean isObject_computed = false;
    protected boolean isObject_value;
    protected Map instanceOf_TypeDecl_values;
    protected int isCircular_visited = -1;
    protected boolean isCircular_computed = false;
    protected boolean isCircular_initialized = false;
    protected boolean isCircular_value;
    protected boolean implementedInterfaces_computed = false;
    protected HashSet implementedInterfaces_value;
    protected Map subtype_TypeDecl_values;
    protected boolean sootClass_computed = false;
    protected SootClass sootClass_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.interfacesMethodsSignatureMap_computed = false;
        this.interfacesMethodsSignatureMap_value = null;
        this.methodsSignatureMap_computed = false;
        this.methodsSignatureMap_value = null;
        this.ancestorMethods_String_values = null;
        this.memberTypes_String_values = null;
        this.memberFieldsMap_computed = false;
        this.memberFieldsMap_value = null;
        this.memberFields_String_values = null;
        this.unimplementedMethods_computed = false;
        this.unimplementedMethods_value = null;
        this.hasAbstract_computed = false;
        this.castingConversionTo_TypeDecl_values = null;
        this.isString_computed = false;
        this.isObject_computed = false;
        this.instanceOf_TypeDecl_values = null;
        this.isCircular_visited = -1;
        this.isCircular_computed = false;
        this.isCircular_initialized = false;
        this.implementedInterfaces_computed = false;
        this.implementedInterfaces_value = null;
        this.subtype_TypeDecl_values = null;
        this.sootClass_computed = false;
        this.sootClass_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ClassDecl clone() throws CloneNotSupportedException {
        ClassDecl node = (ClassDecl)super.clone();
        node.interfacesMethodsSignatureMap_computed = false;
        node.interfacesMethodsSignatureMap_value = null;
        node.methodsSignatureMap_computed = false;
        node.methodsSignatureMap_value = null;
        node.ancestorMethods_String_values = null;
        node.memberTypes_String_values = null;
        node.memberFieldsMap_computed = false;
        node.memberFieldsMap_value = null;
        node.memberFields_String_values = null;
        node.unimplementedMethods_computed = false;
        node.unimplementedMethods_value = null;
        node.hasAbstract_computed = false;
        node.castingConversionTo_TypeDecl_values = null;
        node.isString_computed = false;
        node.isObject_computed = false;
        node.instanceOf_TypeDecl_values = null;
        node.isCircular_visited = -1;
        node.isCircular_computed = false;
        node.isCircular_initialized = false;
        node.implementedInterfaces_computed = false;
        node.implementedInterfaces_value = null;
        node.subtype_TypeDecl_values = null;
        node.sootClass_computed = false;
        node.sootClass_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ClassDecl copy() {
        try {
            ClassDecl node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public ClassDecl fullCopy() {
        ClassDecl tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public void accessControl() {
        ClassDecl typeDecl;
        super.accessControl();
        ClassDecl classDecl = typeDecl = this.hasSuperclass() ? this.superclass() : null;
        if (typeDecl != null && !typeDecl.accessibleFromExtend(this)) {
            this.error("class " + this.fullName() + " may not extend non accessible type " + typeDecl.fullName());
        }
        if (this.hasSuperclass() && !this.superclass().accessibleFrom(this)) {
            this.error("a superclass must be accessible which " + this.superclass().name() + " is not");
        }
        for (int i = 0; i < this.getNumImplements(); ++i) {
            TypeDecl decl = this.getImplements(i).type();
            if (decl.isCircular() || decl.accessibleFrom(this)) continue;
            this.error("class " + this.fullName() + " can not implement non accessible type " + decl.fullName());
        }
    }

    @Override
    public void exceptionHandling() {
        this.constructors();
        super.exceptionHandling();
    }

    public Iterator interfacesMethodsIterator() {
        return new Iterator(){
            private Iterator outer;
            private Iterator inner;
            {
                this.outer = ClassDecl.this.interfacesMethodsSignatureMap().values().iterator();
                this.inner = null;
            }

            @Override
            public boolean hasNext() {
                if ((this.inner == null || !this.inner.hasNext()) && this.outer.hasNext()) {
                    this.inner = ((SimpleSet)this.outer.next()).iterator();
                }
                return this.inner == null ? false : this.inner.hasNext();
            }

            public Object next() {
                return this.inner.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void checkModifiers() {
        ClassDecl typeDecl;
        super.checkModifiers();
        ClassDecl classDecl = typeDecl = this.hasSuperclass() ? this.superclass() : null;
        if (typeDecl != null && typeDecl.isFinal()) {
            this.error("class " + this.fullName() + " may not extend final class " + typeDecl.fullName());
        }
    }

    @Override
    public void toString(StringBuffer s2) {
        s2.append(this.indent());
        this.getModifiers().toString(s2);
        s2.append("class " + this.name());
        if (this.hasSuperClassAccess()) {
            s2.append(" extends ");
            this.getSuperClassAccess().toString(s2);
        }
        if (this.getNumImplements() > 0) {
            s2.append(" implements ");
            this.getImplements(0).toString(s2);
            for (int i = 1; i < this.getNumImplements(); ++i) {
                s2.append(", ");
                this.getImplements(i).toString(s2);
            }
        }
        this.ppBodyDecls(s2);
    }

    public boolean hasSuperclass() {
        return !this.isObject();
    }

    public ClassDecl superclass() {
        if (this.isObject()) {
            return null;
        }
        if (this.hasSuperClassAccess() && !this.isCircular() && this.getSuperClassAccess().type().isClassDecl()) {
            return (ClassDecl)this.getSuperClassAccess().type();
        }
        return (ClassDecl)this.typeObject();
    }

    public Iterator interfacesIterator() {
        return new Iterator(){
            private int index = 0;
            private TypeDecl current = null;

            @Override
            public boolean hasNext() {
                this.computeNextCurrent();
                return this.current != null;
            }

            public Object next() {
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void computeNextCurrent() {
                this.current = null;
                if (ClassDecl.this.isObject() || ClassDecl.this.isCircular()) {
                    return;
                }
                while (this.index < ClassDecl.this.getNumImplements()) {
                    TypeDecl typeDecl;
                    if ((typeDecl = ClassDecl.this.getImplements(this.index++).type()).isCircular() || !typeDecl.isInterfaceDecl()) continue;
                    this.current = typeDecl;
                    return;
                }
            }
        };
    }

    @Override
    public void nameCheck() {
        super.nameCheck();
        if (this.hasSuperClassAccess() && !this.getSuperClassAccess().type().isClassDecl()) {
            this.error("class may only inherit a class and not " + this.getSuperClassAccess().type().typeName());
        }
        if (this.isObject() && this.hasSuperClassAccess()) {
            this.error("class Object may not have superclass");
        }
        if (this.isObject() && this.getNumImplements() != 0) {
            this.error("class Object may not implement interfaces");
        }
        if (this.isCircular()) {
            this.error("circular inheritance dependency in " + this.typeName());
        }
        HashSet<TypeDecl> set = new HashSet<TypeDecl>();
        for (int i = 0; i < this.getNumImplements(); ++i) {
            TypeDecl decl = this.getImplements(i).type();
            if (!decl.isInterfaceDecl() && !decl.isUnknown()) {
                this.error("type " + this.fullName() + " tries to implement non interface type " + decl.fullName());
            }
            if (set.contains(decl)) {
                this.error("type " + decl.fullName() + " mentionened multiple times in implements clause");
            }
            set.add(decl);
        }
        Iterator iter = this.interfacesMethodsIterator();
        while (iter.hasNext()) {
            MethodDecl n;
            MethodDecl m4 = (MethodDecl)iter.next();
            if (!this.localMethodsSignature(m4.signature()).isEmpty()) continue;
            SimpleSet s2 = this.superclass().methodsSignature(m4.signature());
            Iterator i2 = s2.iterator();
            while (i2.hasNext()) {
                n = (MethodDecl)i2.next();
                if (!n.accessibleFrom(this)) continue;
                this.interfaceMethodCompatibleWithInherited(m4, n);
            }
            if (!s2.isEmpty()) continue;
            i2 = this.interfacesMethodsSignature(m4.signature()).iterator();
            while (i2.hasNext()) {
                n = (MethodDecl)i2.next();
                if (n.mayOverrideReturn(m4) || m4.mayOverrideReturn(n)) continue;
                this.error("Xthe return type of method " + m4.signature() + " in " + m4.hostType().typeName() + " does not match the return type of method " + n.signature() + " in " + n.hostType().typeName() + " and may thus not be overriden");
            }
        }
    }

    private void interfaceMethodCompatibleWithInherited(MethodDecl m4, MethodDecl n) {
        if (n.isStatic()) {
            this.error("Xa static method may not hide an instance method");
        }
        if (!n.isAbstract() && !n.isPublic()) {
            this.error("Xoverriding access modifier error for " + m4.signature() + " in " + m4.hostType().typeName() + " and " + n.hostType().typeName());
        }
        if (!n.mayOverrideReturn(m4) && !m4.mayOverrideReturn(m4)) {
            this.error("Xthe return type of method " + m4.signature() + " in " + m4.hostType().typeName() + " does not match the return type of method " + n.signature() + " in " + n.hostType().typeName() + " and may thus not be overriden");
        }
        if (!n.isAbstract()) {
            for (int i = 0; i < n.getNumException(); ++i) {
                Access e = n.getException(i);
                boolean found = false;
                for (int j = 0; !found && j < m4.getNumException(); ++j) {
                    if (!e.type().instanceOf(m4.getException(j).type())) continue;
                    found = true;
                }
                if (found || !e.type().isUncheckedException()) continue;
                this.error("X" + n.signature() + " in " + n.hostType().typeName() + " may not throw more checked exceptions than overridden method " + m4.signature() + " in " + m4.hostType().typeName());
            }
        }
    }

    @Override
    public TypeDecl makeGeneric(Signatures.ClassSignature s2) {
        if (s2.hasFormalTypeParameters()) {
            ASTNode node = this.getParent();
            int index = node.getIndexOfChild(this);
            node.setChild(new GenericClassDecl(this.getModifiersNoTransform(), this.getID(), s2.hasSuperclassSignature() ? new Opt<Access>(s2.superclassSignature()) : this.getSuperClassAccessOptNoTransform(), s2.hasSuperinterfaceSignature() ? s2.superinterfaceSignature() : this.getImplementsListNoTransform(), this.getBodyDeclListNoTransform(), (List<TypeVariable>)s2.typeParameters()), index);
            return (TypeDecl)node.getChildNoTransform(index);
        }
        if (s2.hasSuperclassSignature()) {
            this.setSuperClassAccessOpt(new Opt<Access>(s2.superclassSignature()));
        }
        if (s2.hasSuperinterfaceSignature()) {
            this.setImplementsList(s2.superinterfaceSignature());
        }
        return this;
    }

    public ClassDecl substitutedClassDecl(Parameterization parTypeDecl) {
        ClassDeclSubstituted c = new ClassDeclSubstituted(this.getModifiers().fullCopy(), this.getID(), this.hasSuperClassAccess() ? new Opt<Access>(this.getSuperClassAccess().type().substitute(parTypeDecl)) : new Opt(), (List<Access>)this.getImplementsList().substitute(parTypeDecl), (TypeDecl)this);
        return c;
    }

    @Override
    public void jimplify1phase2() {
        SootClass sc = this.getSootClassDecl();
        sc.setResolvingLevel(0);
        sc.setModifiers(this.sootTypeModifiers());
        sc.setApplicationClass();
        SourceFileTag st = new SourceFileTag(this.sourceNameWithoutPath());
        st.setAbsolutePath(this.compilationUnit().pathName());
        sc.addTag(st);
        if (this.hasSuperclass()) {
            sc.setSuperclass(this.superclass().getSootClassDecl());
        }
        Iterator iter = this.interfacesIterator();
        while (iter.hasNext()) {
            TypeDecl typeDecl = (TypeDecl)iter.next();
            if (sc.implementsInterface(typeDecl.getSootClassDecl().getName())) continue;
            sc.addInterface(typeDecl.getSootClassDecl());
        }
        if (this.isNestedType()) {
            sc.setOuterClass(this.enclosingType().getSootClassDecl());
        }
        sc.setResolvingLevel(1);
        super.jimplify1phase2();
        sc.setResolvingLevel(2);
    }

    public ClassDecl() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[4];
        this.setChild(new Opt(), 1);
        this.setChild(new List(), 2);
        this.setChild(new List(), 3);
    }

    public ClassDecl(Modifiers p0, String p1, Opt<Access> p2, List<Access> p3, List<BodyDecl> p4) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
        this.setChild(p4, 3);
    }

    public ClassDecl(Modifiers p0, Symbol p1, Opt<Access> p2, List<Access> p3, List<BodyDecl> p4) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
        this.setChild(p4, 3);
    }

    @Override
    protected int numChildren() {
        return 4;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setModifiers(Modifiers node) {
        this.setChild(node, 0);
    }

    @Override
    public Modifiers getModifiers() {
        return (Modifiers)this.getChild(0);
    }

    @Override
    public Modifiers getModifiersNoTransform() {
        return (Modifiers)this.getChildNoTransform(0);
    }

    @Override
    public void setID(String value) {
        this.tokenString_ID = value;
    }

    @Override
    public void setID(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol2.value;
        this.IDstart = symbol2.getStart();
        this.IDend = symbol2.getEnd();
    }

    @Override
    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    public void setSuperClassAccessOpt(Opt<Access> opt) {
        this.setChild(opt, 1);
    }

    public boolean hasSuperClassAccess() {
        return this.getSuperClassAccessOpt().getNumChild() != 0;
    }

    public Access getSuperClassAccess() {
        return (Access)this.getSuperClassAccessOpt().getChild(0);
    }

    public void setSuperClassAccess(Access node) {
        this.getSuperClassAccessOpt().setChild(node, 0);
    }

    public Opt<Access> getSuperClassAccessOpt() {
        return (Opt)this.getChild(1);
    }

    public Opt<Access> getSuperClassAccessOptNoTransform() {
        return (Opt)this.getChildNoTransform(1);
    }

    public void setImplementsList(List<Access> list) {
        this.setChild(list, 2);
    }

    public int getNumImplements() {
        return this.getImplementsList().getNumChild();
    }

    public int getNumImplementsNoTransform() {
        return this.getImplementsListNoTransform().getNumChildNoTransform();
    }

    public Access getImplements(int i) {
        return (Access)this.getImplementsList().getChild(i);
    }

    public void addImplements(Access node) {
        List<Access> list = this.parent == null || state == null ? this.getImplementsListNoTransform() : this.getImplementsList();
        list.addChild(node);
    }

    public void addImplementsNoTransform(Access node) {
        List<Access> list = this.getImplementsListNoTransform();
        list.addChild(node);
    }

    public void setImplements(Access node, int i) {
        List<Access> list = this.getImplementsList();
        list.setChild(node, i);
    }

    public List<Access> getImplementss() {
        return this.getImplementsList();
    }

    public List<Access> getImplementssNoTransform() {
        return this.getImplementsListNoTransform();
    }

    public List<Access> getImplementsList() {
        List list = (List)this.getChild(2);
        list.getNumChild();
        return list;
    }

    public List<Access> getImplementsListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    @Override
    public void setBodyDeclList(List<BodyDecl> list) {
        this.setChild(list, 3);
    }

    @Override
    public int getNumBodyDecl() {
        return this.getBodyDeclList().getNumChild();
    }

    @Override
    public int getNumBodyDeclNoTransform() {
        return this.getBodyDeclListNoTransform().getNumChildNoTransform();
    }

    @Override
    public BodyDecl getBodyDecl(int i) {
        return (BodyDecl)this.getBodyDeclList().getChild(i);
    }

    @Override
    public void addBodyDecl(BodyDecl node) {
        List<BodyDecl> list = this.parent == null || state == null ? this.getBodyDeclListNoTransform() : this.getBodyDeclList();
        list.addChild(node);
    }

    @Override
    public void addBodyDeclNoTransform(BodyDecl node) {
        List<BodyDecl> list = this.getBodyDeclListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setBodyDecl(BodyDecl node, int i) {
        List<BodyDecl> list = this.getBodyDeclList();
        list.setChild(node, i);
    }

    @Override
    public List<BodyDecl> getBodyDecls() {
        return this.getBodyDeclList();
    }

    @Override
    public List<BodyDecl> getBodyDeclsNoTransform() {
        return this.getBodyDeclListNoTransform();
    }

    @Override
    public List<BodyDecl> getBodyDeclList() {
        List list = (List)this.getChild(3);
        list.getNumChild();
        return list;
    }

    @Override
    public List<BodyDecl> getBodyDeclListNoTransform() {
        return (List)this.getChildNoTransform(3);
    }

    private boolean refined_TypeConversion_ClassDecl_castingConversionTo_TypeDecl(TypeDecl type) {
        if (type.isArrayDecl()) {
            return this.isObject();
        }
        if (type.isClassDecl()) {
            return this == type || this.instanceOf(type) || type.instanceOf(this);
        }
        if (type.isInterfaceDecl()) {
            return !this.isFinal() || this.instanceOf(type);
        }
        return super.castingConversionTo(type);
    }

    private boolean refined_Generics_ClassDecl_castingConversionTo_TypeDecl(TypeDecl type) {
        ClassDecl S = this;
        TypeDecl T = type;
        if (T instanceof TypeVariable) {
            TypeVariable t2 = (TypeVariable)T;
            if (t2.getNumTypeBound() == 0) {
                return true;
            }
            for (int i = 0; i < t2.getNumTypeBound(); ++i) {
                if (!this.castingConversionTo(t2.getTypeBound(i).type())) continue;
                return true;
            }
            return false;
        }
        if (T.isClassDecl() && (S.erasure() != S || T.erasure() != T)) {
            return S.erasure().castingConversionTo(T.erasure());
        }
        return this.refined_TypeConversion_ClassDecl_castingConversionTo_TypeDecl(type);
    }

    private SootClass refined_EmitJimpleRefinements_ClassDecl_sootClass() {
        boolean needAddclass = false;
        SootClass sc = null;
        if (Scene.v().containsClass(this.jvmName())) {
            SootClass cl = Scene.v().getSootClass(this.jvmName());
            try {
                MethodSource source = cl.getMethodByName("<clinit>").getSource();
                if (source instanceof CoffiMethodSource) {
                    Scene.v().removeClass(cl);
                    needAddclass = true;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            sc = cl;
        } else {
            needAddclass = true;
        }
        if (needAddclass) {
            if (this.options().verbose()) {
                System.out.println("Creating from source " + this.jvmName());
            }
            sc = new SootClass(this.jvmName());
            sc.setResolvingLevel(0);
            Scene.v().addClass(sc);
        }
        return sc;
    }

    @Override
    public Constant cast(Constant c) {
        ASTNode$State state = this.state();
        return Constant.create(c.stringValue());
    }

    @Override
    public Constant add(Constant c1, Constant c2) {
        ASTNode$State state = this.state();
        return Constant.create(c1.stringValue() + c2.stringValue());
    }

    @Override
    public Constant questionColon(Constant cond, Constant c1, Constant c2) {
        ASTNode$State state = this.state();
        return Constant.create(cond.booleanValue() ? c1.stringValue() : c2.stringValue());
    }

    @Override
    public boolean eqIsTrue(Expr left, Expr right) {
        ASTNode$State state = this.state();
        return this.isString() && left.constant().stringValue().equals(right.constant().stringValue());
    }

    @Override
    public int lineNumber() {
        ASTNode$State state = this.state();
        return ClassDecl.getLine(this.IDstart);
    }

    @Override
    public Collection lookupSuperConstructor() {
        ASTNode$State state = this.state();
        return this.hasSuperclass() ? this.superclass().constructors() : Collections.EMPTY_LIST;
    }

    public boolean noConstructor() {
        ASTNode$State state = this.state();
        if (!this.compilationUnit().fromSource()) {
            return false;
        }
        for (int i = 0; i < this.getNumBodyDecl(); ++i) {
            if (!(this.getBodyDecl(i) instanceof ConstructorDecl)) continue;
            return false;
        }
        return true;
    }

    public SimpleSet interfacesMethodsSignature(String signature) {
        ASTNode$State state = this.state();
        SimpleSet set = (SimpleSet)this.interfacesMethodsSignatureMap().get(signature);
        if (set != null) {
            return set;
        }
        return SimpleSet.emptySet;
    }

    public HashMap interfacesMethodsSignatureMap() {
        if (this.interfacesMethodsSignatureMap_computed) {
            return this.interfacesMethodsSignatureMap_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.interfacesMethodsSignatureMap_value = this.interfacesMethodsSignatureMap_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.interfacesMethodsSignatureMap_computed = true;
        }
        return this.interfacesMethodsSignatureMap_value;
    }

    private HashMap interfacesMethodsSignatureMap_compute() {
        HashMap map = new HashMap();
        Iterator iter = this.interfacesIterator();
        while (iter.hasNext()) {
            InterfaceDecl typeDecl = (InterfaceDecl)iter.next();
            Iterator i2 = typeDecl.methodsIterator();
            while (i2.hasNext()) {
                MethodDecl m4 = (MethodDecl)i2.next();
                ClassDecl.putSimpleSetElement(map, m4.signature(), m4);
            }
        }
        return map;
    }

    @Override
    public HashMap methodsSignatureMap() {
        if (this.methodsSignatureMap_computed) {
            return this.methodsSignatureMap_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.methodsSignatureMap_value = this.methodsSignatureMap_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.methodsSignatureMap_computed = true;
        }
        return this.methodsSignatureMap_value;
    }

    private HashMap methodsSignatureMap_compute() {
        HashMap map = new HashMap(this.localMethodsSignatureMap());
        if (this.hasSuperclass()) {
            Iterator iter = this.superclass().methodsIterator();
            while (iter.hasNext()) {
                MethodDecl m4 = (MethodDecl)iter.next();
                if (m4.isPrivate() || !m4.accessibleFrom(this) || this.localMethodsSignatureMap().containsKey(m4.signature()) || m4 instanceof MethodDeclSubstituted && this.localMethodsSignatureMap().containsKey(m4.sourceMethodDecl().signature())) continue;
                ClassDecl.putSimpleSetElement(map, m4.signature(), m4);
            }
        }
        Iterator outerIter = this.interfacesIterator();
        while (outerIter.hasNext()) {
            TypeDecl typeDecl = (TypeDecl)outerIter.next();
            Iterator iter = typeDecl.methodsIterator();
            while (iter.hasNext()) {
                MethodDecl m5 = (MethodDecl)iter.next();
                if (m5.isPrivate() || !m5.accessibleFrom(this) || this.localMethodsSignatureMap().containsKey(m5.signature()) || m5 instanceof MethodDeclSubstituted && this.localMethodsSignatureMap().containsKey(m5.sourceMethodDecl().signature()) || !this.allMethodsAbstract((SimpleSet)map.get(m5.signature())) || m5 instanceof MethodDeclSubstituted && !this.allMethodsAbstract((SimpleSet)map.get(m5.sourceMethodDecl().signature()))) continue;
                ClassDecl.putSimpleSetElement(map, m5.signature(), m5);
            }
        }
        return map;
    }

    @Override
    public SimpleSet ancestorMethods(String signature) {
        String _parameters = signature;
        if (this.ancestorMethods_String_values == null) {
            this.ancestorMethods_String_values = new HashMap(4);
        }
        if (this.ancestorMethods_String_values.containsKey(_parameters)) {
            return (SimpleSet)this.ancestorMethods_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        SimpleSet ancestorMethods_String_value = this.ancestorMethods_compute(signature);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.ancestorMethods_String_values.put(_parameters, ancestorMethods_String_value);
        }
        return ancestorMethods_String_value;
    }

    private SimpleSet ancestorMethods_compute(String signature) {
        MethodDecl m4;
        MethodDecl m5;
        Iterator iter;
        SimpleSet set = SimpleSet.emptySet;
        if (this.hasSuperclass()) {
            iter = this.superclass().localMethodsSignature(signature).iterator();
            while (iter.hasNext()) {
                m5 = (MethodDecl)iter.next();
                if (m5.isPrivate()) continue;
                set = set.add(m5);
            }
        }
        if (set.size() != 1 || ((MethodDecl)set.iterator().next()).isAbstract()) {
            iter = this.interfacesMethodsSignature(signature).iterator();
            while (iter.hasNext()) {
                m5 = (MethodDecl)iter.next();
                set = set.add(m5);
            }
        }
        if (!this.hasSuperclass()) {
            return set;
        }
        if (set.size() == 1 && !(m4 = (MethodDecl)set.iterator().next()).isAbstract()) {
            boolean done = true;
            Iterator iter2 = this.superclass().ancestorMethods(signature).iterator();
            while (iter2.hasNext()) {
                MethodDecl n = (MethodDecl)iter2.next();
                if (!n.isPrivate() && n.accessibleFrom(m4.hostType())) continue;
                done = false;
            }
            if (done) {
                return set;
            }
        }
        iter = this.superclass().ancestorMethods(signature).iterator();
        while (iter.hasNext()) {
            MethodDecl m6 = (MethodDecl)iter.next();
            set = set.add(m6);
        }
        return set;
    }

    @Override
    public SimpleSet memberTypes(String name) {
        String _parameters = name;
        if (this.memberTypes_String_values == null) {
            this.memberTypes_String_values = new HashMap(4);
        }
        if (this.memberTypes_String_values.containsKey(_parameters)) {
            return (SimpleSet)this.memberTypes_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        SimpleSet memberTypes_String_value = this.memberTypes_compute(name);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.memberTypes_String_values.put(_parameters, memberTypes_String_value);
        }
        return memberTypes_String_value;
    }

    private SimpleSet memberTypes_compute(String name) {
        SimpleSet set = this.localTypeDecls(name);
        if (!set.isEmpty()) {
            return set;
        }
        Iterator outerIter = this.interfacesIterator();
        while (outerIter.hasNext()) {
            TypeDecl type = (TypeDecl)outerIter.next();
            Iterator iter = type.memberTypes(name).iterator();
            while (iter.hasNext()) {
                TypeDecl decl = (TypeDecl)iter.next();
                if (decl.isPrivate() || !decl.accessibleFrom(this)) continue;
                set = set.add(decl);
            }
        }
        if (this.hasSuperclass()) {
            Iterator iter = this.superclass().memberTypes(name).iterator();
            while (iter.hasNext()) {
                TypeDecl decl = (TypeDecl)iter.next();
                if (decl.isPrivate() || !decl.accessibleFrom(this)) continue;
                set = set.add(decl);
            }
        }
        return set;
    }

    @Override
    public HashMap memberFieldsMap() {
        if (this.memberFieldsMap_computed) {
            return this.memberFieldsMap_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.memberFieldsMap_value = this.memberFieldsMap_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.memberFieldsMap_computed = true;
        }
        return this.memberFieldsMap_value;
    }

    private HashMap memberFieldsMap_compute() {
        HashMap map = new HashMap(this.localFieldsMap());
        if (this.hasSuperclass()) {
            Iterator iter = this.superclass().fieldsIterator();
            while (iter.hasNext()) {
                FieldDeclaration decl = (FieldDeclaration)iter.next();
                if (decl.isPrivate() || !decl.accessibleFrom(this) || this.localFieldsMap().containsKey(decl.name())) continue;
                ClassDecl.putSimpleSetElement(map, decl.name(), decl);
            }
        }
        Iterator outerIter = this.interfacesIterator();
        while (outerIter.hasNext()) {
            TypeDecl type = (TypeDecl)outerIter.next();
            Iterator iter = type.fieldsIterator();
            while (iter.hasNext()) {
                FieldDeclaration decl = (FieldDeclaration)iter.next();
                if (decl.isPrivate() || !decl.accessibleFrom(this) || this.localFieldsMap().containsKey(decl.name())) continue;
                ClassDecl.putSimpleSetElement(map, decl.name(), decl);
            }
        }
        return map;
    }

    @Override
    public SimpleSet memberFields(String name) {
        String _parameters = name;
        if (this.memberFields_String_values == null) {
            this.memberFields_String_values = new HashMap(4);
        }
        if (this.memberFields_String_values.containsKey(_parameters)) {
            return (SimpleSet)this.memberFields_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        SimpleSet memberFields_String_value = this.memberFields_compute(name);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.memberFields_String_values.put(_parameters, memberFields_String_value);
        }
        return memberFields_String_value;
    }

    private SimpleSet memberFields_compute(String name) {
        SimpleSet fields = this.localFields(name);
        if (!fields.isEmpty()) {
            return fields;
        }
        if (this.hasSuperclass()) {
            Iterator iter = this.superclass().memberFields(name).iterator();
            while (iter.hasNext()) {
                FieldDeclaration decl = (FieldDeclaration)iter.next();
                if (decl.isPrivate() || !decl.accessibleFrom(this)) continue;
                fields = fields.add(decl);
            }
        }
        Iterator outerIter = this.interfacesIterator();
        while (outerIter.hasNext()) {
            TypeDecl type = (TypeDecl)outerIter.next();
            Iterator iter = type.memberFields(name).iterator();
            while (iter.hasNext()) {
                FieldDeclaration decl = (FieldDeclaration)iter.next();
                if (decl.isPrivate() || !decl.accessibleFrom(this)) continue;
                fields = fields.add(decl);
            }
        }
        return fields;
    }

    @Override
    public Collection unimplementedMethods() {
        if (this.unimplementedMethods_computed) {
            return this.unimplementedMethods_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.unimplementedMethods_value = this.unimplementedMethods_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.unimplementedMethods_computed = true;
        }
        return this.unimplementedMethods_value;
    }

    private Collection unimplementedMethods_compute() {
        MethodDecl m42;
        ArrayList<MethodDecl> c = new ArrayList<MethodDecl>();
        Iterator iter = this.interfacesMethodsIterator();
        while (iter.hasNext()) {
            MethodDecl n;
            m42 = (MethodDecl)iter.next();
            boolean implemented = false;
            SimpleSet set = this.localMethodsSignature(m42.signature());
            if (set.size() == 1 && !(n = (MethodDecl)set.iterator().next()).isAbstract()) {
                implemented = true;
            }
            if (!implemented) {
                set = this.ancestorMethods(m42.signature());
                Iterator i2 = set.iterator();
                while (i2.hasNext()) {
                    MethodDecl n2 = (MethodDecl)i2.next();
                    if (n2.isAbstract()) continue;
                    implemented = true;
                    break;
                }
            }
            if (implemented) continue;
            c.add(m42);
        }
        if (this.hasSuperclass()) {
            for (MethodDecl m42 : this.superclass().unimplementedMethods()) {
                SimpleSet set = this.localMethodsSignature(m42.signature());
                if (set.size() == 1) {
                    MethodDecl n = (MethodDecl)set.iterator().next();
                    if (!n.isAbstract() && n.overrides(m42)) continue;
                    c.add(m42);
                    continue;
                }
                c.add(m42);
            }
        }
        iter = this.localMethodsIterator();
        while (iter.hasNext()) {
            m42 = (MethodDecl)iter.next();
            if (!m42.isAbstract()) continue;
            c.add(m42);
        }
        return c;
    }

    @Override
    public boolean hasAbstract() {
        if (this.hasAbstract_computed) {
            return this.hasAbstract_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.hasAbstract_value = this.hasAbstract_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.hasAbstract_computed = true;
        }
        return this.hasAbstract_value;
    }

    private boolean hasAbstract_compute() {
        return !this.unimplementedMethods().isEmpty();
    }

    @Override
    public boolean castingConversionTo(TypeDecl type) {
        TypeDecl _parameters = type;
        if (this.castingConversionTo_TypeDecl_values == null) {
            this.castingConversionTo_TypeDecl_values = new HashMap(4);
        }
        if (this.castingConversionTo_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.castingConversionTo_TypeDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean castingConversionTo_TypeDecl_value = this.castingConversionTo_compute(type);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.castingConversionTo_TypeDecl_values.put(_parameters, castingConversionTo_TypeDecl_value);
        }
        return castingConversionTo_TypeDecl_value;
    }

    private boolean castingConversionTo_compute(TypeDecl type) {
        boolean canUnboxType;
        if (this.refined_Generics_ClassDecl_castingConversionTo_TypeDecl(type)) {
            return true;
        }
        boolean canUnboxThis = !this.unboxed().isUnknown();
        boolean bl = canUnboxType = !type.unboxed().isUnknown();
        if (canUnboxThis && !canUnboxType) {
            return this.unboxed().wideningConversionTo(type);
        }
        return false;
    }

    @Override
    public boolean isClassDecl() {
        ASTNode$State state = this.state();
        return true;
    }

    @Override
    public boolean isString() {
        if (this.isString_computed) {
            return this.isString_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isString_value = this.isString_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isString_computed = true;
        }
        return this.isString_value;
    }

    private boolean isString_compute() {
        return this.fullName().equals("java.lang.String");
    }

    @Override
    public boolean isObject() {
        if (this.isObject_computed) {
            return this.isObject_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isObject_value = this.isObject_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isObject_computed = true;
        }
        return this.isObject_value;
    }

    private boolean isObject_compute() {
        return this.name().equals("Object") && this.packageName().equals("java.lang");
    }

    @Override
    public boolean instanceOf(TypeDecl type) {
        TypeDecl _parameters = type;
        if (this.instanceOf_TypeDecl_values == null) {
            this.instanceOf_TypeDecl_values = new HashMap(4);
        }
        if (this.instanceOf_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.instanceOf_TypeDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean instanceOf_TypeDecl_value = this.instanceOf_compute(type);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.instanceOf_TypeDecl_values.put(_parameters, instanceOf_TypeDecl_value);
        }
        return instanceOf_TypeDecl_value;
    }

    private boolean instanceOf_compute(TypeDecl type) {
        return this.subtype(type);
    }

    @Override
    public boolean isSupertypeOfClassDecl(ClassDecl type) {
        ASTNode$State state = this.state();
        if (super.isSupertypeOfClassDecl(type)) {
            return true;
        }
        return type.hasSuperclass() && type.superclass() != null && type.superclass().instanceOf(this);
    }

    @Override
    public boolean isSupertypeOfInterfaceDecl(InterfaceDecl type) {
        ASTNode$State state = this.state();
        return this.isObject();
    }

    @Override
    public boolean isSupertypeOfArrayDecl(ArrayDecl type) {
        ASTNode$State state = this.state();
        if (super.isSupertypeOfArrayDecl(type)) {
            return true;
        }
        return type.hasSuperclass() && type.superclass() != null && type.superclass().instanceOf(this);
    }

    @Override
    public boolean isInnerClass() {
        ASTNode$State state = this.state();
        return this.isNestedType() && !this.isStatic() && this.enclosingType().isClassDecl();
    }

    @Override
    public boolean isCircular() {
        if (this.isCircular_computed) {
            return this.isCircular_value;
        }
        ASTNode$State state = this.state();
        if (!this.isCircular_initialized) {
            this.isCircular_initialized = true;
            this.isCircular_value = true;
        }
        if (!state.IN_CIRCLE) {
            state.IN_CIRCLE = true;
            int num = state.boundariesCrossed;
            boolean isFinal = this.is$Final();
            do {
                this.isCircular_visited = state.CIRCLE_INDEX;
                state.CHANGE = false;
                boolean new_isCircular_value = this.isCircular_compute();
                if (new_isCircular_value != this.isCircular_value) {
                    state.CHANGE = true;
                }
                this.isCircular_value = new_isCircular_value;
                ++state.CIRCLE_INDEX;
            } while (state.CHANGE);
            if (isFinal && num == this.state().boundariesCrossed) {
                this.isCircular_computed = true;
            } else {
                state.RESET_CYCLE = true;
                this.isCircular_compute();
                state.RESET_CYCLE = false;
                this.isCircular_computed = false;
                this.isCircular_initialized = false;
            }
            state.IN_CIRCLE = false;
            return this.isCircular_value;
        }
        if (this.isCircular_visited != state.CIRCLE_INDEX) {
            this.isCircular_visited = state.CIRCLE_INDEX;
            if (state.RESET_CYCLE) {
                this.isCircular_computed = false;
                this.isCircular_initialized = false;
                this.isCircular_visited = -1;
                return this.isCircular_value;
            }
            boolean new_isCircular_value = this.isCircular_compute();
            if (new_isCircular_value != this.isCircular_value) {
                state.CHANGE = true;
            }
            this.isCircular_value = new_isCircular_value;
            return this.isCircular_value;
        }
        return this.isCircular_value;
    }

    private boolean isCircular_compute() {
        if (this.hasSuperClassAccess()) {
            Access a = this.getSuperClassAccess().lastAccess();
            while (a != null) {
                if (a.type().isCircular()) {
                    return true;
                }
                a = a.isQualified() && a.qualifier().isTypeAccess() ? (Access)a.qualifier() : null;
            }
        }
        for (int i = 0; i < this.getNumImplements(); ++i) {
            Access a = this.getImplements(i).lastAccess();
            while (a != null) {
                if (a.type().isCircular()) {
                    return true;
                }
                a = a.isQualified() && a.qualifier().isTypeAccess() ? (Access)a.qualifier() : null;
            }
        }
        return false;
    }

    @Override
    public Annotation annotation(TypeDecl typeDecl) {
        ASTNode$State state = this.state();
        Annotation a = super.annotation(typeDecl);
        if (a != null) {
            return a;
        }
        if (this.hasSuperclass() && typeDecl.annotation(this.lookupType("java.lang.annotation", "Inherited")) != null) {
            return this.superclass().annotation(typeDecl);
        }
        return null;
    }

    @Override
    public HashSet implementedInterfaces() {
        if (this.implementedInterfaces_computed) {
            return this.implementedInterfaces_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.implementedInterfaces_value = this.implementedInterfaces_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.implementedInterfaces_computed = true;
        }
        return this.implementedInterfaces_value;
    }

    private HashSet implementedInterfaces_compute() {
        HashSet<InterfaceDecl> set = new HashSet<InterfaceDecl>();
        if (this.hasSuperclass()) {
            set.addAll(this.superclass().implementedInterfaces());
        }
        Iterator iter = this.interfacesIterator();
        while (iter.hasNext()) {
            InterfaceDecl decl = (InterfaceDecl)iter.next();
            set.add(decl);
            set.addAll(decl.implementedInterfaces());
        }
        return set;
    }

    @Override
    public boolean subtype(TypeDecl type) {
        ASTNode$State.CircularValue _value;
        TypeDecl _parameters = type;
        if (this.subtype_TypeDecl_values == null) {
            this.subtype_TypeDecl_values = new HashMap(4);
        }
        if (this.subtype_TypeDecl_values.containsKey(_parameters)) {
            Object _o = this.subtype_TypeDecl_values.get(_parameters);
            if (!(_o instanceof ASTNode$State.CircularValue)) {
                return (Boolean)_o;
            }
            _value = (ASTNode$State.CircularValue)_o;
        } else {
            _value = new ASTNode$State.CircularValue();
            this.subtype_TypeDecl_values.put(_parameters, _value);
            _value.value = true;
        }
        ASTNode$State state = this.state();
        if (!state.IN_CIRCLE) {
            boolean new_subtype_TypeDecl_value;
            state.IN_CIRCLE = true;
            int num = state.boundariesCrossed;
            boolean isFinal = this.is$Final();
            do {
                _value.visited = new Integer(state.CIRCLE_INDEX);
                state.CHANGE = false;
                new_subtype_TypeDecl_value = this.subtype_compute(type);
                if (new_subtype_TypeDecl_value != (Boolean)_value.value) {
                    state.CHANGE = true;
                    _value.value = new_subtype_TypeDecl_value;
                }
                ++state.CIRCLE_INDEX;
            } while (state.CHANGE);
            if (isFinal && num == this.state().boundariesCrossed) {
                this.subtype_TypeDecl_values.put(_parameters, new_subtype_TypeDecl_value);
            } else {
                this.subtype_TypeDecl_values.remove(_parameters);
                state.RESET_CYCLE = true;
                this.subtype_compute(type);
                state.RESET_CYCLE = false;
            }
            state.IN_CIRCLE = false;
            return new_subtype_TypeDecl_value;
        }
        if (!new Integer(state.CIRCLE_INDEX).equals(_value.visited)) {
            _value.visited = new Integer(state.CIRCLE_INDEX);
            boolean new_subtype_TypeDecl_value = this.subtype_compute(type);
            if (state.RESET_CYCLE) {
                this.subtype_TypeDecl_values.remove(_parameters);
            } else if (new_subtype_TypeDecl_value != (Boolean)_value.value) {
                state.CHANGE = true;
                _value.value = new_subtype_TypeDecl_value;
            }
            return new_subtype_TypeDecl_value;
        }
        return (Boolean)_value.value;
    }

    private boolean subtype_compute(TypeDecl type) {
        return type.supertypeClassDecl(this);
    }

    @Override
    public boolean supertypeClassDecl(ClassDecl type) {
        ASTNode$State state = this.state();
        return super.supertypeClassDecl(type) || type.hasSuperclass() && type.superclass() != null && type.superclass().subtype(this);
    }

    @Override
    public boolean supertypeInterfaceDecl(InterfaceDecl type) {
        ASTNode$State state = this.state();
        return this.isObject();
    }

    @Override
    public boolean supertypeArrayDecl(ArrayDecl type) {
        ASTNode$State state = this.state();
        if (super.supertypeArrayDecl(type)) {
            return true;
        }
        return type.hasSuperclass() && type.superclass() != null && type.superclass().subtype(this);
    }

    @Override
    public TypeDecl superEnclosing() {
        ASTNode$State state = this.state();
        return this.superclass().erasure().enclosing();
    }

    @Override
    public SootClass sootClass() {
        if (this.sootClass_computed) {
            return this.sootClass_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.sootClass_value = this.sootClass_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.sootClass_computed = true;
        }
        return this.sootClass_value;
    }

    private SootClass sootClass_compute() {
        if (!Scene.v().isIncrementalBuild()) {
            return this.refined_EmitJimpleRefinements_ClassDecl_sootClass();
        }
        if (Scene.v().containsClass(this.jvmName())) {
            Scene.v().removeClass(Scene.v().getSootClass(this.jvmName()));
        }
        SootClass sc = null;
        if (this.options().verbose()) {
            System.out.println("Creating from source " + this.jvmName());
        }
        sc = new SootClass(this.jvmName());
        sc.setResolvingLevel(0);
        Scene.v().addClass(sc);
        return sc;
    }

    @Override
    public String typeDescriptor() {
        ASTNode$State state = this.state();
        return "L" + this.jvmName().replace('.', '/') + ";";
    }

    @Override
    public SimpleSet bridgeCandidates(String signature) {
        ASTNode$State state = this.state();
        SimpleSet set = this.ancestorMethods(signature);
        Iterator iter = this.interfacesMethodsSignature(signature).iterator();
        while (iter.hasNext()) {
            set = set.add(iter.next());
        }
        return set;
    }

    @Override
    public boolean Define_boolean_mayBeFinal(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return super.Define_boolean_mayBeFinal(caller, child);
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getImplementsListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return NameType.TYPE_NAME;
        }
        if (caller == this.getSuperClassAccessOptNoTransform()) {
            return NameType.TYPE_NAME;
        }
        return super.Define_NameType_nameType(caller, child);
    }

    @Override
    public TypeDecl Define_TypeDecl_hostType(ASTNode caller, ASTNode child) {
        if (caller == this.getImplementsListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.hostType();
        }
        if (caller == this.getSuperClassAccessOptNoTransform()) {
            return this.hostType();
        }
        return super.Define_TypeDecl_hostType(caller, child);
    }

    @Override
    public boolean Define_boolean_withinSuppressWarnings(ASTNode caller, ASTNode child, String s2) {
        if (caller == this.getImplementsListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.hasAnnotationSuppressWarnings(s2) || this.withinSuppressWarnings(s2);
        }
        if (caller == this.getSuperClassAccessOptNoTransform()) {
            return this.hasAnnotationSuppressWarnings(s2) || this.withinSuppressWarnings(s2);
        }
        return super.Define_boolean_withinSuppressWarnings(caller, child, s2);
    }

    @Override
    public boolean Define_boolean_withinDeprecatedAnnotation(ASTNode caller, ASTNode child) {
        if (caller == this.getImplementsListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.isDeprecated() || this.withinDeprecatedAnnotation();
        }
        if (caller == this.getSuperClassAccessOptNoTransform()) {
            return this.isDeprecated() || this.withinDeprecatedAnnotation();
        }
        return super.Define_boolean_withinDeprecatedAnnotation(caller, child);
    }

    @Override
    public boolean Define_boolean_inExtendsOrImplements(ASTNode caller, ASTNode child) {
        if (caller == this.getImplementsListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            return true;
        }
        if (caller == this.getSuperClassAccessOptNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_inExtendsOrImplements(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

