/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.CompilationDeathException;
import soot.G;
import soot.JastAddJ.BodyDecl;
import soot.JastAddJ.CompilationUnit;
import soot.JastAddJ.ConstructorDecl;
import soot.JastAddJ.MethodDecl;
import soot.JastAddJ.Problem;
import soot.JastAddJ.Program;
import soot.JastAddJ.TypeDecl;
import soot.MethodSource;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.javaToJimple.IInitialResolver;

public class JastAddInitialResolver
implements IInitialResolver {
    private static final Logger logger = LoggerFactory.getLogger(JastAddInitialResolver.class);
    protected Map<String, CompilationUnit> classNameToCU = new HashMap<String, CompilationUnit>();

    public JastAddInitialResolver(Singletons.Global g2) {
    }

    public static JastAddInitialResolver v() {
        return G.v().soot_JastAddInitialResolver();
    }

    @Override
    public void formAst(String fullPath, List<String> locations, String className) {
        Program program = SootResolver.v().getProgram();
        CompilationUnit u = program.getCachedOrLoadCompilationUnit(fullPath);
        if (u != null && !u.isResolved) {
            u.isResolved = true;
            ArrayList errors = new ArrayList();
            u.errorCheck(errors);
            if (!errors.isEmpty()) {
                for (Problem p : errors) {
                    logger.debug("" + p);
                }
                throw new CompilationDeathException(0, "there were errors during parsing and/or type checking (JastAdd frontend)");
            }
            u.transformation();
            u.jimplify1phase1();
            u.jimplify1phase2();
            HashSet<SootClass> types = new HashSet<SootClass>();
            for (TypeDecl typeDecl : u.getTypeDecls()) {
                this.collectTypeDecl(typeDecl, types);
            }
            if (types.isEmpty()) {
                this.classNameToCU.put(className, u);
            } else {
                for (SootClass sc : types) {
                    this.classNameToCU.put(sc.getName(), u);
                }
            }
        }
    }

    private void collectTypeDecl(TypeDecl typeDecl, HashSet<SootClass> types) {
        types.add(typeDecl.getSootClassDecl());
        for (TypeDecl nestedType : typeDecl.nestedTypes()) {
            this.collectTypeDecl(nestedType, types);
        }
    }

    private TypeDecl findNestedTypeDecl(TypeDecl typeDecl, SootClass sc) {
        if (typeDecl.sootClass() == sc) {
            return typeDecl;
        }
        for (TypeDecl nestedType : typeDecl.nestedTypes()) {
            TypeDecl t2 = this.findNestedTypeDecl(nestedType, sc);
            if (t2 == null) continue;
            return t2;
        }
        return null;
    }

    @Override
    public IInitialResolver.Dependencies resolveFromJavaFile(SootClass sootclass) {
        CompilationUnit u = this.classNameToCU.get(sootclass.getName());
        if (u == null) {
            throw new RuntimeException("Error: couldn't find class: " + sootclass.getName() + " are the packages set properly?");
        }
        HashSet<SootClass> types = new HashSet<SootClass>();
        for (TypeDecl typeDecl : u.getTypeDecls()) {
            this.collectTypeDecl(typeDecl, types);
        }
        IInitialResolver.Dependencies deps = new IInitialResolver.Dependencies();
        u.collectTypesToHierarchy(deps.typesToHierarchy);
        u.collectTypesToSignatures(deps.typesToSignature);
        for (SootClass sc : types) {
            for (SootMethod m4 : sc.getMethods()) {
                m4.setSource(new MethodSource(){

                    @Override
                    public Body getBody(SootMethod m4, String phaseName) {
                        SootClass sc = m4.getDeclaringClass();
                        CompilationUnit u = JastAddInitialResolver.this.classNameToCU.get(sc.getName());
                        for (TypeDecl typeDecl : u.getTypeDecls()) {
                            if ((typeDecl = JastAddInitialResolver.this.findNestedTypeDecl(typeDecl, sc)) == null) continue;
                            if (typeDecl.clinit == m4) {
                                typeDecl.jimplify2clinit();
                                return m4.getActiveBody();
                            }
                            for (BodyDecl bodyDecl : typeDecl.getBodyDecls()) {
                                if (bodyDecl instanceof MethodDecl) {
                                    MethodDecl methodDecl = (MethodDecl)bodyDecl;
                                    if (!m4.equals(methodDecl.sootMethod)) continue;
                                    methodDecl.jimplify2();
                                    return m4.getActiveBody();
                                }
                                if (!(bodyDecl instanceof ConstructorDecl)) continue;
                                ConstructorDecl constrDecl = (ConstructorDecl)bodyDecl;
                                if (!m4.equals(constrDecl.sootMethod)) continue;
                                constrDecl.jimplify2();
                                return m4.getActiveBody();
                            }
                        }
                        throw new RuntimeException("Could not find body for " + m4.getSignature() + " in " + m4.getDeclaringClass().getName());
                    }
                });
            }
        }
        return deps;
    }
}

