/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import soot.G;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.util.NumberedString;

public class EntryPoints {
    final NumberedString sigMain = Scene.v().getSubSigNumberer().findOrAdd("void main(java.lang.String[])");
    final NumberedString sigFinalize = Scene.v().getSubSigNumberer().findOrAdd("void finalize()");
    final NumberedString sigExit = Scene.v().getSubSigNumberer().findOrAdd("void exit()");
    final NumberedString sigClinit = Scene.v().getSubSigNumberer().findOrAdd("void <clinit>()");
    final NumberedString sigInit = Scene.v().getSubSigNumberer().findOrAdd("void <init>()");
    final NumberedString sigStart = Scene.v().getSubSigNumberer().findOrAdd("void start()");
    final NumberedString sigRun = Scene.v().getSubSigNumberer().findOrAdd("void run()");
    final NumberedString sigObjRun = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Object run()");
    final NumberedString sigForName = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Class forName(java.lang.String)");

    public EntryPoints(Singletons.Global g2) {
    }

    public static EntryPoints v() {
        return G.v().soot_EntryPoints();
    }

    protected void addMethod(List<SootMethod> set, SootClass cls, NumberedString methodSubSig) {
        SootMethod sm = cls.getMethodUnsafe(methodSubSig);
        if (sm != null) {
            set.add(sm);
        }
    }

    protected void addMethod(List<SootMethod> set, String methodSig) {
        if (Scene.v().containsMethod(methodSig)) {
            set.add(Scene.v().getMethod(methodSig));
        }
    }

    public List<SootMethod> application() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        if (Scene.v().hasMainClass()) {
            this.addMethod(ret, Scene.v().getMainClass(), this.sigMain);
            for (SootMethod clinit : this.clinitsOf(Scene.v().getMainClass())) {
                ret.add(clinit);
            }
        }
        return ret;
    }

    public List<SootMethod> implicit() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        this.addMethod(ret, "<java.lang.System: void initializeSystemClass()>");
        this.addMethod(ret, "<java.lang.ThreadGroup: void <init>()>");
        this.addMethod(ret, "<java.lang.Thread: void exit()>");
        this.addMethod(ret, "<java.lang.ThreadGroup: void uncaughtException(java.lang.Thread,java.lang.Throwable)>");
        this.addMethod(ret, "<java.lang.ClassLoader: void <init>()>");
        this.addMethod(ret, "<java.lang.ClassLoader: java.lang.Class loadClassInternal(java.lang.String)>");
        this.addMethod(ret, "<java.lang.ClassLoader: void checkPackageAccess(java.lang.Class,java.security.ProtectionDomain)>");
        this.addMethod(ret, "<java.lang.ClassLoader: void addClass(java.lang.Class)>");
        this.addMethod(ret, "<java.lang.ClassLoader: long findNative(java.lang.ClassLoader,java.lang.String)>");
        this.addMethod(ret, "<java.security.PrivilegedActionException: void <init>(java.lang.Exception)>");
        this.addMethod(ret, "<java.lang.ref.Finalizer: void runFinalizer()>");
        this.addMethod(ret, "<java.lang.Thread: void <init>(java.lang.ThreadGroup,java.lang.Runnable)>");
        this.addMethod(ret, "<java.lang.Thread: void <init>(java.lang.ThreadGroup,java.lang.String)>");
        return ret;
    }

    public List<SootMethod> all() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        ret.addAll(this.application());
        ret.addAll(this.implicit());
        return ret;
    }

    public List<SootMethod> clinits() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        for (SootClass cl : Scene.v().getClasses()) {
            this.addMethod(ret, cl, this.sigClinit);
        }
        return ret;
    }

    public List<SootMethod> inits() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        for (SootClass cl : Scene.v().getClasses()) {
            this.addMethod(ret, cl, this.sigInit);
        }
        return ret;
    }

    public List<SootMethod> allInits() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        for (SootClass cl : Scene.v().getClasses()) {
            for (SootMethod m4 : cl.getMethods()) {
                if (!m4.getName().equals("<init>")) continue;
                ret.add(m4);
            }
        }
        return ret;
    }

    public List<SootMethod> methodsOfApplicationClasses() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        for (SootClass cl : Scene.v().getApplicationClasses()) {
            for (SootMethod m4 : cl.getMethods()) {
                if (!m4.isConcrete()) continue;
                ret.add(m4);
            }
        }
        return ret;
    }

    public List<SootMethod> mainsOfApplicationClasses() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        for (SootClass cl : Scene.v().getApplicationClasses()) {
            SootMethod m4 = cl.getMethodUnsafe("void main(java.lang.String[])");
            if (m4 == null || !m4.isConcrete()) continue;
            ret.add(m4);
        }
        return ret;
    }

    public Iterable<SootMethod> clinitsOf(SootClass cl) {
        final SootMethod initStart = cl.getMethodUnsafe(this.sigClinit);
        if (initStart == null) {
            return Collections.emptyList();
        }
        return new Iterable<SootMethod>(){

            @Override
            public Iterator<SootMethod> iterator() {
                return new Iterator<SootMethod>(){
                    SootMethod current;
                    {
                        this.current = initStart;
                    }

                    @Override
                    public SootMethod next() {
                        SootClass superClass;
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        SootMethod n = this.current;
                        this.current = null;
                        SootClass currentClass = n.getDeclaringClass();
                        while ((superClass = currentClass.getSuperclassUnsafe()) != null) {
                            SootMethod m4 = superClass.getMethodUnsafe(EntryPoints.this.sigClinit);
                            if (m4 != null) {
                                this.current = m4;
                                break;
                            }
                            currentClass = superClass;
                        }
                        return n;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current != null;
                    }
                };
            }
        };
    }
}

