/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ClassProvider;
import soot.ClassSource;
import soot.DexClassSource;
import soot.SourceLocator;
import soot.dexpler.DexFileProvider;
import soot.dexpler.Util;
import soot.options.Options;

public class DexClassProvider
implements ClassProvider {
    private static final Logger logger = LoggerFactory.getLogger(DexClassProvider.class);

    public static Set<String> classesOfDex(DexFile dexFile) {
        HashSet<String> classes = new HashSet<String>();
        for (ClassDef classDef : dexFile.getClasses()) {
            String name = Util.dottedClassName(classDef.getType());
            classes.add(name);
        }
        return classes;
    }

    @Override
    public ClassSource find(String className) {
        this.ensureDexIndex();
        Map<String, File> index = SourceLocator.v().dexClassIndex();
        File file = index.get(className);
        if (file == null) {
            return null;
        }
        return new DexClassSource(className, file);
    }

    protected void ensureDexIndex() {
        Map<String, File> index = SourceLocator.v().dexClassIndex();
        if (index == null) {
            index = new HashMap<String, File>();
            this.buildDexIndex(index, SourceLocator.v().classPath());
            SourceLocator.v().setDexClassIndex(index);
        }
        if (SourceLocator.v().getDexClassPathExtensions() != null) {
            this.buildDexIndex(SourceLocator.v().dexClassIndex(), new ArrayList<String>(SourceLocator.v().getDexClassPathExtensions()));
            SourceLocator.v().clearDexClassPathExtensions();
        }
    }

    private void buildDexIndex(Map<String, File> index, List<String> classPath) {
        for (String path : classPath) {
            try {
                File dexFile = new File(path);
                if (!dexFile.exists()) continue;
                for (DexFileProvider.DexContainer<? extends DexFile> container2 : DexFileProvider.v().getDexFromSource(dexFile)) {
                    for (String className : DexClassProvider.classesOfDex(container2.getBase().getDexFile())) {
                        if (!index.containsKey(className)) {
                            index.put(className, container2.getFilePath());
                            continue;
                        }
                        if (!Options.v().verbose()) continue;
                        logger.debug("" + String.format("Warning: Duplicate of class '%s' found in dex file '%s' from source '%s'. Omitting class.", className, container2.getDexName(), container2.getFilePath().getCanonicalPath()));
                    }
                }
            }
            catch (IOException e) {
                logger.warn("IO error while processing dex file '" + path + "'");
                logger.debug("Exception: " + e);
            }
            catch (Exception e) {
                logger.warn("exception while processing dex file '" + path + "'");
                logger.debug("Exception: " + e);
            }
        }
    }
}

