/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Binary;
import polyglot.ast.CodeDecl;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Unary;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.IdentityKey;
import polyglot.util.InternalCompilerError;
import polyglot.util.StringUtil;
import polyglot.visit.CFGBuildError;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ErrorHandlingVisitor;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;

public abstract class DataFlow
extends ErrorHandlingVisitor {
    protected final boolean forward;
    protected final boolean dataflowOnEntry;
    protected LinkedList flowgraphStack;
    protected static int flowCounter = 0;

    public DataFlow(Job job, TypeSystem ts, NodeFactory nf, boolean forward) {
        this(job, ts, nf, forward, false);
    }

    public DataFlow(Job job, TypeSystem ts, NodeFactory nf, boolean forward, boolean dataflowOnEntry) {
        super(job, ts, nf);
        this.forward = forward;
        this.dataflowOnEntry = dataflowOnEntry;
        this.flowgraphStack = dataflowOnEntry ? new LinkedList() : null;
    }

    protected abstract Item createInitialItem(FlowGraph var1, Term var2);

    protected Map flow(Item in, FlowGraph graph, Term n, Set edgeKeys) {
        throw new InternalCompilerError("Unimplemented: should be implemented by subclasses if needed");
    }

    protected Map flow(List inItems, List inItemKeys, FlowGraph graph, Term n, Set edgeKeys) {
        Item inItem = this.safeConfluence(inItems, inItemKeys, n, graph);
        return this.flow(inItem, graph, n, edgeKeys);
    }

    protected final Map flowToBooleanFlow(List inItems, List inItemKeys, FlowGraph graph, Term n, Set edgeKeys) {
        ArrayList<Item> trueItems = new ArrayList<Item>();
        ArrayList<FlowGraph.EdgeKey> trueItemKeys = new ArrayList<FlowGraph.EdgeKey>();
        ArrayList<Item> falseItems = new ArrayList<Item>();
        ArrayList<FlowGraph.EdgeKey> falseItemKeys = new ArrayList<FlowGraph.EdgeKey>();
        ArrayList<Item> otherItems = new ArrayList<Item>();
        ArrayList<FlowGraph.EdgeKey> otherItemKeys = new ArrayList<FlowGraph.EdgeKey>();
        Iterator i = inItems.iterator();
        Iterator j = inItemKeys.iterator();
        while (i.hasNext() || j.hasNext()) {
            Item item = (Item)i.next();
            FlowGraph.EdgeKey key = (FlowGraph.EdgeKey)j.next();
            if (FlowGraph.EDGE_KEY_TRUE.equals(key)) {
                trueItems.add(item);
                trueItemKeys.add(key);
                continue;
            }
            if (FlowGraph.EDGE_KEY_FALSE.equals(key)) {
                falseItems.add(item);
                falseItemKeys.add(key);
                continue;
            }
            otherItems.add(item);
            otherItemKeys.add(key);
        }
        Item trueItem = trueItems.isEmpty() ? null : this.safeConfluence(trueItems, trueItemKeys, n, graph);
        Item falseItem = falseItems.isEmpty() ? null : this.safeConfluence(falseItems, falseItemKeys, n, graph);
        Item otherItem = otherItems.isEmpty() ? null : this.safeConfluence(otherItems, otherItemKeys, n, graph);
        return this.flow(trueItem, falseItem, otherItem, graph, n, edgeKeys);
    }

    protected Map flow(Item trueItem, Item falseItem, Item otherItem, FlowGraph graph, Term n, Set edgeKeys) {
        throw new InternalCompilerError("Unimplemented: should be implemented by subclasses if needed");
    }

    protected Map flowBooleanConditions(Item trueItem, Item falseItem, Item otherItem, FlowGraph graph, Expr n, Set edgeKeys) {
        if (!n.type().isBoolean() || !(n instanceof Binary) && !(n instanceof Unary)) {
            throw new InternalCompilerError("This method only takes binary or unary operators of boolean type");
        }
        if (trueItem == null || falseItem == null) {
            throw new IllegalArgumentException("The trueItem and falseItem for flowBooleanConditions must be non-null.");
        }
        if (n instanceof Unary) {
            Unary u = (Unary)n;
            if (u.operator() == Unary.NOT) {
                return DataFlow.itemsToMap(falseItem, trueItem, otherItem, edgeKeys);
            }
        } else {
            Binary b = (Binary)n;
            if (b.operator() == Binary.COND_AND) {
                return DataFlow.itemsToMap(trueItem, falseItem, otherItem, edgeKeys);
            }
            if (b.operator() == Binary.COND_OR) {
                return DataFlow.itemsToMap(trueItem, falseItem, otherItem, edgeKeys);
            }
            if (b.operator() == Binary.BIT_AND) {
                Item bitANDFalse = this.safeConfluence(trueItem, FlowGraph.EDGE_KEY_TRUE, falseItem, FlowGraph.EDGE_KEY_FALSE, n, graph);
                return DataFlow.itemsToMap(trueItem, bitANDFalse, otherItem, edgeKeys);
            }
            if (b.operator() == Binary.BIT_OR) {
                Item bitORTrue = this.safeConfluence(trueItem, FlowGraph.EDGE_KEY_TRUE, falseItem, FlowGraph.EDGE_KEY_FALSE, n, graph);
                return DataFlow.itemsToMap(bitORTrue, falseItem, otherItem, edgeKeys);
            }
        }
        return null;
    }

    protected abstract Item confluence(List var1, Term var2, FlowGraph var3);

    protected Item confluence(List items, List itemKeys, Term node, FlowGraph graph) {
        return this.confluence(items, node, graph);
    }

    protected Item safeConfluence(List items, List itemKeys, Term node, FlowGraph graph) {
        if (items.isEmpty()) {
            return this.createInitialItem(graph, node);
        }
        if (items.size() == 1) {
            return (Item)items.get(0);
        }
        return this.confluence(items, itemKeys, node, graph);
    }

    protected Item safeConfluence(Item item1, FlowGraph.EdgeKey key1, Item item2, FlowGraph.EdgeKey key2, Term node, FlowGraph graph) {
        return this.safeConfluence(item1, key1, item2, key2, null, null, node, graph);
    }

    protected Item safeConfluence(Item item1, FlowGraph.EdgeKey key1, Item item2, FlowGraph.EdgeKey key2, Item item3, FlowGraph.EdgeKey key3, Term node, FlowGraph graph) {
        ArrayList<Item> items = new ArrayList<Item>(3);
        ArrayList<FlowGraph.EdgeKey> itemKeys = new ArrayList<FlowGraph.EdgeKey>(3);
        if (item1 != null) {
            items.add(item1);
            itemKeys.add(key1);
        }
        if (item2 != null) {
            items.add(item2);
            itemKeys.add(key2);
        }
        if (item3 != null) {
            items.add(item3);
            itemKeys.add(key3);
        }
        return this.safeConfluence(items, itemKeys, node, graph);
    }

    protected abstract void check(FlowGraph var1, Term var2, Item var3, Map var4) throws SemanticException;

    protected void dataflow(CodeDecl cd2) throws SemanticException {
        FlowGraph g2;
        if (cd2.body() != null && (g2 = this.initGraph(cd2, cd2)) != null) {
            CFGBuilder v = this.createCFGBuilder(this.ts, g2);
            try {
                v.visitGraph();
            }
            catch (CFGBuildError e) {
                throw new SemanticException(e.message(), e.position());
            }
            this.dataflow(g2);
            this.post(g2, cd2);
            if (this.dataflowOnEntry) {
                this.flowgraphStack.addFirst(new FlowGraphSource(g2, cd2));
            }
        }
    }

    protected LinkedList findSCCs(FlowGraph graph) {
        Collection peers = graph.peers();
        FlowGraph.Peer[] sorted = new FlowGraph.Peer[peers.size()];
        Collection start = graph.peers(graph.startNode());
        int n = 0;
        LinkedList<Frame> stack = new LinkedList<Frame>();
        HashSet<FlowGraph.Peer> reachable = new HashSet<FlowGraph.Peer>();
        Iterator i = start.iterator();
        while (i.hasNext()) {
            FlowGraph.Peer peer = (FlowGraph.Peer)i.next();
            if (reachable.contains(peer)) continue;
            reachable.add(peer);
            stack.addFirst(new Frame(peer, true));
            while (stack.size() != 0) {
                Frame top = (Frame)stack.getFirst();
                if (top.edges.hasNext()) {
                    FlowGraph.Edge e = (FlowGraph.Edge)top.edges.next();
                    FlowGraph.Peer q = e.getTarget();
                    if (reachable.contains(q)) continue;
                    reachable.add(q);
                    stack.addFirst(new Frame(q, true));
                    continue;
                }
                stack.removeFirst();
                sorted[n++] = top.peer;
            }
        }
        FlowGraph.Peer[] by_scc = new FlowGraph.Peer[n];
        int[] scc_head = new int[n];
        HashSet<FlowGraph.Peer> visited = new HashSet<FlowGraph.Peer>();
        int head = 0;
        for (int i2 = n - 1; i2 >= 0; --i2) {
            if (visited.contains(sorted[i2])) continue;
            HashSet<FlowGraph.Peer> SCC2 = new HashSet<FlowGraph.Peer>();
            visited.add(sorted[i2]);
            stack.add(new Frame(sorted[i2], false));
            while (stack.size() != 0) {
                Frame top = (Frame)stack.getFirst();
                if (top.edges.hasNext()) {
                    FlowGraph.Edge e = (FlowGraph.Edge)top.edges.next();
                    FlowGraph.Peer q = e.getTarget();
                    if (!reachable.contains(q) || visited.contains(q)) continue;
                    visited.add(q);
                    Frame f = new Frame(q, false);
                    stack.addFirst(f);
                    continue;
                }
                stack.removeFirst();
                SCC2.add(top.peer);
            }
            stack.add(new Frame(sorted[i2], true));
            HashSet<FlowGraph.Peer> revisited = new HashSet<FlowGraph.Peer>();
            revisited.add(sorted[i2]);
            int scc_size = SCC2.size();
            int nsorted = 0;
            while (stack.size() != 0) {
                Frame top = (Frame)stack.getFirst();
                if (top.edges.hasNext()) {
                    FlowGraph.Edge e = (FlowGraph.Edge)top.edges.next();
                    FlowGraph.Peer q = e.getTarget();
                    if (!SCC2.contains(q) || revisited.contains(q)) continue;
                    revisited.add(q);
                    Frame f = new Frame(q, true);
                    stack.addFirst(f);
                    continue;
                }
                stack.removeFirst();
                int n3 = head + scc_size - nsorted - 1;
                scc_head[n3] = -2;
                by_scc[n3] = top.peer;
                ++nsorted;
            }
            scc_head[head + scc_size - 1] = head;
            scc_head[head] = -1;
            head += scc_size;
        }
        if (Report.should_report("dataflow", 2)) {
            for (int j = 0; j < n; ++j) {
                switch (scc_head[j]) {
                    case -1: {
                        Report.report(2, j + "[HEAD] : " + by_scc[j]);
                        break;
                    }
                    case -2: {
                        Report.report(2, j + "       : " + by_scc[j]);
                        break;
                    }
                    default: {
                        Report.report(2, j + " ->" + scc_head[j] + " : " + by_scc[j]);
                    }
                }
                Iterator i3 = by_scc[j].succs().iterator();
                while (i3.hasNext()) {
                    Report.report(3, "     successor: " + ((FlowGraph.Edge)i3.next()).getTarget());
                }
            }
        }
        LinkedList<Object[]> ret = new LinkedList<Object[]>();
        ret.addFirst(scc_head);
        ret.addFirst(by_scc);
        return ret;
    }

    protected void dataflow(FlowGraph graph) {
        if (Report.should_report("dataflow", 1)) {
            Report.report(1, "Finding strongly connected components");
        }
        LinkedList pair = this.findSCCs(graph);
        FlowGraph.Peer[] by_scc = (FlowGraph.Peer[])pair.getFirst();
        int[] scc_head = (int[])pair.getLast();
        int npeers = by_scc.length;
        if (Report.should_report("dataflow", 1)) {
            Report.report(1, "Iterating dataflow equations");
        }
        int current = 0;
        boolean change = false;
        while (current < npeers) {
            FlowGraph.Peer p = by_scc[current];
            if (scc_head[current] == -1) {
                change = false;
            }
            ArrayList<Item> inItems = new ArrayList<Item>(p.preds.size());
            ArrayList<FlowGraph.EdgeKey> inItemKeys = new ArrayList<FlowGraph.EdgeKey>(p.preds.size());
            Iterator i = p.preds.iterator();
            while (i.hasNext()) {
                FlowGraph.Edge e = (FlowGraph.Edge)i.next();
                FlowGraph.Peer o = e.getTarget();
                if (o.outItems == null) continue;
                if (!o.outItems.keySet().contains(e.getKey())) {
                    throw new InternalCompilerError("There should have an out Item with edge key " + e.getKey() + "; instead there were only " + o.outItems.keySet());
                }
                Item it = (Item)o.outItems.get(e.getKey());
                if (it == null) continue;
                inItems.add(it);
                inItemKeys.add(e.getKey());
            }
            Map oldOutItems = p.outItems;
            p.inItem = this.safeConfluence(inItems, inItemKeys, p.node, graph);
            p.outItems = this.flow(inItems, inItemKeys, graph, p.node, p.succEdgeKeys());
            if (!((Object)p.succEdgeKeys()).equals(p.outItems.keySet())) {
                throw new InternalCompilerError("The flow only defined outputs for " + p.outItems.keySet() + "; needs to " + "define outputs for all of: " + p.succEdgeKeys());
            }
            if (!(oldOutItems == p.outItems || oldOutItems != null && ((Object)oldOutItems).equals(p.outItems))) {
                change = true;
            }
            if (change && scc_head[current] >= 0) {
                current = scc_head[current];
                continue;
            }
            ++current;
        }
        if (Report.should_report("dataflow", 1)) {
            Report.report(1, "Done.");
        }
    }

    protected FlowGraph initGraph(CodeDecl code, Term root) {
        return new FlowGraph(root, this.forward);
    }

    protected CFGBuilder createCFGBuilder(TypeSystem ts, FlowGraph g2) {
        return new CFGBuilder(ts, g2, this);
    }

    protected NodeVisitor enterCall(Node n) throws SemanticException {
        if (this.dataflowOnEntry && n instanceof CodeDecl) {
            this.dataflow((CodeDecl)n);
        }
        return this;
    }

    public Node leave(Node parent, Node old, Node n, NodeVisitor v) {
        Object o;
        if (old != n && this.dataflowOnEntry && this.currentFlowGraph() != null && (o = this.currentFlowGraph().peerMap.get(new IdentityKey(old))) != null) {
            this.currentFlowGraph().peerMap.put(new IdentityKey(n), o);
        }
        return super.leave(parent, old, n, v);
    }

    protected Node leaveCall(Node n) throws SemanticException {
        if (n instanceof CodeDecl) {
            if (!this.dataflowOnEntry) {
                this.dataflow((CodeDecl)n);
            } else if (this.dataflowOnEntry && !this.flowgraphStack.isEmpty()) {
                FlowGraphSource fgs = (FlowGraphSource)this.flowgraphStack.getFirst();
                if (fgs.source.equals(n)) {
                    this.flowgraphStack.removeFirst();
                }
            }
        }
        return n;
    }

    protected void post(FlowGraph graph, Term root) throws SemanticException {
        if (Report.should_report("cfg", 2)) {
            this.dumpFlowGraph(graph, root);
        }
        HashSet uncheckedPeers = new HashSet(graph.peers());
        LinkedList<FlowGraph.Peer> peersToCheck = new LinkedList<FlowGraph.Peer>(graph.peers(graph.startNode()));
        while (!peersToCheck.isEmpty()) {
            FlowGraph.Peer p = (FlowGraph.Peer)peersToCheck.removeFirst();
            uncheckedPeers.remove(p);
            this.check(graph, p.node, p.inItem, p.outItems);
            Iterator iter = p.succs.iterator();
            while (iter.hasNext()) {
                FlowGraph.Peer q = ((FlowGraph.Edge)iter.next()).getTarget();
                if (!uncheckedPeers.contains(q) || peersToCheck.contains(q)) continue;
                peersToCheck.addLast(q);
            }
            if (!peersToCheck.isEmpty() || uncheckedPeers.isEmpty()) continue;
            Iterator i = uncheckedPeers.iterator();
            peersToCheck.add((FlowGraph.Peer)i.next());
            i.remove();
        }
    }

    protected FlowGraph currentFlowGraph() {
        if (!this.dataflowOnEntry) {
            throw new InternalCompilerError("currentFlowGraph() cannot be called when dataflow is not performed on entry");
        }
        if (this.flowgraphStack.isEmpty()) {
            return null;
        }
        return ((FlowGraphSource)this.flowgraphStack.getFirst()).flowgraph;
    }

    protected static final Map itemToMap(Item i, Set edgeKeys) {
        HashMap m4 = new HashMap();
        Iterator iter = edgeKeys.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            m4.put(o, i);
        }
        return m4;
    }

    protected static final Map itemsToMap(Item trueItem, Item falseItem, Item remainingItem, Set edgeKeys) {
        HashMap<FlowGraph.EdgeKey, Item> m4 = new HashMap<FlowGraph.EdgeKey, Item>();
        Iterator iter = edgeKeys.iterator();
        while (iter.hasNext()) {
            FlowGraph.EdgeKey k = (FlowGraph.EdgeKey)iter.next();
            if (FlowGraph.EDGE_KEY_TRUE.equals(k)) {
                m4.put(k, trueItem);
                continue;
            }
            if (FlowGraph.EDGE_KEY_FALSE.equals(k)) {
                m4.put(k, falseItem);
                continue;
            }
            m4.put(k, remainingItem);
        }
        return m4;
    }

    protected final List filterItemsNonError(List items, List itemKeys) {
        ArrayList<Item> filtered = new ArrayList<Item>(items.size());
        Iterator i = items.iterator();
        Iterator j = itemKeys.iterator();
        while (i.hasNext() && j.hasNext()) {
            Item item = (Item)i.next();
            FlowGraph.EdgeKey key = (FlowGraph.EdgeKey)j.next();
            if (key instanceof FlowGraph.ExceptionEdgeKey && ((FlowGraph.ExceptionEdgeKey)key).type().isSubtype(this.ts.Error())) continue;
            filtered.add(item);
        }
        if (i.hasNext() || j.hasNext()) {
            throw new InternalCompilerError("item and item key lists have different sizes.");
        }
        return filtered;
    }

    protected final List filterItemsNonException(List items, List itemKeys) {
        ArrayList<Item> filtered = new ArrayList<Item>(items.size());
        Iterator i = items.iterator();
        Iterator j = itemKeys.iterator();
        while (i.hasNext() && j.hasNext()) {
            Item item = (Item)i.next();
            FlowGraph.EdgeKey key = (FlowGraph.EdgeKey)j.next();
            if (key instanceof FlowGraph.ExceptionEdgeKey) continue;
            filtered.add(item);
        }
        if (i.hasNext() || j.hasNext()) {
            throw new InternalCompilerError("item and item key lists have different sizes.");
        }
        return filtered;
    }

    protected final List filterItemsExceptionSubclass(List items, List itemKeys, Type excType) {
        ArrayList<Item> filtered = new ArrayList<Item>(items.size());
        Iterator i = items.iterator();
        Iterator j = itemKeys.iterator();
        while (i.hasNext() && j.hasNext()) {
            FlowGraph.ExceptionEdgeKey eek;
            Item item = (Item)i.next();
            FlowGraph.EdgeKey key = (FlowGraph.EdgeKey)j.next();
            if (!(key instanceof FlowGraph.ExceptionEdgeKey) || !(eek = (FlowGraph.ExceptionEdgeKey)key).type().isImplicitCastValid(excType)) continue;
            filtered.add(item);
        }
        if (i.hasNext() || j.hasNext()) {
            throw new InternalCompilerError("item and item key lists have different sizes.");
        }
        return filtered;
    }

    protected final List filterItems(List items, List itemKeys, FlowGraph.EdgeKey filterEdgeKey) {
        ArrayList<Item> filtered = new ArrayList<Item>(items.size());
        Iterator i = items.iterator();
        Iterator j = itemKeys.iterator();
        while (i.hasNext() && j.hasNext()) {
            Item item = (Item)i.next();
            FlowGraph.EdgeKey key = (FlowGraph.EdgeKey)j.next();
            if (!filterEdgeKey.equals(key)) continue;
            filtered.add(item);
        }
        if (i.hasNext() || j.hasNext()) {
            throw new InternalCompilerError("item and item key lists have different sizes.");
        }
        return filtered;
    }

    protected static final boolean hasTrueFalseBranches(Set edgeKeys) {
        return edgeKeys.contains(FlowGraph.EDGE_KEY_FALSE) && edgeKeys.contains(FlowGraph.EDGE_KEY_TRUE);
    }

    protected static Map constructItemsFromCondition(Expr booleanCond, Item startingItem, Set succEdgeKeys, ConditionNavigator navigator) {
        if (!booleanCond.type().isBoolean()) {
            throw new IllegalArgumentException("booleanCond must be a boolean expression");
        }
        if (!DataFlow.hasTrueFalseBranches(succEdgeKeys)) {
            throw new IllegalArgumentException("succEdgeKeys does not have true and false branches.");
        }
        BoolItem results = navigator.navigate(booleanCond, startingItem);
        HashMap<FlowGraph.EdgeKey, Item> m4 = new HashMap<FlowGraph.EdgeKey, Item>();
        m4.put(FlowGraph.EDGE_KEY_TRUE, results.trueItem);
        m4.put(FlowGraph.EDGE_KEY_FALSE, results.falseItem);
        Iterator iter = succEdgeKeys.iterator();
        while (iter.hasNext()) {
            FlowGraph.EdgeKey e = (FlowGraph.EdgeKey)iter.next();
            if (FlowGraph.EDGE_KEY_TRUE.equals(e) || FlowGraph.EDGE_KEY_FALSE.equals(e)) continue;
            m4.put(e, startingItem);
        }
        return m4;
    }

    protected void dumpFlowGraph(FlowGraph graph, Term root) {
        String name = StringUtil.getShortNameComponent(this.getClass().getName());
        name = name + flowCounter++;
        String rootName = "";
        if (graph.root() instanceof CodeDecl) {
            CodeDecl cd2 = (CodeDecl)graph.root();
            rootName = cd2.codeInstance().toString() + " in " + cd2.codeInstance().container().toString();
        }
        Report.report(2, "digraph DataFlow" + name + " {");
        Report.report(2, "  label=\"Dataflow: " + name + "\\n" + rootName + "\"; fontsize=20; center=true; ratio=auto; size = \"8.5,11\";");
        Iterator iter = graph.peers().iterator();
        while (iter.hasNext()) {
            FlowGraph.Peer p = (FlowGraph.Peer)iter.next();
            Report.report(2, p.hashCode() + " [ label = \"" + StringUtil.escape(p.node.toString()) + "\\n(" + StringUtil.escape(StringUtil.getShortNameComponent(p.node.getClass().getName())) + ")\" ];");
            Iterator iter2 = p.succs.iterator();
            while (iter2.hasNext()) {
                FlowGraph.Edge q = (FlowGraph.Edge)iter2.next();
                Report.report(2, q.getTarget().hashCode() + " [ label = \"" + StringUtil.escape(q.getTarget().node.toString()) + " (" + StringUtil.escape(StringUtil.getShortNameComponent(q.getTarget().node.getClass().getName())) + ")\" ];");
                String label = q.getKey().toString();
                label = p.outItems != null ? label + "\\n" + p.outItems.get(q.getKey()) : label + "\\n[no dataflow available]";
                Report.report(2, p.hashCode() + " -> " + q.getTarget().hashCode() + " [label=\"" + label + "\"];");
            }
        }
        Report.report(2, "}");
    }

    protected static abstract class ConditionNavigator {
        protected ConditionNavigator() {
        }

        public BoolItem navigate(Expr expr, Item startingItem) {
            if (expr.type().isBoolean()) {
                Unary u;
                if (expr instanceof Binary) {
                    Binary b = (Binary)expr;
                    if (Binary.COND_AND.equals(b.operator()) || Binary.BIT_AND.equals(b.operator())) {
                        BoolItem leftRes = this.navigate(b.left(), startingItem);
                        Item rightResStart = startingItem;
                        if (Binary.COND_AND.equals(b.operator())) {
                            rightResStart = leftRes.trueItem;
                        }
                        BoolItem rightRes = this.navigate(b.right(), rightResStart);
                        return this.andResults(leftRes, rightRes, startingItem);
                    }
                    if (Binary.COND_OR.equals(b.operator()) || Binary.BIT_OR.equals(b.operator())) {
                        BoolItem leftRes = this.navigate(b.left(), startingItem);
                        Item rightResStart = startingItem;
                        if (Binary.COND_OR.equals(b.operator())) {
                            rightResStart = leftRes.falseItem;
                        }
                        BoolItem rightRes = this.navigate(b.right(), rightResStart);
                        return this.orResults(leftRes, rightRes, startingItem);
                    }
                } else if (expr instanceof Unary && Unary.NOT.equals((u = (Unary)expr).operator())) {
                    BoolItem res = this.navigate(u.expr(), startingItem);
                    return this.notResult(res);
                }
            }
            return this.handleExpression(expr, startingItem);
        }

        public BoolItem andResults(BoolItem left, BoolItem right, Item startingItem) {
            return new BoolItem(this.combine(left.trueItem, right.trueItem), startingItem);
        }

        public BoolItem orResults(BoolItem left, BoolItem right, Item startingItem) {
            return new BoolItem(startingItem, this.combine(left.falseItem, right.falseItem));
        }

        public BoolItem notResult(BoolItem results) {
            return new BoolItem(results.falseItem, results.trueItem);
        }

        public abstract Item combine(Item var1, Item var2);

        public abstract BoolItem handleExpression(Expr var1, Item var2);
    }

    protected static class BoolItem {
        Item trueItem;
        Item falseItem;

        public BoolItem(Item trueItem, Item falseItem) {
            this.trueItem = trueItem;
            this.falseItem = falseItem;
        }

        public Item trueItem() {
            return this.trueItem;
        }

        public Item falseItem() {
            return this.falseItem;
        }

        public String toString() {
            return "[ true: " + this.trueItem + "; false: " + this.falseItem + " ]";
        }
    }

    private static class Frame {
        FlowGraph.Peer peer;
        Iterator edges;

        Frame(FlowGraph.Peer p, boolean forward) {
            this.peer = p;
            this.edges = forward ? p.succs().iterator() : p.preds().iterator();
        }
    }

    public static abstract class Item {
        public abstract boolean equals(Object var1);

        public abstract int hashCode();
    }

    protected static class FlowGraphSource {
        FlowGraph flowgraph;
        CodeDecl source;

        FlowGraphSource(FlowGraph g2, CodeDecl s2) {
            this.flowgraph = g2;
            this.source = s2;
        }

        public FlowGraph flowGraph() {
            return this.flowgraph;
        }

        public CodeDecl source() {
            return this.source;
        }
    }
}

