/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util.typedump;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.TypeEncoder;

class TypeDumper {
    static Set dontExpand;
    Type theType;
    String rawName;
    String compilerVersion;
    Date timestamp;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    TypeDumper(String rawName, Type t2, String compilerVersion, Long timestamp) {
        this.theType = t2;
        this.rawName = rawName;
        this.compilerVersion = compilerVersion;
        this.timestamp = new Date(timestamp);
    }

    public static TypeDumper load(String name, TypeSystem ts) throws ClassNotFoundException, NoSuchFieldException, IOException, SecurityException {
        Class<?> c = Class.forName(name);
        try {
            Field jlcVersion = c.getDeclaredField("jlc$CompilerVersion");
            Field jlcTimestamp = c.getDeclaredField("jlc$SourceLastModified");
            Field jlcType = c.getDeclaredField("jlc$ClassType");
            String t2 = (String)jlcType.get(null);
            TypeEncoder te = new TypeEncoder(ts);
            return new TypeDumper(name, te.decode(t2), (String)jlcVersion.get(null), (Long)jlcTimestamp.get(null));
        }
        catch (IllegalAccessException exn) {
            throw new SecurityException("illegal access: " + exn.getMessage());
        }
    }

    public void dump(CodeWriter w) {
        HashMap<Type, Type> cache = new HashMap<Type, Type>();
        cache.put(this.theType, this.theType);
        w.write("Type " + this.rawName + " {");
        w.allowBreak(2);
        w.begin(0);
        w.write("Compiled with polyglot version " + this.compilerVersion + ".  ");
        w.allowBreak(0);
        w.write("Last modified: " + this.timestamp.toString() + ".  ");
        w.allowBreak(0);
        w.write(((Object)this.theType).toString());
        w.allowBreak(4);
        w.write("<" + this.theType.getClass().toString() + ">");
        w.allowBreak(0);
        this.dumpObject(w, this.theType, cache);
        w.allowBreak(0);
        w.end();
        w.allowBreak(0);
        w.write("}");
        w.newline(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpObject(CodeWriter w, Object obj, Map cache) {
        w.write(" fields {");
        w.allowBreak(2);
        w.begin(0);
        try {
            try {
                AccessibleObject[] declaredFields = obj.getClass().getDeclaredFields();
                AccessibleObject.setAccessible(declaredFields, true);
                for (int i = 0; i < declaredFields.length; ++i) {
                    if (Modifier.isStatic(((Field)declaredFields[i]).getModifiers())) continue;
                    w.begin(4);
                    w.write(((Field)declaredFields[i]).getName() + ": ");
                    w.allowBreak(0);
                    try {
                        Object o = ((Field)declaredFields[i]).get(obj);
                        if (o != null) {
                            Class<?> rtType = o.getClass();
                            w.write("<" + rtType.toString() + ">:");
                            w.allowBreak(0);
                            w.write(o.toString());
                            w.allowBreak(4);
                            if (!((class$java$lang$Object == null ? TypeDumper.class$("java.lang.Object") : class$java$lang$Object).equals(rtType) || TypeDumper.dontDump(rtType) || rtType.isArray() || cache.containsKey(o) && cache.get(o) == o)) {
                                cache.put(o, o);
                                this.dumpObject(w, o, cache);
                            }
                        } else {
                            w.write("null");
                        }
                    }
                    catch (IllegalAccessException exn) {
                        w.write("##[" + exn.getMessage() + "]");
                    }
                    w.end();
                    w.allowBreak(0);
                }
                Object var9_10 = null;
            }
            catch (SecurityException exn) {
                Object var9_11 = null;
                w.end();
                w.allowBreak(0);
                w.write("}");
            }
            w.end();
            w.allowBreak(0);
            w.write("}");
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            w.end();
            w.allowBreak(0);
            w.write("}");
            throw throwable;
        }
    }

    static boolean dontDump(Class c) {
        return dontExpand.contains(c);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Object[] primitiveLike = new Object[]{class$java$lang$Void == null ? (class$java$lang$Void = TypeDumper.class$("java.lang.Void")) : class$java$lang$Void, class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeDumper.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Short == null ? (class$java$lang$Short = TypeDumper.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = TypeDumper.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = TypeDumper.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = TypeDumper.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Double == null ? (class$java$lang$Double = TypeDumper.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Class == null ? (class$java$lang$Class = TypeDumper.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$String == null ? (class$java$lang$String = TypeDumper.class$("java.lang.String")) : class$java$lang$String};
        dontExpand = new HashSet<Object>(Arrays.asList(primitiveLike));
    }
}

