/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import polyglot.util.CodeWriter;
import polyglot.util.FormatResult;
import polyglot.util.MaxLevels;
import polyglot.util.Overrun;

abstract class Item {
    Item next = null;
    static final int NO_WIDTH = -9999;
    Map min_widths = new HashMap();
    Map min_indents = new HashMap();
    Map min_pos_width = new HashMap();
    boolean contains_brks;
    boolean cb_init = false;

    protected Item() {
    }

    abstract FormatResult formatN(int var1, int var2, int var3, int var4, MaxLevels var5, int var6, int var7) throws Overrun;

    abstract int sendOutput(PrintWriter var1, int var2, int var3, boolean var4, Item var5) throws IOException;

    static FormatResult format(Item it, int lmargin, int pos, int rmargin, int fin, MaxLevels m4, int minLevel, int minLevelUnified) throws Overrun {
        ++CodeWriter.format_calls;
        if (it == null) {
            if (pos > fin) {
                throw Overrun.overrun(pos - fin, 2);
            }
            return new FormatResult(pos, minLevelUnified);
        }
        int amount2 = lmargin + Item.getMinWidth(it, m4) - rmargin;
        if (amount2 > 0) {
            throw Overrun.overrun(amount2, 1);
        }
        int amount = pos + Item.getMinPosWidth(it, m4) - rmargin;
        if (amount > 0) {
            throw Overrun.overrun(amount, 0);
        }
        int amount3 = lmargin + Item.getMinIndent(it, m4) - fin;
        if (amount3 > 0) {
            throw Overrun.overrun(amount3, 2);
        }
        return it.formatN(lmargin, pos, rmargin, fin, m4, minLevel, minLevelUnified);
    }

    static int getMinWidth(Item it, MaxLevels m4) {
        if (it == null) {
            return -9999;
        }
        if (it.min_widths.containsKey(m4)) {
            return (Integer)it.min_widths.get(m4);
        }
        int p1 = it.selfMinWidth(m4);
        int p2 = it.selfMinIndent(m4);
        int p3 = p2 != -9999 ? Item.getMinPosWidth(it.next, m4) + p2 : -9999;
        int p4 = Item.getMinWidth(it.next, m4);
        int result = Math.max(Math.max(p1, p3), p4);
        it.min_widths.put(m4, new Integer(result));
        return result;
    }

    static int getMinPosWidth(Item it, MaxLevels m4) {
        if (it == null) {
            return 0;
        }
        if (it.min_pos_width.containsKey(m4)) {
            return (Integer)it.min_pos_width.get(m4);
        }
        int p1 = it.selfMinPosWidth(m4);
        int result = it.next == null || it.selfContainsBreaks(m4) ? p1 : p1 + Item.getMinPosWidth(it.next, m4);
        it.min_pos_width.put(m4, new Integer(result));
        return result;
    }

    static int getMinIndent(Item it, MaxLevels m4) {
        if (it == null) {
            return -9999;
        }
        if (it.min_indents.containsKey(m4)) {
            return (Integer)it.min_indents.get(m4);
        }
        int p1 = it.selfMinIndent(m4);
        if (it.next == null) {
            return p1;
        }
        int result = Item.containsBreaks(it.next, m4) ? Item.getMinIndent(it.next, m4) : Item.getMinPosWidth(it.next, m4);
        it.min_indents.put(m4, new Integer(result));
        return result;
    }

    static boolean containsBreaks(Item it, MaxLevels m4) {
        if (it == null) {
            return false;
        }
        if (it.cb_init) {
            return it.contains_brks;
        }
        if (it.selfContainsBreaks(m4)) {
            it.contains_brks = true;
            it.cb_init = true;
            return true;
        }
        if (it.next == null) {
            return false;
        }
        it.contains_brks = Item.containsBreaks(it.next, m4);
        it.cb_init = true;
        return it.contains_brks;
    }

    public String summarize(String s2) {
        if (s2.length() <= 79) {
            return s2;
        }
        return s2.substring(0, 76) + "...";
    }

    public String toString() {
        if (this.next == null) {
            return this.summarize(this.selfToString());
        }
        return this.summarize(this.selfToString() + this.next.toString());
    }

    abstract String selfToString();

    abstract int selfMinIndent(MaxLevels var1);

    abstract int selfMinWidth(MaxLevels var1);

    abstract int selfMinPosWidth(MaxLevels var1);

    abstract boolean selfContainsBreaks(MaxLevels var1);
}

