/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.Report;

public class Stats {
    protected ExtensionInfo ext;
    protected Map passTimes = new HashMap();
    protected List keys = new ArrayList(20);

    public Stats(ExtensionInfo ext) {
        this.ext = ext;
    }

    public void resetPassTimes(Object key) {
        this.passTimes.remove(key);
    }

    public long passTime(Object key, boolean inclusive) {
        Times t2 = (Times)this.passTimes.get(key);
        if (t2 == null) {
            return 0L;
        }
        return inclusive ? t2.inclusive : t2.exclusive;
    }

    public void accumPassTimes(Object key, long in, long ex) {
        Times t2 = (Times)this.passTimes.get(key);
        if (t2 == null) {
            this.keys.add(key);
            t2 = new Times();
            this.passTimes.put(key, t2);
        }
        t2.inclusive += in;
        t2.exclusive += ex;
    }

    public void report() {
        if (Report.should_report("time", 1)) {
            Report.report(1, "\nStatistics for " + this.ext.compilerName() + " (" + this.ext.getClass().getName() + ")");
            Report.report(1, "Pass Inclusive Exclusive");
            Report.report(1, "---- --------- ---------");
            Iterator i = this.keys.iterator();
            while (i.hasNext()) {
                Object key = i.next();
                Times t2 = (Times)this.passTimes.get(key);
                Report.report(1, key.toString() + " " + t2.inclusive + " " + t2.exclusive);
            }
        }
    }

    protected static class Times {
        long inclusive;
        long exclusive;

        protected Times() {
        }
    }
}

