/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;
    private static final String SEPARATOR = ".";
    private transient String versionString;
    private transient int hash;
    public static final Version emptyVersion = new Version(0, 0, 0);

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public Version(int major, int minor, int micro, String qualifier) {
        if (qualifier == null) {
            qualifier = "";
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
        this.validate();
    }

    public Version(String version2) {
        int maj = 0;
        int min2 = 0;
        int mic = 0;
        String qual = "";
        try {
            StringTokenizer st = new StringTokenizer(version2, SEPARATOR, true);
            maj = Version.parseInt(st.nextToken(), version2);
            if (st.hasMoreTokens()) {
                st.nextToken();
                min2 = Version.parseInt(st.nextToken(), version2);
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    mic = Version.parseInt(st.nextToken(), version2);
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                        qual = st.nextToken("");
                        if (st.hasMoreTokens()) {
                            throw new IllegalArgumentException("invalid version \"" + version2 + "\": invalid format");
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("invalid version \"" + version2 + "\": invalid format", e);
        }
        this.major = maj;
        this.minor = min2;
        this.micro = mic;
        this.qualifier = qual;
        this.validate();
    }

    private static int parseInt(String value, String version2) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid version \"" + version2 + "\": non-numeric \"" + value + "\"", e);
        }
    }

    private void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString0() + "\": negative number \"" + this.major + "\"");
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString0() + "\": negative number \"" + this.minor + "\"");
        }
        if (this.micro < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString0() + "\": negative number \"" + this.micro + "\"");
        }
        char[] cArray = this.qualifier.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (!('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9' || ch == '_' || ch == '-')) {
                throw new IllegalArgumentException("invalid version \"" + this.toString0() + "\": invalid qualifier \"" + this.qualifier + "\"");
            }
            ++n2;
        }
    }

    public static Version parseVersion(String version2) {
        if (version2 == null) {
            return emptyVersion;
        }
        return Version.valueOf(version2);
    }

    public static Version valueOf(String version2) {
        if ((version2 = version2.trim()).length() == 0) {
            return emptyVersion;
        }
        return new Version(version2);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        return this.toString0();
    }

    String toString0() {
        String s2 = this.versionString;
        if (s2 != null) {
            return s2;
        }
        int q = this.qualifier.length();
        StringBuilder result = new StringBuilder(20 + q);
        result.append(this.major);
        result.append(SEPARATOR);
        result.append(this.minor);
        result.append(SEPARATOR);
        result.append(this.micro);
        if (q > 0) {
            result.append(SEPARATOR);
            result.append(this.qualifier);
        }
        this.versionString = result.toString();
        return this.versionString;
    }

    public int hashCode() {
        int h2 = this.hash;
        if (h2 != 0) {
            return h2;
        }
        h2 = 527;
        h2 = 31 * h2 + this.major;
        h2 = 31 * h2 + this.minor;
        h2 = 31 * h2 + this.micro;
        this.hash = h2 = 31 * h2 + this.qualifier.hashCode();
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version other = (Version)object;
        return this.major == other.major && this.minor == other.minor && this.micro == other.micro && this.qualifier.equals(other.qualifier);
    }

    @Override
    public int compareTo(Version other) {
        if (other == this) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - other.micro;
        if (result != 0) {
            return result;
        }
        return this.qualifier.compareTo(other.qualifier);
    }
}

