/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.util;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.jf.dexlib2.dexbacked.DexBuffer;
import org.jf.dexlib2.dexbacked.DexReader;

public abstract class VariableSizeListIterator<T>
implements ListIterator<T> {
    @Nonnull
    private DexReader<? extends DexBuffer> reader;
    protected final int size;
    private final int startOffset;
    private int index;

    protected VariableSizeListIterator(@Nonnull DexBuffer buffer, int offset, int size) {
        this.reader = buffer.readerAt(offset);
        this.startOffset = offset;
        this.size = size;
    }

    protected abstract T readNextItem(@Nonnull DexReader<? extends DexBuffer> var1, int var2);

    public int getReaderOffset() {
        return this.reader.getOffset();
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size;
    }

    @Override
    public T next() {
        if (this.index >= this.size) {
            throw new NoSuchElementException();
        }
        return this.readNextItem(this.reader, this.index++);
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public T previous() {
        int targetIndex = this.index - 1;
        this.reader.setOffset(this.startOffset);
        this.index = 0;
        while (this.index < targetIndex) {
            this.readNextItem(this.reader, this.index++);
        }
        return this.readNextItem(this.reader, this.index++);
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(T t2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(T t2) {
        throw new UnsupportedOperationException();
    }
}

