/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ecoreInference;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.XtextSwitch;
import org.eclipse.xtext.xtext.GrammarResource;
import org.eclipse.xtext.xtext.ecoreInference.DatatypeRuleUtil;
import org.eclipse.xtext.xtext.ecoreInference.EClassifierInfo;
import org.eclipse.xtext.xtext.ecoreInference.EClassifierInfos;
import org.eclipse.xtext.xtext.ecoreInference.ErrorAcceptor;
import org.eclipse.xtext.xtext.ecoreInference.IXtext2EcorePostProcessor;
import org.eclipse.xtext.xtext.ecoreInference.SourceAdapter;
import org.eclipse.xtext.xtext.ecoreInference.TransformationErrorCode;
import org.eclipse.xtext.xtext.ecoreInference.TransformationException;
import org.eclipse.xtext.xtext.ecoreInference.TypeHierarchyHelper;
import org.eclipse.xtext.xtext.ecoreInference.Xtext2EcoreInterpretationContext;

public class Xtext2EcoreTransformer {
    private static final Logger log = Logger.getLogger(Xtext2EcoreTransformer.class);
    private final Grammar grammar;
    private Map<String, EPackage> generatedEPackages;
    private EClassifierInfos eClassifierInfos;
    private ErrorAcceptor errorAcceptor = new NullErrorAcceptor();
    private IXtext2EcorePostProcessor postProcessor;

    public Xtext2EcoreTransformer(Grammar grammar) {
        this.grammar = grammar;
    }

    public ErrorAcceptor getErrorAcceptor() {
        return this.errorAcceptor;
    }

    public void setErrorAcceptor(ErrorAcceptor errorAcceptor) {
        this.errorAcceptor = errorAcceptor;
    }

    @Deprecated
    public void setPostProcessor(IXtext2EcorePostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public static void doTransform(Grammar grammar) {
        new Xtext2EcoreTransformer(grammar).transform();
    }

    public static List<EPackage> doGetGeneratedPackages(Grammar grammar) {
        return new Xtext2EcoreTransformer(grammar).getGeneratedPackages();
    }

    public List<EPackage> getGeneratedPackages() {
        ResourceSet resourceSet = this.grammar.eResource().getResourceSet();
        if (resourceSet == null) {
            throw new NullPointerException("resourceSet may not be null");
        }
        return FluentIterable.from(this.grammar.getMetamodelDeclarations()).filter(GeneratedMetamodel.class).transform(mm4 -> {
            EPackage pack = (EPackage)mm4.eGet(XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, false);
            if (pack != null && !pack.eIsProxy()) {
                return pack;
            }
            return null;
        }).filter(Predicates.notNull()).toSortedList(Comparator.comparing(ENamedElement::getName));
    }

    public void transform() {
        this.eClassifierInfos = new EClassifierInfos(this.grammar);
        this.generatedEPackages = Maps.newLinkedHashMap();
        this.collectEClassInfosOfUsedGrammars();
        this.collectEPackages();
        if (!this.deriveTypes()) {
            return;
        }
        if (!this.deriveFeatures()) {
            return;
        }
        this.normalizeAndValidateGeneratedPackages();
        this.postProcessGeneratedPackages();
    }

    public void removeGeneratedPackages() {
        ResourceSet resourceSet = this.grammar.eResource().getResourceSet();
        EList<Resource> resources = resourceSet.getResources();
        List<EPackage> packages = this.getGeneratedPackages();
        int i = 0;
        while (i < resources.size()) {
            Resource r = (Resource)resources.get(i);
            if (!(r instanceof GrammarResource)) {
                for (EObject content : r.getContents()) {
                    if ((!(content instanceof EPackage) || !packages.contains(content)) && (this.generatedEPackages == null || !this.generatedEPackages.containsValue(content))) continue;
                    this.clearPackage(r, (EPackage)content);
                    break;
                }
            }
            ++i;
        }
    }

    protected void clearPackage(Resource resource, EPackage pack) {
        HashMap<InternalEObject, URI> uris = Maps.newHashMap();
        for (EClassifier eClassifier : pack.getEClassifiers()) {
            InternalEObject internalEObject = (InternalEObject)((Object)eClassifier);
            URI appendFragment = resource.getURI().appendFragment(resource.getURIFragment(internalEObject));
            uris.put(internalEObject, appendFragment);
        }
        pack.getEClassifiers().clear();
        for (Map.Entry entry : uris.entrySet()) {
            ((InternalEObject)entry.getKey()).eSetProxyURI((URI)entry.getValue());
        }
    }

    private boolean deriveTypes() {
        return this.deriveTypesImpl() && this.checkDatatypeRules() && this.deriveTypeHierarchy();
    }

    private boolean deriveTypeHierarchy() {
        boolean result = true;
        for (AbstractRule rule : this.grammar.getRules()) {
            try {
                EClassifierInfo generatedEClass = this.findOrCreateEClassifierInfo(rule);
                if (generatedEClass != null || !this.isWildcardFragment(rule)) {
                    if (rule instanceof ParserRule) {
                        ParserRule parserRule = (ParserRule)rule;
                        if (parserRule.getAlternatives() != null) {
                            if (!GrammarUtil.isDatatypeRule(parserRule)) {
                                this.deriveTypesAndHierarchy(parserRule, generatedEClass, parserRule.getAlternatives());
                            } else {
                                this.checkSupertypeOfOverriddenDatatypeRule(rule);
                            }
                        }
                    } else if (rule instanceof TerminalRule) {
                        if (rule.getType() != null) {
                            if (!(rule.getType().getClassifier() instanceof EDataType)) {
                                throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Return type of a terminal rule must be an EDataType.", rule.getType());
                            }
                            this.checkSupertypeOfOverriddenDatatypeRule(rule);
                        }
                    } else if (rule instanceof EnumRule) {
                        if (rule.getType() != null) {
                            if (!(rule.getType().getClassifier() instanceof EEnum)) {
                                throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Return type of an enum rule must be an EEnum.", rule.getType());
                            }
                            this.checkSupertypeOfOverriddenDatatypeRule(rule);
                        }
                    } else {
                        throw new IllegalStateException("Unknown rule type: " + rule.eClass().getName());
                    }
                }
                if (!this.isWildcardFragment(rule)) continue;
                for (Grammar usedGrammar : this.grammar.getUsedGrammars()) {
                    this.deriveTypeHierarchyFromOverridden((ParserRule)rule, usedGrammar);
                }
            }
            catch (TransformationException e) {
                this.reportError(e);
                result = false;
            }
        }
        return result;
    }

    private void checkSupertypeOfOverriddenDatatypeRule(AbstractRule rule) throws TransformationException {
        EDataType datatype = (EDataType)rule.getType().getClassifier();
        for (Grammar usedGrammar : this.grammar.getUsedGrammars()) {
            TerminalRule terminal2;
            AbstractRule parentRule = GrammarUtil.findRuleForName(usedGrammar, rule.getName());
            if (parentRule == null || parentRule == rule) continue;
            if (parentRule.getType() == null || parentRule.getType().getClassifier() == null) {
                throw new TransformationException(TransformationErrorCode.InvalidSupertype, "Cannot determine return type of overridden rule.", rule.getType());
            }
            if (!datatype.equals(parentRule.getType().getClassifier())) {
                String ruleName = this.getRuleNameForErrorMessage(parentRule);
                throw new TransformationException(TransformationErrorCode.InvalidSupertype, "Cannot inherit from " + ruleName + "rule and return another type.", rule.getType());
            }
            if (parentRule.eClass() != rule.eClass()) {
                if (parentRule instanceof EnumRule || parentRule instanceof ParserRule) {
                    if (rule instanceof TerminalRule && ((TerminalRule)rule).isFragment()) {
                        throw new TransformationException(TransformationErrorCode.NoSuchRuleAvailable, "A terminal fragment cannot override enum rule " + rule.getName() + ".", rule);
                    }
                } else if (parentRule instanceof TerminalRule) {
                    String ruleName = this.getRuleNameForErrorMessage(rule);
                    throw new TransformationException(TransformationErrorCode.NoSuchRuleAvailable, "A " + ruleName + " rule cannot override a terminal rule.", rule);
                }
            }
            if (rule instanceof TerminalRule && parentRule instanceof TerminalRule && (terminal2 = (TerminalRule)rule).isFragment() && !((TerminalRule)parentRule).isFragment()) {
                String message = "Terminal fragment cannot inherit from terminal rule '" + parentRule.getName() + "'";
                throw new TransformationException(TransformationErrorCode.NoSuchRuleAvailable, message, rule);
            }
            return;
        }
    }

    protected String getRuleNameForErrorMessage(AbstractRule rule) {
        String ruleName = "datatype ";
        if (rule instanceof TerminalRule) {
            ruleName = "terminal ";
        } else if (rule instanceof EnumRule) {
            ruleName = "enum ";
        }
        return ruleName;
    }

    private boolean deriveTypesImpl() {
        boolean result = true;
        for (AbstractRule rule : this.grammar.getRules()) {
            try {
                this.findOrCreateEClassifierInfo(rule);
            }
            catch (TransformationException e) {
                this.reportError(e);
                result = false;
            }
        }
        return result;
    }

    private boolean checkDatatypeRules() {
        boolean result = true;
        for (AbstractRule rule : this.grammar.getRules()) {
            try {
                if (!(rule instanceof ParserRule) || !GrammarUtil.isDatatypeRule((ParserRule)rule) || DatatypeRuleUtil.isValidDatatypeRule((ParserRule)rule)) continue;
                throw new TransformationException(TransformationErrorCode.InvalidDatatypeRule, "Datatype rules may only use other datatype rules, lexer rules and keywords.", rule);
            }
            catch (TransformationException e) {
                this.reportError(e);
                result = false;
            }
        }
        return result;
    }

    private boolean deriveFeatures() {
        boolean result = true;
        for (AbstractRule rule : this.grammar.getRules()) {
            try {
                if (rule instanceof ParserRule && !GrammarUtil.isDatatypeRule((ParserRule)rule) && !this.isWildcardFragment(rule)) {
                    this.deriveFeatures((ParserRule)rule);
                    continue;
                }
                if (!(rule instanceof EnumRule)) continue;
                this.deriveEnums((EnumRule)rule);
            }
            catch (TransformationException e) {
                result = false;
                this.reportError(e);
            }
        }
        return result;
    }

    private void deriveEnums(EnumRule rule) {
        EEnum returnType = (EEnum)rule.getType().getClassifier();
        if (returnType != null) {
            List<EnumLiteralDeclaration> decls = EcoreUtil2.getAllContentsOfType(rule, EnumLiteralDeclaration.class);
            for (EnumLiteralDeclaration decl : decls) {
                List<INode> nodes;
                if (decl.getEnumLiteral() == null && !(nodes = NodeModelUtils.findNodesForFeature(decl, XtextPackage.Literals.ENUM_LITERAL_DECLARATION__ENUM_LITERAL)).isEmpty()) {
                    if (nodes.size() > 1) {
                        throw new IllegalStateException("Unexpected nodes found: " + nodes);
                    }
                    INode node = nodes.get(0);
                    String text = NodeModelUtils.getTokenText(node).replace("^", "");
                    EEnumLiteral literal = null;
                    if (rule.getType().getMetamodel() instanceof ReferencedMetamodel) {
                        literal = returnType.getEEnumLiteral(text);
                    } else {
                        EEnumLiteral existing = returnType.getEEnumLiteral(text);
                        if (existing == null) {
                            literal = EcoreFactory.eINSTANCE.createEEnumLiteral();
                            int index = returnType.getELiterals().size();
                            returnType.getELiterals().add(literal);
                            literal.setName(text);
                            literal.setValue(index);
                            if (decl.getLiteral() != null) {
                                literal.setLiteral(decl.getLiteral().getValue());
                            } else {
                                literal.setLiteral(text);
                            }
                        } else {
                            literal = existing;
                        }
                        SourceAdapter.adapt(literal, decl);
                    }
                    if (literal == null) {
                        this.reportError(new TransformationException(TransformationErrorCode.InvalidFeature, "Enum literal '" + text + "' does not exist.", decl));
                    } else {
                        decl.setEnumLiteral(literal);
                    }
                }
                if (decl.getLiteral() != null || decl.getEnumLiteral() == null) continue;
                Keyword kw = XtextFactory.eINSTANCE.createKeyword();
                kw.setValue(decl.getEnumLiteral().getLiteral());
                decl.setLiteral(kw);
            }
        }
    }

    private Xtext2EcoreInterpretationContext deriveFeatures(final Xtext2EcoreInterpretationContext context, AbstractElement element) {
        XtextSwitch<Xtext2EcoreInterpretationContext> visitor = new XtextSwitch<Xtext2EcoreInterpretationContext>(){

            @Override
            public Xtext2EcoreInterpretationContext caseCompoundElement(CompoundElement object) {
                ArrayList<Xtext2EcoreInterpretationContext> contexts = new ArrayList<Xtext2EcoreInterpretationContext>();
                for (AbstractElement group : object.getElements()) {
                    contexts.add(Xtext2EcoreTransformer.this.deriveFeatures(context, group));
                }
                Xtext2EcoreInterpretationContext result = context;
                if (!contexts.isEmpty()) {
                    if (GrammarUtil.isOptionalCardinality(object)) {
                        contexts.add(0, result);
                    } else {
                        result = (Xtext2EcoreInterpretationContext)contexts.get(0);
                    }
                    result = result.mergeSpawnedContexts(contexts);
                }
                return result;
            }

            @Override
            public Xtext2EcoreInterpretationContext caseAssignment(Assignment object) {
                try {
                    context.addFeature(object);
                }
                catch (TransformationException ex) {
                    Xtext2EcoreTransformer.this.reportError(ex);
                }
                return context;
            }

            @Override
            public Xtext2EcoreInterpretationContext caseGroup(Group object) {
                return this.visitElements(object, object.getElements());
            }

            private Xtext2EcoreInterpretationContext visitElements(AbstractElement caller, List<AbstractElement> elementsToProcess) {
                Xtext2EcoreInterpretationContext result = Xtext2EcoreTransformer.this.deriveFeatures(context.spawnContextForGroup(), elementsToProcess);
                if (GrammarUtil.isMultipleCardinality(caller)) {
                    result = Xtext2EcoreTransformer.this.deriveFeatures(result.spawnContextForGroup(), elementsToProcess);
                }
                if (GrammarUtil.isOptionalCardinality(caller)) {
                    result = result.mergeSpawnedContexts(Arrays.asList(context, result));
                }
                return result;
            }

            @Override
            public Xtext2EcoreInterpretationContext caseAlternatives(Alternatives object) {
                ArrayList<Xtext2EcoreInterpretationContext> contexts = Lists.newArrayList();
                if (GrammarUtil.isOptionalCardinality(object)) {
                    contexts.add(context);
                }
                for (AbstractElement alternative : object.getElements()) {
                    contexts.add(Xtext2EcoreTransformer.this.deriveFeatures(context.spawnContextForGroup(), alternative));
                }
                Xtext2EcoreInterpretationContext result = context.mergeSpawnedContexts(contexts);
                if (GrammarUtil.isMultipleCardinality(object)) {
                    for (AbstractElement alternative : object.getElements()) {
                        Xtext2EcoreTransformer.this.deriveFeatures(result.spawnContextForGroup(), alternative);
                    }
                }
                return result;
            }

            @Override
            public Xtext2EcoreInterpretationContext caseRuleCall(RuleCall object) {
                AbstractRule calledRule = object.getRule();
                if (Xtext2EcoreTransformer.this.isWildcardFragment(calledRule)) {
                    AbstractElement ruleBody = calledRule.getAlternatives();
                    if (ruleBody != null) {
                        return this.visitElements(object, Collections.singletonList(ruleBody));
                    }
                    return context;
                }
                if (Xtext2EcoreTransformer.this.isParserRuleFragment(calledRule)) {
                    return context;
                }
                if (!GrammarUtil.isOptionalCardinality(object) && calledRule != null && calledRule instanceof ParserRule && !GrammarUtil.isDatatypeRule((ParserRule)calledRule)) {
                    try {
                        EClassifierInfo eClassifierInfo = Xtext2EcoreTransformer.this.findOrCreateEClassifierInfo(calledRule);
                        return context.spawnContextWithCalledRule(eClassifierInfo, object);
                    }
                    catch (TransformationException e) {
                        Xtext2EcoreTransformer.this.reportError(e);
                    }
                }
                return context;
            }

            @Override
            public Xtext2EcoreInterpretationContext caseAction(Action object) {
                try {
                    TypeRef actionTypeRef = object.getType();
                    EClassifierInfo actionType = Xtext2EcoreTransformer.this.findOrCreateEClassifierInfo(actionTypeRef, null, true);
                    Xtext2EcoreInterpretationContext ctx = context.spawnContextWithReferencedType(actionType, object);
                    if (object.getFeature() != null) {
                        ctx.addFeature(object.getFeature(), context, GrammarUtil.isMultipleAssignment(object), true, object);
                    }
                    return ctx;
                }
                catch (TransformationException e) {
                    Xtext2EcoreTransformer.this.reportError(e);
                    return context;
                }
            }

            @Override
            public Xtext2EcoreInterpretationContext defaultCase(EObject object) {
                return context;
            }
        };
        return (Xtext2EcoreInterpretationContext)visitor.doSwitch(element);
    }

    private Xtext2EcoreInterpretationContext deriveFeatures(Xtext2EcoreInterpretationContext context, List<AbstractElement> elements) {
        Xtext2EcoreInterpretationContext result = context;
        for (AbstractElement element : elements) {
            result = this.deriveFeatures(result, element);
        }
        return result;
    }

    private void deriveFeatures(ParserRule rule) throws TransformationException {
        EClassifierInfo classInfo = this.findEClassifierInfo(rule);
        if (classInfo == null) {
            throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "No type available for rule " + rule.getName(), rule);
        }
        Xtext2EcoreInterpretationContext context = new Xtext2EcoreInterpretationContext(this.eClassifierInfos, classInfo);
        if (rule.getAlternatives() != null) {
            this.deriveFeatures(context, rule.getAlternatives());
        }
    }

    private TypeRef getOrComputeReturnType(AbstractRule rule) {
        TypeRef result = rule.getType();
        if (result == null) {
            EClassifier classifier = this.getClassifierFor(rule);
            if (classifier == null) {
                if (rule.getName() == null) {
                    return null;
                }
                result = this.getTypeRef(rule.getName());
            } else {
                result = this.getTypeRef(classifier);
            }
            if (result.getMetamodel() == null) {
                AbstractMetamodelDeclaration bestMatch = null;
                for (AbstractMetamodelDeclaration decl : this.grammar.getMetamodelDeclarations()) {
                    if (!(decl instanceof GeneratedMetamodel) || !Strings.isEmpty(decl.getAlias())) continue;
                    bestMatch = decl;
                    break;
                }
                if (result.getMetamodel() == null) {
                    result.setMetamodel(bestMatch);
                }
            }
            rule.setType(result);
        }
        return result;
    }

    EClassifier getClassifierFor(AbstractRule rule) {
        if (rule.getType() != null && rule.getType().getClassifier() != null) {
            return rule.getType().getClassifier();
        }
        if (rule instanceof TerminalRule || rule instanceof ParserRule && DatatypeRuleUtil.isDatatypeRule((ParserRule)rule)) {
            return GrammarUtil.findEString(this.grammar);
        }
        return null;
    }

    TypeRef getTypeRef(EClassifier classifier) {
        TypeRef result = XtextFactory.eINSTANCE.createTypeRef();
        result.setClassifier(classifier);
        EPackage pack = classifier.getEPackage();
        for (AbstractMetamodelDeclaration decl : GrammarUtil.allMetamodelDeclarations(this.grammar)) {
            if (!pack.equals(decl.getEPackage())) continue;
            result.setMetamodel(decl);
            return result;
        }
        return result;
    }

    TypeRef getTypeRef(String qualifiedName) {
        TypeRef result = XtextFactory.eINSTANCE.createTypeRef();
        String[] split = qualifiedName.split("::");
        String name = qualifiedName;
        if (split.length > 1) {
            result.setMetamodel(this.findMetamodel(this.grammar, split[0], split[1]));
            name = split[1];
        } else {
            result.setMetamodel(this.findDefaultMetamodel(this.grammar, qualifiedName));
        }
        if (result.getMetamodel() instanceof ReferencedMetamodel && result.getMetamodel().getEPackage() != null) {
            result.setClassifier(result.getMetamodel().getEPackage().getEClassifier(name));
        }
        return result;
    }

    public AbstractMetamodelDeclaration findDefaultMetamodel(Grammar grammar, String containedClassifier) {
        return this.findMetamodel(grammar, "", containedClassifier);
    }

    public AbstractMetamodelDeclaration findMetamodel(Grammar grammar, String alias, String containedClassifier) {
        EList<AbstractMetamodelDeclaration> declarations = grammar.getMetamodelDeclarations();
        AbstractMetamodelDeclaration result = null;
        for (AbstractMetamodelDeclaration decl : declarations) {
            EPackage pack;
            if (!this.isSameAlias(decl.getAlias(), alias) || (pack = decl.getEPackage()) == null || pack.getEClassifier(containedClassifier) == null) continue;
            if (result != null) {
                return null;
            }
            result = decl;
        }
        return result;
    }

    public boolean isSameAlias(String alias, String alias2) {
        return Strings.isEmpty(alias) ? Strings.isEmpty(alias2) : alias.equals(alias2);
    }

    private void normalizeAndValidateGeneratedPackages() {
        TypeHierarchyHelper helper = new TypeHierarchyHelper(this.grammar, this.eClassifierInfos, this.errorAcceptor);
        helper.liftUpFeaturesRecursively();
        helper.removeDuplicateDerivedFeatures();
    }

    private void deriveTypesAndHierarchy(final ParserRule rule, final EClassifierInfo ruleReturnType, AbstractElement element) throws TransformationException {
        TransformationException ex = (TransformationException)new XtextSwitch<TransformationException>(){
            Set<AbstractRule> visiting = Sets.newHashSet();

            @Override
            public TransformationException caseAction(Action action) {
                TypeRef actionTypeRef = action.getType();
                try {
                    Xtext2EcoreTransformer.this.addSuperType(rule, actionTypeRef, ruleReturnType);
                    return null;
                }
                catch (TransformationException ex) {
                    return ex;
                }
            }

            @Override
            public TransformationException caseCompoundElement(CompoundElement object) {
                for (AbstractElement ele : object.getElements()) {
                    TransformationException ex = (TransformationException)this.doSwitch(ele);
                    if (ex == null) continue;
                    return ex;
                }
                return null;
            }

            @Override
            public TransformationException caseRuleCall(RuleCall ruleCall) {
                block11: {
                    AbstractRule calledRule = ruleCall.getRule();
                    if (calledRule == null) {
                        ICompositeNode node = NodeModelUtils.getNode(ruleCall);
                        if (node != null) {
                            return new TransformationException(TransformationErrorCode.NoSuchRuleAvailable, "Cannot find rule " + node.getText().trim(), ruleCall);
                        }
                        return new TransformationException(TransformationErrorCode.NoSuchRuleAvailable, "Cannot find called rule.", ruleCall);
                    }
                    if (calledRule instanceof TerminalRule || calledRule instanceof ParserRule && GrammarUtil.isDatatypeRule((ParserRule)calledRule) || Xtext2EcoreTransformer.this.isWildcardFragment(calledRule)) {
                        return null;
                    }
                    if (calledRule instanceof EnumRule) {
                        return new TransformationException(TransformationErrorCode.NoSuchRuleAvailable, "Cannot call enum rule without assignment.", ruleCall);
                    }
                    try {
                        if (Xtext2EcoreTransformer.this.isParserRuleFragment(calledRule)) {
                            TypeRef subTypeRef = Xtext2EcoreTransformer.this.getOrComputeReturnType(rule);
                            Xtext2EcoreTransformer.this.addSuperType(rule, subTypeRef, Xtext2EcoreTransformer.this.findOrCreateEClassifierInfo(calledRule));
                            if (!this.visiting.add(calledRule)) break block11;
                            try {
                                AbstractElement fragment = calledRule.getAlternatives();
                                if (fragment != null) {
                                    this.doSwitch(fragment);
                                }
                                break block11;
                            }
                            finally {
                                this.visiting.remove(calledRule);
                            }
                        }
                        TypeRef calledRuleReturnTypeRef = Xtext2EcoreTransformer.this.getOrComputeReturnType(calledRule);
                        Xtext2EcoreTransformer.this.addSuperType(rule, calledRuleReturnTypeRef, ruleReturnType);
                    }
                    catch (TransformationException ex) {
                        return ex;
                    }
                }
                return null;
            }

            @Override
            public TransformationException defaultCase(EObject object) {
                return null;
            }
        }.doSwitch(element);
        if (ex != null) {
            throw ex;
        }
        for (Grammar usedGrammar : this.grammar.getUsedGrammars()) {
            if (!this.deriveTypeHierarchyFromOverridden(rule, usedGrammar)) continue;
            return;
        }
    }

    private boolean deriveTypeHierarchyFromOverridden(ParserRule rule, Grammar grammar) throws TransformationException {
        AbstractRule parentRule = GrammarUtil.findRuleForName(grammar, rule.getName());
        if (parentRule != null) {
            if (parentRule != rule && parentRule instanceof ParserRule) {
                ParserRule casted = (ParserRule)parentRule;
                if (casted.isFragment() != rule.isFragment()) {
                    if (rule.isFragment()) {
                        throw new TransformationException(TransformationErrorCode.InvalidFragmentOverride, "A fragment rule cannot override a production rule.", rule);
                    }
                    throw new TransformationException(TransformationErrorCode.InvalidFragmentOverride, "Only fragment rule can override other fragment rules.", rule);
                }
                if (casted.isWildcard() != rule.isWildcard()) {
                    if (rule.isWildcard()) {
                        throw new TransformationException(TransformationErrorCode.InvalidFragmentOverride, "A wildcard fragment rule cannot override a typed fragment rule.", rule);
                    }
                    throw new TransformationException(TransformationErrorCode.InvalidFragmentOverride, "Only wildcard fragment rules can override other wildcard fragments.", rule);
                }
                if (rule.isFragment() && !rule.isWildcard() && parentRule.getType() != null && rule.getType().getClassifier() != parentRule.getType().getClassifier()) {
                    throw new TransformationException(TransformationErrorCode.InvalidFragmentOverride, "Overriding fragment rules cannot redeclare their type.", rule.getType());
                }
                this.checkParameterLists(rule, casted);
            }
            if (parentRule.getType() != null && parentRule != rule) {
                if (parentRule.getType().getClassifier() instanceof EDataType) {
                    throw new TransformationException(TransformationErrorCode.InvalidSupertype, "Cannot inherit from datatype rule and return another type.", rule.getType());
                }
                EClassifierInfo parentTypeInfo = this.eClassifierInfos.getInfoOrNull(parentRule.getType());
                if (parentTypeInfo == null) {
                    throw new TransformationException(TransformationErrorCode.InvalidSupertype, "Cannot determine return type of overridden rule.", rule.getType());
                }
                this.addSuperType(rule, rule.getType(), parentTypeInfo);
                return true;
            }
        }
        return false;
    }

    private void checkParameterLists(ParserRule rule, ParserRule overridden) throws TransformationException {
        int i;
        int inherited = overridden.getParameters().size();
        if (inherited == rule.getParameters().size()) {
            boolean ok = true;
            i = 0;
            while (ok && i < inherited) {
                if (!Strings.equal(((Parameter)rule.getParameters().get(i)).getName(), ((Parameter)overridden.getParameters().get(i)).getName())) {
                    ok = false;
                }
                ++i;
            }
            if (ok) {
                return;
            }
        }
        if (inherited == 0) {
            throw new TransformationException(TransformationErrorCode.InvalidRuleOverride, "Overridden rule " + rule.getName() + " does not declare any parameters", rule);
        }
        StringBuilder message = new StringBuilder("Parameter list is incompatible with inherited ");
        message.append(rule.getName()).append("<");
        i = 0;
        while (i < overridden.getParameters().size()) {
            if (i != 0) {
                message.append(", ");
            }
            message.append(((Parameter)overridden.getParameters().get(i)).getName());
            ++i;
        }
        message.append(">");
        throw new TransformationException(TransformationErrorCode.InvalidRuleOverride, message.toString(), rule);
    }

    private void addSuperType(ParserRule rule, TypeRef subTypeRef, EClassifierInfo superTypeInfo) throws TransformationException {
        EClassifierInfo subTypeInfo;
        EClassifier subType = subTypeRef.getClassifier();
        EClassifierInfo eClassifierInfo = subTypeInfo = subType == null ? this.findOrCreateEClassifierInfo(subTypeRef, null, true) : this.eClassifierInfos.getInfoOrNull(subType);
        if (subTypeInfo == null) {
            throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Type '" + superTypeInfo.getEClassifier().getName() + "' is not available.", rule.getType());
        }
        if (superTypeInfo.isAssignableFrom(subTypeInfo)) {
            return;
        }
        if (subTypeInfo.getEClassifier() instanceof EDataType) {
            throw new TransformationException(TransformationErrorCode.InvalidSupertype, "Cannot add supertype '" + superTypeInfo.getEClassifier().getName() + "' to simple datatype '" + subTypeInfo.getEClassifier().getName() + "'.", rule.getType());
        }
        if (!subTypeInfo.isGenerated()) {
            throw new TransformationException(TransformationErrorCode.CannotCreateTypeInSealedMetamodel, "Cannot add supertype '" + superTypeInfo.getEClassifier().getName() + "' to sealed type '" + subTypeInfo.getEClassifier().getName() + "'.", rule.getType());
        }
        subTypeInfo.addSupertype(superTypeInfo);
    }

    private void collectEPackages() {
        EList<AbstractMetamodelDeclaration> metamodelDeclarations = this.grammar.getMetamodelDeclarations();
        LinkedHashMap<String, GeneratedMetamodel> generateUs = Maps.newLinkedHashMap();
        for (AbstractMetamodelDeclaration metamodelDeclaration : metamodelDeclarations) {
            try {
                if (metamodelDeclaration instanceof ReferencedMetamodel) {
                    ReferencedMetamodel referencedMetamodel = (ReferencedMetamodel)metamodelDeclaration;
                    EPackage referencedEPackage = referencedMetamodel.getEPackage();
                    if (referencedEPackage == null) continue;
                    this.collectClassInfosOf(referencedEPackage, referencedMetamodel);
                    continue;
                }
                if (metamodelDeclaration instanceof GeneratedMetamodel) {
                    String alias = Strings.emptyIfNull(metamodelDeclaration.getAlias());
                    if (generateUs.containsKey(alias)) {
                        GeneratedMetamodel prev = (GeneratedMetamodel)generateUs.get(alias);
                        if (prev != null) {
                            if (prev.getEPackage() != null) {
                                prev.getEPackage().eResource().getResourceSet().getResources().remove(prev.getEPackage().eResource());
                            }
                            prev.setEPackage(null);
                        }
                        generateUs.put(alias, null);
                        EPackage pack = metamodelDeclaration.getEPackage();
                        if (pack != null) {
                            pack.eResource().getResourceSet().getResources().remove(pack.eResource());
                        }
                        metamodelDeclaration.setEPackage(null);
                        throw new TransformationException(TransformationErrorCode.AliasForMetamodelAlreadyExists, "Alias '" + alias + "' registered more than once.", metamodelDeclaration);
                    }
                    generateUs.put(alias, (GeneratedMetamodel)metamodelDeclaration);
                    continue;
                }
                throw new IllegalStateException("unknown metamodelDeclaraton " + metamodelDeclaration);
            }
            catch (TransformationException e) {
                this.reportError(e);
            }
        }
        for (GeneratedMetamodel metamodel : generateUs.values()) {
            try {
                if (metamodel == null) continue;
                this.addGeneratedEPackage(metamodel);
            }
            catch (TransformationException e) {
                this.reportError(e);
            }
        }
    }

    private void collectEClassInfosOfUsedGrammars() {
        LinkedHashSet<Grammar> visitedGrammars = Sets.newLinkedHashSet();
        visitedGrammars.add(this.grammar);
        for (Grammar usedGrammar : this.grammar.getUsedGrammars()) {
            EClassifierInfos parent = this.createClassifierInfosFor(usedGrammar, visitedGrammars);
            if (parent == null) continue;
            this.getEClassifierInfos().addParent(parent);
        }
    }

    private EClassifierInfos createClassifierInfosFor(Grammar grammar, Set<Grammar> visitedGrammars) {
        if (!visitedGrammars.add(grammar)) {
            return null;
        }
        EClassifierInfos result = new EClassifierInfos(grammar);
        for (AbstractMetamodelDeclaration declaration : grammar.getMetamodelDeclarations()) {
            EPackage referencedEPackage = declaration.getEPackage();
            if (referencedEPackage == null) continue;
            this.collectClassInfosOf(result, referencedEPackage, declaration, false);
        }
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            EClassifierInfos parent = this.createClassifierInfosFor(usedGrammar, visitedGrammars);
            if (parent == null) continue;
            result.addParent(parent);
        }
        return result;
    }

    private void collectClassInfosOf(EPackage referencedEPackage, AbstractMetamodelDeclaration metaModel) {
        this.collectClassInfosOf(this.eClassifierInfos, referencedEPackage, metaModel, metaModel instanceof GeneratedMetamodel);
    }

    private void collectClassInfosOf(EClassifierInfos target, EPackage referencedEPackage, AbstractMetamodelDeclaration metaModel, boolean generated) {
        for (EClassifier eClassifier : referencedEPackage.getEClassifiers()) {
            EClassifierInfo info;
            if (eClassifier instanceof EClass) {
                EClass eClass = (EClass)eClassifier;
                info = EClassifierInfo.createEClassInfo(eClass, generated, this.getGeneratedEPackageURIs(), GrammarUtil.getGrammar(metaModel));
                target.addInfo(metaModel, eClassifier.getName(), info);
                continue;
            }
            if (!(eClassifier instanceof EDataType)) continue;
            EDataType eDataType = (EDataType)eClassifier;
            info = EClassifierInfo.createEDataTypeInfo(eDataType, generated);
            target.addInfo(metaModel, eClassifier.getName(), info);
        }
    }

    private Set<String> getGeneratedEPackageURIs() {
        List<GeneratedMetamodel> list = EcoreUtil2.typeSelect(this.grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
        return Sets.newLinkedHashSet(Iterables.transform(list, new Function<GeneratedMetamodel, String>(){

            @Override
            public String apply(GeneratedMetamodel from) {
                return from.getEPackage() != null ? from.getEPackage().getNsURI() : null;
            }
        }));
    }

    private void reportError(TransformationErrorCode errorCode, String message, EObject erroneousElement) {
        this.errorAcceptor.acceptError(errorCode, message, erroneousElement);
    }

    private void reportError(TransformationException exception) {
        log.trace((Object)exception.getErrorCode(), exception);
        this.reportError(exception.getErrorCode(), exception.getMessage(), exception.getErroneousElement());
    }

    private EClassifierInfo findOrCreateEClassifierInfo(AbstractRule rule) throws TransformationException {
        if (this.isWildcardFragment(rule)) {
            return null;
        }
        TypeRef typeRef = this.getOrComputeReturnType(rule);
        if (typeRef == null) {
            throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Cannot create type for unnamed rule.", rule);
        }
        if (typeRef.getMetamodel() != null && typeRef.getMetamodel().getEPackage() == null) {
            throw new TransformationException(TransformationErrorCode.UnknownMetaModelAlias, "Cannot create type without declared package.", typeRef);
        }
        return this.findOrCreateEClassifierInfo(typeRef, rule.getName(), this.grammar.getRules().contains(rule));
    }

    private boolean isWildcardFragment(AbstractRule rule) {
        if (rule instanceof ParserRule) {
            ParserRule casted = (ParserRule)rule;
            return casted.isFragment() && casted.isWildcard();
        }
        return false;
    }

    private boolean isParserRuleFragment(AbstractRule rule) {
        if (rule instanceof ParserRule) {
            ParserRule casted = (ParserRule)rule;
            return casted.isFragment() && !casted.isWildcard();
        }
        return false;
    }

    private EClassifierInfo findEClassifierInfo(AbstractRule rule) {
        TypeRef typeRef = this.getOrComputeReturnType(rule);
        if (typeRef == null) {
            throw new NullPointerException();
        }
        if (rule.getType() != typeRef) {
            throw new IllegalStateException();
        }
        return this.eClassifierInfos.getInfo(typeRef);
    }

    private EClassifierInfo findOrCreateEClassifierInfo(TypeRef typeRef, String name, boolean createIfMissing) throws TransformationException {
        if (typeRef.getClassifier() != null && typeRef.getMetamodel() == null) {
            throw new TransformationException(TransformationErrorCode.UnknownMetaModelAlias, "Cannot find EPackage for type '" + typeRef.getClassifier().getName() + "'", typeRef);
        }
        EClassifierInfo info = this.eClassifierInfos.getInfo(typeRef);
        if (info == null) {
            EDataType dataType = GrammarUtil.findEString(GrammarUtil.getGrammar(typeRef));
            if (dataType != null && typeRef.getClassifier() == dataType && (info = this.eClassifierInfos.getInfoOrNull(typeRef)) != null) {
                return info;
            }
            if (createIfMissing) {
                info = this.createEClassifierInfo(typeRef, name);
            }
        }
        return info;
    }

    private EClassifierInfo createEClassifierInfo(TypeRef typeRef, String name) throws TransformationException {
        if (this.eClassifierInfos.getInfo(typeRef) != null) {
            throw new IllegalArgumentException("Cannot create EClass for same type twice " + typeRef.getClassifier().getName());
        }
        String classifierName = GrammarUtil.getTypeRefName(typeRef);
        if (classifierName == null) {
            classifierName = name;
        }
        if (classifierName == null) {
            throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Cannot reference unnamed type.", typeRef);
        }
        AbstractMetamodelDeclaration metaModel = typeRef.getMetamodel();
        if (metaModel == null) {
            throw new TransformationException(TransformationErrorCode.UnknownMetaModelAlias, "Cannot create type for " + classifierName + " because its EPackage is unknown.", typeRef);
        }
        EPackage generatedEPackage = this.getGeneratedEPackage(metaModel);
        if (generatedEPackage == null) {
            throw new TransformationException(TransformationErrorCode.CannotCreateTypeInSealedMetamodel, "Cannot create type '" + classifierName + "' in alias " + typeRef.getMetamodel().getAlias(), typeRef);
        }
        EClassifier classifier = generatedEPackage.getEClassifier(classifierName);
        if (classifier == null) {
            if (GrammarUtil.containingParserRule(typeRef) != null) {
                classifier = EcoreFactory.eINSTANCE.createEClass();
            } else if (GrammarUtil.containingEnumRule(typeRef) != null) {
                classifier = EcoreFactory.eINSTANCE.createEEnum();
            } else {
                for (AbstractMetamodelDeclaration mmd : this.grammar.getMetamodelDeclarations()) {
                    if (!(mmd instanceof ReferencedMetamodel) || mmd.getEPackage() == null || !mmd.getEPackage().getNsURI().equals("http://www.eclipse.org/emf/2002/Ecore")) continue;
                    throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Cannot create datatype " + classifierName, typeRef);
                }
                throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Cannot create datatype " + classifierName + ". If this is supposed to return EString, make sure you have imported '" + "http://www.eclipse.org/emf/2002/Ecore" + "'", typeRef);
            }
            classifier.setName(classifierName);
            generatedEPackage.getEClassifiers().add(classifier);
            typeRef.setClassifier(classifier);
            EClassifierInfo result = classifier instanceof EClass ? EClassifierInfo.createEClassInfo((EClass)classifier, true, this.getGeneratedEPackageURIs(), GrammarUtil.getGrammar(typeRef)) : EClassifierInfo.createEDataTypeInfo((EDataType)classifier, true);
            if (!this.eClassifierInfos.addInfo(typeRef, result)) {
                throw new IllegalStateException("cannot add type for typeRef twice: '" + classifierName + "'");
            }
            SourceAdapter.adapt(classifier, typeRef);
            return result;
        }
        typeRef.setClassifier(classifier);
        SourceAdapter.adapt(classifier, typeRef);
        return this.eClassifierInfos.getInfo(classifier);
    }

    private void addGeneratedEPackage(GeneratedMetamodel generatedMetamodel) throws TransformationException {
        String alias = Strings.emptyIfNull(generatedMetamodel.getAlias());
        if (this.generatedEPackages.containsKey(alias)) {
            throw new TransformationException(TransformationErrorCode.AliasForMetamodelAlreadyExists, "alias '" + alias + "' already exists", generatedMetamodel);
        }
        if (generatedMetamodel.getEPackage() == null) {
            throw new TransformationException(TransformationErrorCode.UnknownMetaModelAlias, "Cannot create EPackage without NsURI.", generatedMetamodel);
        }
        EPackage generatedEPackage = generatedMetamodel.getEPackage();
        this.generatedEPackages.put(alias, generatedEPackage);
        this.collectClassInfosOf(generatedEPackage, generatedMetamodel);
    }

    private EPackage getGeneratedEPackage(AbstractMetamodelDeclaration metaModel) {
        if (metaModel instanceof GeneratedMetamodel) {
            return metaModel.getEPackage();
        }
        return null;
    }

    private void postProcessGeneratedPackages() {
        if (this.postProcessor != null) {
            Iterable<GeneratedMetamodel> generatedMetamodels = Iterables.filter(this.grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
            for (GeneratedMetamodel metamodel : generatedMetamodels) {
                this.postProcessor.process(metamodel);
            }
        }
    }

    public EClassifierInfos getEClassifierInfos() {
        return this.eClassifierInfos;
    }

    public static class NullErrorAcceptor
    implements ErrorAcceptor {
        @Override
        public void acceptError(TransformationErrorCode errorCode, String arg0, EObject arg1) {
        }
    }
}

