/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ecoreInference;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.XtextSwitch;
import org.eclipse.xtext.xtext.ecoreInference.EClassifierInfo;
import org.eclipse.xtext.xtext.ecoreInference.EClassifierInfoAccess;
import org.eclipse.xtext.xtext.ecoreInference.EClassifierInfos;
import org.eclipse.xtext.xtext.ecoreInference.ElementTypeCalculator;
import org.eclipse.xtext.xtext.ecoreInference.TransformationErrorCode;
import org.eclipse.xtext.xtext.ecoreInference.TransformationException;

public class Xtext2EcoreInterpretationContext
implements EClassifierInfoAccess {
    private final EClassifierInfos eClassifierInfos;
    private final Function<AbstractElement, Set<EClassifier>> classifierCalculator;
    private final Collection<EClassifierInfo> currentTypes = Sets.newLinkedHashSet();
    private boolean isRuleCallAllowed = true;

    private Xtext2EcoreInterpretationContext(EClassifierInfos classifierInfos) {
        if (classifierInfos == null) {
            throw new NullPointerException("classifierInfos may not be null");
        }
        this.eClassifierInfos = classifierInfos;
        this.classifierCalculator = new ElementTypeCalculator(this.eClassifierInfos);
    }

    public Xtext2EcoreInterpretationContext(EClassifierInfos eClassifierInfos, EClassifierInfo currentType) {
        this(eClassifierInfos);
        this.currentTypes.add(currentType);
    }

    private Xtext2EcoreInterpretationContext(Collection<EClassifierInfo> currentTypes, EClassifierInfos classifierInfos, boolean isRuleCallAllowed) {
        this(classifierInfos);
        this.currentTypes.addAll(currentTypes);
        this.isRuleCallAllowed = isRuleCallAllowed;
    }

    public Xtext2EcoreInterpretationContext(EClassifierInfo newType, EClassifierInfos classifierInfos, boolean isRuleCallAllowed) {
        this(classifierInfos);
        this.currentTypes.add(newType);
        this.isRuleCallAllowed = isRuleCallAllowed;
    }

    public void addFeature(Assignment assignment) throws TransformationException {
        EClassifierInfoAccess featureTypeInfo;
        String featureName = assignment.getFeature();
        boolean isMultivalue = GrammarUtil.isMultipleAssignment(assignment);
        boolean isContainment = true;
        if (GrammarUtil.isBooleanAssignment(assignment)) {
            this.checkNoFragmentRuleCall(assignment.getTerminal());
            EDataType eBoolean = GrammarUtil.findEBoolean(GrammarUtil.getGrammar(assignment));
            EClassifierInfo classifierInfo = this.getEClassifierInfoOrThrowException(eBoolean, assignment);
            featureTypeInfo = () -> classifierInfo;
            isMultivalue = false;
        } else {
            AbstractElement terminal2 = assignment.getTerminal();
            if (terminal2 == null) {
                throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Cannot derive type from incomplete assignment.", assignment);
            }
            this.checkNoFragmentRuleCall(terminal2);
            final ArrayList<EClassifierInfo> classifierInfos = new ArrayList<EClassifierInfo>();
            for (EClassifier type : this.getTerminalTypes(terminal2)) {
                classifierInfos.add(this.getEClassifierInfoOrThrowException(type, assignment));
            }
            isContainment = this.isContainmentAssignment(assignment);
            featureTypeInfo = new EClassifierInfoAccess(){

                @Override
                public Collection<EClassifierInfo> getCurrentTypes() {
                    return classifierInfos;
                }

                @Override
                public EClassifierInfo getCurrentCompatibleType() {
                    try {
                        return Xtext2EcoreInterpretationContext.this.eClassifierInfos.getCompatibleTypeOf(classifierInfos);
                    }
                    catch (IllegalArgumentException e) {
                        return null;
                    }
                }
            };
        }
        this.addFeature(featureName, featureTypeInfo, isMultivalue, isContainment, assignment);
    }

    private void checkNoFragmentRuleCall(AbstractElement terminal2) throws TransformationException {
        if (GrammarUtil.isEObjectFragmentRuleCall(terminal2)) {
            throw new TransformationException(TransformationErrorCode.InvalidFragmentCall, "Cannot call a fragment from an assignment", terminal2);
        }
        if (terminal2 instanceof Alternatives) {
            for (AbstractElement child : ((Alternatives)terminal2).getElements()) {
                this.checkNoFragmentRuleCall(child);
            }
        }
    }

    public boolean isContainmentAssignment(Assignment assignment) {
        return (Boolean)new XtextSwitch<Boolean>(){

            @Override
            public Boolean caseAlternatives(Alternatives object) {
                for (AbstractElement group : object.getElements()) {
                    if (!((Boolean)this.doSwitch(group)).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean caseCrossReference(CrossReference object) {
                return false;
            }

            @Override
            public Boolean caseAbstractElement(AbstractElement object) {
                return true;
            }
        }.doSwitch(assignment.getTerminal());
    }

    public void addFeature(String featureName, EClassifierInfoAccess featureTypeInfo, boolean isMultivalue, boolean isContainment, AbstractElement parserElement) throws TransformationException {
        for (EClassifierInfo type : this.currentTypes) {
            type.addFeature(featureName, featureTypeInfo, isMultivalue, isContainment, parserElement);
        }
    }

    private Set<EClassifier> getTerminalTypes(AbstractElement terminal2) throws TransformationException {
        Set<EClassifier> result = this.classifierCalculator.apply(terminal2);
        if (result == null) {
            ICompositeNode node = NodeModelUtils.getNode(terminal2);
            if (node != null) {
                throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Cannot find type for '" + node.getText().trim() + "'.", terminal2);
            }
            throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Cannot find type for " + terminal2.eClass().getName(), terminal2);
        }
        return result;
    }

    private EClassifierInfo getEClassifierInfoOrThrowException(EClassifier type, AbstractElement parserElement) throws TransformationException {
        EClassifierInfo featureTypeInfo = this.eClassifierInfos.getInfoOrNull(type);
        if (featureTypeInfo == null) {
            String typeName = "null";
            if (type != null) {
                typeName = type.getName();
            }
            throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Cannot resolve type " + typeName, parserElement);
        }
        return featureTypeInfo;
    }

    public Xtext2EcoreInterpretationContext spawnContextForGroup() {
        Xtext2EcoreInterpretationContext result = new Xtext2EcoreInterpretationContext(this.currentTypes, this.eClassifierInfos, this.isRuleCallAllowed);
        return result;
    }

    public Xtext2EcoreInterpretationContext spawnContextWithCalledRule(EClassifierInfo newType, EObject parserElement) throws TransformationException {
        if (!this.isRuleCallAllowed) {
            throw new TransformationException(TransformationErrorCode.MoreThanOneTypeChangeInOneRule, "Cannot change type twice within a rule", parserElement);
        }
        return new Xtext2EcoreInterpretationContext(newType, this.eClassifierInfos, false);
    }

    public Xtext2EcoreInterpretationContext mergeSpawnedContexts(List<Xtext2EcoreInterpretationContext> contexts) {
        Xtext2EcoreInterpretationContext result = new Xtext2EcoreInterpretationContext(this.eClassifierInfos);
        for (Xtext2EcoreInterpretationContext context : contexts) {
            result.currentTypes.addAll(context.currentTypes);
            result.isRuleCallAllowed &= context.isRuleCallAllowed;
        }
        return result;
    }

    @Override
    public Collection<EClassifierInfo> getCurrentTypes() {
        return this.currentTypes;
    }

    @Override
    public EClassifierInfo getCurrentCompatibleType() {
        try {
            return this.eClassifierInfos.getCompatibleTypeOf(this.currentTypes);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Xtext2EcoreInterpretationContext spawnContextWithReferencedType(EClassifierInfo referencedType, EObject parserElement) {
        return new Xtext2EcoreInterpretationContext(referencedType, this.eClassifierInfos, false);
    }
}

