/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.ForwardingEObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class SuperCallScope
implements IScope {
    static final String SUPER = "super";
    private EObject context;

    public SuperCallScope(EObject context) {
        this.context = context;
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        IEObjectDescription result = this.doGetSingleElement(name);
        if (result != null && this.context instanceof RuleCall) {
            return new ExplicitCallDescription(result, (RuleCall)this.context);
        }
        return result;
    }

    private IEObjectDescription doGetSingleElement(QualifiedName qn) {
        Grammar grammar;
        if (qn.getSegmentCount() == 1) {
            AbstractRule containingRule;
            if (SUPER.equals(qn.getFirstSegment()) && (containingRule = GrammarUtil.containingRule(this.context)) != null) {
                Grammar grammar2 = GrammarUtil.getGrammar(containingRule);
                for (Grammar parent : grammar2.getUsedGrammars()) {
                    AbstractRule superRule = GrammarUtil.findRuleForName(parent, containingRule.getName());
                    if (superRule == null) continue;
                    return EObjectDescription.create(qn, (EObject)superRule);
                }
            }
        } else if (qn.getSegmentCount() > 1 && (grammar = GrammarUtil.getGrammar(this.context)) != null) {
            AbstractRule result;
            String firstSegment = qn.getFirstSegment();
            if (qn.getSegmentCount() == 2) {
                AbstractRule rule;
                String ruleName = qn.getLastSegment();
                if (SUPER.equals(firstSegment)) {
                    for (Grammar parent : grammar.getUsedGrammars()) {
                        AbstractRule superRule = GrammarUtil.findRuleForName(parent, ruleName);
                        if (superRule == null) continue;
                        return EObjectDescription.create(qn, (EObject)superRule);
                    }
                }
                if (firstSegment.equals(GrammarUtil.getSimpleName(grammar)) && (rule = GrammarUtil.findRuleForName(grammar, String.valueOf(grammar.getName()) + "." + ruleName)) != null) {
                    return EObjectDescription.create(qn, (EObject)rule);
                }
                for (Grammar usedGrammar : GrammarUtil.allUsedGrammars(grammar)) {
                    AbstractRule rule2;
                    if (!firstSegment.equals(GrammarUtil.getSimpleName(usedGrammar)) || (rule2 = GrammarUtil.findRuleForName(usedGrammar, String.valueOf(usedGrammar.getName()) + "." + ruleName)) == null) continue;
                    return EObjectDescription.create(qn, (EObject)rule2);
                }
            }
            if ((result = GrammarUtil.findRuleForName(grammar, qn.toString())) != null) {
                return EObjectDescription.create(qn, (EObject)result);
            }
        }
        return null;
    }

    @Override
    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        IEObjectDescription result = this.doGetSingleElement(name);
        if (result != null) {
            return Collections.singletonList(result);
        }
        return Collections.emptyList();
    }

    @Override
    public IEObjectDescription getSingleElement(EObject object) {
        return Iterables.getFirst(this.getElements(object), null);
    }

    @Override
    public Iterable<IEObjectDescription> getElements(EObject object) {
        if (object instanceof AbstractRule) {
            Grammar grammar = GrammarUtil.getGrammar(this.context);
            AbstractRule rule = (AbstractRule)object;
            if (GrammarUtil.getGrammar(rule) == grammar) {
                return Lists.newArrayList(EObjectDescription.create(String.valueOf(GrammarUtil.getSimpleName(grammar)) + "." + rule.getName(), (EObject)rule), EObjectDescription.create(String.valueOf(grammar.getName()) + "." + rule.getName(), (EObject)rule));
            }
            ArrayList<IEObjectDescription> result = Lists.newArrayList(EObjectDescription.create("super." + rule.getName(), (EObject)rule), EObjectDescription.create(String.valueOf(GrammarUtil.getSimpleName(grammar)) + "." + rule.getName(), (EObject)rule), EObjectDescription.create(String.valueOf(grammar.getName()) + "." + rule.getName(), (EObject)rule));
            AbstractRule contextRule = GrammarUtil.containingRule(this.context);
            if (contextRule != null && contextRule.getName().equals(rule.getName())) {
                result.add(0, EObjectDescription.create(SUPER, (EObject)rule));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public Iterable<IEObjectDescription> getAllElements() {
        AbstractRule contextRule = GrammarUtil.containingRule(this.context);
        Grammar grammar = contextRule != null ? GrammarUtil.getGrammar(contextRule) : GrammarUtil.getGrammar(this.context);
        LinkedHashMap<QualifiedName, IEObjectDescription> result = Maps.newLinkedHashMap();
        if (grammar != null) {
            String shortName = String.valueOf(GrammarUtil.getSimpleName(grammar)) + ".";
            String longName = String.valueOf(grammar.getName()) + ".";
            for (AbstractRule rule : grammar.getRules()) {
                this.putIfAbsent(EObjectDescription.create(String.valueOf(shortName) + rule.getName(), (EObject)rule), result);
                this.putIfAbsent(EObjectDescription.create(String.valueOf(longName) + rule.getName(), (EObject)rule), result);
            }
            boolean waitingForSuper = contextRule != null;
            for (Grammar usedGrammar : GrammarUtil.allUsedGrammars(grammar)) {
                shortName = String.valueOf(GrammarUtil.getSimpleName(usedGrammar)) + ".";
                longName = String.valueOf(usedGrammar.getName()) + ".";
                for (AbstractRule rule : usedGrammar.getRules()) {
                    if (waitingForSuper) {
                        assert (contextRule != null);
                        if (rule.getName().equals(contextRule.getName())) {
                            this.putIfAbsent(EObjectDescription.create(SUPER, (EObject)rule), result);
                            waitingForSuper = false;
                        }
                    }
                    this.putIfAbsent(EObjectDescription.create("super." + rule.getName(), (EObject)rule), result);
                    this.putIfAbsent(EObjectDescription.create(String.valueOf(shortName) + rule.getName(), (EObject)rule), result);
                    this.putIfAbsent(EObjectDescription.create(String.valueOf(longName) + rule.getName(), (EObject)rule), result);
                }
            }
        }
        return Lists.newArrayList(result.values());
    }

    private void putIfAbsent(IEObjectDescription desc, Map<QualifiedName, IEObjectDescription> result) {
        if (!result.containsKey(desc.getName())) {
            result.put(desc.getName(), desc);
        }
    }

    public static class ExplicitCallDescription
    extends ForwardingEObjectDescription {
        private RuleCall ruleCall;

        public ExplicitCallDescription(IEObjectDescription delegate, RuleCall ruleCall) {
            super(delegate);
            this.ruleCall = ruleCall;
        }

        @Override
        public EObject getEObjectOrProxy() {
            this.ruleCall.setExplicitlyCalled(true);
            return super.getEObjectOrProxy();
        }
    }
}

