/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.xtext.common.types.JvmConstraintOwner;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

@Singleton
public class ReferencedInvalidTypeFinder
extends TypeReferenceVisitorWithResult<LightweightTypeReference> {
    @Inject
    private CommonTypeComputationServices services;

    public LightweightTypeReference findReferencedInvalidType(JvmIdentifiableElement element) {
        return this.internalFindReferencedInvalidType(element);
    }

    protected LightweightTypeReference _internalFindReferencedInvalidType(JvmIdentifiableElement field) {
        return null;
    }

    protected LightweightTypeReference _internalFindReferencedInvalidType(Void field) {
        return null;
    }

    protected LightweightTypeReference _internalFindReferencedInvalidType(JvmField field) {
        LightweightTypeReference type = this.toLightweightTypeReference(field.getType());
        if (type.isPrimitiveVoid()) {
            return type;
        }
        return this.findUnknownType(type);
    }

    protected LightweightTypeReference _internalFindReferencedInvalidType(JvmOperation operation) {
        LightweightTypeReference unknownType = this.findUnknownType(operation.getReturnType());
        if (unknownType != null) {
            return unknownType;
        }
        return this._internalFindReferencedInvalidType((JvmExecutable)operation);
    }

    protected LightweightTypeReference _internalFindReferencedInvalidType(JvmExecutable executable) {
        LightweightTypeReference unknownType;
        Iterable<JvmTypeReference> typeReferences = Iterables.transform(Iterables.concat(Lists.transform(executable.getTypeParameters(), JvmConstraintOwner::getConstraints)), JvmTypeConstraint::getTypeReference);
        for (JvmTypeReference typeReference : typeReferences) {
            unknownType = this.findUnknownType(typeReference);
            if (unknownType == null) continue;
            return unknownType;
        }
        for (LightweightTypeReference parameterType : Lists.transform(executable.getParameters(), it -> this.toLightweightTypeReference(it.getParameterType()))) {
            if (parameterType.isPrimitiveVoid()) {
                return parameterType;
            }
            unknownType = this.findUnknownType(parameterType);
            if (unknownType == null) continue;
            return unknownType;
        }
        for (JvmTypeReference exception : executable.getExceptions()) {
            unknownType = this.findUnknownType(exception);
            if (unknownType == null) continue;
            return unknownType;
        }
        return null;
    }

    protected LightweightTypeReference findUnknownType(JvmTypeReference reference) {
        return this.findUnknownType(this.toLightweightTypeReference(reference));
    }

    protected LightweightTypeReference findUnknownType(LightweightTypeReference type) {
        return type.accept(this);
    }

    @Override
    protected LightweightTypeReference doVisitTypeReference(LightweightTypeReference reference) {
        if (reference.isUnknown()) {
            return reference;
        }
        return null;
    }

    @Override
    protected LightweightTypeReference doVisitArrayTypeReference(ArrayTypeReference reference) {
        return reference.getComponentType().accept(this);
    }

    @Override
    protected LightweightTypeReference doVisitWildcardTypeReference(WildcardTypeReference reference) {
        LightweightTypeReference unknownType = this.visit(reference.getUpperBounds());
        if (unknownType != null) {
            return unknownType;
        }
        LightweightTypeReference lowerBound = reference.getLowerBound();
        if (lowerBound != null) {
            return lowerBound.accept(this);
        }
        return null;
    }

    @Override
    protected LightweightTypeReference doVisitParameterizedTypeReference(ParameterizedTypeReference reference) {
        return this.visit(reference.getTypeArguments());
    }

    @Override
    protected LightweightTypeReference doVisitCompoundTypeReference(CompoundTypeReference reference) {
        return this.visit(reference.getMultiTypeComponents());
    }

    protected LightweightTypeReference visit(List<LightweightTypeReference> references) {
        return Iterables.getFirst(IterableExtensions.filterNull(Lists.transform(references, it -> it.accept(this))), null);
    }

    protected LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef) {
        return new StandardTypeReferenceOwner(this.services, typeRef).toLightweightTypeReference(typeRef);
    }

    protected LightweightTypeReference internalFindReferencedInvalidType(JvmIdentifiableElement operation) {
        if (operation instanceof JvmOperation) {
            return this._internalFindReferencedInvalidType((JvmOperation)operation);
        }
        if (operation instanceof JvmExecutable) {
            return this._internalFindReferencedInvalidType((JvmExecutable)operation);
        }
        if (operation instanceof JvmField) {
            return this._internalFindReferencedInvalidType((JvmField)operation);
        }
        if (operation != null) {
            return this._internalFindReferencedInvalidType(operation);
        }
        return this._internalFindReferencedInvalidType((Void)null);
    }
}

