/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.util;

import com.google.inject.Inject;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.interpreter.ConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.interpreter.SwitchConstantExpressionsInterpreter;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class XSwitchExpressions {
    @Inject
    private IBatchTypeResolver batchTypeResolver;
    @Inject
    private SwitchConstantExpressionsInterpreter switchConstantExpressionsInterpreter;

    public boolean isJavaSwitchExpression(XSwitchExpression it) {
        LightweightTypeReference switchType = this.getSwitchVariableType(it);
        if (switchType == null) {
            return false;
        }
        if (switchType.isSubtypeOf(Integer.TYPE)) {
            return true;
        }
        return switchType.isSubtypeOf(Enum.class);
    }

    public boolean isJava7SwitchExpression(XSwitchExpression it) {
        LightweightTypeReference switchType = this.getSwitchVariableType(it);
        if (switchType == null) {
            return false;
        }
        if (switchType.isSubtypeOf(Integer.TYPE)) {
            return true;
        }
        if (switchType.isSubtypeOf(Enum.class)) {
            return true;
        }
        return switchType.isSubtypeOf(String.class);
    }

    public boolean isJavaCaseExpression(XSwitchExpression it, XCasePart casePart) {
        if (casePart.getTypeGuard() != null) {
            return false;
        }
        XExpression caseExpression = casePart.getCase();
        if (caseExpression == null) {
            return false;
        }
        IResolvedTypes resolvedTypes = this.batchTypeResolver.resolveTypes(it);
        LightweightTypeReference caseType = resolvedTypes.getActualType(caseExpression);
        if (caseType == null) {
            return false;
        }
        LightweightTypeReference switchType = this.getSwitchVariableType(it);
        return switchType.isAssignableFrom(caseType);
    }

    public LightweightTypeReference getSwitchVariableType(XSwitchExpression it) {
        IResolvedTypes resolvedTypes = this.batchTypeResolver.resolveTypes(it);
        JvmFormalParameter declaredParam = it.getDeclaredParam();
        if (declaredParam == null) {
            return resolvedTypes.getActualType(it.getSwitch());
        }
        LightweightTypeReference paramType = resolvedTypes.getActualType(declaredParam);
        if (paramType != null) {
            return paramType;
        }
        return resolvedTypes.getActualType(it.getSwitch());
    }

    public boolean isConstant(XCasePart casePart) {
        XExpression caseExpression = casePart.getCase();
        if (caseExpression == null) {
            return false;
        }
        try {
            this.switchConstantExpressionsInterpreter.evaluate(caseExpression);
            return true;
        }
        catch (ConstantExpressionEvaluationException e) {
            return false;
        }
    }

    public XExpression getThen(XCasePart casePart, XSwitchExpression switchExpression) {
        XExpression then = casePart.getThen();
        if (then != null) {
            return then;
        }
        int casePartIndex = switchExpression.getCases().indexOf(casePart);
        if (casePartIndex == -1) {
            return null;
        }
        int count = switchExpression.getCases().size();
        if (casePartIndex == count - 1) {
            return switchExpression.getDefault();
        }
        if (casePartIndex + 1 < count) {
            return this.getThen((XCasePart)switchExpression.getCases().get(casePartIndex + 1), switchExpression);
        }
        return null;
    }
}

