/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XAbstractWhileExpression;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XSynchronizedExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.override.BottomResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedExecutable;
import org.eclipse.xtext.xbase.typesystem.override.OverrideTester;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.IThrownExceptionDelegate;
import org.eclipse.xtext.xbase.typesystem.util.ThrownExceptionSwitch;

public class ExtendedEarlyExitComputer {
    @Inject
    private OverrideTester overrideTester;

    public boolean isIntentionalEarlyExit(XExpression expression) {
        if (expression == null) {
            return true;
        }
        if (expression instanceof XBlockExpression) {
            XBlockExpression block = (XBlockExpression)expression;
            EList<XExpression> children = block.getExpressions();
            for (XExpression child : children) {
                if (!this.isIntentionalEarlyExit(child)) continue;
                return true;
            }
        } else {
            if (expression instanceof XIfExpression) {
                return this.isIntentionalEarlyExit(((XIfExpression)expression).getThen()) || this.isIntentionalEarlyExit(((XIfExpression)expression).getElse());
            }
            if (expression instanceof XSwitchExpression) {
                XSwitchExpression switchExpression = (XSwitchExpression)expression;
                for (XCasePart caseExpression : switchExpression.getCases()) {
                    if (!this.isIntentionalEarlyExit(caseExpression.getThen())) continue;
                    return true;
                }
                if (this.isIntentionalEarlyExit(switchExpression.getDefault())) {
                    return true;
                }
            } else {
                if (expression instanceof XTryCatchFinallyExpression) {
                    XTryCatchFinallyExpression tryCatchFinally = (XTryCatchFinallyExpression)expression;
                    if (this.isIntentionalEarlyExit(tryCatchFinally.getExpression())) {
                        for (XCatchClause catchClause : tryCatchFinally.getCatchClauses()) {
                            if (this.isIntentionalEarlyExit(catchClause.getExpression())) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                if (expression instanceof XAbstractWhileExpression) {
                    return this.isIntentionalEarlyExit(((XAbstractWhileExpression)expression).getBody());
                }
                if (expression instanceof XForLoopExpression) {
                    return this.isIntentionalEarlyExit(((XForLoopExpression)expression).getEachExpression());
                }
                if (expression instanceof XBasicForLoopExpression) {
                    return this.isIntentionalEarlyExit(((XBasicForLoopExpression)expression).getEachExpression());
                }
                if (expression instanceof XSynchronizedExpression) {
                    return this.isIntentionalEarlyExit(((XSynchronizedExpression)expression).getExpression());
                }
            }
        }
        return expression instanceof XReturnExpression || expression instanceof XThrowExpression;
    }

    public boolean isDefiniteEarlyExit(XExpression expression) {
        if (expression instanceof XIfExpression) {
            XIfExpression ifExpression = (XIfExpression)expression;
            return this.isDefiniteEarlyExit(ifExpression.getThen()) && this.isDefiniteEarlyExit(ifExpression.getElse());
        }
        if (expression instanceof XSwitchExpression) {
            XSwitchExpression switchExpression = (XSwitchExpression)expression;
            if (this.isDefiniteEarlyExit(switchExpression.getDefault())) {
                for (XCasePart caseExpression : switchExpression.getCases()) {
                    if (this.isDefiniteEarlyExit(caseExpression.getThen())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (expression instanceof XTryCatchFinallyExpression) {
            XTryCatchFinallyExpression tryExpression = (XTryCatchFinallyExpression)expression;
            if (this.isDefiniteEarlyExit(tryExpression.getFinallyExpression())) {
                return true;
            }
            if (this.isDefiniteEarlyExit(tryExpression.getExpression())) {
                for (XCatchClause catchClause : tryExpression.getCatchClauses()) {
                    if (this.isDefiniteEarlyExit(catchClause.getExpression())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (expression instanceof XBlockExpression) {
            EList<XExpression> expressions = ((XBlockExpression)expression).getExpressions();
            int i = expressions.size() - 1;
            while (i >= 0) {
                if (this.isDefiniteEarlyExit((XExpression)expressions.get(i))) {
                    return true;
                }
                --i;
            }
        } else if (expression instanceof XSynchronizedExpression) {
            return this.isDefiniteEarlyExit(((XSynchronizedExpression)expression).getExpression());
        }
        return expression instanceof XReturnExpression || expression instanceof XThrowExpression;
    }

    public List<LightweightTypeReference> getThrownExceptions(XExpression obj, IResolvedTypes types, ITypeReferenceOwner owner) {
        if (obj == null) {
            return Collections.emptyList();
        }
        ArrayList<LightweightTypeReference> result = Lists.newArrayListWithExpectedSize(2);
        ThrownExceptionDelegate delegate = this.createDelegate(result, types, owner);
        Switch<Boolean> collector = this.createThrownExceptionCollector(delegate);
        delegate.collectWith(collector);
        delegate.collectThrownExceptions(obj);
        return result;
    }

    protected ThrownExceptionDelegate createDelegate(List<LightweightTypeReference> result, IResolvedTypes types, ITypeReferenceOwner owner) {
        return new ThrownExceptionDelegate(result, types, owner);
    }

    protected Switch<Boolean> createThrownExceptionCollector(IThrownExceptionDelegate delegate) {
        return new ThrownExceptionSwitch(delegate);
    }

    protected abstract class AbstractThrownExceptionDelegate
    implements IThrownExceptionDelegate {
        private Switch<Boolean> collector;

        protected AbstractThrownExceptionDelegate() {
        }

        @Override
        public void collectThrownExceptions(XExpression expression) {
            if (expression != null) {
                TreeIterator<EObject> iterator = EcoreUtil2.eAll(expression);
                while (iterator.hasNext()) {
                    if (this.collector.doSwitch((EObject)iterator.next()).booleanValue()) continue;
                    iterator.prune();
                }
            }
        }

        @Override
        public IThrownExceptionDelegate catchExceptions(List<LightweightTypeReference> caughtExceptions) {
            if (caughtExceptions.isEmpty()) {
                return this;
            }
            FilteringThrownExceptionDelegate delegate = new FilteringThrownExceptionDelegate(this, caughtExceptions);
            Switch<Boolean> collector = ExtendedEarlyExitComputer.this.createThrownExceptionCollector(delegate);
            delegate.collectWith(collector);
            return delegate;
        }

        public void collectWith(Switch<Boolean> collector) {
            this.collector = collector;
        }

        @Override
        public IResolvedExecutable getResolvedFeature(JvmExecutable executable, LightweightTypeReference contextType) {
            if (executable instanceof JvmOperation) {
                return new BottomResolvedOperation((JvmOperation)executable, contextType, ExtendedEarlyExitComputer.this.overrideTester);
            }
            if (executable instanceof JvmConstructor) {
                return new ResolvedConstructor((JvmConstructor)executable, contextType);
            }
            throw new IllegalArgumentException(String.valueOf(executable));
        }
    }

    protected class FilteringThrownExceptionDelegate
    extends AbstractThrownExceptionDelegate {
        private final IThrownExceptionDelegate delegate;
        private final List<LightweightTypeReference> caughtExceptions;

        protected FilteringThrownExceptionDelegate(IThrownExceptionDelegate delegate, List<LightweightTypeReference> caughtExceptions) {
            this.delegate = delegate;
            this.caughtExceptions = caughtExceptions;
        }

        @Override
        public LightweightTypeReference toLightweightReference(JvmTypeReference exception) {
            return this.delegate.toLightweightReference(exception);
        }

        @Override
        public void accept(LightweightTypeReference type) {
            for (LightweightTypeReference caughtException : this.caughtExceptions) {
                if (!type.isSubtypeOf(caughtException.getType())) continue;
                return;
            }
            this.delegate.accept(type);
        }

        @Override
        public LightweightTypeReference getActualType(XExpression expr) {
            return this.delegate.getActualType(expr);
        }

        @Override
        public LightweightTypeReference getActualType(JvmIdentifiableElement identifiable) {
            return this.delegate.getActualType(identifiable);
        }
    }

    protected class ThrownExceptionDelegate
    extends AbstractThrownExceptionDelegate {
        private final List<LightweightTypeReference> result;
        private final Set<String> seen;
        private final IResolvedTypes types;
        private final ITypeReferenceOwner owner;

        public ThrownExceptionDelegate(List<LightweightTypeReference> result, IResolvedTypes types, ITypeReferenceOwner owner) {
            this.result = result;
            this.types = types;
            this.owner = owner;
            this.seen = Sets.newHashSet();
        }

        @Override
        public LightweightTypeReference toLightweightReference(JvmTypeReference exception) {
            return this.owner.toLightweightTypeReference(exception);
        }

        @Override
        public void accept(LightweightTypeReference type) {
            if (type != null && this.seen.add(type.getIdentifier())) {
                this.result.add(type);
            }
        }

        @Override
        public LightweightTypeReference getActualType(XExpression expr) {
            return this.types.getActualType(expr);
        }

        @Override
        public LightweightTypeReference getActualType(JvmIdentifiableElement identifiable) {
            return this.types.getActualType(identifiable);
        }
    }
}

