/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import java.util.Arrays;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.impl.JvmGenericArrayTypeReferenceImplCustom;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.XtypePackage;
import org.eclipse.xtext.xtype.impl.XFunctionTypeRefImplCustom;
import org.eclipse.xtext.xtype.util.XFunctionTypeRefs;

public class IndexingLightweightTypeReferenceFactory
extends LightweightTypeReferenceFactory {
    public IndexingLightweightTypeReferenceFactory(ITypeReferenceOwner owner) {
        super(owner);
    }

    public IndexingLightweightTypeReferenceFactory(ITypeReferenceOwner owner, boolean keepUnboundWildcards) {
        super(owner, keepUnboundWildcards);
    }

    protected JvmType _getType(JvmTypeReference it) {
        throw new UnsupportedOperationException("It is not possible to get a type for the given jvm type reference: " + it.getClass().getName());
    }

    protected JvmType _getType(JvmGenericArrayTypeReferenceImplCustom it) {
        JvmTypeReference componentTypeReference = it.getComponentType();
        if (componentTypeReference == null) {
            return null;
        }
        JvmType componentType = this.getType(componentTypeReference);
        if (componentType instanceof JvmComponentType) {
            return ((JvmComponentType)componentType).getArrayType();
        }
        return null;
    }

    protected JvmType _getType(JvmParameterizedTypeReference it) {
        return this.getType(it, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
    }

    protected JvmType _getType(XFunctionTypeRef it) {
        return this.getType(it, XtypePackage.Literals.XFUNCTION_TYPE_REF__TYPE);
    }

    protected JvmType _getType(XFunctionTypeRefImplCustom it) {
        URI uri = XFunctionTypeRefs.computeTypeUri(this.isProcedure(it), it.getParamTypes().size());
        return (JvmType)it.eResource().getResourceSet().getEObject(uri, true);
    }

    public boolean isProcedure(XFunctionTypeRefImplCustom it) {
        JvmTypeReference returnType = it.getReturnType();
        if (returnType == null) {
            return true;
        }
        JvmType type = this.getType(returnType);
        if (type == null) {
            return false;
        }
        if (type.eIsProxy()) {
            return false;
        }
        return type instanceof JvmVoid;
    }

    public JvmType getType(EObject it, EReference reference) {
        Object proxy = it.eGet(reference, false);
        if (proxy instanceof EObject && ((EObject)proxy).eIsProxy()) {
            URI uri = ((InternalEObject)proxy).eProxyURI();
            return (JvmType)it.eResource().getResourceSet().getEObject(uri, true);
        }
        if (proxy instanceof JvmType) {
            return (JvmType)proxy;
        }
        return null;
    }

    @Override
    public LightweightTypeReference doVisitFunctionTypeReference(XFunctionTypeRef reference) {
        FunctionTypeReference result = new FunctionTypeReference(this.getOwner(), this.getType(reference));
        for (JvmTypeReference parameter : reference.getParamTypes()) {
            LightweightTypeReference parameterType = (LightweightTypeReference)this.visit(this.wrapIfNecessary(parameter));
            result.addParameterType(parameterType);
            WildcardTypeReference typeArgument = this.getOwner().newWildcardTypeReference();
            typeArgument.setLowerBound(parameterType);
            typeArgument.addUpperBound(this.getJavaLangObjectTypeReference());
            result.addTypeArgument(typeArgument);
        }
        if (reference.getReturnType() != null) {
            LightweightTypeReference returnType = (LightweightTypeReference)this.visit(this.wrapIfNecessary(reference.getReturnType()));
            result.setReturnType(returnType);
            if (reference instanceof XFunctionTypeRefImplCustom && this.isProcedure((XFunctionTypeRefImplCustom)reference)) {
                return result;
            }
            WildcardTypeReference typeArgument = this.getOwner().newWildcardTypeReference();
            typeArgument.addUpperBound(returnType);
            result.addTypeArgument(typeArgument);
        }
        return result;
    }

    public JvmTypeReference wrapIfNecessary(JvmTypeReference reference) {
        if (reference == null) {
            return null;
        }
        JvmType type = this.getType(reference);
        return XFunctionTypeRefs.wrapIfNecessary(reference, type);
    }

    protected LightweightTypeReference getJavaLangObjectTypeReference() {
        return this.getOwner().newReferenceToObject();
    }

    @Override
    public JvmType getType(JvmTypeReference it) {
        if (it instanceof XFunctionTypeRefImplCustom) {
            return this._getType((XFunctionTypeRefImplCustom)it);
        }
        if (it instanceof JvmGenericArrayTypeReferenceImplCustom) {
            return this._getType((JvmGenericArrayTypeReferenceImplCustom)it);
        }
        if (it instanceof XFunctionTypeRef) {
            return this._getType((XFunctionTypeRef)it);
        }
        if (it instanceof JvmParameterizedTypeReference) {
            return this._getType((JvmParameterizedTypeReference)it);
        }
        if (it != null) {
            return this._getType(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

