/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.override;

import com.google.common.base.Function;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypesSwitch;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xbase.typesystem.override.AbstractResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.override.AbstractResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.BottomResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.ConflictingDefaultOperation;
import org.eclipse.xtext.xbase.typesystem.override.IOverrideCheckResult;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedField;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideTester;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedField;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class ResolvedFeatures
extends AbstractResolvedFeatures {
    private List<IResolvedField> declaredFields;
    private List<IResolvedConstructor> declaredConstructors;
    private List<IResolvedOperation> allOperations;
    private List<IResolvedOperation> declaredOperations;
    private ListMultimap<String, IResolvedOperation> allOperationsPerErasure;
    private ListMultimap<String, IResolvedOperation> declaredOperationsPerErasure;
    private JavaVersion targetVersion = JavaVersion.JAVA5;

    public ResolvedFeatures(LightweightTypeReference type, OverrideTester overrideTester, JavaVersion targetVersion) {
        super(type, overrideTester);
        this.targetVersion = targetVersion;
    }

    public ResolvedFeatures(LightweightTypeReference type, OverrideTester overrideTester) {
        super(type, overrideTester);
    }

    public ResolvedFeatures(LightweightTypeReference type) {
        this(type, new OverrideTester());
    }

    public List<IResolvedOperation> getAllOperations() {
        if (this.allOperations != null) {
            return this.allOperations;
        }
        this.allOperations = this.computeAllOperations();
        return this.allOperations;
    }

    public IResolvedOperation getResolvedOperation(JvmOperation operation) {
        return this.createResolvedOperation(operation);
    }

    public List<IResolvedField> getDeclaredFields() {
        if (this.declaredFields != null) {
            return this.declaredFields;
        }
        this.declaredFields = this.computeDeclaredFields();
        return this.declaredFields;
    }

    public List<IResolvedConstructor> getDeclaredConstructors() {
        if (this.declaredConstructors != null) {
            return this.declaredConstructors;
        }
        this.declaredConstructors = this.computeDeclaredConstructors();
        return this.declaredConstructors;
    }

    public List<IResolvedOperation> getDeclaredOperations() {
        if (this.declaredOperations != null) {
            return this.declaredOperations;
        }
        this.declaredOperations = this.computeDeclaredOperations();
        return this.declaredOperations;
    }

    public List<IResolvedOperation> getDeclaredOperations(String erasedSignature) {
        if (this.declaredOperationsPerErasure != null) {
            return this.declaredOperationsPerErasure.get((Object)erasedSignature);
        }
        this.declaredOperationsPerErasure = this.computeIndex(this.getDeclaredOperations());
        return this.declaredOperationsPerErasure.get((Object)erasedSignature);
    }

    public List<IResolvedOperation> getAllOperations(String erasedSignature) {
        if (this.allOperationsPerErasure != null) {
            return this.allOperationsPerErasure.get((Object)erasedSignature);
        }
        this.allOperationsPerErasure = this.computeIndex(this.getAllOperations());
        return this.allOperationsPerErasure.get((Object)erasedSignature);
    }

    protected ListMultimap<String, IResolvedOperation> computeIndex(List<IResolvedOperation> operations) {
        return Multimaps.index(operations, new Function<IResolvedOperation, String>(){

            @Override
            public String apply(IResolvedOperation input) {
                return input.getResolvedErasureSignature();
            }
        });
    }

    protected List<IResolvedOperation> computeAllOperations() {
        JvmType rawType = this.getRawType();
        if (!(rawType instanceof JvmDeclaredType)) {
            return Collections.emptyList();
        }
        LinkedHashMultimap<String, AbstractResolvedOperation> processedOperations = LinkedHashMultimap.create();
        for (IResolvedOperation resolvedOperation : this.getDeclaredOperations()) {
            processedOperations.put(resolvedOperation.getDeclaration().getSimpleName(), (AbstractResolvedOperation)resolvedOperation);
        }
        if (this.targetVersion.isAtLeast(JavaVersion.JAVA8)) {
            this.computeAllOperationsFromSortedSuperTypes((JvmDeclaredType)rawType, processedOperations);
        } else {
            HashSet<JvmType> processedTypes = Sets.newHashSet(rawType);
            this.computeAllOperationsFromSuperTypes((JvmDeclaredType)rawType, processedOperations, processedTypes);
        }
        ArrayList<IResolvedOperation> result = new ArrayList<IResolvedOperation>(processedOperations.size());
        result.addAll(this.getDeclaredOperations());
        for (AbstractResolvedOperation operation : processedOperations.values()) {
            if (((JvmOperation)operation.getDeclaration()).getDeclaringType() == rawType) continue;
            result.add(operation);
        }
        return Collections.unmodifiableList(result);
    }

    protected void computeAllOperations(JvmDeclaredType type, Multimap<String, AbstractResolvedOperation> processedOperations) {
        for (JvmOperation operation : type.getDeclaredOperations()) {
            boolean addToResult = true;
            if (this.targetVersion.isAtLeast(JavaVersion.JAVA8)) {
                addToResult = this.handleOverridesAndConflicts(operation, processedOperations);
            } else {
                String simpleName = operation.getSimpleName();
                if (processedOperations.containsKey(simpleName)) {
                    boolean bl = addToResult = !this.isOverridden(operation, processedOperations.get(simpleName));
                }
            }
            if (!addToResult) continue;
            BottomResolvedOperation resolvedOperation = this.createResolvedOperation(operation);
            processedOperations.put(operation.getSimpleName(), resolvedOperation);
        }
    }

    protected void computeAllOperationsFromSuperTypes(JvmDeclaredType type, Multimap<String, AbstractResolvedOperation> processedOperations, Set<JvmType> processedTypes) {
        for (JvmTypeReference superType : type.getSuperTypes()) {
            JvmType rawSuperType = superType.getType();
            if (!(rawSuperType instanceof JvmDeclaredType) || rawSuperType.eIsProxy() || !processedTypes.add(rawSuperType)) continue;
            this.computeAllOperations((JvmDeclaredType)rawSuperType, processedOperations);
            this.computeAllOperationsFromSuperTypes((JvmDeclaredType)rawSuperType, processedOperations, processedTypes);
        }
    }

    protected void computeAllOperationsFromSortedSuperTypes(JvmDeclaredType rootType, Multimap<String, AbstractResolvedOperation> processedOperations) {
        class SuperTypes
        extends TypesSwitch<Boolean> {
            private Multiset<JvmType> interfaces = LinkedHashMultiset.create();
            private Set<JvmType> notInterfaces = Sets.newLinkedHashSet();

            public SuperTypes(JvmDeclaredType rootType) {
                this.doSwitch(rootType);
            }

            @Override
            public Boolean doSwitch(EObject theEObject) {
                if (theEObject == null) {
                    return Boolean.FALSE;
                }
                return (Boolean)super.doSwitch(theEObject);
            }

            @Override
            public Boolean caseJvmTypeReference(JvmTypeReference object) {
                return this.doSwitch(object.getType());
            }

            @Override
            public Boolean caseJvmType(JvmType object) {
                return this.notInterfaces.add(object);
            }

            @Override
            public Boolean caseJvmDeclaredType(JvmDeclaredType object) {
                if (this.notInterfaces.add(object)) {
                    for (JvmTypeReference superType : object.getSuperTypes()) {
                        this.doSwitch(superType);
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public Boolean caseJvmGenericType(JvmGenericType object) {
                boolean traverseSuperTypes = false;
                traverseSuperTypes = object.isInterface() ? this.interfaces.add(object, 1) == 0 : this.notInterfaces.add(object);
                if (traverseSuperTypes) {
                    for (JvmTypeReference superType : object.getSuperTypes()) {
                        this.doSwitch(superType);
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            public Collection<JvmType> getSuperTypesNoInterfaces() {
                return this.notInterfaces;
            }

            public int consumeInterfaceOccurrence(JvmGenericType intf) {
                return this.interfaces.remove(intf, 1);
            }
        }
        SuperTypes superTypes = new SuperTypes(rootType);
        for (JvmType superClass : superTypes.getSuperTypesNoInterfaces()) {
            if (!(superClass instanceof JvmDeclaredType)) continue;
            this.computeAllOperations((JvmDeclaredType)superClass, processedOperations);
        }
        class SuperInterfaceConsumer
        extends TypesSwitch<Boolean> {
            private Set<JvmType> seen = Sets.newHashSet();
            private final /* synthetic */ SuperTypes val$superTypes;
            private final /* synthetic */ Multimap val$processedOperations;

            SuperInterfaceConsumer(SuperTypes superTypes, Multimap multimap) {
                this.val$superTypes = superTypes;
                this.val$processedOperations = multimap;
            }

            @Override
            public Boolean doSwitch(EObject theEObject) {
                if (theEObject == null) {
                    return Boolean.FALSE;
                }
                return (Boolean)super.doSwitch(theEObject);
            }

            @Override
            public Boolean defaultCase(EObject object) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean caseJvmTypeReference(JvmTypeReference object) {
                return this.doSwitch(object.getType());
            }

            @Override
            public Boolean caseJvmDeclaredType(JvmDeclaredType object) {
                if (this.seen.add(object)) {
                    for (JvmTypeReference superType : object.getSuperTypes()) {
                        this.doSwitch(superType);
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public Boolean caseJvmGenericType(JvmGenericType object) {
                if (object.isInterface()) {
                    int was = this.val$superTypes.consumeInterfaceOccurrence(object);
                    if (was == 0) {
                        return Boolean.FALSE;
                    }
                    if (was == 1) {
                        ResolvedFeatures.this.computeAllOperations(object, this.val$processedOperations);
                    }
                    for (JvmTypeReference superType : object.getSuperTypes()) {
                        this.doSwitch(superType);
                    }
                    if (was > 1) {
                        return true;
                    }
                    return false;
                }
                if (this.seen.add(object)) {
                    for (JvmTypeReference superType : object.getSuperTypes()) {
                        this.doSwitch(superType);
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            public void consume(JvmType rootType) {
                this.doSwitch(rootType);
            }
        }
        new SuperInterfaceConsumer(superTypes, processedOperations).consume(rootType);
    }

    protected List<IResolvedOperation> computeDeclaredOperations() {
        JvmType rawType = this.getRawType();
        if (!(rawType instanceof JvmDeclaredType)) {
            return Collections.emptyList();
        }
        ArrayList<BottomResolvedOperation> result = Lists.newArrayList();
        Iterable<JvmOperation> operations = ((JvmDeclaredType)rawType).getDeclaredOperations();
        for (JvmOperation operation : operations) {
            BottomResolvedOperation resolvedOperation = this.createResolvedOperation(operation);
            result.add(resolvedOperation);
        }
        return Collections.unmodifiableList(result);
    }

    protected List<IResolvedField> computeDeclaredFields() {
        JvmType rawType = this.getRawType();
        if (!(rawType instanceof JvmGenericType)) {
            return Collections.emptyList();
        }
        ArrayList<ResolvedField> result = Lists.newArrayList();
        for (JvmField field : ((JvmGenericType)rawType).getDeclaredFields()) {
            result.add(new ResolvedField(field, this.getType()));
        }
        return Collections.unmodifiableList(result);
    }

    protected List<IResolvedConstructor> computeDeclaredConstructors() {
        JvmType rawType = this.getRawType();
        if (!(rawType instanceof JvmGenericType)) {
            return Collections.emptyList();
        }
        ArrayList<ResolvedConstructor> result = Lists.newArrayList();
        for (JvmConstructor constructor : ((JvmGenericType)rawType).getDeclaredConstructors()) {
            result.add(new ResolvedConstructor(constructor, this.getType()));
        }
        return Collections.unmodifiableList(result);
    }

    private boolean handleOverridesAndConflicts(JvmOperation operation, Multimap<String, AbstractResolvedOperation> processedOperations) {
        String simpleName = operation.getSimpleName();
        if (!processedOperations.containsKey(simpleName)) {
            return true;
        }
        LinkedList<AbstractResolvedOperation> conflictingOperations = null;
        for (AbstractResolvedOperation candidate : processedOperations.get(simpleName)) {
            OverrideTester overrideTester = candidate.getOverrideTester();
            IOverrideCheckResult checkResult = overrideTester.isSubsignature(candidate, operation, false);
            if (checkResult.getDetails().contains((Object)IOverrideCheckResult.OverrideCheckDetails.DEFAULT_IMPL_CONFLICT)) {
                if (conflictingOperations == null) {
                    conflictingOperations = Lists.newLinkedList();
                }
                conflictingOperations.add(candidate);
                continue;
            }
            if (!checkResult.isOverridingOrImplementing()) continue;
            return false;
        }
        if (conflictingOperations != null) {
            ConflictingDefaultOperation resolvedOperation;
            if (conflictingOperations.size() == 1 && conflictingOperations.get(0) instanceof ConflictingDefaultOperation) {
                ConflictingDefaultOperation conflictingDefaultOperation = (ConflictingDefaultOperation)conflictingOperations.get(0);
                boolean isOverridden = false;
                for (IResolvedOperation conflictingOp : conflictingDefaultOperation.getConflictingOperations()) {
                    if (!conflictingOp.getResolvedDeclarator().isSubtypeOf(operation.getDeclaringType())) continue;
                    isOverridden = true;
                    break;
                }
                if (!isOverridden) {
                    conflictingDefaultOperation.getConflictingOperations().add(this.createResolvedOperation(operation));
                }
                return false;
            }
            if (operation.isAbstract()) {
                resolvedOperation = this.createConflictingOperation((JvmOperation)((AbstractResolvedOperation)conflictingOperations.get(0)).getDeclaration(), new IResolvedOperation[0]);
                resolvedOperation.getConflictingOperations().add(this.createResolvedOperation(operation));
                for (AbstractResolvedOperation conflictingOp : conflictingOperations) {
                    processedOperations.remove(simpleName, conflictingOp);
                    if (conflictingOp.getDeclaration() == resolvedOperation.getDeclaration()) continue;
                    resolvedOperation.getConflictingOperations().add(conflictingOp);
                }
                processedOperations.put(simpleName, resolvedOperation);
            } else {
                resolvedOperation = this.createConflictingOperation(operation, new IResolvedOperation[0]);
                for (AbstractResolvedOperation conflictingOp : conflictingOperations) {
                    processedOperations.remove(simpleName, conflictingOp);
                    resolvedOperation.getConflictingOperations().add(conflictingOp);
                }
                processedOperations.put(simpleName, resolvedOperation);
            }
            return false;
        }
        return true;
    }
}

