/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XPostfixOperation;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractAmbiguousLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractPendingLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkingCandidate;

public class AmbiguousFeatureLinkingCandidate
extends AbstractAmbiguousLinkingCandidate<FeatureLinkingCandidate>
implements IFeatureLinkingCandidate {
    protected AmbiguousFeatureLinkingCandidate(FeatureLinkingCandidate first, AbstractPendingLinkingCandidate<?> second) {
        super(first, second);
    }

    @Override
    protected String getSyntaxDescriptions() {
        XExpression expression = this.getExpression();
        if (expression instanceof XBinaryOperation) {
            return "binary operation";
        }
        if (expression instanceof XUnaryOperation) {
            return "unary operation";
        }
        if (expression instanceof XPostfixOperation) {
            return "postfix operation";
        }
        return "feature call";
    }

    @Override
    protected String getFeatureTypeName() {
        XExpression expression = this.getExpression();
        if (expression instanceof XAbstractFeatureCall && ((XAbstractFeatureCall)expression).isOperation()) {
            return "operator declaration";
        }
        if (((FeatureLinkingCandidate)this.getPrimaryCandidate()).isExtension()) {
            return "extension method";
        }
        return super.getFeatureTypeName();
    }

    @Override
    public XAbstractFeatureCall getFeatureCall() {
        return ((FeatureLinkingCandidate)this.getPrimaryCandidate()).getFeatureCall();
    }

    @Override
    public boolean isStatic() {
        return ((FeatureLinkingCandidate)this.getPrimaryCandidate()).isStatic();
    }

    @Override
    public boolean isExtension() {
        return ((FeatureLinkingCandidate)this.getPrimaryCandidate()).isExtension();
    }

    @Override
    public boolean isTypeLiteral() {
        return ((FeatureLinkingCandidate)this.getPrimaryCandidate()).isTypeLiteral();
    }

    @Override
    protected EStructuralFeature getFeatureToMark() {
        return XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE;
    }

    @Override
    protected String[] getDiagnosticData() {
        FeatureLinkingCandidate primaryCandidate = (FeatureLinkingCandidate)this.getPrimaryCandidate();
        XAbstractFeatureCall expression = (XAbstractFeatureCall)primaryCandidate.getExpression();
        if (expression.isExplicitOperationCallOrBuilderSyntax()) {
            return null;
        }
        LinkedHashSet<String> data = Sets.newLinkedHashSet();
        for (ILinkingCandidate candidate : this.getAlternatives()) {
            JvmIdentifiableElement feature = candidate.getFeature();
            String simpleName = feature.getSimpleName();
            data.add(String.valueOf(simpleName) + "()");
        }
        return data.toArray(new String[data.size()]);
    }
}

