/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.xtext.JvmMemberInitializableResource;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopes;
import org.eclipse.xtext.xbase.scoping.batch.IBatchScopeProvider;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.EmptyResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public abstract class AbstractBatchTypeResolver
implements IBatchTypeResolver {
    private static Logger LOG = Logger.getLogger(AbstractBatchTypeResolver.class);
    @Inject
    private IBatchScopeProvider scopeProvider;
    @Inject
    private FeatureScopes featureScopes;
    @Inject
    private CommonTypeComputationServices services;

    protected AbstractBatchTypeResolver() {
    }

    @Override
    public IResolvedTypes resolveTypes(Resource resource) {
        return this.resolveTypes(resource, null);
    }

    @Override
    public final IResolvedTypes resolveTypes(EObject object) {
        return this.resolveTypes(object, null);
    }

    @Override
    public final IResolvedTypes resolveTypes(EObject object, CancelIndicator monitor) {
        if (object == null || object.eIsProxy()) {
            return IResolvedTypes.NULL;
        }
        Resource resource = object.eResource();
        this.validateResourceState(resource);
        if (resource instanceof JvmMemberInitializableResource) {
            ((JvmMemberInitializableResource)((Object)resource)).ensureJvmMembersInitialized();
        }
        return this.doResolveTypes(object, monitor);
    }

    protected void validateResourceState(Resource resource) {
        if (resource instanceof StorageAwareResource && ((StorageAwareResource)resource).isLoadedFromStorage()) {
            LOG.error("Discouraged attempt to compute types for resource that was loaded from storage. Resource was : " + resource.getURI(), new Exception());
        }
    }

    @Override
    public IResolvedTypes resolveTypes(Resource resource, CancelIndicator monitor) {
        this.validateResourceState(resource);
        EList<EObject> resourceContents = resource.getContents();
        if (resourceContents.isEmpty()) {
            IFeatureScopeSession session = this.scopeProvider.newSession(resource);
            return new EmptyResolvedTypes(session, this.featureScopes, new StandardTypeReferenceOwner(this.services, resource));
        }
        return this.resolveTypes((EObject)resourceContents.get(0), monitor);
    }

    protected abstract IResolvedTypes doResolveTypes(EObject var1, CancelIndicator var2);
}

