/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.typesystem.computation.AbstractClosureTypeHelper;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeAssigner;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;

public class UnknownClosureTypeHelper
extends AbstractClosureTypeHelper {
    private List<JvmFormalParameter> implicitParameters;

    protected UnknownClosureTypeHelper(XClosure closure, ITypeExpectation expectation, ITypeComputationState state) {
        super(closure, expectation, state);
    }

    @Override
    protected void computeTypes() {
        ITypeAssigner typeAssigner = this.getState().withoutRootExpectation().assignTypes();
        ITypeComputationState closureBodyTypeComputationState = this.getClosureBodyTypeComputationState(typeAssigner);
        closureBodyTypeComputationState.computeTypes(this.getClosure().getExpression());
        this.getExpectation().acceptActualType((LightweightTypeReference)this.getExpectation().getReferenceOwner().newUnknownTypeReference(), 0x400000);
    }

    @Override
    public FunctionTypeReference getExpectedClosureType() {
        return null;
    }

    @Override
    public JvmOperation getOperation() {
        return null;
    }

    protected ITypeComputationState getClosureBodyTypeComputationState(ITypeAssigner typeAssigner) {
        ITypeComputationState result = this.assignParameters(typeAssigner);
        result.withinScope(this.getClosure());
        return result;
    }

    @Override
    public List<JvmFormalParameter> getParameters() {
        XClosure closure = this.getClosure();
        if (closure.isExplicitSyntax()) {
            return closure.getDeclaredFormalParameters();
        }
        if (this.implicitParameters != null) {
            return this.implicitParameters;
        }
        return closure.getImplicitFormalParameters();
    }

    protected ITypeComputationState assignParameters(ITypeAssigner typeAssigner) {
        XClosure closure = this.getClosure();
        if (closure.isExplicitSyntax() || !closure.getImplicitFormalParameters().isEmpty()) {
            EList<JvmFormalParameter> closureParameters = closure.getFormalParameters();
            int paramCount = closureParameters.size();
            int i = 0;
            while (i < paramCount) {
                JvmFormalParameter closureParameter = (JvmFormalParameter)closureParameters.get(i);
                if (closureParameter.getParameterType() != null) {
                    LightweightTypeReference closureParameterType = typeAssigner.toLightweightTypeReference(closureParameter.getParameterType());
                    typeAssigner.assignType(closureParameter, closureParameterType);
                } else {
                    UnknownTypeReference unknownType = typeAssigner.getReferenceOwner().newUnknownTypeReference();
                    typeAssigner.assignType(closureParameter, unknownType);
                }
                ++i;
            }
            ITypeComputationState result = typeAssigner.getForkedState();
            return result;
        }
        JvmFormalParameter implicitParameter = TypesFactory.eINSTANCE.createJvmFormalParameter();
        implicitParameter.setName(IFeatureNames.IT.getFirstSegment());
        this.implicitParameters = Collections.singletonList(implicitParameter);
        typeAssigner.assignType(implicitParameter, typeAssigner.getReferenceOwner().newUnknownTypeReference());
        ITypeComputationState result = typeAssigner.getForkedState();
        return result;
    }
}

