/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedExecutableScope;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.ExpressionBucket;
import org.eclipse.xtext.xbase.scoping.batch.ExtensionScopeHelper;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.InstanceExtensionDescription;
import org.eclipse.xtext.xbase.scoping.batch.InstanceExtensionDescriptionWithImplicitFirstArgument;
import org.eclipse.xtext.xbase.scoping.batch.InstanceFeatureDescriptionWithImplicitReceiver;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;

public class DynamicExtensionsScope
extends AbstractSessionBasedExecutableScope {
    private final ExtensionScopeHelper helper;
    private final XExpression firstArgument;
    private final LightweightTypeReference argumentType;
    private final boolean implicit;
    private Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> argumentTypeParameterMapping;

    public DynamicExtensionsScope(IScope parent, IFeatureScopeSession session, XExpression firstArgument, LightweightTypeReference argumentType, boolean implicit, XAbstractFeatureCall context, OperatorMapping operatorMapping) {
        super(parent, session, context, operatorMapping);
        this.firstArgument = firstArgument;
        this.argumentType = argumentType;
        this.implicit = implicit;
        this.helper = argumentType != null ? new ExtensionScopeHelper(argumentType) : null;
    }

    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getArgumentTypeParameterMapping() {
        if (this.argumentTypeParameterMapping == null) {
            this.argumentTypeParameterMapping = Collections.emptyMap();
            if (this.argumentType != null) {
                this.argumentTypeParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(this.argumentType);
            }
        }
        return this.argumentTypeParameterMapping;
    }

    @Override
    protected List<IEObjectDescription> getAllLocalElements() {
        List<ExpressionBucket> buckets = this.getBuckets();
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IEObjectDescription> result = Lists.newArrayList();
        for (ExpressionBucket bucket : buckets) {
            this.getAllLocalElements(bucket, result);
        }
        return result;
    }

    protected void getAllLocalElements(ExpressionBucket bucket, List<IEObjectDescription> result) {
        Map<XExpression, LightweightTypeReference> extensionProviders = bucket.getExtensionProviders();
        for (Map.Entry<XExpression, LightweightTypeReference> extensionProvider : extensionProviders.entrySet()) {
            LightweightTypeReference extensionType = extensionProvider.getValue();
            Set<JvmFeature> allFeatures = this.getAllFeatures(extensionType, bucket.getResolvedFeaturesProvider());
            if (allFeatures.isEmpty()) continue;
            Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(extensionType);
            for (JvmFeature feature : allFeatures) {
                if (feature.isStatic()) continue;
                this.addDescriptions(feature, extensionProvider.getKey(), extensionType, receiverTypeParameterMapping, bucket, result);
            }
        }
    }

    protected Set<JvmFeature> getAllFeatures(LightweightTypeReference extensionType, IResolvedFeatures.Provider resolvedFeaturesProvider) {
        LinkedHashSet<JvmFeature> allFeatures = Sets.newLinkedHashSet();
        List<JvmType> types = extensionType.getRawTypes();
        for (JvmType type : types) {
            if (!(type instanceof JvmDeclaredType)) continue;
            IResolvedFeatures resolvedFeatures = resolvedFeaturesProvider.getResolvedFeatures(type).getParameterizedView(extensionType);
            List<JvmFeature> features = resolvedFeatures.getAllFeatures();
            allFeatures.addAll(features);
        }
        return allFeatures;
    }

    protected void addDescriptions(JvmFeature feature, XExpression receiver, LightweightTypeReference receiverType, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping, ExpressionBucket bucket, List<IEObjectDescription> result) {
        QualifiedName operator;
        String propertyName;
        BucketedEObjectDescription description;
        String simpleName = feature.getSimpleName();
        QualifiedName featureName = QualifiedName.create(simpleName);
        boolean validStaticState = this.isValidStaticState(receiver);
        if (this.firstArgument != null && this.helper.isPossibleExtension(feature) && this.helper.isMatchingFirstParameterDeepCheck((JvmOperation)feature) && (description = this.doCreateExtensionDescription(featureName, feature, receiver, receiverType, receiverTypeParameterMapping, bucket, validStaticState)) != null) {
            this.addToList(description, result);
            propertyName = this.toProperty(simpleName, feature);
            if (propertyName != null) {
                this.addToList(this.doCreateExtensionDescription(QualifiedName.create(propertyName), feature, receiver, receiverType, receiverTypeParameterMapping, bucket, validStaticState), result);
            }
        }
        if (this.implicit && (description = this.createReceiverDescription(featureName, feature, receiver, receiverType, receiverTypeParameterMapping, bucket, validStaticState)) != null) {
            this.addToList(description, result);
            propertyName = super.toProperty(simpleName, feature);
            if (propertyName != null) {
                this.addToList(this.createReceiverDescription(QualifiedName.create(propertyName), feature, receiver, receiverType, receiverTypeParameterMapping, bucket, validStaticState), result);
            }
        }
        if ((operator = this.getOperatorMapping().getOperator(featureName)) != null) {
            if (this.firstArgument != null) {
                this.addToList(this.doCreateExtensionDescription(operator, feature, receiver, receiverType, receiverTypeParameterMapping, bucket, validStaticState), result);
            }
            if (this.implicit) {
                this.addToList(this.createReceiverDescription(operator, feature, receiver, receiverType, receiverTypeParameterMapping, bucket, validStaticState), result);
            }
        }
    }

    protected List<ExpressionBucket> getBuckets() {
        return this.getSession().getExtensionProviders();
    }

    @Override
    protected List<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        List<ExpressionBucket> buckets = this.getBuckets();
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IEObjectDescription> result = Lists.newArrayList();
        for (final ExpressionBucket bucket : buckets) {
            Map<XExpression, LightweightTypeReference> extensionProviders = bucket.getExtensionProviders();
            for (Map.Entry<XExpression, LightweightTypeReference> extensionProvider : extensionProviders.entrySet()) {
                final LightweightTypeReference extensionType = extensionProvider.getValue();
                if (extensionType == null) {
                    throw new IllegalStateException("extensionType is null");
                }
                final List<JvmType> types = extensionType.getRawTypes();
                final LinkedHashSet<JvmFeature> allFeatures = Sets.newLinkedHashSet();
                this.processFeatureNames(name, new AbstractSessionBasedScope.NameAcceptor(){

                    @Override
                    public void accept(String simpleName, int order) {
                        for (JvmType type : types) {
                            if (!(type instanceof JvmDeclaredType)) continue;
                            IResolvedFeatures resolvedFeatures = bucket.getResolvedFeaturesProvider().getResolvedFeatures(type).getParameterizedView(extensionType);
                            List<JvmFeature> features = resolvedFeatures.getAllFeatures(simpleName);
                            if (order == 1) {
                                allFeatures.addAll(features);
                                continue;
                            }
                            int i = 0;
                            int size = features.size();
                            while (i < size) {
                                JvmFeature feature = features.get(i);
                                if (feature.eClass() == TypesPackage.Literals.JVM_OPERATION) {
                                    allFeatures.add(feature);
                                }
                                ++i;
                            }
                        }
                    }
                });
                if (allFeatures.isEmpty()) continue;
                Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(extensionType);
                for (JvmFeature feature : allFeatures) {
                    BucketedEObjectDescription description;
                    if (feature.isStatic()) continue;
                    XExpression receiver = extensionProvider.getKey();
                    boolean validStaticState = this.isValidStaticState(receiver);
                    if (this.firstArgument != null && (description = this.createExtensionDescription(name, feature, receiver, extensionType, receiverTypeParameterMapping, bucket, validStaticState)) != null) {
                        this.addToList(description, result);
                    }
                    if (!this.implicit) continue;
                    this.addToList(this.createReceiverDescription(name, feature, receiver, extensionType, receiverTypeParameterMapping, bucket, validStaticState), result);
                }
            }
        }
        return result;
    }

    protected boolean isValidStaticState(XExpression receiver) {
        XExpression thisReference;
        boolean validStaticState = true;
        if (receiver instanceof XMemberFeatureCall && (thisReference = ((XMemberFeatureCall)receiver).getMemberCallTarget()) instanceof XFeatureCall && ((XFeatureCall)thisReference).getFeature() instanceof JvmType) {
            validStaticState = this.getSession().isInstanceContext();
        }
        return validStaticState;
    }

    protected BucketedEObjectDescription createExtensionDescription(QualifiedName name, JvmFeature feature, XExpression receiver, LightweightTypeReference receiverType, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping, ExpressionBucket bucket, boolean validStaticState) {
        if (this.helper == null || !this.helper.isPossibleExtension(feature)) {
            return null;
        }
        return this.doCreateExtensionDescription(name, feature, receiver, receiverType, receiverTypeParameterMapping, bucket, validStaticState);
    }

    protected BucketedEObjectDescription doCreateExtensionDescription(QualifiedName name, JvmFeature feature, XExpression receiver, LightweightTypeReference receiverType, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping, ExpressionBucket bucket, boolean validStaticState) {
        if (this.implicit) {
            return new InstanceExtensionDescriptionWithImplicitFirstArgument(name, feature, receiver, receiverType, receiverTypeParameterMapping, 0x100200, this.firstArgument, this.argumentType, this.getArgumentTypeParameterMapping(), bucket.getId(), this.getSession().isVisible(feature), validStaticState);
        }
        return new InstanceExtensionDescription(name, feature, receiver, receiverType, receiverTypeParameterMapping, 0x100200, this.firstArgument, this.argumentType, this.getArgumentTypeParameterMapping(), 0x400000, bucket.getId(), this.getSession().isVisible(feature), validStaticState);
    }

    protected BucketedEObjectDescription createReceiverDescription(QualifiedName name, JvmFeature feature, XExpression receiver, LightweightTypeReference receiverType, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping, ExpressionBucket bucket, boolean validStaticState) {
        return new InstanceFeatureDescriptionWithImplicitReceiver(name, feature, receiver, receiverType, receiverTypeParameterMapping, 0x100200, bucket.getId(), this.getSession().isVisible(feature), validStaticState);
    }

    @Override
    protected String toProperty(String methodName, JvmFeature feature) {
        return this.toProperty(methodName, feature, 1, 2);
    }
}

