/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractGlobalScopeDelegatingScopeProvider;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportScope;
import org.eclipse.xtext.scoping.impl.MapBasedScope;
import org.eclipse.xtext.scoping.impl.MultimapBasedSelectable;
import org.eclipse.xtext.scoping.impl.ScopeBasedSelectable;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.scoping.AbstractNestedTypeAwareImportNormalizer;
import org.eclipse.xtext.xbase.scoping.XImportSectionNamespaceScopeProvider;

@Deprecated
public class XbaseImportedNamespaceScopeProvider
extends AbstractGlobalScopeDelegatingScopeProvider {
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private IResourceScopeCache cache;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public IQualifiedNameProvider getQualifiedNameProvider() {
        return this.qualifiedNameProvider;
    }

    @Override
    public IScope getScope(EObject context, EReference reference) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (context.eResource() == null) {
            throw new IllegalArgumentException("context must be contained in a resource");
        }
        IScope globalScope = this.getGlobalScope(context.eResource(), reference);
        return this.internalGetScope(globalScope, globalScope, context, reference);
    }

    @Override
    protected IScope getGlobalScope(Resource context, EReference reference) {
        IScope globalScope = super.getGlobalScope(context, reference, null);
        return SelectableBasedScope.createScope(globalScope, this.getAllDescriptions(context), reference.getEReferenceType(), this.isIgnoreCase(reference));
    }

    protected IScope internalGetScope(IScope parent, IScope globalScope, EObject context, EReference reference) {
        IScope result = parent;
        if (context.eContainer() == null) {
            if (parent != globalScope) {
                throw new IllegalStateException("the parent should be the global scope");
            }
            result = this.getResourceScope(globalScope, context.eResource(), reference);
        } else {
            result = this.internalGetScope(parent, globalScope, context.eContainer(), reference);
        }
        return this.getLocalElementsScope(result, globalScope, context, reference);
    }

    protected IScope getLocalElementsScope(IScope parent, IScope globalScope, EObject context, EReference reference) {
        IScope result = parent;
        QualifiedName name = this.getQualifiedNameOfLocalElement(context);
        boolean ignoreCase = this.isIgnoreCase(reference);
        ISelectable resourceOnlySelectable = this.getAllDescriptions(context.eResource());
        ScopeBasedSelectable globalScopeSelectable = new ScopeBasedSelectable(globalScope);
        List<ImportNormalizer> explicitImports = this.getImportedNamespaceResolvers(context, ignoreCase);
        if (!explicitImports.isEmpty()) {
            result = this.createImportScope(result, explicitImports, globalScopeSelectable, reference.getEReferenceType(), ignoreCase);
        }
        if (name != null) {
            ImportNormalizer localNormalizer = this.doCreateImportNormalizer(name, true, ignoreCase);
            result = this.createImportScope(result, Collections.singletonList(localNormalizer), resourceOnlySelectable, reference.getEReferenceType(), ignoreCase);
        }
        Set<EObject> elements = this.associations.getJvmElements(context);
        for (EObject derivedJvmElement : elements) {
            if (derivedJvmElement instanceof JvmDeclaredType) {
                JvmDeclaredType declaredType = (JvmDeclaredType)derivedJvmElement;
                QualifiedName jvmTypeName = this.getQualifiedNameOfLocalElement(declaredType);
                if (declaredType.getDeclaringType() == null && !Strings.isEmpty(declaredType.getPackageName())) {
                    QualifiedName packageName = this.qualifiedNameConverter.toQualifiedName(declaredType.getPackageName());
                    ImportNormalizer normalizer = this.doCreateImportNormalizer(packageName, true, ignoreCase);
                    result = this.createImportScope(result, Collections.singletonList(normalizer), globalScopeSelectable, reference.getEReferenceType(), ignoreCase);
                }
                if (jvmTypeName != null && !jvmTypeName.equals(name)) {
                    ImportNormalizer localNormalizer = this.doCreateImportNormalizer(jvmTypeName, true, ignoreCase);
                    result = this.createImportScope(result, Collections.singletonList(localNormalizer), resourceOnlySelectable, reference.getEReferenceType(), ignoreCase);
                }
            }
            if (!(derivedJvmElement instanceof JvmTypeParameterDeclarator)) continue;
            JvmTypeParameterDeclarator parameterDeclarator = (JvmTypeParameterDeclarator)derivedJvmElement;
            ArrayList<IEObjectDescription> descriptions = null;
            for (JvmTypeParameter param : parameterDeclarator.getTypeParameters()) {
                if (param.getSimpleName() == null) continue;
                if (descriptions == null) {
                    descriptions = Lists.newArrayList();
                }
                QualifiedName paramName = QualifiedName.create(param.getSimpleName());
                descriptions.add(EObjectDescription.create(paramName, (EObject)param));
            }
            if (descriptions == null || descriptions.isEmpty()) continue;
            result = MapBasedScope.createScope(result, (Collection<IEObjectDescription>)descriptions);
        }
        return result;
    }

    protected IScope getResourceScope(IScope globalScope, Resource res, EReference reference) {
        IScope result = globalScope;
        ScopeBasedSelectable globalScopeSelectable = new ScopeBasedSelectable(result);
        List<ImportNormalizer> normalizers = this.getImplicitImports(this.isIgnoreCase(reference));
        if (!normalizers.isEmpty()) {
            result = this.createImportScope(result, normalizers, globalScopeSelectable, reference.getEReferenceType(), this.isIgnoreCase(reference));
        }
        return result;
    }

    protected List<ImportNormalizer> getImplicitImports(boolean ignoreCase) {
        return Collections.singletonList(this.doCreateImportNormalizer(QualifiedName.create("java", "lang"), true, ignoreCase));
    }

    protected ImportScope createImportScope(IScope parent, List<ImportNormalizer> namespaceResolvers, ISelectable importFrom, EClass type, boolean ignoreCase) {
        if (importFrom == null) {
            throw new NullPointerException("importFrom");
        }
        return new ImportScope(namespaceResolvers, parent, importFrom, type, ignoreCase){

            @Override
            protected IEObjectDescription getSingleLocalElementByName(QualifiedName name) {
                if (name.getSegmentCount() > 1) {
                    QualifiedName singleSegment = QualifiedName.create(name.toString("$"));
                    IEObjectDescription result = super.getSingleLocalElementByName(singleSegment);
                    if (result != null) {
                        return new AliasedEObjectDescription(name, result);
                    }
                    return null;
                }
                IEObjectDescription result = super.getSingleLocalElementByName(name);
                return result;
            }

            @Override
            protected Iterable<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
                if (name.getSegmentCount() > 1) {
                    return Collections.emptyList();
                }
                return super.getLocalElementsByName(name);
            }
        };
    }

    protected Object getKey(Notifier context, EReference reference) {
        return Tuples.create(XImportSectionNamespaceScopeProvider.class, context, reference);
    }

    protected List<ImportNormalizer> getImportedNamespaceResolvers(final EObject context, final boolean ignoreCase) {
        return this.cache.get(Tuples.create(context, ignoreCase, "imports"), context.eResource(), new Provider<List<ImportNormalizer>>(){

            @Override
            public List<ImportNormalizer> get() {
                return XbaseImportedNamespaceScopeProvider.this.internalGetImportedNamespaceResolvers(context, ignoreCase);
            }
        });
    }

    protected List<ImportNormalizer> internalGetImportedNamespaceResolvers(EObject context, boolean ignoreCase) {
        ArrayList<ImportNormalizer> importedNamespaceResolvers = Lists.newArrayList();
        EList<EObject> eContents = context.eContents();
        for (EObject child : eContents) {
            String value = this.getImportedNamespace(child);
            ImportNormalizer resolver = this.createImportedNamespaceResolver(value, ignoreCase);
            if (resolver == null) continue;
            importedNamespaceResolvers.add(resolver);
        }
        return importedNamespaceResolvers;
    }

    protected String getImportedNamespace(EObject object) {
        EStructuralFeature feature = object.eClass().getEStructuralFeature("importedNamespace");
        if (feature != null && String.class.equals(feature.getEType().getInstanceClass())) {
            return (String)object.eGet(feature);
        }
        return null;
    }

    protected ImportNormalizer createImportedNamespaceResolver(String namespace, boolean ignoreCase) {
        boolean hasWildCard;
        if (Strings.isEmpty(namespace)) {
            return null;
        }
        QualifiedName importedNamespace = this.qualifiedNameConverter.toQualifiedName(namespace);
        if (importedNamespace == null || importedNamespace.isEmpty()) {
            return null;
        }
        boolean bl = hasWildCard = ignoreCase ? importedNamespace.getLastSegment().equalsIgnoreCase(this.getWildCard()) : importedNamespace.getLastSegment().equals(this.getWildCard());
        if (hasWildCard) {
            if (importedNamespace.getSegmentCount() <= 1) {
                return null;
            }
            return this.doCreateImportNormalizer(importedNamespace.skipLast(1), true, ignoreCase);
        }
        return this.doCreateImportNormalizer(importedNamespace, false, ignoreCase);
    }

    protected ImportNormalizer doCreateImportNormalizer(QualifiedName importedNamespace, boolean wildcard, boolean ignoreCase) {
        return AbstractNestedTypeAwareImportNormalizer.createNestedTypeAwareImportNormalizer(importedNamespace, wildcard, ignoreCase);
    }

    protected QualifiedName getQualifiedNameOfLocalElement(EObject context) {
        return this.qualifiedNameProvider.getFullyQualifiedName(context);
    }

    protected ISelectable getAllDescriptions(final Resource resource) {
        return this.cache.get("internalGetAllDescriptions", resource, new Provider<ISelectable>(){

            @Override
            public ISelectable get() {
                return XbaseImportedNamespaceScopeProvider.this.internalGetAllDescriptions(resource);
            }
        });
    }

    protected ISelectable internalGetAllDescriptions(final Resource resource) {
        Iterable<EObject> allContents = new Iterable<EObject>(){

            @Override
            public Iterator<EObject> iterator() {
                return EcoreUtil.getAllContents(resource, false);
            }
        };
        Iterable<IEObjectDescription> allDescriptions = Scopes.scopedElementsFor(allContents, this.qualifiedNameProvider);
        return new MultimapBasedSelectable(allDescriptions);
    }

    public String getWildCard() {
        return "*";
    }
}

