/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.XtextSwitch;
import org.eclipse.xtext.xbase.scoping.SyntaxFilteredScope;

public class SyntaxFilteredScopes {
    public IScope create(IScope parent, AbstractElement syntaxElement) {
        AbstractRule rule;
        if (syntaxElement instanceof CrossReference) {
            return this.create(parent, ((CrossReference)syntaxElement).getTerminal());
        }
        if (syntaxElement instanceof RuleCall && GrammarUtil.isDatatypeRule(rule = ((RuleCall)syntaxElement).getRule())) {
            List<String> values = this.getEnumeratedValues((ParserRule)rule);
            if (values.isEmpty()) {
                return parent;
            }
            return new SyntaxFilteredScope(parent, values);
        }
        return parent;
    }

    public List<String> getEnumeratedValues(ParserRule rule) {
        List result = (List)new XtextSwitch<List<String>>(){

            @Override
            public List<String> caseKeyword(Keyword object) {
                if (GrammarUtil.isMultipleCardinality(object)) {
                    return Collections.emptyList();
                }
                if (GrammarUtil.isOptionalCardinality(object)) {
                    return Lists.newArrayList("", object.getValue());
                }
                return Lists.newArrayList(object.getValue());
            }

            @Override
            public List<String> caseAssignment(Assignment object) {
                if (GrammarUtil.isMultipleCardinality(object)) {
                    return Collections.emptyList();
                }
                List nested = (List)this.doSwitch(object.getTerminal());
                if (GrammarUtil.isOptionalCardinality(object)) {
                    if (nested.isEmpty()) {
                        return Collections.emptyList();
                    }
                    nested.add("");
                }
                return nested;
            }

            @Override
            public List<String> caseAlternatives(Alternatives object) {
                if (GrammarUtil.isMultipleCardinality(object)) {
                    return Collections.emptyList();
                }
                ArrayList<String> result = Lists.newArrayList();
                if (GrammarUtil.isOptionalCardinality(object)) {
                    result.add("");
                }
                for (AbstractElement element : object.getElements()) {
                    List nested = (List)this.doSwitch(element);
                    if (nested.isEmpty()) {
                        return Collections.emptyList();
                    }
                    result.addAll(nested);
                }
                return result;
            }

            @Override
            public List<String> caseGroup(Group object) {
                if (GrammarUtil.isMultipleCardinality(object)) {
                    return Collections.emptyList();
                }
                ArrayList<String> result = Lists.newArrayList();
                for (AbstractElement element : object.getElements()) {
                    List nested = (List)this.doSwitch(element);
                    if (nested.isEmpty()) {
                        return Collections.emptyList();
                    }
                    if (result.isEmpty()) {
                        result.addAll(nested);
                        continue;
                    }
                    if (nested.size() == 1) {
                        String addMe = (String)nested.get(0);
                        int i = 0;
                        while (i < result.size()) {
                            result.set(i, String.valueOf((String)result.get(i)) + addMe);
                            ++i;
                        }
                        continue;
                    }
                    ArrayList<String> wasResult = result;
                    result = Lists.newArrayListWithExpectedSize(result.size() * nested.size());
                    for (String prefix : wasResult) {
                        for (String suffix : nested) {
                            result.add(String.valueOf(prefix) + suffix);
                        }
                    }
                }
                if (GrammarUtil.isOptionalCardinality(object)) {
                    result.add("");
                }
                return result;
            }

            @Override
            public List<String> caseAbstractElement(AbstractElement object) {
                return Collections.emptyList();
            }
        }.doSwitch(rule.getAlternatives());
        return result;
    }
}

