/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping;

import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.scoping.AbstractNestedTypeAwareImportNormalizer;

public class NestedTypeAwareImportNormalizer
extends AbstractNestedTypeAwareImportNormalizer {
    protected final boolean allowWildcard = this.importedNamespaceHasDollar();

    public NestedTypeAwareImportNormalizer(QualifiedName importedNamespace, boolean wildcard, boolean ignoreCase) {
        super(importedNamespace, wildcard, ignoreCase);
    }

    protected boolean importedNamespaceHasDollar() {
        if (!this.hasWildCard()) {
            return true;
        }
        QualifiedName importedNamespace = this.getImportedNamespacePrefix();
        int segmentCount = importedNamespace.getSegmentCount();
        int i = 0;
        while (i < segmentCount) {
            if (importedNamespace.getSegment(i).indexOf(36) != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public QualifiedName deresolve(QualifiedName fullyQualifiedName) {
        if (this.hasWildCard()) {
            if (fullyQualifiedName.startsWith(this.getImportedNamespacePrefix()) && fullyQualifiedName.getSegmentCount() != this.getImportedNamespacePrefix().getSegmentCount()) {
                return fullyQualifiedName.skipFirst(this.getImportedNamespacePrefix().getSegmentCount());
            }
        } else {
            if (fullyQualifiedName.equals(this.getImportedNamespacePrefix())) {
                String lastSegment = fullyQualifiedName.getLastSegment();
                int dollar = lastSegment.lastIndexOf(36);
                if (dollar >= 0) {
                    return QualifiedName.create(lastSegment.substring(dollar + 1));
                }
                return QualifiedName.create(fullyQualifiedName.getLastSegment());
            }
            if (fullyQualifiedName.skipLast(1).equals(this.getImportedNamespacePrefix().skipLast(1))) {
                String lastImportedSegment = this.getImportedNamespacePrefix().getLastSegment();
                String lastSegment = fullyQualifiedName.getLastSegment();
                if (lastSegment.startsWith(lastImportedSegment) && lastSegment.charAt(lastImportedSegment.length()) == '$') {
                    int dollar = lastImportedSegment.lastIndexOf(36);
                    if (dollar == -1) {
                        return fullyQualifiedName.skipFirst(this.getImportedNamespacePrefix().getSegmentCount() - 1);
                    }
                    return QualifiedName.create(lastSegment.substring(dollar + 1));
                }
            }
        }
        return null;
    }

    @Override
    protected QualifiedName resolveWildcard(QualifiedName relativeName) {
        if (!this.allowWildcard) {
            return null;
        }
        return super.resolveWildcard(relativeName);
    }

    @Override
    protected QualifiedName resolveNonWildcard(QualifiedName relativeName) {
        if (relativeName.getSegmentCount() == 1) {
            if (this.getImportedNamespacePrefix().getLastSegment().equals(relativeName.getFirstSegment())) {
                return this.getImportedNamespacePrefix();
            }
            return this.internalResolve(relativeName);
        }
        StringBuilder concatenated = new StringBuilder();
        int i = 0;
        while (i < relativeName.getSegmentCount()) {
            String segment = relativeName.getSegment(i);
            if (segment.indexOf(36) == -1) {
                if (concatenated.length() != 0) {
                    concatenated.append('$');
                }
            } else {
                return null;
            }
            concatenated.append(segment);
            ++i;
        }
        return this.internalResolve(QualifiedName.create(concatenated.toString()));
    }

    private QualifiedName internalResolve(QualifiedName relativeName) {
        String singleSegment;
        if (relativeName.getSegmentCount() != 1) {
            throw new IllegalArgumentException(relativeName.toString());
        }
        String lastImportSegment = this.getImportedNamespacePrefix().getLastSegment();
        int importDollarIndex = lastImportSegment.lastIndexOf(36);
        if (importDollarIndex != -1) {
            lastImportSegment = lastImportSegment.substring(importDollarIndex + 1);
        }
        if (lastImportSegment.equals(singleSegment = relativeName.getFirstSegment())) {
            return this.getImportedNamespacePrefix();
        }
        if (singleSegment.startsWith(lastImportSegment) && singleSegment.charAt(lastImportSegment.length()) == '$') {
            if (importDollarIndex == -1) {
                return this.getImportedNamespacePrefix().skipLast(1).append(relativeName);
            }
            String resolvedLastSegment = String.valueOf(this.getImportedNamespacePrefix().getLastSegment()) + singleSegment.substring(lastImportSegment.length());
            return this.getImportedNamespacePrefix().skipLast(1).append(resolvedLastSegment);
        }
        return null;
    }
}

