/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib.internal;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

@GwtCompatible
public class UnmodifiableMergingMapView<K, V>
extends AbstractMap<K, V> {
    private final Map<? extends K, ? extends V> left;
    private final Map<? extends K, ? extends V> right;

    public UnmodifiableMergingMapView(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right) {
        assert (left != null) : "left must not be null";
        assert (right != null) : "right must not be null";
        this.left = left;
        this.right = right;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final Set<Map.Entry<? extends K, ? extends V>> diff = UnmodifiableMergingMapView.difference(this.left, this.right);
        return new AbstractEarlyFailingSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return Iterators.unmodifiableIterator(Iterators.concat(UnmodifiableMergingMapView.this.right.entrySet().iterator(), diff.iterator()));
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }
        };
    }

    private static <K, V> Set<Map.Entry<K, V>> difference(final Map<? extends K, ? extends V> left, final Map<? extends K, ? extends V> right) {
        final Predicate notInSet = new Predicate<Map.Entry<? extends K, ? extends V>>(){

            @Override
            public boolean apply(Map.Entry<? extends K, ? extends V> it) {
                if (it == null) {
                    return false;
                }
                return !right.containsKey(it.getKey());
            }
        };
        return new AbstractEarlyFailingSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return Iterators.unmodifiableIterator(Iterators.filter(left.entrySet().iterator(), notInSet));
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }
        };
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @GwtCompatible
    private static abstract class AbstractEarlyFailingSet<T>
    extends AbstractSet<T> {
        AbstractEarlyFailingSet() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(T entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object element) {
            throw new UnsupportedOperationException();
        }
    }
}

