/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.internal.BooleanFunctionDelegate;
import org.eclipse.xtext.xbase.lib.internal.FunctionDelegate;

@GwtCompatible
public class IterableExtensions {
    @Pure
    @Inline(value="$3.$4concat($1, $2)", imported={Iterables.class})
    public static <T> Iterable<T> operator_plus(Iterable<? extends T> a, Iterable<? extends T> b) {
        return Iterables.concat(a, b);
    }

    public static <T> T findFirst(Iterable<T> iterable, Functions.Function1<? super T, Boolean> predicate) {
        return IteratorExtensions.findFirst(iterable.iterator(), predicate);
    }

    public static <T> T findLast(Iterable<T> iterable, Functions.Function1<? super T, Boolean> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        if (iterable instanceof List) {
            List list = (List)iterable;
            ListIterator iterator = list.listIterator(list.size());
            while (iterator.hasPrevious()) {
                Object t2 = iterator.previous();
                if (!predicate.apply(t2).booleanValue()) continue;
                return (T)t2;
            }
            return null;
        }
        return IteratorExtensions.findLast(iterable.iterator(), predicate);
    }

    public static <T> T head(Iterable<T> iterable) {
        return IteratorExtensions.head(iterable.iterator());
    }

    public static <T> Iterable<T> tail(Iterable<T> iterable) {
        return IterableExtensions.drop(iterable, 1);
    }

    public static <T> T last(Iterable<T> iterable) {
        if (iterable instanceof List) {
            List list = (List)iterable;
            if (list.isEmpty()) {
                return null;
            }
            return (T)list.get(list.size() - 1);
        }
        if (iterable instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)iterable;
            if (sortedSet.isEmpty()) {
                return null;
            }
            return (T)sortedSet.last();
        }
        return IteratorExtensions.last(iterable.iterator());
    }

    public static <T> Iterable<T> take(final Iterable<T> iterable, final int count) {
        if (iterable == null) {
            throw new NullPointerException("iterable");
        }
        if (count < 0) {
            throw new IllegalArgumentException("Cannot take a negative number of elements. Argument 'count' was: " + count);
        }
        if (count == 0) {
            return Collections.emptyList();
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return IteratorExtensions.take(iterable.iterator(), count);
            }
        };
    }

    @Pure
    public static <T> Iterable<T> drop(final Iterable<T> iterable, final int count) {
        if (iterable == null) {
            throw new NullPointerException("iterable");
        }
        if (count == 0) {
            return iterable;
        }
        if (count < 0) {
            throw new IllegalArgumentException("Cannot drop a negative number of elements. Argument 'count' was: " + count);
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return IteratorExtensions.drop(iterable.iterator(), count);
            }
        };
    }

    public static <T> boolean exists(Iterable<T> iterable, Functions.Function1<? super T, Boolean> predicate) {
        return IteratorExtensions.exists(iterable.iterator(), predicate);
    }

    public static <T> boolean forall(Iterable<T> iterable, Functions.Function1<? super T, Boolean> predicate) {
        return IteratorExtensions.forall(iterable.iterator(), predicate);
    }

    @Pure
    public static <T> Iterable<T> filter(Iterable<T> unfiltered, Functions.Function1<? super T, Boolean> predicate) {
        return Iterables.filter(unfiltered, new BooleanFunctionDelegate<T>(predicate));
    }

    @Pure
    public static <T> Iterable<T> reject(Iterable<T> unfiltered, Functions.Function1<? super T, Boolean> predicate) {
        return Iterables.filter(unfiltered, Predicates.not(new BooleanFunctionDelegate<T>(predicate)));
    }

    @Pure
    @GwtIncompatible(value="Class.isInstance")
    public static <T> Iterable<T> reject(Iterable<T> unfiltered, Class<?> type) {
        return IterableExtensions.filter(unfiltered, (? super T t2) -> !type.isInstance(t2));
    }

    @Pure
    @Inline(value="$3.$4filter($1, $2)", imported={Iterables.class})
    @GwtIncompatible(value="Class.isInstance")
    public static <T> Iterable<T> filter(Iterable<?> unfiltered, Class<T> type) {
        return Iterables.filter(unfiltered, type);
    }

    @Pure
    public static <T> Iterable<T> filterNull(Iterable<T> unfiltered) {
        return Iterables.filter(unfiltered, Predicates.notNull());
    }

    @Pure
    public static <T, R> Iterable<R> map(Iterable<T> original, Functions.Function1<? super T, ? extends R> transformation) {
        return Iterables.transform(original, new FunctionDelegate<T, R>(transformation));
    }

    @Pure
    public static <T, R> Iterable<R> flatMap(Iterable<T> original, Functions.Function1<? super T, ? extends Iterable<R>> transformation) {
        return IterableExtensions.flatten(IterableExtensions.map(original, transformation));
    }

    @Inline(value="$2.$3concat($1)", imported={Iterables.class})
    public static <T> Iterable<T> flatten(Iterable<? extends Iterable<? extends T>> inputs) {
        return Iterables.concat(inputs);
    }

    public static <T> void forEach(Iterable<T> iterable, Procedures.Procedure1<? super T> procedure) {
        IteratorExtensions.forEach(iterable.iterator(), procedure);
    }

    public static <T> void forEach(Iterable<T> iterable, Procedures.Procedure2<? super T, ? super Integer> procedure) {
        IteratorExtensions.forEach(iterable.iterator(), procedure);
    }

    public static String join(Iterable<?> iterable) {
        return IteratorExtensions.join(iterable.iterator());
    }

    public static String join(Iterable<?> iterable, CharSequence separator) {
        return IteratorExtensions.join(iterable.iterator(), separator);
    }

    public static <T> String join(Iterable<T> iterable, CharSequence separator, Functions.Function1<? super T, ? extends CharSequence> function) {
        return IteratorExtensions.join(iterable.iterator(), separator, function);
    }

    public static <T> String join(Iterable<T> iterable, CharSequence before, CharSequence separator, CharSequence after, Functions.Function1<? super T, ? extends CharSequence> function) {
        return IteratorExtensions.join(iterable.iterator(), before, separator, after, function);
    }

    public static boolean elementsEqual(Iterable<?> iterable, Iterable<?> other) {
        return Iterables.elementsEqual(iterable, other);
    }

    public static boolean isNullOrEmpty(Iterable<?> iterable) {
        return iterable == null || IterableExtensions.isEmpty(iterable);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return !iterable.iterator().hasNext();
    }

    public static int size(Iterable<?> iterable) {
        return Iterables.size(iterable);
    }

    public static <T> T reduce(Iterable<? extends T> iterable, Functions.Function2<? super T, ? super T, ? extends T> function) {
        return IteratorExtensions.reduce(iterable.iterator(), function);
    }

    public static <T, R> R fold(Iterable<T> iterable, R seed, Functions.Function2<? super R, ? super T, ? extends R> function) {
        return IteratorExtensions.fold(iterable.iterator(), seed, function);
    }

    @Beta
    public static <T> List<T> toList(Iterable<T> iterable) {
        if (iterable instanceof List) {
            List result = (List)iterable;
            return result;
        }
        return Lists.newArrayList(iterable);
    }

    @Beta
    public static <T> Set<T> toSet(Iterable<T> iterable) {
        if (iterable instanceof Set) {
            Set result = (Set)iterable;
            return result;
        }
        return Sets.newLinkedHashSet(iterable);
    }

    public static <K, V> Map<K, V> toInvertedMap(Iterable<? extends K> keys, Functions.Function1<? super K, V> computeValues) {
        return IteratorExtensions.toInvertedMap(keys.iterator(), computeValues);
    }

    public static <K, V> Map<K, V> toMap(Iterable<? extends V> values, Functions.Function1<? super V, K> computeKeys) {
        return IteratorExtensions.toMap(values.iterator(), computeKeys);
    }

    public static <T, K, V> Map<K, V> toMap(Iterable<? extends T> inputs, Functions.Function1<? super T, K> computeKeys, Functions.Function1<? super T, V> computeValues) {
        return IteratorExtensions.toMap(inputs.iterator(), computeKeys, computeValues);
    }

    public static <K, V> Map<K, List<V>> groupBy(Iterable<? extends V> values, Functions.Function1<? super V, ? extends K> computeKeys) {
        return IteratorExtensions.groupBy(values.iterator(), computeKeys);
    }

    public static <T extends Comparable<? super T>> List<T> sort(Iterable<T> iterable) {
        ArrayList<T> asList = Lists.newArrayList(iterable);
        if (iterable instanceof SortedSet && ((SortedSet)iterable).comparator() == null) {
            return asList;
        }
        return ListExtensions.sortInplace(asList);
    }

    @Deprecated
    @Inline(value="$3.$4sortWith($1, $2)", imported={IterableExtensions.class})
    public static <T> List<T> sort(Iterable<T> iterable, Comparator<? super T> comparator) {
        return IterableExtensions.sortWith(iterable, comparator);
    }

    public static <T> List<T> sortWith(Iterable<T> iterable, Comparator<? super T> comparator) {
        return ListExtensions.sortInplace(Lists.newArrayList(iterable), comparator);
    }

    public static <T, C extends Comparable<? super C>> List<T> sortBy(Iterable<T> iterable, Functions.Function1<? super T, C> key) {
        return ListExtensions.sortInplaceBy(Lists.newArrayList(iterable), key);
    }

    public static <T> Iterable<T> takeWhile(final Iterable<? extends T> iterable, final Functions.Function1<? super T, Boolean> predicate) {
        if (iterable == null) {
            throw new NullPointerException("iterable");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return IteratorExtensions.takeWhile(iterable.iterator(), predicate);
            }
        };
    }

    public static <T> Iterable<T> dropWhile(final Iterable<? extends T> iterable, final Functions.Function1<? super T, Boolean> predicate) {
        if (iterable == null) {
            throw new NullPointerException("iterable");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return IteratorExtensions.dropWhile(iterable.iterator(), predicate);
            }
        };
    }

    public static <A> Iterable<Pair<Integer, A>> indexed(final Iterable<? extends A> iterable) {
        if (iterable == null) {
            throw new NullPointerException("iterable");
        }
        return new Iterable<Pair<Integer, A>>(){

            @Override
            public Iterator<Pair<Integer, A>> iterator() {
                return IteratorExtensions.indexed(iterable.iterator());
            }
        };
    }

    public static <T extends Comparable<? super T>> T min(Iterable<T> iterable) {
        SortedSet asSet;
        if (iterable instanceof SortedSet && (asSet = (SortedSet)iterable).comparator() == null) {
            return (T)((Comparable)asSet.first());
        }
        return IteratorExtensions.min(iterable.iterator());
    }

    public static <T, C extends Comparable<? super C>> T minBy(Iterable<T> iterable, Functions.Function1<? super T, C> compareBy) {
        return IteratorExtensions.minBy(iterable.iterator(), compareBy);
    }

    public static <T> T min(Iterable<T> iterable, Comparator<? super T> comparator) {
        return IteratorExtensions.min(iterable.iterator(), comparator);
    }

    public static <T extends Comparable<? super T>> T max(Iterable<T> iterable) {
        return IteratorExtensions.max(iterable.iterator());
    }

    public static <T, C extends Comparable<? super C>> T maxBy(Iterable<T> iterable, Functions.Function1<? super T, C> compareBy) {
        return IteratorExtensions.maxBy(iterable.iterator(), compareBy);
    }

    public static <T> T max(Iterable<T> iterable, Comparator<? super T> comparator) {
        return IteratorExtensions.max(iterable.iterator(), comparator);
    }

    public static boolean contains(Iterable<?> iterable, Object o) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).contains(o);
        }
        return IteratorExtensions.contains(iterable.iterator(), o);
    }
}

