/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.jvmmodel;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.TypeReferences;

public class JvmAnnotationReferenceBuilder {
    private ResourceSet context;
    @Inject
    private TypeReferences references;
    @Inject
    private TypesFactory typesFactory;

    public JvmAnnotationReference annotationRef(Class<?> annotationType, String ... values) {
        if (annotationType == null) {
            return null;
        }
        return this.annotationRef(annotationType.getCanonicalName(), values);
    }

    public JvmAnnotationReference annotationRef(String annotationTypeName, String ... values) {
        if (this.context == null || annotationTypeName == null) {
            return null;
        }
        JvmAnnotationReference result = this.typesFactory.createJvmAnnotationReference();
        JvmType jvmType = this.references.findDeclaredType(annotationTypeName, (Notifier)this.context);
        if (jvmType == null) {
            throw new IllegalArgumentException("The type " + annotationTypeName + " is not on the classpath.");
        }
        if (!(jvmType instanceof JvmAnnotationType)) {
            throw new IllegalArgumentException("The given class " + annotationTypeName + " is not an annotation type.");
        }
        result.setAnnotation((JvmAnnotationType)jvmType);
        if (values != null && values.length > 0) {
            JvmStringAnnotationValue annotationValue = this.typesFactory.createJvmStringAnnotationValue();
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                annotationValue.getValues().add(value);
                ++n2;
            }
            result.getExplicitValues().add(annotationValue);
        }
        return result;
    }

    public static class Factory {
        @Inject
        Provider<JvmAnnotationReferenceBuilder> builderProvider;

        public JvmAnnotationReferenceBuilder create(ResourceSet context) {
            JvmAnnotationReferenceBuilder result = this.builderProvider.get();
            result.context = context;
            return result;
        }
    }
}

