/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.formatting2;

import com.google.common.base.Joiner;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.xbase.formatting2.Entry;
import org.eclipse.xtext.xbase.formatting2.ObjectEntry;
import org.eclipse.xtext.xbase.formatting2.SeparatorEntry;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SeparatorRegions<T, R extends ITextSegment>
implements Iterable<ObjectEntry<T, R>> {
    private final ITextSegment root;
    private ObjectEntry<T, R> first;

    public void prepend(T object) {
        ObjectEntry newObject = new ObjectEntry(this);
        newObject.setObject(object);
        if (this.first == null) {
            this.first = newObject;
        } else {
            newObject.next = this.first.getLeadingSeparator();
            this.first.getLeadingSeparator().next = newObject;
            this.first = newObject;
        }
    }

    public void prependWithLeadingSeparator(T object, R separator) {
        ObjectEntry newObject = new ObjectEntry(this);
        SeparatorEntry newSeparator = new SeparatorEntry();
        newObject.setObject(object);
        newSeparator.setSeparator(separator);
        newObject.previous = newSeparator;
        newSeparator.next = newObject;
        if (this.first == null) {
            this.first = newObject;
        } else {
            newObject.next = this.first.getLeadingSeparator();
            this.first.getLeadingSeparator().previous = newObject;
            this.first = newObject;
        }
    }

    public void appendWithTrailingSeparator(T object, R separator) {
        ObjectEntry newObject = new ObjectEntry(this);
        newObject.setObject(object);
        if (separator != null) {
            SeparatorEntry newSeparator = new SeparatorEntry();
            newSeparator.setSeparator(separator);
            newObject.next = newSeparator;
            newSeparator.previous = newObject;
        }
        if (this.first == null) {
            this.first = newObject;
        } else {
            SeparatorEntry<T, R> last;
            newObject.previous = last = IterableExtensions.last(this.separators());
            last.next = newObject;
        }
    }

    @Override
    public Iterator<ObjectEntry<T, R>> iterator() {
        return new AbstractIterator<ObjectEntry<T, R>>(){
            ObjectEntry<T, R> next;
            {
                this.next = SeparatorRegions.this.first;
            }

            @Override
            protected ObjectEntry<T, R> computeNext() {
                if (this.next == null) {
                    return (ObjectEntry)this.endOfData();
                }
                ObjectEntry current = this.next;
                this.next = this.next.getTrailingObject();
                return current;
            }
        };
    }

    public Iterable<SeparatorEntry<T, R>> separators() {
        return new Iterable<SeparatorEntry<T, R>>(){

            @Override
            public Iterator<SeparatorEntry<T, R>> iterator() {
                return new AbstractIterator<SeparatorEntry<T, R>>(){
                    SeparatorEntry<T, R> next;
                    {
                        this.next = (this).SeparatorRegions.this.first.getTrailingSeparator();
                    }

                    @Override
                    protected SeparatorEntry<T, R> computeNext() {
                        if (this.next == null) {
                            return (SeparatorEntry)this.endOfData();
                        }
                        SeparatorEntry current = this.next;
                        this.next = this.next.getTrailingSeparator();
                        return current;
                    }
                };
            }
        };
    }

    public String toString() {
        if (this.first != null) {
            ArrayList<String> list = new ArrayList<String>();
            Entry current = this.first.getLeadingSeparator();
            while (current != null) {
                list.add(((Object)current).toString());
                current = current.next;
            }
            return Joiner.on("\n").join(list);
        }
        return "empty";
    }

    public SeparatorRegions(ITextSegment root) {
        this.root = root;
    }

    public ITextSegment getRoot() {
        return this.root;
    }
}

