/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.formatting2;

import org.eclipse.xtext.formatting2.IAutowrapFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.xbase.lib.Extension;

public class IndentOnceAutowrapFormatter
implements IAutowrapFormatter {
    private final IHiddenRegion last;
    private boolean hasWrapped = false;

    public IndentOnceAutowrapFormatter(IHiddenRegion last) {
        this.last = last;
    }

    @Override
    public void format(ITextSegment region, IHiddenRegionFormatting wrapped, @Extension IFormattableDocument document) {
        if (!this.hasWrapped) {
            IHiddenRegion hiddenRegion = null;
            if (region instanceof IHiddenRegion) {
                hiddenRegion = (IHiddenRegion)region;
            } else if (region instanceof IHiddenRegionPart) {
                hiddenRegion = ((IHiddenRegionPart)region).getHiddenRegion();
            }
            document.set(hiddenRegion, this.last, it -> it.indent());
            this.hasWrapped = true;
        }
    }
}

