/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.controlflow;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XSynchronizedExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.controlflow.EarlyExitInterpreter;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;

@Singleton
public class DefaultEarlyExitComputer
implements IEarlyExitComputer {
    @Inject
    private EarlyExitInterpreter earlyExitInterpreter;

    @Override
    public boolean isEarlyExit(XExpression expression) {
        Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(expression);
        boolean _isNotEmpty = this.isNotEmpty(exitPoints);
        return _isNotEmpty;
    }

    protected boolean isNotEmpty(Collection<IEarlyExitComputer.ExitPoint> exitPoints) {
        return exitPoints != null && !exitPoints.isEmpty();
    }

    @Override
    public Collection<IEarlyExitComputer.ExitPoint> getExitPoints(XExpression expression) {
        if (expression == null) {
            return Collections.emptyList();
        }
        return this.exitPoints(expression);
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XExpression expression) {
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XReturnExpression expression) {
        IEarlyExitComputer.ExitPoint _exitPoint = new IEarlyExitComputer.ExitPoint(expression, false);
        return Collections.singletonList(_exitPoint);
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XThrowExpression expression) {
        IEarlyExitComputer.ExitPoint _exitPoint = new IEarlyExitComputer.ExitPoint(expression, true);
        return Collections.singletonList(_exitPoint);
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XBlockExpression expression) {
        EList<XExpression> _expressions = expression.getExpressions();
        for (XExpression child : _expressions) {
            Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(child);
            boolean _isNotEmpty = this.isNotEmpty(exitPoints);
            if (!_isNotEmpty) continue;
            return exitPoints;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XBasicForLoopExpression expression) {
        EList<XExpression> _initExpressions = expression.getInitExpressions();
        for (XExpression initExpression : _initExpressions) {
            Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(initExpression);
            boolean _isNotEmpty = this.isNotEmpty(exitPoints);
            if (!_isNotEmpty) continue;
            return exitPoints;
        }
        XExpression predicate = expression.getExpression();
        Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(predicate);
        boolean _isNotEmpty = this.isNotEmpty(exitPoints);
        if (_isNotEmpty) {
            return exitPoints;
        }
        if (predicate == null || this.isBooleanConstant(predicate, true)) {
            exitPoints = this.getExitPoints(expression.getEachExpression());
            boolean _isNotEmpty_1 = this.isNotEmpty(exitPoints);
            if (_isNotEmpty_1) {
                return exitPoints;
            }
            EList<XExpression> _updateExpressions = expression.getUpdateExpressions();
            for (XExpression child : _updateExpressions) {
                exitPoints = this.getExitPoints(child);
                boolean _isNotEmpty_2 = this.isNotEmpty(exitPoints);
                if (!_isNotEmpty_2) continue;
                return exitPoints;
            }
            IEarlyExitComputer.ExitPoint _exitPoint = new IEarlyExitComputer.ExitPoint(expression, false);
            return Collections.singletonList(_exitPoint);
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XForLoopExpression expression) {
        Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(expression.getForExpression());
        boolean _isNotEmpty = this.isNotEmpty(exitPoints);
        if (_isNotEmpty) {
            return exitPoints;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XWhileExpression expression) {
        Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(expression.getPredicate());
        boolean _isNotEmpty = this.isNotEmpty(exitPoints);
        if (_isNotEmpty) {
            return exitPoints;
        }
        boolean _isBooleanConstant = this.isBooleanConstant(expression.getPredicate(), true);
        if (_isBooleanConstant) {
            exitPoints = this.getExitPoints(expression.getBody());
            boolean _isNotEmpty_1 = this.isNotEmpty(exitPoints);
            if (_isNotEmpty_1) {
                return exitPoints;
            }
            IEarlyExitComputer.ExitPoint _exitPoint = new IEarlyExitComputer.ExitPoint(expression, false);
            return Collections.singletonList(_exitPoint);
        }
        return Collections.emptyList();
    }

    protected boolean isBooleanConstant(XExpression expression, boolean value) {
        return this.earlyExitInterpreter.isConstant(expression, value);
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XDoWhileExpression expression) {
        Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(expression.getBody());
        boolean _isNotEmpty = this.isNotEmpty(exitPoints);
        if (_isNotEmpty) {
            return exitPoints;
        }
        exitPoints = this.getExitPoints(expression.getPredicate());
        boolean _isNotEmpty_1 = this.isNotEmpty(exitPoints);
        if (_isNotEmpty_1) {
            return exitPoints;
        }
        boolean _isBooleanConstant = this.isBooleanConstant(expression.getPredicate(), true);
        if (_isBooleanConstant) {
            IEarlyExitComputer.ExitPoint _exitPoint = new IEarlyExitComputer.ExitPoint(expression, false);
            return Collections.singletonList(_exitPoint);
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XVariableDeclaration expression) {
        return this.getExitPoints(expression.getRight());
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XIfExpression expression) {
        Collection<IEarlyExitComputer.ExitPoint> ifExitPoints = this.getExitPoints(expression.getIf());
        boolean _isNotEmpty = this.isNotEmpty(ifExitPoints);
        if (_isNotEmpty) {
            return ifExitPoints;
        }
        Collection<IEarlyExitComputer.ExitPoint> thenExitPoints = this.getExitPoints(expression.getThen());
        Collection<IEarlyExitComputer.ExitPoint> elseExitPoints = this.getExitPoints(expression.getElse());
        if (this.isNotEmpty(thenExitPoints) && this.isNotEmpty(elseExitPoints)) {
            ArrayList<IEarlyExitComputer.ExitPoint> result = Lists.newArrayList(thenExitPoints);
            result.addAll(elseExitPoints);
            return result;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XSwitchExpression expression) {
        boolean _not;
        Collection<IEarlyExitComputer.ExitPoint> switchExitPoints = this.getExitPoints(expression.getSwitch());
        boolean _isNotEmpty = this.isNotEmpty(switchExitPoints);
        if (_isNotEmpty) {
            return switchExitPoints;
        }
        ArrayList<IEarlyExitComputer.ExitPoint> result = Lists.newArrayList();
        EList<XCasePart> _cases = expression.getCases();
        for (XCasePart casePart : _cases) {
            boolean _not2;
            XExpression then = casePart.getThen();
            if (then == null) continue;
            Collection<IEarlyExitComputer.ExitPoint> caseExit = this.getExitPoints(then);
            boolean _isNotEmpty_1 = this.isNotEmpty(caseExit);
            boolean bl = _not2 = !_isNotEmpty_1;
            if (_not2) {
                return Collections.emptyList();
            }
            result.addAll(caseExit);
        }
        Collection<IEarlyExitComputer.ExitPoint> defaultExit = this.getExitPoints(expression.getDefault());
        boolean _isNotEmpty_1 = this.isNotEmpty(defaultExit);
        boolean bl = _not = !_isNotEmpty_1;
        if (_not) {
            return Collections.emptyList();
        }
        result.addAll(defaultExit);
        return result;
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XAbstractFeatureCall expression) {
        EList<XExpression> _actualArguments = expression.getActualArguments();
        for (XExpression argument : _actualArguments) {
            Collection<IEarlyExitComputer.ExitPoint> argumentExitPoints = this.getExitPoints(argument);
            boolean _isNotEmpty = this.isNotEmpty(argumentExitPoints);
            if (!_isNotEmpty) continue;
            return argumentExitPoints;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XConstructorCall expression) {
        EList<XExpression> _arguments = expression.getArguments();
        for (XExpression argument : _arguments) {
            Collection<IEarlyExitComputer.ExitPoint> argumentExitPoints = this.getExitPoints(argument);
            boolean _isNotEmpty = this.isNotEmpty(argumentExitPoints);
            if (!_isNotEmpty) continue;
            return argumentExitPoints;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XTryCatchFinallyExpression expression) {
        Collection<IEarlyExitComputer.ExitPoint> tryExitPoints = this.getExitPoints(expression.getExpression());
        boolean _isNotEmpty = this.isNotEmpty(tryExitPoints);
        if (_isNotEmpty) {
            ArrayList<IEarlyExitComputer.ExitPoint> result = Lists.newArrayList(tryExitPoints);
            EList<XCatchClause> _catchClauses = expression.getCatchClauses();
            for (XCatchClause catchClause : _catchClauses) {
                Collection<IEarlyExitComputer.ExitPoint> catchExitPoints = this.getExitPoints(catchClause.getExpression());
                boolean _isNotEmpty_1 = this.isNotEmpty(catchExitPoints);
                if (_isNotEmpty_1) {
                    result.addAll(catchExitPoints);
                    continue;
                }
                return this.getExitPoints(expression.getFinallyExpression());
            }
            return result;
        }
        return this.getExitPoints(expression.getFinallyExpression());
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XSynchronizedExpression expression) {
        Collection<IEarlyExitComputer.ExitPoint> paramExitPoints = this.getExitPoints(expression.getParam());
        boolean _isNotEmpty = this.isNotEmpty(paramExitPoints);
        if (_isNotEmpty) {
            return paramExitPoints;
        }
        return this.getExitPoints(expression.getExpression());
    }

    protected Collection<IEarlyExitComputer.ExitPoint> exitPoints(XExpression expression) {
        if (expression instanceof XDoWhileExpression) {
            return this._exitPoints((XDoWhileExpression)expression);
        }
        if (expression instanceof XWhileExpression) {
            return this._exitPoints((XWhileExpression)expression);
        }
        if (expression instanceof XAbstractFeatureCall) {
            return this._exitPoints((XAbstractFeatureCall)expression);
        }
        if (expression instanceof XBasicForLoopExpression) {
            return this._exitPoints((XBasicForLoopExpression)expression);
        }
        if (expression instanceof XBlockExpression) {
            return this._exitPoints((XBlockExpression)expression);
        }
        if (expression instanceof XConstructorCall) {
            return this._exitPoints((XConstructorCall)expression);
        }
        if (expression instanceof XForLoopExpression) {
            return this._exitPoints((XForLoopExpression)expression);
        }
        if (expression instanceof XIfExpression) {
            return this._exitPoints((XIfExpression)expression);
        }
        if (expression instanceof XReturnExpression) {
            return this._exitPoints((XReturnExpression)expression);
        }
        if (expression instanceof XSwitchExpression) {
            return this._exitPoints((XSwitchExpression)expression);
        }
        if (expression instanceof XSynchronizedExpression) {
            return this._exitPoints((XSynchronizedExpression)expression);
        }
        if (expression instanceof XThrowExpression) {
            return this._exitPoints((XThrowExpression)expression);
        }
        if (expression instanceof XTryCatchFinallyExpression) {
            return this._exitPoints((XTryCatchFinallyExpression)expression);
        }
        if (expression instanceof XVariableDeclaration) {
            return this._exitPoints((XVariableDeclaration)expression);
        }
        if (expression != null) {
            return this._exitPoints(expression);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expression).toString());
    }
}

