/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.controlflow;

import com.google.common.base.Optional;
import org.eclipse.xtext.xbase.controlflow.IConstantEvaluationResult;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class BooleanResult
implements IConstantEvaluationResult<Boolean> {
    private final Boolean value;
    private final boolean compileTimeConstant;

    @Override
    public Optional<Boolean> getValue() {
        return Optional.fromNullable(this.value);
    }

    public BooleanResult(Boolean value, boolean compileTimeConstant) {
        this.value = value;
        this.compileTimeConstant = compileTimeConstant;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.compileTimeConstant ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanResult other = (BooleanResult)obj;
        if (this.compileTimeConstant != other.compileTimeConstant) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder(this);
        b.add("value", this.value);
        b.add("compileTimeConstant", this.compileTimeConstant);
        return b.toString();
    }

    @Override
    public boolean isCompileTimeConstant() {
        return this.compileTimeConstant;
    }
}

