/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ScopeStack {
    private Stack<Scope> scopes = new Stack();

    public void openScope(boolean pseudoScope) {
        this.scopes.push(new Scope(pseudoScope));
    }

    public void closeScope() {
        this.scopes.pop();
    }

    public Object get(String name) {
        Variable var = this.internalGet(name);
        if (var != null) {
            return var.getReferenced();
        }
        return null;
    }

    private Variable internalGet(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.scopes.isEmpty()) {
            return null;
        }
        int size = this.scopes.size();
        int i = size - 1;
        while (i >= 0) {
            Scope currentScope;
            Variable var;
            if ((var = (currentScope = (Scope)this.scopes.get(i--)).get(name)) == null) continue;
            return var;
        }
        return null;
    }

    public String getName(Object referenced) {
        if (referenced == null) {
            throw new NullPointerException("referenced");
        }
        if (this.scopes.isEmpty()) {
            return null;
        }
        int size = this.scopes.size();
        int i = size - 1;
        while (i >= 0) {
            Scope currentScope = (Scope)this.scopes.get(i--);
            for (Variable v : currentScope.variables()) {
                if (!v.referenced.equals(referenced)) continue;
                return v.name;
            }
        }
        return null;
    }

    public String removeName(Object referenced) throws IllegalStateException {
        if (referenced == null) {
            throw new NullPointerException("referenced");
        }
        if (this.scopes.isEmpty()) {
            throw new IllegalStateException("Cannot find referenced object in current scope");
        }
        Scope currentScope = (Scope)this.scopes.get(this.scopes.size() - 1);
        for (Variable v : currentScope.variables()) {
            if (!v.referenced.equals(referenced)) continue;
            v.markRemoved();
            return v.name;
        }
        throw new IllegalStateException("Cannot find referenced object in current scope");
    }

    public String declareVariable(Object key, String proposedName, boolean synthetic) {
        return this.declareVariable(key, proposedName, synthetic, false);
    }

    public String declareVariable(Object key, String proposedName, boolean synthetic, boolean withUniqueName) {
        if (this.scopes.isEmpty()) {
            throw new IllegalArgumentException("No scope has been opened yet.");
        }
        Scope currentScope = this.scopes.peek();
        if (this.internalGet(proposedName) == null) {
            currentScope.addVariable(proposedName, synthetic, key);
            return proposedName;
        }
        HashSet<String> names = Sets.newHashSet();
        boolean scopeClosed = false;
        for (Scope scope : Lists.reverse(Lists.newArrayList(this.scopes))) {
            for (Variable variable : scope.variables()) {
                if (!withUniqueName && scopeClosed && variable.synthetic) continue;
                names.add(variable.name);
            }
            boolean bl = scopeClosed = scopeClosed || !scope.pseudoScope;
            if (scopeClosed && !synthetic && !withUniqueName) break;
        }
        String newName = this.findNewName(names, proposedName);
        currentScope.addVariable(newName, synthetic, key);
        return newName;
    }

    protected String findNewName(Set<String> names, String proposedName) {
        if (names.contains(proposedName)) {
            int i = 1;
            while (i < Integer.MAX_VALUE) {
                String newProposal = String.valueOf(proposedName) + "_" + i;
                if (!names.contains(newProposal)) {
                    return newProposal;
                }
                ++i;
            }
        }
        return proposedName;
    }

    static class Scope {
        public boolean pseudoScope = false;
        private Map<String, Variable> variables = Maps.newHashMap();

        public Scope(boolean pseudoScope) {
            this.pseudoScope = pseudoScope;
        }

        public void addVariable(String name, boolean synthetic, Object element) {
            if (this.variables.containsKey(name)) {
                throw new IllegalArgumentException("variable '" + name + "' already declared in scope.");
            }
            this.variables.put(name, new Variable(name, synthetic, element));
        }

        public Set<String> variableNames() {
            return this.variables.keySet();
        }

        public Iterable<Variable> variables() {
            return this.variables.values();
        }

        public Variable get(String name) {
            return this.variables.get(name);
        }

        public String toString() {
            return String.valueOf(this.pseudoScope ? "[PSEUDO]" : "") + this.variables;
        }
    }

    static final class Variable {
        private static final Object REMOVED = new Object();
        public String name;
        public boolean synthetic;
        public Object referenced;

        Variable(String name2, boolean synthetic2, Object referenced) {
            this.name = name2;
            this.synthetic = synthetic2;
            this.referenced = referenced;
        }

        public String toString() {
            if (this.referenced == REMOVED) {
                return "[removed]";
            }
            return this.referenced.getClass().getSimpleName();
        }

        private Object getReferenced() {
            if (this.referenced == REMOVED) {
                return null;
            }
            return this.referenced;
        }

        private void markRemoved() {
            this.referenced = REMOVED;
        }
    }
}

