/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.compiler.IElementIssueProvider;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;

public class ElementIssueProvider
implements IElementIssueProvider {
    private Data data;

    protected ElementIssueProvider(Data data) {
        this.data = data;
    }

    @Override
    public Iterable<Issue> getIssues(EObject element) {
        if (this.data == null) {
            return Collections.emptyList();
        }
        return this.data.getIssuesIncludingContents().get(element);
    }

    public static class Data
    extends AdapterImpl {
        private Multimap<EObject, Issue> issuesIncludingContents = ArrayListMultimap.create();

        public Multimap<EObject, Issue> getIssuesIncludingContents() {
            return this.issuesIncludingContents;
        }

        protected void addIssue(EObject erroneousElement, Issue issue) {
            if (erroneousElement != null) {
                EObject currentContainer = erroneousElement;
                do {
                    this.issuesIncludingContents.put(currentContainer, issue);
                } while ((currentContainer = currentContainer.eContainer()) != null);
            }
        }

        @Override
        public boolean isAdapterForType(Object type) {
            return Data.class == type;
        }
    }

    public static class Factory
    implements IElementIssueProvider.Factory {
        @Inject
        IJvmModelAssociations associations;
        @Inject
        IResourceValidator resourceValidator;
        @Inject
        IBatchTypeResolver typeResolver;

        public void attachData(Resource resource) {
            if (this.findDataAdapter(resource) != null) {
                return;
            }
            List<Issue> issues = this.collectIssues(resource);
            Data adapter = new Data();
            for (Issue issue : issues) {
                URI uriToProblem = issue.getUriToProblem();
                if (uriToProblem == null || !uriToProblem.trimFragment().equals(resource.getURI())) continue;
                EObject erroneousElement = resource.getEObject(uriToProblem.fragment());
                adapter.addIssue(erroneousElement, issue);
                for (EObject jvmElement : this.associations.getJvmElements(erroneousElement)) {
                    adapter.addIssue(jvmElement, issue);
                }
            }
            resource.eAdapters().add(adapter);
        }

        protected List<Issue> collectIssues(Resource resource) {
            ArrayList<Issue> issues = Lists.newArrayList(this.resourceValidator.validate(resource, CheckMode.NORMAL_AND_FAST, CancelIndicator.NullImpl));
            this.synthesizeIssuesForFollowUpErrors(resource, issues);
            return issues;
        }

        protected void synthesizeIssuesForFollowUpErrors(Resource resource, List<Issue> result) {
            EList<EObject> contents = resource.getContents();
            if (!contents.isEmpty()) {
                IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes((EObject)contents.get(0));
                for (ILinkingCandidate linkingCandidate : resolvedTypes.getFollowUpErrors()) {
                    XExpression expression = linkingCandidate.getExpression();
                    Issue.IssueImpl issue = new Issue.IssueImpl();
                    issue.setUriToProblem(EcoreUtil.getURI(linkingCandidate.getExpression()));
                    if (expression instanceof XAbstractFeatureCall) {
                        issue.setMessage(String.valueOf(((XAbstractFeatureCall)expression).getConcreteSyntaxFeatureName()) + " cannot be resolved");
                    } else {
                        List<INode> nodes = NodeModelUtils.findNodesForFeature(expression, XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR);
                        if (nodes.size() >= 1) {
                            issue.setMessage(String.valueOf(nodes.get(0).getText()) + " cannot be resolved");
                        }
                    }
                    result.add(issue);
                }
            }
        }

        public void detachData(Resource resource) {
            resource.eAdapters().remove(this.findDataAdapter(resource));
        }

        @Override
        public IElementIssueProvider get(Resource resource) {
            Data data = this.findDataAdapter(resource);
            return new ElementIssueProvider(data);
        }

        protected Data findDataAdapter(Resource resource) {
            return (Data)EcoreUtil.getAdapter(resource.eAdapters(), Data.class);
        }
    }
}

